/*****************************************************************************
* linker command file for OMAP-L138 test code.
*
******************************************************************************/

-stack           0x00000800
-heap            0x00000800

MEMORY
{
   timer_regs:      ORIGIN = 0x01C20000  LENGTH = 0x00000080
   gpio_memory:     ORIGIN = 0x01E26000  LENGTH = 0x00001000
   spi_memory:      ORIGIN = 0x01F0E000  LENGTH = 0x00001000
   dsp_l2_ram:      ORIGIN = 0x11800000  LENGTH = 0x00040000
   discrete_memory: ORIGIN = 0x63000000  LENGTH = 0x00001000
   ms1553_memory:   ORIGIN = 0x64000000  LENGTH = 0x00020000
   shared_ram:      ORIGIN = 0x80000000  LENGTH = 0x05000000
   ddr_sdram:       ORIGIN = 0xC0000000  LENGTH = 0x10000000
   arm_local_ram:   ORIGIN = 0xFFFF0000  LENGTH = 0x00002000
}

SECTIONS
{
   .text       > shared_ram
   .const      > shared_ram
   .bss        > shared_ram
   .far        > shared_ram
   .switch     > shared_ram
   .stack      > shared_ram
   .data       > shared_ram
   .cinit      > shared_ram
   .sysmem     > shared_ram
   .cio        > shared_ram
   flash       > shared_ram

   gpio                    > gpio_memory
   memory_mapped_discretes > discrete_memory
   ms1553                  > ms1553_memory
   spi                     > spi_memory
   time_clock_registers    > timer_regs
}
