#include "stdio.h"

typedef unsigned char   uint8;
typedef unsigned int    uint32;

typedef struct  {
  volatile uint32 REVID;
  volatile uint32 EMUMGT;
  volatile uint32 GPINTGPEN;
  volatile uint32 GPDATGPDIR;
  volatile uint32 TIM12;
  volatile uint32 TIM34;
  volatile uint32 PRD12;
  volatile uint32 PRD34;
  volatile uint32 TCR;
  volatile uint32 TGCR;
  volatile uint32 WDTCR;
  volatile uint8  RSVD0[8];
  volatile uint32 REL12;
  volatile uint32 REL34;
  volatile uint32 CAP12;
  volatile uint32 CAP34;
  volatile uint32 INTCTLSTAT;
  volatile uint8  RSVD1[24];
  volatile uint32 CMP0;
  volatile uint32 CMP1;
  volatile uint32 CMP2;
  volatile uint32 CMP3;
  volatile uint32 CMP4;
  volatile uint32 CMP5;
  volatile uint32 CMP6;
  volatile uint32 CMP7;
} CSL_TmrRegs;

static CSL_TmrRegs time_clock_regs;
#pragma DATA_SECTION(time_clock_regs, "time_clock_registers")

#define TIM12RS_NOT_IN_RESET 1u
#define TIM34RS_NOT_IN_RESET 2u
#define TIM12_RUNS_CONTINUOUSLY 0x00000080u
#define TIM34_RUNS_CONTINUOUSLY 0x00800000u

void   timer_initialize(void);
uint32 timer_current_time(void);
void   display_timer_memory(char * message);

void main(void) {
  display_timer_memory("Before initialization");

  timer_initialize();

  display_timer_memory("\nAfter initialization");
}

void display_timer_memory(char * message) {
  unsigned int * timer_mem = (unsigned int *)0x01C20000;
  int i;

  printf("%s\n", message);
  for (i=0; i < 10; i++) {
    printf("(%08X) = %08X\n", timer_mem, *timer_mem);
    timer_mem++;
  }
}

void timer_initialize(void) {   
  time_clock_regs.TIM12 = 0x00000000u;
  time_clock_regs.TIM34 = 0x00000000u;
  time_clock_regs.TGCR  = TIM12RS_NOT_IN_RESET | TIM34RS_NOT_IN_RESET;
  time_clock_regs.PRD12 = 0x00000000u;
  time_clock_regs.PRD34 = 0x00000000u;
  time_clock_regs.TCR   = TIM12_RUNS_CONTINUOUSLY | TIM34_RUNS_CONTINUOUSLY;
}

uint32 timer_current_time(void) {
  uint32 current;

  asm("DINT");

  current = time_clock_regs.TIM12;

  asm("RINT");

  return current;
}
