var env = Packages.com.ti.ccstudio.scripting.environment.ScriptingEnvironment.instance()
env.setScriptTimeout(15000)

debugServer = env.getServer("DebugServer.1")
debugServer.setConfig("simulate_c6748.ccxml");

debugSession = debugServer.openSession("*", "*")
print("TARGET: " + debugSession.getBoardName())

debugSession.memory.loadProgram("temp/main.out")

function display_timer_memory(message) {
  var address = 0x01C20000;
  var memory;

  print(message);
  for (i=0; i < 10; i++) {
    memory = debugSession.memory.readData(Packages.com.ti.debug.engine.scripting.Memory.Page.PROGRAM, address, 32, false)
    print(address.toString(16) + " = " + memory.toString(16));
    address = address + 4;
  }
}

debugSession.breakpoint.add("timer_initialize")
debugSession.target.run()

display_timer_memory("\nDSS: before watchpoint")
var properties = debugSession.breakpoint.createProperties(1)
properties.setString("Hardware Configuration.Type", "Watchpoint")
properties.setString("Hardware Configuration.Type.Start Location", "C$$EXIT") //0x64005066)
properties.setString("Hardware Configuration.Type.Access.Access Type", "Memory Write")
var breakpoint_id = debugSession.breakpoint.add(properties)
display_timer_memory("\nDSS: after watchpoint")

debugSession.target.run()
