/********************************************************************
* Copyright (C) 2003-2008 Texas Instruments Incorporated.
* All Rights Reserved
*********************************************************************
* file: cslr_gpio.h
*
* Brief: This file contains the Register Description for gpio
*
*********************************************************************/
#ifndef _CSLR_GPIO_H_
#define _CSLR_GPIO_H_

#include "cslr.h"

#include "tistdtypes.h"
#include "csl_general.h"


/* Minimum unit = 2 bytes */

/**************************************************************************\
* Register Overlay Structure
\**************************************************************************/
typedef struct  {
    volatile Uint16 RSVD0[6];
    volatile Uint16 IODIR1;
    volatile Uint16 IODIR2;
    volatile Uint16 IOINDATA1;
    volatile Uint16 IOINDATA2;
    volatile Uint16 IOOUTDATA1;
    volatile Uint16 IOOUTDATA2;
    volatile Uint16 IOINTEDG1;
    volatile Uint16 IOINTEDG2;
    volatile Uint16 IOINTEN1;
    volatile Uint16 IOINTEN2;
    volatile Uint16 IOINTFLG1;
    volatile Uint16 IOINTFLG2;
} CSL_GpioRegs;

/**************************************************************************\
* Field Definition Macros
\**************************************************************************/

/* IODIR1 */

#define CSL_GPIO_IODIR1_DIR15_MASK       (0x8000u)
#define CSL_GPIO_IODIR1_DIR15_SHIFT      (0x000Fu)
#define CSL_GPIO_IODIR1_DIR15_RESETVAL   (0x0000u)
/*----DIR15 Tokens----*/
#define CSL_GPIO_IODIR1_DIR15_CLEAR      (0x0000u)
#define CSL_GPIO_IODIR1_DIR15_SET        (0x0001u)

#define CSL_GPIO_IODIR1_DIR14_MASK       (0x4000u)
#define CSL_GPIO_IODIR1_DIR14_SHIFT      (0x000Eu)
#define CSL_GPIO_IODIR1_DIR14_RESETVAL   (0x0000u)
/*----DIR14 Tokens----*/
#define CSL_GPIO_IODIR1_DIR14_CLEAR      (0x0000u)
#define CSL_GPIO_IODIR1_DIR14_SET        (0x0001u)

#define CSL_GPIO_IODIR1_DIR13_MASK       (0x2000u)
#define CSL_GPIO_IODIR1_DIR13_SHIFT      (0x000Du)
#define CSL_GPIO_IODIR1_DIR13_RESETVAL   (0x0000u)
/*----DIR13 Tokens----*/
#define CSL_GPIO_IODIR1_DIR13_CLEAR      (0x0000u)
#define CSL_GPIO_IODIR1_DIR13_SET        (0x0001u)

#define CSL_GPIO_IODIR1_DIR12_MASK       (0x1000u)
#define CSL_GPIO_IODIR1_DIR12_SHIFT      (0x000Cu)
#define CSL_GPIO_IODIR1_DIR12_RESETVAL   (0x0000u)
/*----DIR12 Tokens----*/
#define CSL_GPIO_IODIR1_DIR12_CLEAR      (0x0000u)
#define CSL_GPIO_IODIR1_DIR12_SET        (0x0001u)

#define CSL_GPIO_IODIR1_DIR11_MASK       (0x0800u)
#define CSL_GPIO_IODIR1_DIR11_SHIFT      (0x000Bu)
#define CSL_GPIO_IODIR1_DIR11_RESETVAL   (0x0000u)
/*----DIR11 Tokens----*/
#define CSL_GPIO_IODIR1_DIR11_CLEAR      (0x0000u)
#define CSL_GPIO_IODIR1_DIR11_SET        (0x0001u)

#define CSL_GPIO_IODIR1_DIR10_MASK       (0x0400u)
#define CSL_GPIO_IODIR1_DIR10_SHIFT      (0x000Au)
#define CSL_GPIO_IODIR1_DIR10_RESETVAL   (0x0000u)
/*----DIR10 Tokens----*/
#define CSL_GPIO_IODIR1_DIR10_CLEAR      (0x0000u)
#define CSL_GPIO_IODIR1_DIR10_SET        (0x0001u)

#define CSL_GPIO_IODIR1_DIR9_MASK        (0x0200u)
#define CSL_GPIO_IODIR1_DIR9_SHIFT       (0x0009u)
#define CSL_GPIO_IODIR1_DIR9_RESETVAL    (0x0000u)
/*----DIR9 Tokens----*/
#define CSL_GPIO_IODIR1_DIR9_CLEAR       (0x0000u)
#define CSL_GPIO_IODIR1_DIR9_SET         (0x0001u)

#define CSL_GPIO_IODIR1_DIR8_MASK        (0x0100u)
#define CSL_GPIO_IODIR1_DIR8_SHIFT       (0x0008u)
#define CSL_GPIO_IODIR1_DIR8_RESETVAL    (0x0000u)
/*----DIR8 Tokens----*/
#define CSL_GPIO_IODIR1_DIR8_CLEAR       (0x0000u)
#define CSL_GPIO_IODIR1_DIR8_SET         (0x0001u)

#define CSL_GPIO_IODIR1_DIR7_MASK        (0x0080u)
#define CSL_GPIO_IODIR1_DIR7_SHIFT       (0x0007u)
#define CSL_GPIO_IODIR1_DIR7_RESETVAL    (0x0000u)
/*----DIR7 Tokens----*/
#define CSL_GPIO_IODIR1_DIR7_CLEAR       (0x0000u)
#define CSL_GPIO_IODIR1_DIR7_SET         (0x0001u)

#define CSL_GPIO_IODIR1_DIR6_MASK        (0x0040u)
#define CSL_GPIO_IODIR1_DIR6_SHIFT       (0x0006u)
#define CSL_GPIO_IODIR1_DIR6_RESETVAL    (0x0000u)
/*----DIR6 Tokens----*/
#define CSL_GPIO_IODIR1_DIR6_CLEAR       (0x0000u)
#define CSL_GPIO_IODIR1_DIR6_SET         (0x0001u)

#define CSL_GPIO_IODIR1_DIR5_MASK        (0x0020u)
#define CSL_GPIO_IODIR1_DIR5_SHIFT       (0x0005u)
#define CSL_GPIO_IODIR1_DIR5_RESETVAL    (0x0000u)
/*----DIR5 Tokens----*/
#define CSL_GPIO_IODIR1_DIR5_CLEAR       (0x0000u)
#define CSL_GPIO_IODIR1_DIR5_SET         (0x0001u)

#define CSL_GPIO_IODIR1_DIR4_MASK        (0x0010u)
#define CSL_GPIO_IODIR1_DIR4_SHIFT       (0x0004u)
#define CSL_GPIO_IODIR1_DIR4_RESETVAL    (0x0000u)
/*----DIR4 Tokens----*/
#define CSL_GPIO_IODIR1_DIR4_CLEAR       (0x0000u)
#define CSL_GPIO_IODIR1_DIR4_SET         (0x0001u)

#define CSL_GPIO_IODIR1_DIR3_MASK        (0x0008u)
#define CSL_GPIO_IODIR1_DIR3_SHIFT       (0x0003u)
#define CSL_GPIO_IODIR1_DIR3_RESETVAL    (0x0000u)
/*----DIR3 Tokens----*/
#define CSL_GPIO_IODIR1_DIR3_CLEAR       (0x0000u)
#define CSL_GPIO_IODIR1_DIR3_SET         (0x0001u)

#define CSL_GPIO_IODIR1_DIR2_MASK        (0x0004u)
#define CSL_GPIO_IODIR1_DIR2_SHIFT       (0x0002u)
#define CSL_GPIO_IODIR1_DIR2_RESETVAL    (0x0000u)
/*----DIR2 Tokens----*/
#define CSL_GPIO_IODIR1_DIR2_CLEAR       (0x0000u)
#define CSL_GPIO_IODIR1_DIR2_SET         (0x0001u)

#define CSL_GPIO_IODIR1_DIR1_MASK        (0x0002u)
#define CSL_GPIO_IODIR1_DIR1_SHIFT       (0x0001u)
#define CSL_GPIO_IODIR1_DIR1_RESETVAL    (0x0000u)
/*----DIR1 Tokens----*/
#define CSL_GPIO_IODIR1_DIR1_CLEAR       (0x0000u)
#define CSL_GPIO_IODIR1_DIR1_SET         (0x0001u)

#define CSL_GPIO_IODIR1_DIR0_MASK        (0x0001u)
#define CSL_GPIO_IODIR1_DIR0_SHIFT       (0x0000u)
#define CSL_GPIO_IODIR1_DIR0_RESETVAL    (0x0000u)
/*----DIR0 Tokens----*/
#define CSL_GPIO_IODIR1_DIR0_CLEAR       (0x0000u)
#define CSL_GPIO_IODIR1_DIR0_SET         (0x0001u)

#define CSL_GPIO_IODIR1_RESETVAL         (0x0000u)

/* IODIR2 */

#define CSL_GPIO_IODIR2_DIR31_MASK       (0x8000u)
#define CSL_GPIO_IODIR2_DIR31_SHIFT      (0x000Fu)
#define CSL_GPIO_IODIR2_DIR31_RESETVAL   (0x0000u)
/*----DIR31 Tokens----*/
#define CSL_GPIO_IODIR2_DIR31_CLEAR      (0x0000u)
#define CSL_GPIO_IODIR2_DIR31_SET        (0x0001u)

#define CSL_GPIO_IODIR2_DIR30_MASK       (0x4000u)
#define CSL_GPIO_IODIR2_DIR30_SHIFT      (0x000Eu)
#define CSL_GPIO_IODIR2_DIR30_RESETVAL   (0x0000u)
/*----DIR30 Tokens----*/
#define CSL_GPIO_IODIR2_DIR30_CLEAR      (0x0000u)
#define CSL_GPIO_IODIR2_DIR30_SET        (0x0001u)

#define CSL_GPIO_IODIR2_DIR29_MASK       (0x2000u)
#define CSL_GPIO_IODIR2_DIR29_SHIFT      (0x000Du)
#define CSL_GPIO_IODIR2_DIR29_RESETVAL   (0x0000u)
/*----DIR29 Tokens----*/
#define CSL_GPIO_IODIR2_DIR29_CLEAR      (0x0000u)
#define CSL_GPIO_IODIR2_DIR29_SET        (0x0001u)

#define CSL_GPIO_IODIR2_DIR28_MASK       (0x1000u)
#define CSL_GPIO_IODIR2_DIR28_SHIFT      (0x000Cu)
#define CSL_GPIO_IODIR2_DIR28_RESETVAL   (0x0000u)
/*----DIR28 Tokens----*/
#define CSL_GPIO_IODIR2_DIR28_CLEAR      (0x0000u)
#define CSL_GPIO_IODIR2_DIR28_SET        (0x0001u)

#define CSL_GPIO_IODIR2_DIR27_MASK       (0x0800u)
#define CSL_GPIO_IODIR2_DIR27_SHIFT      (0x000Bu)
#define CSL_GPIO_IODIR2_DIR27_RESETVAL   (0x0000u)
/*----DIR27 Tokens----*/
#define CSL_GPIO_IODIR2_DIR27_CLEAR      (0x0000u)
#define CSL_GPIO_IODIR2_DIR27_SET        (0x0001u)

#define CSL_GPIO_IODIR2_DIR26_MASK       (0x0400u)
#define CSL_GPIO_IODIR2_DIR26_SHIFT      (0x000Au)
#define CSL_GPIO_IODIR2_DIR26_RESETVAL   (0x0000u)
/*----DIR26 Tokens----*/
#define CSL_GPIO_IODIR2_DIR26_CLEAR      (0x0000u)
#define CSL_GPIO_IODIR2_DIR26_SET        (0x0001u)

#define CSL_GPIO_IODIR2_DIR25_MASK       (0x0200u)
#define CSL_GPIO_IODIR2_DIR25_SHIFT      (0x0009u)
#define CSL_GPIO_IODIR2_DIR25_RESETVAL   (0x0000u)
/*----DIR25 Tokens----*/
#define CSL_GPIO_IODIR2_DIR25_CLEAR      (0x0000u)
#define CSL_GPIO_IODIR2_DIR25_SET        (0x0001u)

#define CSL_GPIO_IODIR2_DIR24_MASK       (0x0100u)
#define CSL_GPIO_IODIR2_DIR24_SHIFT      (0x0008u)
#define CSL_GPIO_IODIR2_DIR24_RESETVAL   (0x0000u)
/*----DIR24 Tokens----*/
#define CSL_GPIO_IODIR2_DIR24_CLEAR      (0x0000u)
#define CSL_GPIO_IODIR2_DIR24_SET        (0x0001u)

#define CSL_GPIO_IODIR2_DIR23_MASK       (0x0080u)
#define CSL_GPIO_IODIR2_DIR23_SHIFT      (0x0007u)
#define CSL_GPIO_IODIR2_DIR23_RESETVAL   (0x0000u)
/*----DIR23 Tokens----*/
#define CSL_GPIO_IODIR2_DIR23_CLEAR      (0x0000u)
#define CSL_GPIO_IODIR2_DIR23_SET        (0x0001u)

#define CSL_GPIO_IODIR2_DIR22_MASK       (0x0040u)
#define CSL_GPIO_IODIR2_DIR22_SHIFT      (0x0006u)
#define CSL_GPIO_IODIR2_DIR22_RESETVAL   (0x0000u)
/*----DIR22 Tokens----*/
#define CSL_GPIO_IODIR2_DIR22_CLEAR      (0x0000u)
#define CSL_GPIO_IODIR2_DIR22_SET        (0x0001u)

#define CSL_GPIO_IODIR2_DIR21_MASK       (0x0020u)
#define CSL_GPIO_IODIR2_DIR21_SHIFT      (0x0005u)
#define CSL_GPIO_IODIR2_DIR21_RESETVAL   (0x0000u)
/*----DIR21 Tokens----*/
#define CSL_GPIO_IODIR2_DIR21_CLEAR      (0x0000u)
#define CSL_GPIO_IODIR2_DIR21_SET        (0x0001u)

#define CSL_GPIO_IODIR2_DIR20_MASK       (0x0010u)
#define CSL_GPIO_IODIR2_DIR20_SHIFT      (0x0004u)
#define CSL_GPIO_IODIR2_DIR20_RESETVAL   (0x0000u)
/*----DIR20 Tokens----*/
#define CSL_GPIO_IODIR2_DIR20_CLEAR      (0x0000u)
#define CSL_GPIO_IODIR2_DIR20_SET        (0x0001u)

#define CSL_GPIO_IODIR2_DIR19_MASK       (0x0008u)
#define CSL_GPIO_IODIR2_DIR19_SHIFT      (0x0003u)
#define CSL_GPIO_IODIR2_DIR19_RESETVAL   (0x0000u)
/*----DIR19 Tokens----*/
#define CSL_GPIO_IODIR2_DIR19_CLEAR      (0x0000u)
#define CSL_GPIO_IODIR2_DIR19_SET        (0x0001u)

#define CSL_GPIO_IODIR2_DIR18_MASK       (0x0004u)
#define CSL_GPIO_IODIR2_DIR18_SHIFT      (0x0002u)
#define CSL_GPIO_IODIR2_DIR18_RESETVAL   (0x0000u)
/*----DIR18 Tokens----*/
#define CSL_GPIO_IODIR2_DIR18_CLEAR      (0x0000u)
#define CSL_GPIO_IODIR2_DIR18_SET        (0x0001u)

#define CSL_GPIO_IODIR2_DIR17_MASK       (0x0002u)
#define CSL_GPIO_IODIR2_DIR17_SHIFT      (0x0001u)
#define CSL_GPIO_IODIR2_DIR17_RESETVAL   (0x0000u)
/*----DIR17 Tokens----*/
#define CSL_GPIO_IODIR2_DIR17_CLEAR      (0x0000u)
#define CSL_GPIO_IODIR2_DIR17_SET        (0x0001u)

#define CSL_GPIO_IODIR2_DIR16_MASK       (0x0001u)
#define CSL_GPIO_IODIR2_DIR16_SHIFT      (0x0000u)
#define CSL_GPIO_IODIR2_DIR16_RESETVAL   (0x0000u)
/*----DIR16 Tokens----*/
#define CSL_GPIO_IODIR2_DIR16_CLEAR      (0x0000u)
#define CSL_GPIO_IODIR2_DIR16_SET        (0x0001u)

#define CSL_GPIO_IODIR2_RESETVAL         (0x0000u)

/* IOINDATA1 */

#define CSL_GPIO_IOINDATA1_IN15_MASK     (0x8000u)
#define CSL_GPIO_IOINDATA1_IN15_SHIFT    (0x000Fu)
#define CSL_GPIO_IOINDATA1_IN15_RESETVAL (0x0000u)
/*----IN15 Tokens----*/
#define CSL_GPIO_IOINDATA1_IN15_CLEAR    (0x0000u)
#define CSL_GPIO_IOINDATA1_IN15_SET      (0x0001u)

#define CSL_GPIO_IOINDATA1_IN14_MASK     (0x4000u)
#define CSL_GPIO_IOINDATA1_IN14_SHIFT    (0x000Eu)
#define CSL_GPIO_IOINDATA1_IN14_RESETVAL (0x0000u)
/*----IN14 Tokens----*/
#define CSL_GPIO_IOINDATA1_IN14_CLEAR    (0x0000u)
#define CSL_GPIO_IOINDATA1_IN14_SET      (0x0001u)

#define CSL_GPIO_IOINDATA1_IN13_MASK     (0x2000u)
#define CSL_GPIO_IOINDATA1_IN13_SHIFT    (0x000Du)
#define CSL_GPIO_IOINDATA1_IN13_RESETVAL (0x0000u)
/*----IN13 Tokens----*/
#define CSL_GPIO_IOINDATA1_IN13_CLEAR    (0x0000u)
#define CSL_GPIO_IOINDATA1_IN13_SET      (0x0001u)

#define CSL_GPIO_IOINDATA1_IN12_MASK     (0x1000u)
#define CSL_GPIO_IOINDATA1_IN12_SHIFT    (0x000Cu)
#define CSL_GPIO_IOINDATA1_IN12_RESETVAL (0x0000u)
/*----IN12 Tokens----*/
#define CSL_GPIO_IOINDATA1_IN12_CLEAR    (0x0000u)
#define CSL_GPIO_IOINDATA1_IN12_SET      (0x0001u)

#define CSL_GPIO_IOINDATA1_IN11_MASK     (0x0800u)
#define CSL_GPIO_IOINDATA1_IN11_SHIFT    (0x000Bu)
#define CSL_GPIO_IOINDATA1_IN11_RESETVAL (0x0000u)
/*----IN11 Tokens----*/
#define CSL_GPIO_IOINDATA1_IN11_CLEAR    (0x0000u)
#define CSL_GPIO_IOINDATA1_IN11_SET      (0x0001u)

#define CSL_GPIO_IOINDATA1_IN10_MASK     (0x0400u)
#define CSL_GPIO_IOINDATA1_IN10_SHIFT    (0x000Au)
#define CSL_GPIO_IOINDATA1_IN10_RESETVAL (0x0000u)
/*----IN10 Tokens----*/
#define CSL_GPIO_IOINDATA1_IN10_CLEAR    (0x0000u)
#define CSL_GPIO_IOINDATA1_IN10_SET      (0x0001u)

#define CSL_GPIO_IOINDATA1_IN9_MASK      (0x0200u)
#define CSL_GPIO_IOINDATA1_IN9_SHIFT     (0x0009u)
#define CSL_GPIO_IOINDATA1_IN9_RESETVAL  (0x0000u)
/*----IN9 Tokens----*/
#define CSL_GPIO_IOINDATA1_IN9_CLEAR     (0x0000u)
#define CSL_GPIO_IOINDATA1_IN9_SET       (0x0001u)

#define CSL_GPIO_IOINDATA1_IN8_MASK      (0x0100u)
#define CSL_GPIO_IOINDATA1_IN8_SHIFT     (0x0008u)
#define CSL_GPIO_IOINDATA1_IN8_RESETVAL  (0x0000u)
/*----IN8 Tokens----*/
#define CSL_GPIO_IOINDATA1_IN8_CLEAR     (0x0000u)
#define CSL_GPIO_IOINDATA1_IN8_SET       (0x0001u)

#define CSL_GPIO_IOINDATA1_IN7_MASK      (0x0080u)
#define CSL_GPIO_IOINDATA1_IN7_SHIFT     (0x0007u)
#define CSL_GPIO_IOINDATA1_IN7_RESETVAL  (0x0000u)
/*----IN7 Tokens----*/
#define CSL_GPIO_IOINDATA1_IN7_CLEAR     (0x0000u)
#define CSL_GPIO_IOINDATA1_IN7_SET       (0x0001u)

#define CSL_GPIO_IOINDATA1_IN6_MASK      (0x0040u)
#define CSL_GPIO_IOINDATA1_IN6_SHIFT     (0x0006u)
#define CSL_GPIO_IOINDATA1_IN6_RESETVAL  (0x0000u)
/*----IN6 Tokens----*/
#define CSL_GPIO_IOINDATA1_IN6_CLEAR     (0x0000u)
#define CSL_GPIO_IOINDATA1_IN6_SET       (0x0001u)

#define CSL_GPIO_IOINDATA1_IN5_MASK      (0x0020u)
#define CSL_GPIO_IOINDATA1_IN5_SHIFT     (0x0005u)
#define CSL_GPIO_IOINDATA1_IN5_RESETVAL  (0x0000u)
/*----IN5 Tokens----*/
#define CSL_GPIO_IOINDATA1_IN5_CLEAR     (0x0000u)
#define CSL_GPIO_IOINDATA1_IN5_SET       (0x0001u)

#define CSL_GPIO_IOINDATA1_IN4_MASK      (0x0010u)
#define CSL_GPIO_IOINDATA1_IN4_SHIFT     (0x0004u)
#define CSL_GPIO_IOINDATA1_IN4_RESETVAL  (0x0000u)
/*----IN4 Tokens----*/
#define CSL_GPIO_IOINDATA1_IN4_CLEAR     (0x0000u)
#define CSL_GPIO_IOINDATA1_IN4_SET       (0x0001u)

#define CSL_GPIO_IOINDATA1_IN3_MASK      (0x0008u)
#define CSL_GPIO_IOINDATA1_IN3_SHIFT     (0x0003u)
#define CSL_GPIO_IOINDATA1_IN3_RESETVAL  (0x0000u)
/*----IN3 Tokens----*/
#define CSL_GPIO_IOINDATA1_IN3_CLEAR     (0x0000u)
#define CSL_GPIO_IOINDATA1_IN3_SET       (0x0001u)

#define CSL_GPIO_IOINDATA1_IN2_MASK      (0x0004u)
#define CSL_GPIO_IOINDATA1_IN2_SHIFT     (0x0002u)
#define CSL_GPIO_IOINDATA1_IN2_RESETVAL  (0x0000u)
/*----IN2 Tokens----*/
#define CSL_GPIO_IOINDATA1_IN2_CLEAR     (0x0000u)
#define CSL_GPIO_IOINDATA1_IN2_SET       (0x0001u)

#define CSL_GPIO_IOINDATA1_IN1_MASK      (0x0002u)
#define CSL_GPIO_IOINDATA1_IN1_SHIFT     (0x0001u)
#define CSL_GPIO_IOINDATA1_IN1_RESETVAL  (0x0000u)
/*----IN1 Tokens----*/
#define CSL_GPIO_IOINDATA1_IN1_CLEAR     (0x0000u)
#define CSL_GPIO_IOINDATA1_IN1_SET       (0x0001u)

#define CSL_GPIO_IOINDATA1_IN0_MASK      (0x0001u)
#define CSL_GPIO_IOINDATA1_IN0_SHIFT     (0x0000u)
#define CSL_GPIO_IOINDATA1_IN0_RESETVAL  (0x0000u)
/*----IN0 Tokens----*/
#define CSL_GPIO_IOINDATA1_IN0_CLEAR     (0x0000u)
#define CSL_GPIO_IOINDATA1_IN0_SET       (0x0001u)

#define CSL_GPIO_IOINDATA1_RESETVAL      (0x0000u)

/* IOINDATA2 */

#define CSL_GPIO_IOINDATA2_IN31_MASK     (0x8000u)
#define CSL_GPIO_IOINDATA2_IN31_SHIFT    (0x000Fu)
#define CSL_GPIO_IOINDATA2_IN31_RESETVAL (0x0000u)
/*----IN31 Tokens----*/
#define CSL_GPIO_IOINDATA2_IN31_CLEAR    (0x0000u)
#define CSL_GPIO_IOINDATA2_IN31_SET      (0x0001u)

#define CSL_GPIO_IOINDATA2_IN30_MASK     (0x4000u)
#define CSL_GPIO_IOINDATA2_IN30_SHIFT    (0x000Eu)
#define CSL_GPIO_IOINDATA2_IN30_RESETVAL (0x0000u)
/*----IN30 Tokens----*/
#define CSL_GPIO_IOINDATA2_IN30_CLEAR    (0x0000u)
#define CSL_GPIO_IOINDATA2_IN30_SET      (0x0001u)

#define CSL_GPIO_IOINDATA2_IN29_MASK     (0x2000u)
#define CSL_GPIO_IOINDATA2_IN29_SHIFT    (0x000Du)
#define CSL_GPIO_IOINDATA2_IN29_RESETVAL (0x0000u)
/*----IN29 Tokens----*/
#define CSL_GPIO_IOINDATA2_IN29_CLEAR    (0x0000u)
#define CSL_GPIO_IOINDATA2_IN29_SET      (0x0001u)

#define CSL_GPIO_IOINDATA2_IN28_MASK     (0x1000u)
#define CSL_GPIO_IOINDATA2_IN28_SHIFT    (0x000Cu)
#define CSL_GPIO_IOINDATA2_IN28_RESETVAL (0x0000u)
/*----IN28 Tokens----*/
#define CSL_GPIO_IOINDATA2_IN28_CLEAR    (0x0000u)
#define CSL_GPIO_IOINDATA2_IN28_SET      (0x0001u)

#define CSL_GPIO_IOINDATA2_IN27_MASK     (0x0800u)
#define CSL_GPIO_IOINDATA2_IN27_SHIFT    (0x000Bu)
#define CSL_GPIO_IOINDATA2_IN27_RESETVAL (0x0000u)
/*----IN27 Tokens----*/
#define CSL_GPIO_IOINDATA2_IN27_CLEAR    (0x0000u)
#define CSL_GPIO_IOINDATA2_IN27_SET      (0x0001u)

#define CSL_GPIO_IOINDATA2_IN26_MASK     (0x0400u)
#define CSL_GPIO_IOINDATA2_IN26_SHIFT    (0x000Au)
#define CSL_GPIO_IOINDATA2_IN26_RESETVAL (0x0000u)
/*----IN26 Tokens----*/
#define CSL_GPIO_IOINDATA2_IN26_CLEAR    (0x0000u)
#define CSL_GPIO_IOINDATA2_IN26_SET      (0x0001u)

#define CSL_GPIO_IOINDATA2_IN25_MASK     (0x0200u)
#define CSL_GPIO_IOINDATA2_IN25_SHIFT    (0x0009u)
#define CSL_GPIO_IOINDATA2_IN25_RESETVAL (0x0000u)
/*----IN25 Tokens----*/
#define CSL_GPIO_IOINDATA2_IN25_CLEAR    (0x0000u)
#define CSL_GPIO_IOINDATA2_IN25_SET      (0x0001u)

#define CSL_GPIO_IOINDATA2_IN24_MASK     (0x0100u)
#define CSL_GPIO_IOINDATA2_IN24_SHIFT    (0x0008u)
#define CSL_GPIO_IOINDATA2_IN24_RESETVAL (0x0000u)
/*----IN24 Tokens----*/
#define CSL_GPIO_IOINDATA2_IN24_CLEAR    (0x0000u)
#define CSL_GPIO_IOINDATA2_IN24_SET      (0x0001u)

#define CSL_GPIO_IOINDATA2_IN23_MASK     (0x0080u)
#define CSL_GPIO_IOINDATA2_IN23_SHIFT    (0x0007u)
#define CSL_GPIO_IOINDATA2_IN23_RESETVAL (0x0000u)
/*----IN23 Tokens----*/
#define CSL_GPIO_IOINDATA2_IN23_CLEAR    (0x0000u)
#define CSL_GPIO_IOINDATA2_IN23_SET      (0x0001u)

#define CSL_GPIO_IOINDATA2_IN22_MASK     (0x0040u)
#define CSL_GPIO_IOINDATA2_IN22_SHIFT    (0x0006u)
#define CSL_GPIO_IOINDATA2_IN22_RESETVAL (0x0000u)
/*----IN22 Tokens----*/
#define CSL_GPIO_IOINDATA2_IN22_CLEAR    (0x0000u)
#define CSL_GPIO_IOINDATA2_IN22_SET      (0x0001u)

#define CSL_GPIO_IOINDATA2_IN21_MASK     (0x0020u)
#define CSL_GPIO_IOINDATA2_IN21_SHIFT    (0x0005u)
#define CSL_GPIO_IOINDATA2_IN21_RESETVAL (0x0000u)
/*----IN21 Tokens----*/
#define CSL_GPIO_IOINDATA2_IN21_CLEAR    (0x0000u)
#define CSL_GPIO_IOINDATA2_IN21_SET      (0x0001u)

#define CSL_GPIO_IOINDATA2_IN20_MASK     (0x0010u)
#define CSL_GPIO_IOINDATA2_IN20_SHIFT    (0x0004u)
#define CSL_GPIO_IOINDATA2_IN20_RESETVAL (0x0000u)
/*----IN20 Tokens----*/
#define CSL_GPIO_IOINDATA2_IN20_CLEAR    (0x0000u)
#define CSL_GPIO_IOINDATA2_IN20_SET      (0x0001u)

#define CSL_GPIO_IOINDATA2_IN19_MASK     (0x0008u)
#define CSL_GPIO_IOINDATA2_IN19_SHIFT    (0x0003u)
#define CSL_GPIO_IOINDATA2_IN19_RESETVAL (0x0000u)
/*----IN19 Tokens----*/
#define CSL_GPIO_IOINDATA2_IN19_CLEAR    (0x0000u)
#define CSL_GPIO_IOINDATA2_IN19_SET      (0x0001u)

#define CSL_GPIO_IOINDATA2_IN18_MASK     (0x0004u)
#define CSL_GPIO_IOINDATA2_IN18_SHIFT    (0x0002u)
#define CSL_GPIO_IOINDATA2_IN18_RESETVAL (0x0000u)
/*----IN18 Tokens----*/
#define CSL_GPIO_IOINDATA2_IN18_CLEAR    (0x0000u)
#define CSL_GPIO_IOINDATA2_IN18_SET      (0x0001u)

#define CSL_GPIO_IOINDATA2_IN17_MASK     (0x0002u)
#define CSL_GPIO_IOINDATA2_IN17_SHIFT    (0x0001u)
#define CSL_GPIO_IOINDATA2_IN17_RESETVAL (0x0000u)
/*----IN17 Tokens----*/
#define CSL_GPIO_IOINDATA2_IN17_CLEAR    (0x0000u)
#define CSL_GPIO_IOINDATA2_IN17_SET      (0x0001u)

#define CSL_GPIO_IOINDATA2_IN16_MASK     (0x0001u)
#define CSL_GPIO_IOINDATA2_IN16_SHIFT    (0x0000u)
#define CSL_GPIO_IOINDATA2_IN16_RESETVAL (0x0000u)
/*----IN16 Tokens----*/
#define CSL_GPIO_IOINDATA2_IN16_CLEAR    (0x0000u)
#define CSL_GPIO_IOINDATA2_IN16_SET      (0x0001u)

#define CSL_GPIO_IOINDATA2_RESETVAL      (0x0000u)

/* IOOUTDATA1 */

#define CSL_GPIO_IOOUTDATA1_OUT15_MASK   (0x8000u)
#define CSL_GPIO_IOOUTDATA1_OUT15_SHIFT  (0x000Fu)
#define CSL_GPIO_IOOUTDATA1_OUT15_RESETVAL (0x0000u)
/*----OUT15 Tokens----*/
#define CSL_GPIO_IOOUTDATA1_OUT15_CLEAR  (0x0000u)
#define CSL_GPIO_IOOUTDATA1_OUT15_SET    (0x0001u)

#define CSL_GPIO_IOOUTDATA1_OUT14_MASK   (0x4000u)
#define CSL_GPIO_IOOUTDATA1_OUT14_SHIFT  (0x000Eu)
#define CSL_GPIO_IOOUTDATA1_OUT14_RESETVAL (0x0000u)
/*----OUT14 Tokens----*/
#define CSL_GPIO_IOOUTDATA1_OUT14_CLEAR  (0x0000u)
#define CSL_GPIO_IOOUTDATA1_OUT14_SET    (0x0001u)

#define CSL_GPIO_IOOUTDATA1_OUT13_MASK   (0x2000u)
#define CSL_GPIO_IOOUTDATA1_OUT13_SHIFT  (0x000Du)
#define CSL_GPIO_IOOUTDATA1_OUT13_RESETVAL (0x0000u)
/*----OUT13 Tokens----*/
#define CSL_GPIO_IOOUTDATA1_OUT13_CLEAR  (0x0000u)
#define CSL_GPIO_IOOUTDATA1_OUT13_SET    (0x0001u)

#define CSL_GPIO_IOOUTDATA1_OUT12_MASK   (0x1000u)
#define CSL_GPIO_IOOUTDATA1_OUT12_SHIFT  (0x000Cu)
#define CSL_GPIO_IOOUTDATA1_OUT12_RESETVAL (0x0000u)
/*----OUT12 Tokens----*/
#define CSL_GPIO_IOOUTDATA1_OUT12_CLEAR  (0x0000u)
#define CSL_GPIO_IOOUTDATA1_OUT12_SET    (0x0001u)

#define CSL_GPIO_IOOUTDATA1_OUT11_MASK   (0x0800u)
#define CSL_GPIO_IOOUTDATA1_OUT11_SHIFT  (0x000Bu)
#define CSL_GPIO_IOOUTDATA1_OUT11_RESETVAL (0x0000u)
/*----OUT11 Tokens----*/
#define CSL_GPIO_IOOUTDATA1_OUT11_CLEAR  (0x0000u)
#define CSL_GPIO_IOOUTDATA1_OUT11_SET    (0x0001u)

#define CSL_GPIO_IOOUTDATA1_OUT10_MASK   (0x0400u)
#define CSL_GPIO_IOOUTDATA1_OUT10_SHIFT  (0x000Au)
#define CSL_GPIO_IOOUTDATA1_OUT10_RESETVAL (0x0000u)
/*----OUT10 Tokens----*/
#define CSL_GPIO_IOOUTDATA1_OUT10_CLEAR  (0x0000u)
#define CSL_GPIO_IOOUTDATA1_OUT10_SET    (0x0001u)

#define CSL_GPIO_IOOUTDATA1_OUT9_MASK    (0x0200u)
#define CSL_GPIO_IOOUTDATA1_OUT9_SHIFT   (0x0009u)
#define CSL_GPIO_IOOUTDATA1_OUT9_RESETVAL (0x0000u)
/*----OUT9 Tokens----*/
#define CSL_GPIO_IOOUTDATA1_OUT9_CLEAR   (0x0000u)
#define CSL_GPIO_IOOUTDATA1_OUT9_SET     (0x0001u)

#define CSL_GPIO_IOOUTDATA1_OUT8_MASK    (0x0100u)
#define CSL_GPIO_IOOUTDATA1_OUT8_SHIFT   (0x0008u)
#define CSL_GPIO_IOOUTDATA1_OUT8_RESETVAL (0x0000u)
/*----OUT8 Tokens----*/
#define CSL_GPIO_IOOUTDATA1_OUT8_CLEAR   (0x0000u)
#define CSL_GPIO_IOOUTDATA1_OUT8_SET     (0x0001u)

#define CSL_GPIO_IOOUTDATA1_OUT7_MASK    (0x0080u)
#define CSL_GPIO_IOOUTDATA1_OUT7_SHIFT   (0x0007u)
#define CSL_GPIO_IOOUTDATA1_OUT7_RESETVAL (0x0000u)
/*----OUT7 Tokens----*/
#define CSL_GPIO_IOOUTDATA1_OUT7_CLEAR   (0x0000u)
#define CSL_GPIO_IOOUTDATA1_OUT7_SET     (0x0001u)

#define CSL_GPIO_IOOUTDATA1_OUT6_MASK    (0x0040u)
#define CSL_GPIO_IOOUTDATA1_OUT6_SHIFT   (0x0006u)
#define CSL_GPIO_IOOUTDATA1_OUT6_RESETVAL (0x0000u)
/*----OUT6 Tokens----*/
#define CSL_GPIO_IOOUTDATA1_OUT6_CLEAR   (0x0000u)
#define CSL_GPIO_IOOUTDATA1_OUT6_SET     (0x0001u)

#define CSL_GPIO_IOOUTDATA1_OUT5_MASK    (0x0020u)
#define CSL_GPIO_IOOUTDATA1_OUT5_SHIFT   (0x0005u)
#define CSL_GPIO_IOOUTDATA1_OUT5_RESETVAL (0x0000u)
/*----OUT5 Tokens----*/
#define CSL_GPIO_IOOUTDATA1_OUT5_CLEAR   (0x0000u)
#define CSL_GPIO_IOOUTDATA1_OUT5_SET     (0x0001u)

#define CSL_GPIO_IOOUTDATA1_OUT4_MASK    (0x0010u)
#define CSL_GPIO_IOOUTDATA1_OUT4_SHIFT   (0x0004u)
#define CSL_GPIO_IOOUTDATA1_OUT4_RESETVAL (0x0000u)
/*----OUT4 Tokens----*/
#define CSL_GPIO_IOOUTDATA1_OUT4_CLEAR   (0x0000u)
#define CSL_GPIO_IOOUTDATA1_OUT4_SET     (0x0001u)

#define CSL_GPIO_IOOUTDATA1_OUT3_MASK    (0x0008u)
#define CSL_GPIO_IOOUTDATA1_OUT3_SHIFT   (0x0003u)
#define CSL_GPIO_IOOUTDATA1_OUT3_RESETVAL (0x0000u)
/*----OUT3 Tokens----*/
#define CSL_GPIO_IOOUTDATA1_OUT3_CLEAR   (0x0000u)
#define CSL_GPIO_IOOUTDATA1_OUT3_SET     (0x0001u)

#define CSL_GPIO_IOOUTDATA1_OUT2_MASK    (0x0004u)
#define CSL_GPIO_IOOUTDATA1_OUT2_SHIFT   (0x0002u)
#define CSL_GPIO_IOOUTDATA1_OUT2_RESETVAL (0x0000u)
/*----OUT2 Tokens----*/
#define CSL_GPIO_IOOUTDATA1_OUT2_CLEAR   (0x0000u)
#define CSL_GPIO_IOOUTDATA1_OUT2_SET     (0x0001u)

#define CSL_GPIO_IOOUTDATA1_OUT1_MASK    (0x0002u)
#define CSL_GPIO_IOOUTDATA1_OUT1_SHIFT   (0x0001u)
#define CSL_GPIO_IOOUTDATA1_OUT1_RESETVAL (0x0000u)
/*----OUT1 Tokens----*/
#define CSL_GPIO_IOOUTDATA1_OUT1_CLEAR   (0x0000u)
#define CSL_GPIO_IOOUTDATA1_OUT1_SET     (0x0001u)

#define CSL_GPIO_IOOUTDATA1_OUT0_MASK    (0x0001u)
#define CSL_GPIO_IOOUTDATA1_OUT0_SHIFT   (0x0000u)
#define CSL_GPIO_IOOUTDATA1_OUT0_RESETVAL (0x0000u)
/*----OUT0 Tokens----*/
#define CSL_GPIO_IOOUTDATA1_OUT0_CLEAR   (0x0000u)
#define CSL_GPIO_IOOUTDATA1_OUT0_SET     (0x0001u)

#define CSL_GPIO_IOOUTDATA1_RESETVAL     (0x0000u)

/* IOOUTDATA2 */

#define CSL_GPIO_IOOUTDATA2_OUT31_MASK   (0x8000u)
#define CSL_GPIO_IOOUTDATA2_OUT31_SHIFT  (0x000Fu)
#define CSL_GPIO_IOOUTDATA2_OUT31_RESETVAL (0x0000u)
/*----OUT31 Tokens----*/
#define CSL_GPIO_IOOUTDATA2_OUT31_CLEAR  (0x0000u)
#define CSL_GPIO_IOOUTDATA2_OUT31_SET    (0x0001u)

#define CSL_GPIO_IOOUTDATA2_OUT30_MASK   (0x4000u)
#define CSL_GPIO_IOOUTDATA2_OUT30_SHIFT  (0x000Eu)
#define CSL_GPIO_IOOUTDATA2_OUT30_RESETVAL (0x0000u)
/*----OUT30 Tokens----*/
#define CSL_GPIO_IOOUTDATA2_OUT30_CLEAR  (0x0000u)
#define CSL_GPIO_IOOUTDATA2_OUT30_SET    (0x0001u)

#define CSL_GPIO_IOOUTDATA2_OUT29_MASK   (0x2000u)
#define CSL_GPIO_IOOUTDATA2_OUT29_SHIFT  (0x000Du)
#define CSL_GPIO_IOOUTDATA2_OUT29_RESETVAL (0x0000u)
/*----OUT29 Tokens----*/
#define CSL_GPIO_IOOUTDATA2_OUT29_CLEAR  (0x0000u)
#define CSL_GPIO_IOOUTDATA2_OUT29_SET    (0x0001u)

#define CSL_GPIO_IOOUTDATA2_OUT28_MASK   (0x1000u)
#define CSL_GPIO_IOOUTDATA2_OUT28_SHIFT  (0x000Cu)
#define CSL_GPIO_IOOUTDATA2_OUT28_RESETVAL (0x0000u)
/*----OUT28 Tokens----*/
#define CSL_GPIO_IOOUTDATA2_OUT28_CLEAR  (0x0000u)
#define CSL_GPIO_IOOUTDATA2_OUT28_SET    (0x0001u)

#define CSL_GPIO_IOOUTDATA2_OUT27_MASK   (0x0800u)
#define CSL_GPIO_IOOUTDATA2_OUT27_SHIFT  (0x000Bu)
#define CSL_GPIO_IOOUTDATA2_OUT27_RESETVAL (0x0000u)
/*----OUT27 Tokens----*/
#define CSL_GPIO_IOOUTDATA2_OUT27_CLEAR  (0x0000u)
#define CSL_GPIO_IOOUTDATA2_OUT27_SET    (0x0001u)

#define CSL_GPIO_IOOUTDATA2_OUT26_MASK   (0x0400u)
#define CSL_GPIO_IOOUTDATA2_OUT26_SHIFT  (0x000Au)
#define CSL_GPIO_IOOUTDATA2_OUT26_RESETVAL (0x0000u)
/*----OUT26 Tokens----*/
#define CSL_GPIO_IOOUTDATA2_OUT26_CLEAR  (0x0000u)
#define CSL_GPIO_IOOUTDATA2_OUT26_SET    (0x0001u)

#define CSL_GPIO_IOOUTDATA2_OUT25_MASK   (0x0200u)
#define CSL_GPIO_IOOUTDATA2_OUT25_SHIFT  (0x0009u)
#define CSL_GPIO_IOOUTDATA2_OUT25_RESETVAL (0x0000u)
/*----OUT25 Tokens----*/
#define CSL_GPIO_IOOUTDATA2_OUT25_CLEAR  (0x0000u)
#define CSL_GPIO_IOOUTDATA2_OUT25_SET    (0x0001u)

#define CSL_GPIO_IOOUTDATA2_OUT24_MASK   (0x0100u)
#define CSL_GPIO_IOOUTDATA2_OUT24_SHIFT  (0x0008u)
#define CSL_GPIO_IOOUTDATA2_OUT24_RESETVAL (0x0000u)
/*----OUT24 Tokens----*/
#define CSL_GPIO_IOOUTDATA2_OUT24_CLEAR  (0x0000u)
#define CSL_GPIO_IOOUTDATA2_OUT24_SET    (0x0001u)

#define CSL_GPIO_IOOUTDATA2_OUT23_MASK   (0x0080u)
#define CSL_GPIO_IOOUTDATA2_OUT23_SHIFT  (0x0007u)
#define CSL_GPIO_IOOUTDATA2_OUT23_RESETVAL (0x0000u)
/*----OUT23 Tokens----*/
#define CSL_GPIO_IOOUTDATA2_OUT23_CLEAR  (0x0000u)
#define CSL_GPIO_IOOUTDATA2_OUT23_SET    (0x0001u)

#define CSL_GPIO_IOOUTDATA2_OUT22_MASK   (0x0040u)
#define CSL_GPIO_IOOUTDATA2_OUT22_SHIFT  (0x0006u)
#define CSL_GPIO_IOOUTDATA2_OUT22_RESETVAL (0x0000u)
/*----OUT22 Tokens----*/
#define CSL_GPIO_IOOUTDATA2_OUT22_CLEAR  (0x0000u)
#define CSL_GPIO_IOOUTDATA2_OUT22_SET    (0x0001u)

#define CSL_GPIO_IOOUTDATA2_OUT21_MASK   (0x0020u)
#define CSL_GPIO_IOOUTDATA2_OUT21_SHIFT  (0x0005u)
#define CSL_GPIO_IOOUTDATA2_OUT21_RESETVAL (0x0000u)
/*----OUT21 Tokens----*/
#define CSL_GPIO_IOOUTDATA2_OUT21_CLEAR  (0x0000u)
#define CSL_GPIO_IOOUTDATA2_OUT21_SET    (0x0001u)

#define CSL_GPIO_IOOUTDATA2_OUT20_MASK   (0x0010u)
#define CSL_GPIO_IOOUTDATA2_OUT20_SHIFT  (0x0004u)
#define CSL_GPIO_IOOUTDATA2_OUT20_RESETVAL (0x0000u)
/*----OUT20 Tokens----*/
#define CSL_GPIO_IOOUTDATA2_OUT20_CLEAR  (0x0000u)
#define CSL_GPIO_IOOUTDATA2_OUT20_SET    (0x0001u)

#define CSL_GPIO_IOOUTDATA2_OUT19_MASK   (0x0008u)
#define CSL_GPIO_IOOUTDATA2_OUT19_SHIFT  (0x0003u)
#define CSL_GPIO_IOOUTDATA2_OUT19_RESETVAL (0x0000u)
/*----OUT19 Tokens----*/
#define CSL_GPIO_IOOUTDATA2_OUT19_CLEAR  (0x0000u)
#define CSL_GPIO_IOOUTDATA2_OUT19_SET    (0x0001u)

#define CSL_GPIO_IOOUTDATA2_OUT18_MASK   (0x0004u)
#define CSL_GPIO_IOOUTDATA2_OUT18_SHIFT  (0x0002u)
#define CSL_GPIO_IOOUTDATA2_OUT18_RESETVAL (0x0000u)
/*----OUT18 Tokens----*/
#define CSL_GPIO_IOOUTDATA2_OUT18_CLEAR  (0x0000u)
#define CSL_GPIO_IOOUTDATA2_OUT18_SET    (0x0001u)

#define CSL_GPIO_IOOUTDATA2_OUT17_MASK   (0x0002u)
#define CSL_GPIO_IOOUTDATA2_OUT17_SHIFT  (0x0001u)
#define CSL_GPIO_IOOUTDATA2_OUT17_RESETVAL (0x0000u)
/*----OUT17 Tokens----*/
#define CSL_GPIO_IOOUTDATA2_OUT17_CLEAR  (0x0000u)
#define CSL_GPIO_IOOUTDATA2_OUT17_SET    (0x0001u)

#define CSL_GPIO_IOOUTDATA2_OUT16_MASK   (0x0001u)
#define CSL_GPIO_IOOUTDATA2_OUT16_SHIFT  (0x0000u)
#define CSL_GPIO_IOOUTDATA2_OUT16_RESETVAL (0x0000u)
/*----OUT16 Tokens----*/
#define CSL_GPIO_IOOUTDATA2_OUT16_CLEAR  (0x0000u)
#define CSL_GPIO_IOOUTDATA2_OUT16_SET    (0x0001u)

#define CSL_GPIO_IOOUTDATA2_RESETVAL     (0x0000u)

/* IOINTEDG1 */

#define CSL_GPIO_IOINTEDG1_INTEDG15_MASK (0x8000u)
#define CSL_GPIO_IOINTEDG1_INTEDG15_SHIFT (0x000Fu)
#define CSL_GPIO_IOINTEDG1_INTEDG15_RESETVAL (0x0000u)
/*----INTEDG15 Tokens----*/
#define CSL_GPIO_IOINTEDG1_INTEDG15_CLEAR (0x0000u)
#define CSL_GPIO_IOINTEDG1_INTEDG15_SET  (0x0001u)

#define CSL_GPIO_IOINTEDG1_INTEDG14_MASK (0x4000u)
#define CSL_GPIO_IOINTEDG1_INTEDG14_SHIFT (0x000Eu)
#define CSL_GPIO_IOINTEDG1_INTEDG14_RESETVAL (0x0000u)
/*----INTEDG14 Tokens----*/
#define CSL_GPIO_IOINTEDG1_INTEDG14_CLEAR (0x0000u)
#define CSL_GPIO_IOINTEDG1_INTEDG14_SET  (0x0001u)

#define CSL_GPIO_IOINTEDG1_INTEDG13_MASK (0x2000u)
#define CSL_GPIO_IOINTEDG1_INTEDG13_SHIFT (0x000Du)
#define CSL_GPIO_IOINTEDG1_INTEDG13_RESETVAL (0x0000u)
/*----INTEDG13 Tokens----*/
#define CSL_GPIO_IOINTEDG1_INTEDG13_CLEAR (0x0000u)
#define CSL_GPIO_IOINTEDG1_INTEDG13_SET  (0x0001u)

#define CSL_GPIO_IOINTEDG1_INTEDG12_MASK (0x1000u)
#define CSL_GPIO_IOINTEDG1_INTEDG12_SHIFT (0x000Cu)
#define CSL_GPIO_IOINTEDG1_INTEDG12_RESETVAL (0x0000u)
/*----INTEDG12 Tokens----*/
#define CSL_GPIO_IOINTEDG1_INTEDG12_CLEAR (0x0000u)
#define CSL_GPIO_IOINTEDG1_INTEDG12_SET  (0x0001u)

#define CSL_GPIO_IOINTEDG1_INTEDG11_MASK (0x0800u)
#define CSL_GPIO_IOINTEDG1_INTEDG11_SHIFT (0x000Bu)
#define CSL_GPIO_IOINTEDG1_INTEDG11_RESETVAL (0x0000u)
/*----INTEDG11 Tokens----*/
#define CSL_GPIO_IOINTEDG1_INTEDG11_CLEAR (0x0000u)
#define CSL_GPIO_IOINTEDG1_INTEDG11_SET  (0x0001u)

#define CSL_GPIO_IOINTEDG1_INTEDG10_MASK (0x0400u)
#define CSL_GPIO_IOINTEDG1_INTEDG10_SHIFT (0x000Au)
#define CSL_GPIO_IOINTEDG1_INTEDG10_RESETVAL (0x0000u)
/*----INTEDG10 Tokens----*/
#define CSL_GPIO_IOINTEDG1_INTEDG10_CLEAR (0x0000u)
#define CSL_GPIO_IOINTEDG1_INTEDG10_SET  (0x0001u)

#define CSL_GPIO_IOINTEDG1_INTEDG9_MASK  (0x0200u)
#define CSL_GPIO_IOINTEDG1_INTEDG9_SHIFT (0x0009u)
#define CSL_GPIO_IOINTEDG1_INTEDG9_RESETVAL (0x0000u)
/*----INTEDG9 Tokens----*/
#define CSL_GPIO_IOINTEDG1_INTEDG9_CLEAR (0x0000u)
#define CSL_GPIO_IOINTEDG1_INTEDG9_SET   (0x0001u)

#define CSL_GPIO_IOINTEDG1_INTEDG8_MASK  (0x0100u)
#define CSL_GPIO_IOINTEDG1_INTEDG8_SHIFT (0x0008u)
#define CSL_GPIO_IOINTEDG1_INTEDG8_RESETVAL (0x0000u)
/*----INTEDG8 Tokens----*/
#define CSL_GPIO_IOINTEDG1_INTEDG8_CLEAR (0x0000u)
#define CSL_GPIO_IOINTEDG1_INTEDG8_SET   (0x0001u)

#define CSL_GPIO_IOINTEDG1_INTEDG7_MASK  (0x0080u)
#define CSL_GPIO_IOINTEDG1_INTEDG7_SHIFT (0x0007u)
#define CSL_GPIO_IOINTEDG1_INTEDG7_RESETVAL (0x0000u)
/*----INTEDG7 Tokens----*/
#define CSL_GPIO_IOINTEDG1_INTEDG7_CLEAR (0x0000u)
#define CSL_GPIO_IOINTEDG1_INTEDG7_SET   (0x0001u)

#define CSL_GPIO_IOINTEDG1_INTEDG6_MASK  (0x0040u)
#define CSL_GPIO_IOINTEDG1_INTEDG6_SHIFT (0x0006u)
#define CSL_GPIO_IOINTEDG1_INTEDG6_RESETVAL (0x0000u)
/*----INTEDG6 Tokens----*/
#define CSL_GPIO_IOINTEDG1_INTEDG6_CLEAR (0x0000u)
#define CSL_GPIO_IOINTEDG1_INTEDG6_SET   (0x0001u)

#define CSL_GPIO_IOINTEDG1_INTEDG5_MASK  (0x0020u)
#define CSL_GPIO_IOINTEDG1_INTEDG5_SHIFT (0x0005u)
#define CSL_GPIO_IOINTEDG1_INTEDG5_RESETVAL (0x0000u)
/*----INTEDG5 Tokens----*/
#define CSL_GPIO_IOINTEDG1_INTEDG5_CLEAR (0x0000u)
#define CSL_GPIO_IOINTEDG1_INTEDG5_SET   (0x0001u)

#define CSL_GPIO_IOINTEDG1_INTEDG4_MASK  (0x0010u)
#define CSL_GPIO_IOINTEDG1_INTEDG4_SHIFT (0x0004u)
#define CSL_GPIO_IOINTEDG1_INTEDG4_RESETVAL (0x0000u)
/*----INTEDG4 Tokens----*/
#define CSL_GPIO_IOINTEDG1_INTEDG4_CLEAR (0x0000u)
#define CSL_GPIO_IOINTEDG1_INTEDG4_SET   (0x0001u)

#define CSL_GPIO_IOINTEDG1_INTEDG3_MASK  (0x0008u)
#define CSL_GPIO_IOINTEDG1_INTEDG3_SHIFT (0x0003u)
#define CSL_GPIO_IOINTEDG1_INTEDG3_RESETVAL (0x0000u)
/*----INTEDG3 Tokens----*/
#define CSL_GPIO_IOINTEDG1_INTEDG3_CLEAR (0x0000u)
#define CSL_GPIO_IOINTEDG1_INTEDG3_SET   (0x0001u)

#define CSL_GPIO_IOINTEDG1_INTEDG2_MASK  (0x0004u)
#define CSL_GPIO_IOINTEDG1_INTEDG2_SHIFT (0x0002u)
#define CSL_GPIO_IOINTEDG1_INTEDG2_RESETVAL (0x0000u)
/*----INTEDG2 Tokens----*/
#define CSL_GPIO_IOINTEDG1_INTEDG2_CLEAR (0x0000u)
#define CSL_GPIO_IOINTEDG1_INTEDG2_SET   (0x0001u)

#define CSL_GPIO_IOINTEDG1_INTEDG1_MASK  (0x0002u)
#define CSL_GPIO_IOINTEDG1_INTEDG1_SHIFT (0x0001u)
#define CSL_GPIO_IOINTEDG1_INTEDG1_RESETVAL (0x0000u)
/*----INTEDG1 Tokens----*/
#define CSL_GPIO_IOINTEDG1_INTEDG1_CLEAR (0x0000u)
#define CSL_GPIO_IOINTEDG1_INTEDG1_SET   (0x0001u)

#define CSL_GPIO_IOINTEDG1_INTEDG0_MASK  (0x0001u)
#define CSL_GPIO_IOINTEDG1_INTEDG0_SHIFT (0x0000u)
#define CSL_GPIO_IOINTEDG1_INTEDG0_RESETVAL (0x0000u)
/*----INTEDG0 Tokens----*/
#define CSL_GPIO_IOINTEDG1_INTEDG0_CLEAR (0x0000u)
#define CSL_GPIO_IOINTEDG1_INTEDG0_SET   (0x0001u)

#define CSL_GPIO_IOINTEDG1_RESETVAL      (0x0000u)

/* IOINTEDG2 */

#define CSL_GPIO_IOINTEDG2_INTEDG31_MASK (0x8000u)
#define CSL_GPIO_IOINTEDG2_INTEDG31_SHIFT (0x000Fu)
#define CSL_GPIO_IOINTEDG2_INTEDG31_RESETVAL (0x0000u)
/*----INTEDG31 Tokens----*/
#define CSL_GPIO_IOINTEDG2_INTEDG31_CLEAR (0x0000u)
#define CSL_GPIO_IOINTEDG2_INTEDG31_SET  (0x0001u)

#define CSL_GPIO_IOINTEDG2_INTEDG30_MASK (0x4000u)
#define CSL_GPIO_IOINTEDG2_INTEDG30_SHIFT (0x000Eu)
#define CSL_GPIO_IOINTEDG2_INTEDG30_RESETVAL (0x0000u)
/*----INTEDG30 Tokens----*/
#define CSL_GPIO_IOINTEDG2_INTEDG30_CLEAR (0x0000u)
#define CSL_GPIO_IOINTEDG2_INTEDG30_SET  (0x0001u)

#define CSL_GPIO_IOINTEDG2_INTEDG29_MASK (0x2000u)
#define CSL_GPIO_IOINTEDG2_INTEDG29_SHIFT (0x000Du)
#define CSL_GPIO_IOINTEDG2_INTEDG29_RESETVAL (0x0000u)
/*----INTEDG29 Tokens----*/
#define CSL_GPIO_IOINTEDG2_INTEDG29_CLEAR (0x0000u)
#define CSL_GPIO_IOINTEDG2_INTEDG29_SET  (0x0001u)

#define CSL_GPIO_IOINTEDG2_INTEDG28_MASK (0x1000u)
#define CSL_GPIO_IOINTEDG2_INTEDG28_SHIFT (0x000Cu)
#define CSL_GPIO_IOINTEDG2_INTEDG28_RESETVAL (0x0000u)
/*----INTEDG28 Tokens----*/
#define CSL_GPIO_IOINTEDG2_INTEDG28_CLEAR (0x0000u)
#define CSL_GPIO_IOINTEDG2_INTEDG28_SET  (0x0001u)

#define CSL_GPIO_IOINTEDG2_INTEDG27_MASK (0x0800u)
#define CSL_GPIO_IOINTEDG2_INTEDG27_SHIFT (0x000Bu)
#define CSL_GPIO_IOINTEDG2_INTEDG27_RESETVAL (0x0000u)
/*----INTEDG27 Tokens----*/
#define CSL_GPIO_IOINTEDG2_INTEDG27_CLEAR (0x0000u)
#define CSL_GPIO_IOINTEDG2_INTEDG27_SET  (0x0001u)

#define CSL_GPIO_IOINTEDG2_INTEDG26_MASK (0x0400u)
#define CSL_GPIO_IOINTEDG2_INTEDG26_SHIFT (0x000Au)
#define CSL_GPIO_IOINTEDG2_INTEDG26_RESETVAL (0x0000u)
/*----INTEDG26 Tokens----*/
#define CSL_GPIO_IOINTEDG2_INTEDG26_CLEAR (0x0000u)
#define CSL_GPIO_IOINTEDG2_INTEDG26_SET  (0x0001u)

#define CSL_GPIO_IOINTEDG2_INTEDG25_MASK (0x0200u)
#define CSL_GPIO_IOINTEDG2_INTEDG25_SHIFT (0x0009u)
#define CSL_GPIO_IOINTEDG2_INTEDG25_RESETVAL (0x0000u)
/*----INTEDG25 Tokens----*/
#define CSL_GPIO_IOINTEDG2_INTEDG25_CLEAR (0x0000u)
#define CSL_GPIO_IOINTEDG2_INTEDG25_SET  (0x0001u)

#define CSL_GPIO_IOINTEDG2_INTEDG24_MASK (0x0100u)
#define CSL_GPIO_IOINTEDG2_INTEDG24_SHIFT (0x0008u)
#define CSL_GPIO_IOINTEDG2_INTEDG24_RESETVAL (0x0000u)
/*----INTEDG24 Tokens----*/
#define CSL_GPIO_IOINTEDG2_INTEDG24_CLEAR (0x0000u)
#define CSL_GPIO_IOINTEDG2_INTEDG24_SET  (0x0001u)

#define CSL_GPIO_IOINTEDG2_INTEDG23_MASK (0x0080u)
#define CSL_GPIO_IOINTEDG2_INTEDG23_SHIFT (0x0007u)
#define CSL_GPIO_IOINTEDG2_INTEDG23_RESETVAL (0x0000u)
/*----INTEDG23 Tokens----*/
#define CSL_GPIO_IOINTEDG2_INTEDG23_CLEAR (0x0000u)
#define CSL_GPIO_IOINTEDG2_INTEDG23_SET  (0x0001u)

#define CSL_GPIO_IOINTEDG2_INTEDG22_MASK (0x0040u)
#define CSL_GPIO_IOINTEDG2_INTEDG22_SHIFT (0x0006u)
#define CSL_GPIO_IOINTEDG2_INTEDG22_RESETVAL (0x0000u)
/*----INTEDG22 Tokens----*/
#define CSL_GPIO_IOINTEDG2_INTEDG22_CLEAR (0x0000u)
#define CSL_GPIO_IOINTEDG2_INTEDG22_SET  (0x0001u)

#define CSL_GPIO_IOINTEDG2_INTEDG21_MASK (0x0020u)
#define CSL_GPIO_IOINTEDG2_INTEDG21_SHIFT (0x0005u)
#define CSL_GPIO_IOINTEDG2_INTEDG21_RESETVAL (0x0000u)
/*----INTEDG21 Tokens----*/
#define CSL_GPIO_IOINTEDG2_INTEDG21_CLEAR (0x0000u)
#define CSL_GPIO_IOINTEDG2_INTEDG21_SET  (0x0001u)

#define CSL_GPIO_IOINTEDG2_INTEDG20_MASK (0x0010u)
#define CSL_GPIO_IOINTEDG2_INTEDG20_SHIFT (0x0004u)
#define CSL_GPIO_IOINTEDG2_INTEDG20_RESETVAL (0x0000u)
/*----INTEDG20 Tokens----*/
#define CSL_GPIO_IOINTEDG2_INTEDG20_CLEAR (0x0000u)
#define CSL_GPIO_IOINTEDG2_INTEDG20_SET  (0x0001u)

#define CSL_GPIO_IOINTEDG2_INTEDG19_MASK (0x0008u)
#define CSL_GPIO_IOINTEDG2_INTEDG19_SHIFT (0x0003u)
#define CSL_GPIO_IOINTEDG2_INTEDG19_RESETVAL (0x0000u)
/*----INTEDG19 Tokens----*/
#define CSL_GPIO_IOINTEDG2_INTEDG19_CLEAR (0x0000u)
#define CSL_GPIO_IOINTEDG2_INTEDG19_SET  (0x0001u)

#define CSL_GPIO_IOINTEDG2_INTEDG18_MASK (0x0004u)
#define CSL_GPIO_IOINTEDG2_INTEDG18_SHIFT (0x0002u)
#define CSL_GPIO_IOINTEDG2_INTEDG18_RESETVAL (0x0000u)
/*----INTEDG18 Tokens----*/
#define CSL_GPIO_IOINTEDG2_INTEDG18_CLEAR (0x0000u)
#define CSL_GPIO_IOINTEDG2_INTEDG18_SET  (0x0001u)

#define CSL_GPIO_IOINTEDG2_INTEDG17_MASK (0x0002u)
#define CSL_GPIO_IOINTEDG2_INTEDG17_SHIFT (0x0001u)
#define CSL_GPIO_IOINTEDG2_INTEDG17_RESETVAL (0x0000u)
/*----INTEDG17 Tokens----*/
#define CSL_GPIO_IOINTEDG2_INTEDG17_CLEAR (0x0000u)
#define CSL_GPIO_IOINTEDG2_INTEDG17_SET  (0x0001u)

#define CSL_GPIO_IOINTEDG2_INTEDG16_MASK (0x0001u)
#define CSL_GPIO_IOINTEDG2_INTEDG16_SHIFT (0x0000u)
#define CSL_GPIO_IOINTEDG2_INTEDG16_RESETVAL (0x0000u)
/*----INTEDG16 Tokens----*/
#define CSL_GPIO_IOINTEDG2_INTEDG16_CLEAR (0x0000u)
#define CSL_GPIO_IOINTEDG2_INTEDG16_SET  (0x0001u)

#define CSL_GPIO_IOINTEDG2_RESETVAL      (0x0000u)

/* IOINTEN1 */

#define CSL_GPIO_IOINTEN1_INTEN15_MASK   (0x8000u)
#define CSL_GPIO_IOINTEN1_INTEN15_SHIFT  (0x000Fu)
#define CSL_GPIO_IOINTEN1_INTEN15_RESETVAL (0x0000u)
/*----INTEN15 Tokens----*/
#define CSL_GPIO_IOINTEN1_INTEN15_CLEAR  (0x0000u)
#define CSL_GPIO_IOINTEN1_INTEN15_SET    (0x0001u)

#define CSL_GPIO_IOINTEN1_INTEN14_MASK   (0x4000u)
#define CSL_GPIO_IOINTEN1_INTEN14_SHIFT  (0x000Eu)
#define CSL_GPIO_IOINTEN1_INTEN14_RESETVAL (0x0000u)
/*----INTEN14 Tokens----*/
#define CSL_GPIO_IOINTEN1_INTEN14_CLEAR  (0x0000u)
#define CSL_GPIO_IOINTEN1_INTEN14_SET    (0x0001u)

#define CSL_GPIO_IOINTEN1_INTEN13_MASK   (0x2000u)
#define CSL_GPIO_IOINTEN1_INTEN13_SHIFT  (0x000Du)
#define CSL_GPIO_IOINTEN1_INTEN13_RESETVAL (0x0000u)
/*----INTEN13 Tokens----*/
#define CSL_GPIO_IOINTEN1_INTEN13_CLEAR  (0x0000u)
#define CSL_GPIO_IOINTEN1_INTEN13_SET    (0x0001u)

#define CSL_GPIO_IOINTEN1_INTEN12_MASK   (0x1000u)
#define CSL_GPIO_IOINTEN1_INTEN12_SHIFT  (0x000Cu)
#define CSL_GPIO_IOINTEN1_INTEN12_RESETVAL (0x0000u)
/*----INTEN12 Tokens----*/
#define CSL_GPIO_IOINTEN1_INTEN12_CLEAR  (0x0000u)
#define CSL_GPIO_IOINTEN1_INTEN12_SET    (0x0001u)

#define CSL_GPIO_IOINTEN1_INTEN11_MASK   (0x0800u)
#define CSL_GPIO_IOINTEN1_INTEN11_SHIFT  (0x000Bu)
#define CSL_GPIO_IOINTEN1_INTEN11_RESETVAL (0x0000u)
/*----INTEN11 Tokens----*/
#define CSL_GPIO_IOINTEN1_INTEN11_CLEAR  (0x0000u)
#define CSL_GPIO_IOINTEN1_INTEN11_SET    (0x0001u)

#define CSL_GPIO_IOINTEN1_INTEN10_MASK   (0x0400u)
#define CSL_GPIO_IOINTEN1_INTEN10_SHIFT  (0x000Au)
#define CSL_GPIO_IOINTEN1_INTEN10_RESETVAL (0x0000u)
/*----INTEN10 Tokens----*/
#define CSL_GPIO_IOINTEN1_INTEN10_CLEAR  (0x0000u)
#define CSL_GPIO_IOINTEN1_INTEN10_SET    (0x0001u)

#define CSL_GPIO_IOINTEN1_INTEN9_MASK    (0x0200u)
#define CSL_GPIO_IOINTEN1_INTEN9_SHIFT   (0x0009u)
#define CSL_GPIO_IOINTEN1_INTEN9_RESETVAL (0x0000u)
/*----INTEN9 Tokens----*/
#define CSL_GPIO_IOINTEN1_INTEN9_CLEAR   (0x0000u)
#define CSL_GPIO_IOINTEN1_INTEN9_SET     (0x0001u)

#define CSL_GPIO_IOINTEN1_INTEN8_MASK    (0x0100u)
#define CSL_GPIO_IOINTEN1_INTEN8_SHIFT   (0x0008u)
#define CSL_GPIO_IOINTEN1_INTEN8_RESETVAL (0x0000u)
/*----INTEN8 Tokens----*/
#define CSL_GPIO_IOINTEN1_INTEN8_CLEAR   (0x0000u)
#define CSL_GPIO_IOINTEN1_INTEN8_SET     (0x0001u)

#define CSL_GPIO_IOINTEN1_INTEN7_MASK    (0x0080u)
#define CSL_GPIO_IOINTEN1_INTEN7_SHIFT   (0x0007u)
#define CSL_GPIO_IOINTEN1_INTEN7_RESETVAL (0x0000u)
/*----INTEN7 Tokens----*/
#define CSL_GPIO_IOINTEN1_INTEN7_CLEAR   (0x0000u)
#define CSL_GPIO_IOINTEN1_INTEN7_SET     (0x0001u)

#define CSL_GPIO_IOINTEN1_INTEN6_MASK    (0x0040u)
#define CSL_GPIO_IOINTEN1_INTEN6_SHIFT   (0x0006u)
#define CSL_GPIO_IOINTEN1_INTEN6_RESETVAL (0x0000u)
/*----INTEN6 Tokens----*/
#define CSL_GPIO_IOINTEN1_INTEN6_CLEAR   (0x0000u)
#define CSL_GPIO_IOINTEN1_INTEN6_SET     (0x0001u)

#define CSL_GPIO_IOINTEN1_INTEN5_MASK    (0x0020u)
#define CSL_GPIO_IOINTEN1_INTEN5_SHIFT   (0x0005u)
#define CSL_GPIO_IOINTEN1_INTEN5_RESETVAL (0x0000u)
/*----INTEN5 Tokens----*/
#define CSL_GPIO_IOINTEN1_INTEN5_CLEAR   (0x0000u)
#define CSL_GPIO_IOINTEN1_INTEN5_SET     (0x0001u)

#define CSL_GPIO_IOINTEN1_INTEN4_MASK    (0x0010u)
#define CSL_GPIO_IOINTEN1_INTEN4_SHIFT   (0x0004u)
#define CSL_GPIO_IOINTEN1_INTEN4_RESETVAL (0x0000u)
/*----INTEN4 Tokens----*/
#define CSL_GPIO_IOINTEN1_INTEN4_CLEAR   (0x0000u)
#define CSL_GPIO_IOINTEN1_INTEN4_SET     (0x0001u)

#define CSL_GPIO_IOINTEN1_INTEN3_MASK    (0x0008u)
#define CSL_GPIO_IOINTEN1_INTEN3_SHIFT   (0x0003u)
#define CSL_GPIO_IOINTEN1_INTEN3_RESETVAL (0x0000u)
/*----INTEN3 Tokens----*/
#define CSL_GPIO_IOINTEN1_INTEN3_CLEAR   (0x0000u)
#define CSL_GPIO_IOINTEN1_INTEN3_SET     (0x0001u)

#define CSL_GPIO_IOINTEN1_INTEN2_MASK    (0x0004u)
#define CSL_GPIO_IOINTEN1_INTEN2_SHIFT   (0x0002u)
#define CSL_GPIO_IOINTEN1_INTEN2_RESETVAL (0x0000u)
/*----INTEN2 Tokens----*/
#define CSL_GPIO_IOINTEN1_INTEN2_CLEAR   (0x0000u)
#define CSL_GPIO_IOINTEN1_INTEN2_SET     (0x0001u)

#define CSL_GPIO_IOINTEN1_INTEN1_MASK    (0x0002u)
#define CSL_GPIO_IOINTEN1_INTEN1_SHIFT   (0x0001u)
#define CSL_GPIO_IOINTEN1_INTEN1_RESETVAL (0x0000u)
/*----INTEN1 Tokens----*/
#define CSL_GPIO_IOINTEN1_INTEN1_CLEAR   (0x0000u)
#define CSL_GPIO_IOINTEN1_INTEN1_SET     (0x0001u)

#define CSL_GPIO_IOINTEN1_INTEN0_MASK    (0x0001u)
#define CSL_GPIO_IOINTEN1_INTEN0_SHIFT   (0x0000u)
#define CSL_GPIO_IOINTEN1_INTEN0_RESETVAL (0x0000u)
/*----INTEN0 Tokens----*/
#define CSL_GPIO_IOINTEN1_INTEN0_CLEAR   (0x0000u)
#define CSL_GPIO_IOINTEN1_INTEN0_SET     (0x0001u)

#define CSL_GPIO_IOINTEN1_RESETVAL       (0x0000u)

/* IOINTEN2 */

#define CSL_GPIO_IOINTEN2_INTEN31_MASK   (0x8000u)
#define CSL_GPIO_IOINTEN2_INTEN31_SHIFT  (0x000Fu)
#define CSL_GPIO_IOINTEN2_INTEN31_RESETVAL (0x0000u)
/*----INTEN31 Tokens----*/
#define CSL_GPIO_IOINTEN2_INTEN31_CLEAR  (0x0000u)
#define CSL_GPIO_IOINTEN2_INTEN31_SET    (0x0001u)

#define CSL_GPIO_IOINTEN2_INTEN30_MASK   (0x4000u)
#define CSL_GPIO_IOINTEN2_INTEN30_SHIFT  (0x000Eu)
#define CSL_GPIO_IOINTEN2_INTEN30_RESETVAL (0x0000u)
/*----INTEN30 Tokens----*/
#define CSL_GPIO_IOINTEN2_INTEN30_CLEAR  (0x0000u)
#define CSL_GPIO_IOINTEN2_INTEN30_SET    (0x0001u)

#define CSL_GPIO_IOINTEN2_INTEN29_MASK   (0x2000u)
#define CSL_GPIO_IOINTEN2_INTEN29_SHIFT  (0x000Du)
#define CSL_GPIO_IOINTEN2_INTEN29_RESETVAL (0x0000u)
/*----INTEN29 Tokens----*/
#define CSL_GPIO_IOINTEN2_INTEN29_CLEAR  (0x0000u)
#define CSL_GPIO_IOINTEN2_INTEN29_SET    (0x0001u)

#define CSL_GPIO_IOINTEN2_INTEN28_MASK   (0x1000u)
#define CSL_GPIO_IOINTEN2_INTEN28_SHIFT  (0x000Cu)
#define CSL_GPIO_IOINTEN2_INTEN28_RESETVAL (0x0000u)
/*----INTEN28 Tokens----*/
#define CSL_GPIO_IOINTEN2_INTEN28_CLEAR  (0x0000u)
#define CSL_GPIO_IOINTEN2_INTEN28_SET    (0x0001u)

#define CSL_GPIO_IOINTEN2_INTEN27_MASK   (0x0800u)
#define CSL_GPIO_IOINTEN2_INTEN27_SHIFT  (0x000Bu)
#define CSL_GPIO_IOINTEN2_INTEN27_RESETVAL (0x0000u)
/*----INTEN27 Tokens----*/
#define CSL_GPIO_IOINTEN2_INTEN27_CLEAR  (0x0000u)
#define CSL_GPIO_IOINTEN2_INTEN27_SET    (0x0001u)

#define CSL_GPIO_IOINTEN2_INTEN26_MASK   (0x0400u)
#define CSL_GPIO_IOINTEN2_INTEN26_SHIFT  (0x000Au)
#define CSL_GPIO_IOINTEN2_INTEN26_RESETVAL (0x0000u)
/*----INTEN26 Tokens----*/
#define CSL_GPIO_IOINTEN2_INTEN26_CLEAR  (0x0000u)
#define CSL_GPIO_IOINTEN2_INTEN26_SET    (0x0001u)

#define CSL_GPIO_IOINTEN2_INTEN25_MASK   (0x0200u)
#define CSL_GPIO_IOINTEN2_INTEN25_SHIFT  (0x0009u)
#define CSL_GPIO_IOINTEN2_INTEN25_RESETVAL (0x0000u)
/*----INTEN25 Tokens----*/
#define CSL_GPIO_IOINTEN2_INTEN25_CLEAR  (0x0000u)
#define CSL_GPIO_IOINTEN2_INTEN25_SET    (0x0001u)

#define CSL_GPIO_IOINTEN2_INTEN24_MASK   (0x0100u)
#define CSL_GPIO_IOINTEN2_INTEN24_SHIFT  (0x0008u)
#define CSL_GPIO_IOINTEN2_INTEN24_RESETVAL (0x0000u)
/*----INTEN24 Tokens----*/
#define CSL_GPIO_IOINTEN2_INTEN24_CLEAR  (0x0000u)
#define CSL_GPIO_IOINTEN2_INTEN24_SET    (0x0001u)

#define CSL_GPIO_IOINTEN2_INTEN23_MASK   (0x0080u)
#define CSL_GPIO_IOINTEN2_INTEN23_SHIFT  (0x0007u)
#define CSL_GPIO_IOINTEN2_INTEN23_RESETVAL (0x0000u)
/*----INTEN23 Tokens----*/
#define CSL_GPIO_IOINTEN2_INTEN23_CLEAR  (0x0000u)
#define CSL_GPIO_IOINTEN2_INTEN23_SET    (0x0001u)

#define CSL_GPIO_IOINTEN2_INTEN22_MASK   (0x0040u)
#define CSL_GPIO_IOINTEN2_INTEN22_SHIFT  (0x0006u)
#define CSL_GPIO_IOINTEN2_INTEN22_RESETVAL (0x0000u)
/*----INTEN22 Tokens----*/
#define CSL_GPIO_IOINTEN2_INTEN22_CLEAR  (0x0000u)
#define CSL_GPIO_IOINTEN2_INTEN22_SET    (0x0001u)

#define CSL_GPIO_IOINTEN2_INTEN21_MASK   (0x0020u)
#define CSL_GPIO_IOINTEN2_INTEN21_SHIFT  (0x0005u)
#define CSL_GPIO_IOINTEN2_INTEN21_RESETVAL (0x0000u)
/*----INTEN21 Tokens----*/
#define CSL_GPIO_IOINTEN2_INTEN21_CLEAR  (0x0000u)
#define CSL_GPIO_IOINTEN2_INTEN21_SET    (0x0001u)

#define CSL_GPIO_IOINTEN2_INTEN20_MASK   (0x0010u)
#define CSL_GPIO_IOINTEN2_INTEN20_SHIFT  (0x0004u)
#define CSL_GPIO_IOINTEN2_INTEN20_RESETVAL (0x0000u)
/*----INTEN20 Tokens----*/
#define CSL_GPIO_IOINTEN2_INTEN20_CLEAR  (0x0000u)
#define CSL_GPIO_IOINTEN2_INTEN20_SET    (0x0001u)

#define CSL_GPIO_IOINTEN2_INTEN19_MASK   (0x0008u)
#define CSL_GPIO_IOINTEN2_INTEN19_SHIFT  (0x0003u)
#define CSL_GPIO_IOINTEN2_INTEN19_RESETVAL (0x0000u)
/*----INTEN19 Tokens----*/
#define CSL_GPIO_IOINTEN2_INTEN19_CLEAR  (0x0000u)
#define CSL_GPIO_IOINTEN2_INTEN19_SET    (0x0001u)

#define CSL_GPIO_IOINTEN2_INTEN18_MASK   (0x0004u)
#define CSL_GPIO_IOINTEN2_INTEN18_SHIFT  (0x0002u)
#define CSL_GPIO_IOINTEN2_INTEN18_RESETVAL (0x0000u)
/*----INTEN18 Tokens----*/
#define CSL_GPIO_IOINTEN2_INTEN18_CLEAR  (0x0000u)
#define CSL_GPIO_IOINTEN2_INTEN18_SET    (0x0001u)

#define CSL_GPIO_IOINTEN2_INTEN17_MASK   (0x0002u)
#define CSL_GPIO_IOINTEN2_INTEN17_SHIFT  (0x0001u)
#define CSL_GPIO_IOINTEN2_INTEN17_RESETVAL (0x0000u)
/*----INTEN17 Tokens----*/
#define CSL_GPIO_IOINTEN2_INTEN17_CLEAR  (0x0000u)
#define CSL_GPIO_IOINTEN2_INTEN17_SET    (0x0001u)

#define CSL_GPIO_IOINTEN2_INTEN16_MASK   (0x0001u)
#define CSL_GPIO_IOINTEN2_INTEN16_SHIFT  (0x0000u)
#define CSL_GPIO_IOINTEN2_INTEN16_RESETVAL (0x0000u)
/*----INTEN16 Tokens----*/
#define CSL_GPIO_IOINTEN2_INTEN16_CLEAR  (0x0000u)
#define CSL_GPIO_IOINTEN2_INTEN16_SET    (0x0001u)

#define CSL_GPIO_IOINTEN2_RESETVAL       (0x0000u)

/* IOINTFLG1 */

#define CSL_GPIO_IOINTFLG1_INTFLG15_MASK (0x8000u)
#define CSL_GPIO_IOINTFLG1_INTFLG15_SHIFT (0x000Fu)
#define CSL_GPIO_IOINTFLG1_INTFLG15_RESETVAL (0x0000u)
/*----INTFLG15 Tokens----*/
#define CSL_GPIO_IOINTFLG1_INTFLG15_CLEAR (0x0000u)
#define CSL_GPIO_IOINTFLG1_INTFLG15_SET  (0x0001u)

#define CSL_GPIO_IOINTFLG1_INTFLG14_MASK (0x4000u)
#define CSL_GPIO_IOINTFLG1_INTFLG14_SHIFT (0x000Eu)
#define CSL_GPIO_IOINTFLG1_INTFLG14_RESETVAL (0x0000u)
/*----INTFLG14 Tokens----*/
#define CSL_GPIO_IOINTFLG1_INTFLG14_CLEAR (0x0000u)
#define CSL_GPIO_IOINTFLG1_INTFLG14_SET  (0x0001u)

#define CSL_GPIO_IOINTFLG1_INTFLG13_MASK (0x2000u)
#define CSL_GPIO_IOINTFLG1_INTFLG13_SHIFT (0x000Du)
#define CSL_GPIO_IOINTFLG1_INTFLG13_RESETVAL (0x0000u)
/*----INTFLG13 Tokens----*/
#define CSL_GPIO_IOINTFLG1_INTFLG13_CLEAR (0x0000u)
#define CSL_GPIO_IOINTFLG1_INTFLG13_SET  (0x0001u)

#define CSL_GPIO_IOINTFLG1_INTFLG12_MASK (0x1000u)
#define CSL_GPIO_IOINTFLG1_INTFLG12_SHIFT (0x000Cu)
#define CSL_GPIO_IOINTFLG1_INTFLG12_RESETVAL (0x0000u)
/*----INTFLG12 Tokens----*/
#define CSL_GPIO_IOINTFLG1_INTFLG12_CLEAR (0x0000u)
#define CSL_GPIO_IOINTFLG1_INTFLG12_SET  (0x0001u)

#define CSL_GPIO_IOINTFLG1_INTFLG11_MASK (0x0800u)
#define CSL_GPIO_IOINTFLG1_INTFLG11_SHIFT (0x000Bu)
#define CSL_GPIO_IOINTFLG1_INTFLG11_RESETVAL (0x0000u)
/*----INTFLG11 Tokens----*/
#define CSL_GPIO_IOINTFLG1_INTFLG11_CLEAR (0x0000u)
#define CSL_GPIO_IOINTFLG1_INTFLG11_SET  (0x0001u)

#define CSL_GPIO_IOINTFLG1_INTFLG10_MASK (0x0400u)
#define CSL_GPIO_IOINTFLG1_INTFLG10_SHIFT (0x000Au)
#define CSL_GPIO_IOINTFLG1_INTFLG10_RESETVAL (0x0000u)
/*----INTFLG10 Tokens----*/
#define CSL_GPIO_IOINTFLG1_INTFLG10_CLEAR (0x0000u)
#define CSL_GPIO_IOINTFLG1_INTFLG10_SET  (0x0001u)

#define CSL_GPIO_IOINTFLG1_INTFLG9_MASK  (0x0200u)
#define CSL_GPIO_IOINTFLG1_INTFLG9_SHIFT (0x0009u)
#define CSL_GPIO_IOINTFLG1_INTFLG9_RESETVAL (0x0000u)
/*----INTFLG9 Tokens----*/
#define CSL_GPIO_IOINTFLG1_INTFLG9_CLEAR (0x0000u)
#define CSL_GPIO_IOINTFLG1_INTFLG9_SET   (0x0001u)

#define CSL_GPIO_IOINTFLG1_INTFLG8_MASK  (0x0100u)
#define CSL_GPIO_IOINTFLG1_INTFLG8_SHIFT (0x0008u)
#define CSL_GPIO_IOINTFLG1_INTFLG8_RESETVAL (0x0000u)
/*----INTFLG8 Tokens----*/
#define CSL_GPIO_IOINTFLG1_INTFLG8_CLEAR (0x0000u)
#define CSL_GPIO_IOINTFLG1_INTFLG8_SET   (0x0001u)

#define CSL_GPIO_IOINTFLG1_INTFLG7_MASK  (0x0080u)
#define CSL_GPIO_IOINTFLG1_INTFLG7_SHIFT (0x0007u)
#define CSL_GPIO_IOINTFLG1_INTFLG7_RESETVAL (0x0000u)
/*----INTFLG7 Tokens----*/
#define CSL_GPIO_IOINTFLG1_INTFLG7_CLEAR (0x0000u)
#define CSL_GPIO_IOINTFLG1_INTFLG7_SET   (0x0001u)

#define CSL_GPIO_IOINTFLG1_INTFLG6_MASK  (0x0040u)
#define CSL_GPIO_IOINTFLG1_INTFLG6_SHIFT (0x0006u)
#define CSL_GPIO_IOINTFLG1_INTFLG6_RESETVAL (0x0000u)
/*----INTFLG6 Tokens----*/
#define CSL_GPIO_IOINTFLG1_INTFLG6_CLEAR (0x0000u)
#define CSL_GPIO_IOINTFLG1_INTFLG6_SET   (0x0001u)

#define CSL_GPIO_IOINTFLG1_INTFLG5_MASK  (0x0020u)
#define CSL_GPIO_IOINTFLG1_INTFLG5_SHIFT (0x0005u)
#define CSL_GPIO_IOINTFLG1_INTFLG5_RESETVAL (0x0000u)
/*----INTFLG5 Tokens----*/
#define CSL_GPIO_IOINTFLG1_INTFLG5_CLEAR (0x0000u)
#define CSL_GPIO_IOINTFLG1_INTFLG5_SET   (0x0001u)

#define CSL_GPIO_IOINTFLG1_INTFLG4_MASK  (0x0010u)
#define CSL_GPIO_IOINTFLG1_INTFLG4_SHIFT (0x0004u)
#define CSL_GPIO_IOINTFLG1_INTFLG4_RESETVAL (0x0000u)
/*----INTFLG4 Tokens----*/
#define CSL_GPIO_IOINTFLG1_INTFLG4_CLEAR (0x0000u)
#define CSL_GPIO_IOINTFLG1_INTFLG4_SET   (0x0001u)

#define CSL_GPIO_IOINTFLG1_INTFLG3_MASK  (0x0008u)
#define CSL_GPIO_IOINTFLG1_INTFLG3_SHIFT (0x0003u)
#define CSL_GPIO_IOINTFLG1_INTFLG3_RESETVAL (0x0000u)
/*----INTFLG3 Tokens----*/
#define CSL_GPIO_IOINTFLG1_INTFLG3_CLEAR (0x0000u)
#define CSL_GPIO_IOINTFLG1_INTFLG3_SET   (0x0001u)

#define CSL_GPIO_IOINTFLG1_INTFLG2_MASK  (0x0004u)
#define CSL_GPIO_IOINTFLG1_INTFLG2_SHIFT (0x0002u)
#define CSL_GPIO_IOINTFLG1_INTFLG2_RESETVAL (0x0000u)
/*----INTFLG2 Tokens----*/
#define CSL_GPIO_IOINTFLG1_INTFLG2_CLEAR (0x0000u)
#define CSL_GPIO_IOINTFLG1_INTFLG2_SET   (0x0001u)

#define CSL_GPIO_IOINTFLG1_INTFLG1_MASK  (0x0002u)
#define CSL_GPIO_IOINTFLG1_INTFLG1_SHIFT (0x0001u)
#define CSL_GPIO_IOINTFLG1_INTFLG1_RESETVAL (0x0000u)
/*----INTFLG1 Tokens----*/
#define CSL_GPIO_IOINTFLG1_INTFLG1_CLEAR (0x0000u)
#define CSL_GPIO_IOINTFLG1_INTFLG1_SET   (0x0001u)

#define CSL_GPIO_IOINTFLG1_INTFLG0_MASK  (0x0001u)
#define CSL_GPIO_IOINTFLG1_INTFLG0_SHIFT (0x0000u)
#define CSL_GPIO_IOINTFLG1_INTFLG0_RESETVAL (0x0000u)
/*----INTFLG0 Tokens----*/
#define CSL_GPIO_IOINTFLG1_INTFLG0_CLEAR (0x0000u)
#define CSL_GPIO_IOINTFLG1_INTFLG0_SET   (0x0001u)

#define CSL_GPIO_IOINTFLG1_RESETVAL      (0x0000u)

/* IOINTFLG2 */

#define CSL_GPIO_IOINTFLG2_INTFLG31_MASK (0x8000u)
#define CSL_GPIO_IOINTFLG2_INTFLG31_SHIFT (0x000Fu)
#define CSL_GPIO_IOINTFLG2_INTFLG31_RESETVAL (0x0000u)
/*----INTFLG31 Tokens----*/
#define CSL_GPIO_IOINTFLG2_INTFLG31_CLEAR (0x0000u)
#define CSL_GPIO_IOINTFLG2_INTFLG31_SET  (0x0001u)

#define CSL_GPIO_IOINTFLG2_INTFLG30_MASK (0x4000u)
#define CSL_GPIO_IOINTFLG2_INTFLG30_SHIFT (0x000Eu)
#define CSL_GPIO_IOINTFLG2_INTFLG30_RESETVAL (0x0000u)
/*----INTFLG30 Tokens----*/
#define CSL_GPIO_IOINTFLG2_INTFLG30_CLEAR (0x0000u)
#define CSL_GPIO_IOINTFLG2_INTFLG30_SET  (0x0001u)

#define CSL_GPIO_IOINTFLG2_INTFLG29_MASK (0x2000u)
#define CSL_GPIO_IOINTFLG2_INTFLG29_SHIFT (0x000Du)
#define CSL_GPIO_IOINTFLG2_INTFLG29_RESETVAL (0x0000u)
/*----INTFLG29 Tokens----*/
#define CSL_GPIO_IOINTFLG2_INTFLG29_CLEAR (0x0000u)
#define CSL_GPIO_IOINTFLG2_INTFLG29_SET  (0x0001u)

#define CSL_GPIO_IOINTFLG2_INTFLG28_MASK (0x1000u)
#define CSL_GPIO_IOINTFLG2_INTFLG28_SHIFT (0x000Cu)
#define CSL_GPIO_IOINTFLG2_INTFLG28_RESETVAL (0x0000u)
/*----INTFLG28 Tokens----*/
#define CSL_GPIO_IOINTFLG2_INTFLG28_CLEAR (0x0000u)
#define CSL_GPIO_IOINTFLG2_INTFLG28_SET  (0x0001u)

#define CSL_GPIO_IOINTFLG2_INTFLG27_MASK (0x0800u)
#define CSL_GPIO_IOINTFLG2_INTFLG27_SHIFT (0x000Bu)
#define CSL_GPIO_IOINTFLG2_INTFLG27_RESETVAL (0x0000u)
/*----INTFLG27 Tokens----*/
#define CSL_GPIO_IOINTFLG2_INTFLG27_CLEAR (0x0000u)
#define CSL_GPIO_IOINTFLG2_INTFLG27_SET  (0x0001u)

#define CSL_GPIO_IOINTFLG2_INTFLG26_MASK (0x0400u)
#define CSL_GPIO_IOINTFLG2_INTFLG26_SHIFT (0x000Au)
#define CSL_GPIO_IOINTFLG2_INTFLG26_RESETVAL (0x0000u)
/*----INTFLG26 Tokens----*/
#define CSL_GPIO_IOINTFLG2_INTFLG26_CLEAR (0x0000u)
#define CSL_GPIO_IOINTFLG2_INTFLG26_SET  (0x0001u)

#define CSL_GPIO_IOINTFLG2_INTFLG25_MASK (0x0200u)
#define CSL_GPIO_IOINTFLG2_INTFLG25_SHIFT (0x0009u)
#define CSL_GPIO_IOINTFLG2_INTFLG25_RESETVAL (0x0000u)
/*----INTFLG25 Tokens----*/
#define CSL_GPIO_IOINTFLG2_INTFLG25_CLEAR (0x0000u)
#define CSL_GPIO_IOINTFLG2_INTFLG25_SET  (0x0001u)

#define CSL_GPIO_IOINTFLG2_INTFLG24_MASK (0x0100u)
#define CSL_GPIO_IOINTFLG2_INTFLG24_SHIFT (0x0008u)
#define CSL_GPIO_IOINTFLG2_INTFLG24_RESETVAL (0x0000u)
/*----INTFLG24 Tokens----*/
#define CSL_GPIO_IOINTFLG2_INTFLG24_CLEAR (0x0000u)
#define CSL_GPIO_IOINTFLG2_INTFLG24_SET  (0x0001u)

#define CSL_GPIO_IOINTFLG2_INTFLG23_MASK (0x0080u)
#define CSL_GPIO_IOINTFLG2_INTFLG23_SHIFT (0x0007u)
#define CSL_GPIO_IOINTFLG2_INTFLG23_RESETVAL (0x0000u)
/*----INTFLG23 Tokens----*/
#define CSL_GPIO_IOINTFLG2_INTFLG23_CLEAR (0x0000u)
#define CSL_GPIO_IOINTFLG2_INTFLG23_SET  (0x0001u)

#define CSL_GPIO_IOINTFLG2_INTFLG22_MASK (0x0040u)
#define CSL_GPIO_IOINTFLG2_INTFLG22_SHIFT (0x0006u)
#define CSL_GPIO_IOINTFLG2_INTFLG22_RESETVAL (0x0000u)
/*----INTFLG22 Tokens----*/
#define CSL_GPIO_IOINTFLG2_INTFLG22_CLEAR (0x0000u)
#define CSL_GPIO_IOINTFLG2_INTFLG22_SET  (0x0001u)

#define CSL_GPIO_IOINTFLG2_INTFLG21_MASK (0x0020u)
#define CSL_GPIO_IOINTFLG2_INTFLG21_SHIFT (0x0005u)
#define CSL_GPIO_IOINTFLG2_INTFLG21_RESETVAL (0x0000u)
/*----INTFLG21 Tokens----*/
#define CSL_GPIO_IOINTFLG2_INTFLG21_CLEAR (0x0000u)
#define CSL_GPIO_IOINTFLG2_INTFLG21_SET  (0x0001u)

#define CSL_GPIO_IOINTFLG2_INTFLG20_MASK (0x0010u)
#define CSL_GPIO_IOINTFLG2_INTFLG20_SHIFT (0x0004u)
#define CSL_GPIO_IOINTFLG2_INTFLG20_RESETVAL (0x0000u)
/*----INTFLG20 Tokens----*/
#define CSL_GPIO_IOINTFLG2_INTFLG20_CLEAR (0x0000u)
#define CSL_GPIO_IOINTFLG2_INTFLG20_SET  (0x0001u)

#define CSL_GPIO_IOINTFLG2_INTFLG19_MASK (0x0008u)
#define CSL_GPIO_IOINTFLG2_INTFLG19_SHIFT (0x0003u)
#define CSL_GPIO_IOINTFLG2_INTFLG19_RESETVAL (0x0000u)
/*----INTFLG19 Tokens----*/
#define CSL_GPIO_IOINTFLG2_INTFLG19_CLEAR (0x0000u)
#define CSL_GPIO_IOINTFLG2_INTFLG19_SET  (0x0001u)

#define CSL_GPIO_IOINTFLG2_INTFLG18_MASK (0x0004u)
#define CSL_GPIO_IOINTFLG2_INTFLG18_SHIFT (0x0002u)
#define CSL_GPIO_IOINTFLG2_INTFLG18_RESETVAL (0x0000u)
/*----INTFLG18 Tokens----*/
#define CSL_GPIO_IOINTFLG2_INTFLG18_CLEAR (0x0000u)
#define CSL_GPIO_IOINTFLG2_INTFLG18_SET  (0x0001u)

#define CSL_GPIO_IOINTFLG2_INTFLG17_MASK (0x0002u)
#define CSL_GPIO_IOINTFLG2_INTFLG17_SHIFT (0x0001u)
#define CSL_GPIO_IOINTFLG2_INTFLG17_RESETVAL (0x0000u)
/*----INTFLG17 Tokens----*/
#define CSL_GPIO_IOINTFLG2_INTFLG17_CLEAR (0x0000u)
#define CSL_GPIO_IOINTFLG2_INTFLG17_SET  (0x0001u)

#define CSL_GPIO_IOINTFLG2_INTFLG16_MASK (0x0001u)
#define CSL_GPIO_IOINTFLG2_INTFLG16_SHIFT (0x0000u)
#define CSL_GPIO_IOINTFLG2_INTFLG16_RESETVAL (0x0000u)
/*----INTFLG16 Tokens----*/
#define CSL_GPIO_IOINTFLG2_INTFLG16_CLEAR (0x0000u)
#define CSL_GPIO_IOINTFLG2_INTFLG16_SET  (0x0001u)

#define CSL_GPIO_IOINTFLG2_RESETVAL      (0x0000u)

#endif
