#include <stdio.h>
#include "csl_pll.h"
#include "csl_dma.h"
#include "csl_i2s.h"
#include "csl_intc.h"
#include "aic_i2c.h"

#define AUDIO_BUFFER_SIZE 128
#define OFFSET            AUDIO_BUFFER_SIZE

CSL_DMA_Handle	hDMA0_CH0;
CSL_DMA_Handle  hDMA0_CH1;
CSL_DMA_Handle  hDMA0_CH2;
CSL_DMA_Handle  hDMA0_CH3;
        	 
Int16 InputL[2*AUDIO_BUFFER_SIZE];
Int16 InputR[2*AUDIO_BUFFER_SIZE];
Int16 OutputL[2*AUDIO_BUFFER_SIZE];
Int16 OutputR[2*AUDIO_BUFFER_SIZE];
         
/* Interrupt vector start address */
extern void VECSTART(void);

void bufferCopy(Int16 *input, Int16 *output, Int16 size, Int16 offset_in, Int16 offset_out)
{
	Int16 i;
	
	for(i = 0; i < size; i++) {
		*(output + i + offset_out) = *(input + i + offset_in);
	}
	
}

/* ================== DMA ISR ================== */
interrupt void DMA_IsR(void) {

	CSL_Status	status;
     
	if (DMA_getLastTransferType(hDMA0_CH2, &status)) {
		bufferCopy(InputL, OutputL, AUDIO_BUFFER_SIZE, OFFSET, OFFSET);
	} else {
		bufferCopy(InputL, OutputL, AUDIO_BUFFER_SIZE, 0, 0);
	}
	
	if (DMA_getLastTransferType(hDMA0_CH3, &status)) {
		bufferCopy(InputR, OutputR, AUDIO_BUFFER_SIZE, OFFSET, OFFSET);
	} else {
		bufferCopy(InputR, OutputR, AUDIO_BUFFER_SIZE, 0, 0);
	}
		
}

/* ================== Main function ================== */ 
Int16 main(void) {
	
	 /* CSL Status variable */
	 CSL_Status	status;
         
     /* Variables for PLL functions */
	 PLL_Obj 			pllObj;
     PLL_Config			configPLL;
     PLL_Handle			hPll;
     Uint32				pllInstId;

     /* Variables for DMA functions */
     CSL_DMAChanNum     chanNum;
     CSL_DMA_ChannelObj	pDmaChanObj;
     CSL_DMA_Config     configDMA;

	 /* Variables for I2S functions */
   	 CSL_I2sHandle	hI2S0;
   	 I2S_Config     configI2S;
 
     /* ------------------------ PLL Setup ------------------------- */
     pllInstId = 0;
     status = PLL_init(&pllObj, pllInstId);
     
     hPll = &pllObj;

	 /* Configure the PLL for 100MHz */
	 configPLL.PLLCNTL1   = 0x8BE8;
     configPLL.PLLINCNTL  = 0x8000;
     configPLL.PLLCNTL2   = 0x0806;
     configPLL.PLLOUTCNTL = 0x0200;
     
     status = PLL_config(hPll, &configPLL);
     if (status != CSL_SOK) {
     	printf("PLL ERROR: Could not configure PLL.\n");
     	return 0;
     } else {
     	printf("PLL configuration successful!\n");
     }
     
     status = PLL_enable(hPll);
     if (status != CSL_SOK) {
     	printf("PLL ERROR: Could not enable PLL.\n");
     	return 0;
     } else {
     	printf("PLL enabled!\n");
     }
     /* ------------------------------------------------------------ */
     
     /* --------------------- Interrupts Setup --------------------- */  
     IRQ_globalDisable();

	 IRQ_clearAll();

	 IRQ_disableAll();

	 IRQ_setVecs((Uint32)(&VECSTART));
 	 
 	 IRQ_plug(DMA_EVENT, &DMA_IsR);
	      
     IRQ_enable(DMA_EVENT);
	 
	 IRQ_globalEnable();
	 /* ------------------------------------------------------------ */
     
     /* ---------------------- DMA0_CH0 Setup ---------------------- */
     configDMA.pingPongMode = CSL_DMA_PING_PONG_ENABLE;
     configDMA.autoMode     = CSL_DMA_AUTORELOAD_ENABLE;
     configDMA.trigger      = CSL_DMA_EVENT_TRIGGER;
     configDMA.dmaEvt       = CSL_DMA_EVT_I2S0_RX;
     configDMA.dmaInt       = CSL_DMA_INTERRUPT_ENABLE;
     configDMA.trfType      = CSL_DMA_TRANSFER_IO_MEMORY;
     configDMA.dataLen      = 4*AUDIO_BUFFER_SIZE;
     
     status = DMA_init();
	 if (status != CSL_SOK) {
     	printf("DMA ERROR: Could not initialize DMA.\n");
     	return 0;
     } else {
     	printf("DMA initialized!\n");
     }
     
     chanNum = CSL_DMA_CHAN0;
     hDMA0_CH0 = DMA_open(chanNum, &pDmaChanObj, &status);
	 if (status != CSL_SOK) {
     	printf("DMA ERROR: Could not open DMA0-CH%d.\n", chanNum);
     	return 0;
     } else {
     	printf("DMA0-CH%d open!\n", chanNum);
     }
	
	 configDMA.chanDir      = CSL_DMA_READ;
     configDMA.srcAddr      = 0x2828; /*I2SRXLT0*/
     configDMA.destAddr     = (Uint32)InputL;

     status = DMA_config(hDMA0_CH0, &configDMA);
     if (status != CSL_SOK) {
     	printf("DMA ERROR: Could not configure DMA0-CH%d.\n", chanNum);
     	return 0;
     } else {
     	printf("DMA0-CH%d configuration successful!\n", chanNum);
     }
     
     /* ---------------------- DMA0_CH1 Setup ---------------------- */
     chanNum = CSL_DMA_CHAN1;
     hDMA0_CH1 = DMA_open(chanNum, &pDmaChanObj, &status);
	 if (status != CSL_SOK) {
     	printf("DMA ERROR: Could not open DMA0-CH%d.\n", chanNum);
     	return 0;
     } else {
     	printf("DMA0-CH%d open!\n", chanNum);
     }
     
     configDMA.chanDir      = CSL_DMA_READ;
     configDMA.srcAddr      = 0x282C; /*I2SRXRT0*/
     configDMA.destAddr     = (Uint32)InputR;

     status = DMA_config(hDMA0_CH1, &configDMA);
     if (status != CSL_SOK) {
     	printf("DMA ERROR: Could not configure DMA0-CH%d.\n", chanNum);
     	return 0;
     } else {
     	printf("DMA0-CH%d configuration successful!\n", chanNum);
     }
     
     /* ---------------------- DMA0_CH2 Setup ---------------------- */
     chanNum = CSL_DMA_CHAN2;
     hDMA0_CH2 = DMA_open(chanNum, &pDmaChanObj, &status);
	 if (status != CSL_SOK) {
     	printf("DMA ERROR: Could not open DMA0-CH%d.\n", chanNum);
     	return 0;
     } else {
     	printf("DMA0-CH%d open!\n", chanNum);
     }
     
     configDMA.chanDir      = CSL_DMA_WRITE;
     configDMA.srcAddr      = (Uint32)OutputL;
     configDMA.destAddr     = 0x2808; /*I2STXLT0*/

     status = DMA_config(hDMA0_CH2, &configDMA);
     if (status != CSL_SOK) {
     	printf("DMA ERROR: Could not configure DMA0-CH%d.\n", chanNum);
     	return 0;
     } else {
     	printf("DMA0-CH%d configuration successful!\n", chanNum);
     }
     
     /* ---------------------- DMA0_CH3 Setup ---------------------- */
     chanNum = CSL_DMA_CHAN3;
     hDMA0_CH3 = DMA_open(chanNum, &pDmaChanObj, &status);
	 if (status != CSL_SOK) {
     	printf("DMA ERROR: Could not open DMA0-CH%d.\n", chanNum);
     	return 0;
     } else {
     	printf("DMA0-CH%d open!\n", chanNum);
     }
     
     configDMA.chanDir      = CSL_DMA_WRITE;
     configDMA.srcAddr      = (Uint32)OutputR;
     configDMA.destAddr     = 0x280C; /*I2STXRT0*/

     status = DMA_config(hDMA0_CH3, &configDMA);
     if (status != CSL_SOK) {
     	printf("DMA ERROR: Could not configure DMA0-CH%d.\n", chanNum);
     	return 0;
     } else {
     	printf("DMA0-CH%d configuration successful!\n", chanNum);
     }
     /* ------------------------------------------------------------ */
     
     /* ------------------------ I2S0 Setup ------------------------ */
     hI2S0 = I2S_open(I2S_INSTANCE0, DMA_INTERRUPT, I2S_CHAN_STEREO);
     
     configI2S.dataType     = I2S_STEREO_ENABLE;
     configI2S.loopBackMode = I2S_LOOPBACK_DISABLE;
     configI2S.datapack     = I2S_DATAPACK_ENABLE;
     configI2S.wordLen      = I2S_WORDLEN_16;
     configI2S.i2sMode      = I2S_SLAVE;
     configI2S.dataFormat   = I2S_DATAFORMAT_LJUST;
     
     status = I2S_setup(hI2S0, &configI2S);
     if (status != CSL_SOK) {
     	printf("I2S ERROR: Could not setup I2S.\n");
     	return 0;
     } else {
     	printf("I2S configuration successful!\n");
     }
     /* ------------------------------------------------------------ */

	 status = setupAIC3204();
	 if (status != CSL_SOK) {
	 	printf("AIC3204 setup failed!\n");
	 	return 0;
	 } else {
	 	printf("AIC3204 successfully initialized!\n");
	 }
	 
     status = I2S_transEnable(hI2S0, TRUE);
	 if (status != CSL_SOK) {
	 	printf("I2S ERROR: Could not enable data transfer!\n");
	 	return 0;
	 } else {
	 	printf("I2S data transfer enabled!\n");
	 }
	 status = DMA_start(hDMA0_CH0);
	 if (status != CSL_SOK) {
	 	printf("DMA ERROR: Could not start DMA0-CH0!\n");
	 	return 0;
	 } else {
	 	printf("DMA0-CH0 started!\n");
	 }
	 
	 status = DMA_start(hDMA0_CH1);
	 if (status != CSL_SOK) {
	 	printf("DMA ERROR: Could not start DMA0-CH1!\n");
	 	return 0;
	 } else {
	 	printf("DMA0-CH1 started!\n");
	 }
	 
	 status = DMA_start(hDMA0_CH2);
	if (status != CSL_SOK) {
	 	printf("DMA ERROR: Could not start DMA0-CH2!\n");
	 	return 0;
	 } else {
	 	printf("DMA0-CH2 started!\n");
	 }
	 
	 status = DMA_start(hDMA0_CH3);
	 if (status != CSL_SOK) {
	 	printf("DMA ERROR: Could not start DMA0-CH3!\n");
	 	return 0;
	 } else {
	 	printf("DMA0-CH3 started!\n");
	 }
	 
	 while(1);
	 
	 return 1;
} 
   