/******************************************************************************
*  Description:  Master include file
*
*  Demo Application for MSP430/CC1100-2500 Interface Code Library v1.1
*
* W. Goh
* Texas Instruments, Inc
* December 2009
* Built with IAR Embedded Workbench Version: 4.20
********************************************************************************
* Version:  1.2
* Comments: Added support for antenna diversity thru the use of multiple radios
*           Added support for collision detection, and various help functions.
*           Changed comments for better readability
* Author  : Thomas Almholt, Texas Instruments, October 2010
*
* Version:  1.1
* Comments: Fixed several bugs where it is stuck in a infinite while loop
*           Added support for 5xx
*
* Version:  1.00
* Comments: Initial Release Version
*******************************************************************************/

// Masks for appended status bytes
#define RSSI_RX      0x00        // Position of LQI byte
#define LQI_RX       0x01        // Position of LQI byte
#define CRC_OK       0x80        // Mask "CRC_OK" bit within LQI byte
#define NUM_RXBYTES  0x7F        // Mask "# of bytes" field in _RXBYTES

#include "RF1A.h"
#include "hal_pmm.h"
#include "CC430x_hal.h"
#include "CCxx00_utils.h"
#include "CCx_mac.h"