/*******************************************************************************
*  Description:  This file contains definitions specific to the hardware board.
*  Specifically, the definitions include hardware connections with the
*  CCxxxx connector port, LEDs, and switches.
*
*  MSP430/CC1100-2500 Interface Code Library v1.0
*
*  K. Quiring
*  Texas Instruments, Inc, July 2006
*  IAR Embedded Workbench v3.41
*******************************************************************************/

/* definition of what port and pin the two indicator LEDs are attached */
#define CC_LED1_PxOUT      PJOUT
#define CC_LED1_PxDIR      PJDIR
#define CC_LED1            BIT0             
#define CC_LED2_PxOUT      PJOUT
#define CC_LED2_PxDIR      PJDIR
#define CC_LED2            BIT1             

/* Chip Select for RF_SLOTA */
#define CC_CSAn_PxOUT       P3OUT          
#define CC_CSAn_PxDIR       P3DIR
#define CC_CSAn_PIN         BIT0

/* RF_SLOTA uses GDO0 for runtime interupts */
#define CC_GDO0_PxOUT      P1OUT
#define CC_GDO0_PxIN       P1IN
#define CC_GDO0_PxDIR      P1DIR
#define CC_GDO0_PxIE       P1IE
#define CC_GDO0_PxIES      P1IES
#define CC_GDO0_PxIFG      P1IFG
#define CC_GDO0_PIN        BIT0

/* Chip Select for RF_SLOTB */
#define CC_CSBn_PxOUT       P5OUT          
#define CC_CSBn_PxDIR       P5DIR
#define CC_CSBn_PIN         BIT3

/* RF_SLOTB uses GDO2 for runtime interupts */
#define CC_GDO2_PxOUT      P1OUT
#define CC_GDO2_PxIN       P1IN
#define CC_GDO2_PxDIR      P1DIR
#define CC_GDO2_PxIE       P1IE
#define CC_GDO2_PxIES      P1IES
#define CC_GDO2_PxIFG      P1IFG
#define CC_GDO2_PIN        BIT1

/*******************************************************************************
* Select which port will be used for interface to CCxxxx, valid options are:
*
* CC_SER_INTF_NULL    CC_SER_INTF_USART0   CC_SER_INTF_USART1
* CC_SER_INTF_USCIA0  CC_SER_INTF_USCIA1   CC_SER_INTF_USCIA2  
* CC_SER_INTF_USCIA3  CC_SER_INTF_USCIB0   CC_SER_INTF_USCIB1
* CC_SER_INTF_USCIB2  CC_SER_INTF_USCIB3   CC_SER_INTF_USI   
* CC_SER_INTF_BITBANG
* 
*******************************************************************************/
#define CC_RF_SER_INTF       CC_SER_INTF_USCIB0  // Interface to CCxxxx
#define MSP430_F5xx
/*******************************************************************************
* Defines used to select between RF slot A and RF slot B, not change needed
*******************************************************************************/

#define FALSE 0
#define TRUE  1

// ID's for keeping track of two radios attached to the same SPI port
#define RF_SLOTA 5
#define RF_SLOTB 6
#define RF_CC430 7

// CC Chip versions
#define DEV_UNKNOWN       10
#define DEV_CC1100        11
#define DEV_CC1101        12
#define DEV_CC2500        13
#define DEV_CC430x        14
