/*******************************************************************************
*  Description:  This file contains definitions specific to the CC112x.
*  The configuration registers, strobe commands, and status registers are 
*  defined, as well as some common masks for these registers.
*
*  MSP430/CC112x Interface Code Library v2.0
*
*  T. Almholt
*  Texas Instruments, Inc, March 2011
*  IAR Embedded Workbench v5.11
********************************************************************************
* Version:  1.00
* Comments: Initial Release Version
*******************************************************************************/

/* RF settings SoC */

#define IOCFG3                0x00       // GPIO3 IO pin configuration register.
#define IOCFG2                0x01       // GPIO2 IO pin configuration register.
#define IOCFG1                0x02       // GPIO1 IO pin configuration register.
#define IOCFG0                0x03       // GPIO0 IO pin configuration register.
#define SYNC3                 0x04       // Sync word programming (31:24).
#define SYNC2                 0x05       // Sync word programming (23:16).
#define SYNC1                 0x06       // Sync word programming (15:8).
#define SYNC0                 0x07       // Sync word programming (7:0).
#define SYNC_CFG1             0x08       // Sync Word Detection Programming
#define SYNC_CFG0             0x09       // Sync Word Length Programming
#define DEVIATION_M           0x0A       // Frequency Deviation Programming
#define MODCFG_DEV_E          0x0B       // Modulation Format and Frequency Deviation Programming
#define DCFILT_CFG            0x0C       // Digital DC removal Programming
#define PREAMBLE_CFG1         0x0D       // Preamble Length Programming
#define PREAMBLE_CFG0         0x0E       // Preamble Detection Programming
#define FREQ_IF_CFG           0x0F       // RX Mixer Frequency Programming
#define IQIC                  0x10       // Digital Image Channel Compensation Programming
#define CHAN_BW               0x11       // Channel Filter Programming
#define MDMCFG1               0x12       // 
#define MDMCFG0               0x13       // 
#define DRATE2                0x14       // Symbol Rate Programming Exponent and Mantissa (19:16).
#define DRATE1                0x15       // Symbol Rate Programming Mantissa (15:8).
#define DRATE0                0x16       // Symbol Rate Programming Mantissa (7:0).
#define AGC_REF               0x17       // AGC Reference Level
#define AGC_CS_THR            0x18       // Carrier Sense Threshold Programming
#define AGC_GAIN_ADJUST       0x19       // RSSI Offset Programming.
#define AGC_CFG3              0x1A       // AGC Programming
#define AGC_CFG2              0x1B       // AGC Programming.
#define AGC_CFG1              0x1C       // AGC Programming
#define AGC_CFG0              0x1D       // AGC Programming
#define FIFO_CFG              0x1E       // 
#define DEV_ADDR              0x1F       // 
#define SETTLING_CFG          0x20       // 
#define FS_CFG                0x21       // 
#define WOR_CFG1              0x22       // 
#define WOR_CFG0              0x23       // 
#define WOR_EVENT0_MSB        0x24       // 
#define WOR_EVENT0_LSB        0x25       // 
#define PKT_CFG2              0x26       // 
#define PKT_CFG1              0x27       // 
#define PKT_CFG0              0x28       // 
#define RFEND_CFG1            0x29       // 
#define RFEND_CFG0            0x2A       // 
#define PA_CFG2               0x2B       // Power Amplifier Level Programming
#define PA_CFG1               0x2C       // Power Amplifier Ramp Up/Down Shape Programming
#define PA_CFG0               0x2D       // 
#define PKT_LEN               0x2E       // 
#define IF_MIX_CFG            0x2F00       // IF MIX configuration
#define FREQOFF_CFG           0x2F01       // Frequency Offset Removal programming.
#define TOC_CFG               0x2F02       // Data Rate Offset Removal Programming
#define MARC_SPARE            0x2F03       // 
#define ECG_CFG               0x2F04       // 
#define SOFT_TX_DATA_CFG      0x2F05       // 
#define EXT_CTRL              0x2F06       // 
#define RCCAL_FINE            0x2F07       // 
#define RCCAL_COARSE          0x2F08       // 
#define RCCAL_OFFSET          0x2F09       // 
#define FREQOFF1              0x2F0A       // 
#define FREQOFF0              0x2F0B       // 
#define FREQ2                 0x2F0C       // 
#define FREQ1                 0x2F0D       // 
#define FREQ0                 0x2F0E       // 
#define IF_ADC2               0x2F0F       // Analog to digital converter, reg 2
#define IF_ADC1               0x2F10       // Analog to digital converter, reg 1
#define IF_ADC0               0x2F11       // Analog to digital converter, reg 0
#define FS_DIG1               0x2F12       // 
#define FS_DIG0               0x2F13       // 
#define FS_CAL3               0x2F14       // 
#define FS_CAL2               0x2F15       // 
#define FS_CAL1               0x2F16       // 
#define FS_CAL0               0x2F17       // 
#define FS_CHP                0x2F18       // Charge pump
#define FS_DIVTWO             0x2F19       // Divide by 2
#define FS_DSM1               0x2F1A       // Digital synthesizer module, reg 1
#define FS_DSM0               0x2F1B       // Digital synthesizer module, reg 0
#define FS_DVC1               0x2F1C       // Divider chain, reg 1
#define FS_DVC0               0x2F1D       // Divider chain, reg 0
#define FS_LBI                0x2F1E       // Local bias
#define FS_PFD                0x2F1F       // Phase-frequency detector
#define FS_PRE                0x2F20       // Prescaler
#define FS_REG_DIV_CML        0x2F21       // 
#define FS_SPARE              0x2F22       // 
#define FS_VCO4               0x2F23       // Voltage controlled oscillator, reg 4
#define FS_VCO3               0x2F24       // Voltage controlled oscillator, reg 3
#define FS_VCO2               0x2F25       // Voltage controlled oscillator, reg 2
#define FS_VCO1               0x2F26       // Voltage controlled oscillator, reg 1
#define FS_VCO0               0x2F27       // Voltage controlled oscillator, reg 0
#define GBIAS6                0x2F28       // Global bias, reg 6
#define GBIAS5                0x2F29       // Global bias, reg 5
#define GBIAS4                0x2F2A       // Global bias, reg 4
#define GBIAS3                0x2F2B       // Global bias, reg 3
#define GBIAS2                0x2F2C       // Global bias, reg 2
#define GBIAS1                0x2F2D       // Global bias, reg 1
#define GBIAS0                0x2F2E       // Global bias, reg 0
#define IFAMP                 0x2F2F       // Intermediate frequency amplifier
#define LNA                   0x2F30       // Low noise amplifier
#define RXMIX                 0x2F31       // RX mixer
#define XOSC5                 0x2F32       // Crystal oscillator, reg 5
#define XOSC4                 0x2F33       // Crystal oscillator, reg 4
#define XOSC3                 0x2F34       // Crystal oscillator, reg 3
#define XOSC2                 0x2F35       // Crystal oscillator, reg 2
#define XOSC1                 0x2F36       // Crystal oscillator, reg 1
#define XOSC0                 0x2F37       // Crystal oscillator, reg 0
#define ANALOG_SPARE          0x2F38       // 
#define IRQ0M                 0x2F3F       // IRQ0 mask
#define IRQ0F                 0x2F40       // IRQ0 flag
#define PA_CFG3               0x2F39       // 
#define WOR_TIME1             0x2F64       // WOR timer status MSB
#define WOR_TIME0             0x2F65       // WOR timer status LSB
#define WOR_CAPTURE1          0x2F66       // WOR timer capture MSB
#define WOR_CAPTURE0          0x2F67       // WOR timer capture LSB
#define BIST                  0x2F68       // MARC BIST
#define DCFILTOFFSET_I1       0x2F69       // 
#define DCFILTOFFSET_I0       0x2F6A       // 
#define DCFILTOFFSET_Q1       0x2F6B       // 
#define DCFILTOFFSET_Q0       0x2F6C       // 
#define IQIE_I1               0x2F6D       // 
#define IQIE_I0               0x2F6E       // 
#define IQIE_Q1               0x2F6F       // 
#define IQIE_Q0               0x2F70       // 
#define RSSI1                 0x2F71       // Received signal strength indicator, reg 1
#define RSSI0                 0x2F72       // Received signal strength indicator, reg 0
#define MARCSTATE             0x2F73       // MARC state value
#define LQI_VAL               0x2F74       // 
#define PQT_SYNC_ERR          0x2F75       // Preamble Detection and Sync Word Detection Status
#define DEM_STATUS            0x2F76       // 
#define FREQOFF_EST1          0x2F77       // Frequency Offset Estimate (15:8)
#define FREQOFF_EST0          0x2F78       // Frequency Offset Estimate (7:0)
#define AGC_GAIN3             0x2F79       // AGC Gain [dB]
#define AGC_GAIN2             0x2F7A       // 
#define AGC_GAIN1             0x2F7B       // 
#define AGC_GAIN0             0x2F7C       // 
#define SOFT_RX_DATA_OUT      0x2F7D       // 
#define SOFT_TX_DATA_IN       0x2F7E       // 
#define ASK_SOFT_RX_DATA      0x2F7F       // 
#define RNDGEN                0x2F80       // 
#define MAGN2                 0x2F81       // 
#define MAGN1                 0x2F82       // 
#define MAGN0                 0x2F83       // 
#define ANG1                  0x2F84       // 
#define ANG0                  0x2F85       // 
#define CHFILT_I2             0x2F86       // 
#define CHFILT_I1             0x2F87       // 
#define CHFILT_I0             0x2F88       // 
#define CHFILT_Q2             0x2F89       // 
#define CHFILT_Q1             0x2F8A       // 
#define CHFILT_Q0             0x2F8B       // 
#define GPIO_STATUS           0x2F8C       // 
#define FSCAL_CTRL            0x2F8D       // 
#define PHASE_ADJUST          0x2F8E       // 
#define PARTNUMBER            0x2F8F       // 
#define PARTVERSION           0x2F90       // 
#define SERIAL_STATUS         0x2F91       // 
#define RX_STATUS             0x2F92       // 
#define TX_STATUS             0x2F93       // 
#define MARC_STATUS1          0x2F94       // 
#define MARC_STATUS0          0x2F95       // 
#define PA_IFAMP_TEST         0x2F96       // 
#define FSRF_TEST             0x2F97       // 
#define PRE_TEST              0x2F98       // 
#define PRE_OVR               0x2F99       // 
#define ADC_TEST              0x2F9A       // 
#define DVC_TEST              0x2F9B       // 
#define ATEST                 0x2F9C       // 
#define ATEST_LVDS            0x2F9D       // 
#define ATEST_MODE            0x2F9E       // 
#define XOSC_TEST1            0x2F9F       // 
#define XOSC_TEST0            0x2FA0       // 
#define NUM_TXBYTES           0x2FD6       // 
#define NUM_RXBYTES           0x2FD7       // 


// Strobe commands
#define RF_SRES      0x30        // Reset chip.
#define RF_SFSTXON   0x31        // Enable/calibrate freq synthesizer
#define RF_SXOFF     0x32        // Turn off crystal oscillator.
#define RF_SCAL      0x33        // Calibrate freq synthesizer & disable
#define RF_SRX       0x34        // Enable RX.
#define RF_STX       0x35        // Enable TX.
#define RF_SIDLE     0x36        // Exit RX / TX
#define RF_SWOR      0x38        // Start automatic RX polling sequence
#define RF_SPWD      0x39        // Enter pwr down mode when CSn goes hi
#define RF_SFRX      0x3A        // Flush the RX FIFO buffer.
#define RF_SFTX      0x3B        // Flush the TX FIFO buffer.
#define RF_SWORRST   0x3C        // Reset real time clock.
#define RF_SNOP      0x3D        // No operation.

// Other memory locations
#define PATABLE      0x3E
#define TXFIFO       0x3F
#define RXFIFO       0x3F

// Masks for appended status bytes
#define RSSI_RX      0x00        // Position of LQI byte
#define LQI_RX       0x01        // Position of LQI byte
#define CRC_OK       0x80        // Mask "CRC_OK" bit within LQI byte

// Definitions to support burst/single access:
#define WRITE_BURST  0x40
#define READ_SINGLE  0x80
#define READ_BURST   0xC0