/*******************************************************************************
*  Description:  Header file for TI_CC_spi.c
*
*  MSP430/CC1100-2500 Interface Code Library v1.1
*
*  W. Goh  & T.Almholt
*  Texas Instruments, Inc.
*  December 2009
*  IAR Embedded Workbench v4.20
********************************************************************************
* Version:  1.2
* Comments: Added support for antenna diversity thru the use of multiple radios
*           Added support for collision detection, and various help functions.
*           Changed comments for better readability
* Author  : Thomas Almholt, Texas Instruments, October 2010
*
* Version:  1.1
* Comments: Fixed several bugs where it is stuck in a infinite while loop
*           Added support for 5xx
*
* Version:  1.00
* Comments: Initial Release Version
*******************************************************************************/

void CC_Wait(unsigned int);
void CC_SPISetup(char RF_IDx);
void CC_SPIWriteReg(unsigned char addr, unsigned char value,char RF_IDx);
void CC_SPIWriteBurstReg(unsigned char addr, unsigned char *buffer,  \
  unsigned char count,char RF_IDx);
char CC_SPIReadReg(unsigned char addr, char RF_IDx);
void CC_SPIReadBurstReg(unsigned char addr, unsigned char *buffer, \
  unsigned char count, char RF_IDx);
char CC_SPIReadStatus(unsigned char addr, char RF_IDx);
void CC_SPIStrobe(unsigned char strobe, char RF_IDx);
void CC_PowerupReset(char RF_IDx);

// Specific spi functions for interfacing to a CC112x device
void CC_SPIWriteExtReg(unsigned short addr, unsigned char value, char RF_IDx);
char CC_SPIReadExtReg(unsigned short addr, char RF_IDx);

void CC_wait_for_idle(char RF_IDx);