/*******************************************************************************
*  Description:  physical layer abstration
*
*  The basic radio driver shall implement the following mandatory commands. 
*  This abstraction is based on the abstraction used in Contiki OS.
*
*  T. Almholt, Texas Instruments, Inc, March 2011
*  Compiled with IAR Embedded Workbench v5.10
********************************************************************************
* Version:  1.00
* Comments: Initial Release Version
*******************************************************************************/

/* Initialize the radio hardware */
int radio_init(char RF_IDx);

/* Prepare the radio with a packet to be sent */
int radio_prepare(unsigned char *payload, unsigned short payload_len, char RF_IDx);

/* Send the packet that has previously been prepared (used for exact timing)*/
int radio_transmit(char RF_IDx);

/* Enter recieve mode */
int radio_receive_on(char RF_IDx);

/* Prepare & transmit a packet in same call (slightly worse timing jitter) */
int radio_send(unsigned char *payload, unsigned short payload_len, char RF_IDx);

/* Read a received packet into a buffer */
int radio_read(unsigned char *buf, unsigned short *buf_len, char RF_IDx);

/* Perform a Clear-Channel Assessment (CCA) to find out if channel is clear */
int radio_channel_clear(char RF_IDx);

/* Wait for radio to become idle (currently receiving or transmitting) */
int radio_wait_for_idle(char RF_IDx);

/* Check if the radio driver has just received a packet */
int radio_pending_packet(char RF_IDx);

/* Change channel of radio, using predefined paramters */
int radio_set_channel(unsigned char rf_channel, char RF_IDx);

/* Idle the radio, used when leaving low power modes (below)*/
int radio_idle(char RF_IDx);

/* Put the radio into sleep mode */
int radio_sleep(char RF_IDx);