/*******************************************************************************
* Description:  General purpose RF MAC for CCx radio devices
* T. Almholt
* Texas Instruments, Inc.
* IAR Embedded Workbench v5.10
********************************************************************************
* Version:  1.00
* Comments: Initial Release Version
*******************************************************************************/

#include "msp430.h"
#include "CCx_hal.h"
#include "CC430x_phy.h"
//#include "CCxx00_phy.h"



/*******************************************************************************
*  void RFSendPacket_wCCA(char *txBuffer, char size)
*
*  DESCRIPTION:
*  This function transmits a packet with length up to 63 bytes.  To use this
*  function, GD00 must be configured to be asserted when sync word is sent and
*  de-asserted at the end of the packet, which is accomplished by setting the
*  IOCFG0 register to 0x06, per the CCxxxx datasheet.  GDO0 goes high at
*  packet start and returns low when complete.  The function polls GDO0 to
*  ensure packet completion before returning.
*  
*  This function implements a non-optimized version of a "Carriers-Sense"
*  before TX algorithm. It is based on using the RX for a brief moment (100us)
*  to sense if there are carriers already in the channels, if a carrier is found
*  the algorithm will simply wait and try again 2.5ms later, until is succeeds.
*  The 2.5ms is based on the duration of each burst is only 2ms, so if we wait 
*  2.5ms the particular burst is gone and we can try again.
*
*  ARGUMENTS:
*      char *txBuffer
*          Pointer to a buffer containing the data to be transmitted
*
*      char size
*          The size of the txBuffer
*******************************************************************************/
void RFSendPacket_wCCA(unsigned char *txBuffer, unsigned short size, char RF_IDx) {
  unsigned char status;
  
  radio_prepare(txBuffer, size, RF_IDx);
  radio_receive_on(RF_IDx);
  
  status = 1;
  
  while(status) {
    status = radio_channel_clear(RF_IDx);
    if(status > 0) {
      radio_idle(RF_IDx);
      radio_receive_on(RF_IDx);
      HAL_LED1_ON();                      // indicate that a CCA hit has occured
      __delay_cycles(1000);               // wait 1ms to try again
      HAL_LED1_OFF(); 
    }
  }
 radio_transmit(RF_IDx);
 radio_wait_for_idle(RF_IDx);
}



/* ****************************************************************************
* THIS PROGRAM IS PROVIDED "AS IS". TI MAKES NO WARRANTIES OR REPRESENTATIONS, 
* EITHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING ANY IMPLIED WARRANTIES OF 
* MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, LACK OF VIRUSES, ACCURACY 
* OR COMPLETENESS OF RESPONSES, RESULTS AND LACK OF NEGLIGENCE.
* TI DISCLAIMS ANY WARRANTY OF TITLE, QUIET ENJOYMENT, QUIET POSSESSION, AND 
* NON-INFRINGEMENT OF ANY THIRD PARTY INTELLECTUAL PROPERTY RIGHTS WITH REGARD
* TO THE PROGRAM OR YOUR USE OF THE PROGRAM.
*
* IN NO EVENT SHALL TI BE LIABLE FOR ANY SPECIAL, INCIDENTAL, CONSEQUENTIAL OR 
* INDIRECT DAMAGES, HOWEVER CAUSED, ON ANY THEORY OF LIABILITY AND WHETHER OR 
* NOT TI HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES, ARISING IN ANY WAY 
* OUT OF THIS AGREEMENT, THE PROGRAM, OR YOUR USE OF THE PROGRAM. EXCLUDED 
* DAMAGES INCLUDE, BUT ARE NOT LIMITED TO, COST OF REMOVAL OR REINSTALLATION, 
* COMPUTER TIME, LABOR COSTS, LOSS OF GOODWILL, LOSS OF PROFITS, LOSS OF SAVINGS,
* OR LOSS OF USE OR INTERRUPTION OF BUSINESS. IN NO EVENT WILL TI'S AGGREGATE 
* LIABILITY UNDER THIS AGREEMENT OR ARISING OUT OF YOUR USE OF THE PROGRAM 
* EXCEED FIVE HUNDRED DOLLARS (U.S.$500).
*
* Unless otherwise stated, the Program written and copyrighted by Texas 
* Instruments is distributed as "freeware".  You may, only under TI's copyright
* in the Program, use and modify the Program without any charge or restriction.  
* You may distribute to third parties, provided that you transfer a copy of this
* license to the third party and the third party agrees to these terms by its 
* first use of the Program. You must reproduce the copyright notice and any 
* other legend of ownership on each copy or partial copy, of the Program.
*
* You acknowledge and agree that the Program contains copyrighted material, 
* trade secrets and other TI proprietary information and is protected by 
* copyright laws, international copyright treaties, and trade secret laws, as
* well as other intellectual property laws.  To protect TI's rights in the 
* Program, you agree not to decompile, reverse engineer, disassemble or 
* otherwise translate any object code versions of the Program to a human-
* readable form.  You agree that in no event will you alter, remove or destroy
* any copyright notice included in the Program.  TI reserves all rights not 
* specifically granted under this license. Except as specifically provided 
* herein, nothing in this agreement shall be construed as conferring by 
* implication, estoppel, or otherwise, upon you, any license or other right
* under any TI patents, copyrights or trade secrets.
*
* You may not use the Program in non-TI devices.
*******************************************************************************/


