/*******************************************************************************
*  Description:  CCxx00_drv.c function declarations
*
*  Demo Application for CCxx00_drv.h Interface Code Library v1.2
*
*  K. Quiring & T. Almholt
*  Texas Instruments, Inc.
*  July 2006, December 2010
*  IAR Embedded Workbench v5.10
********************************************************************************
* Version:  1.2
* Comments: Added support for antenna diversity thru the use of multiple radios
*           Added support for collision detection, and various help functions.
*           Changed comments for better readability
* Author  : Thomas Almholt, Texas Instruments, October 2010
*
* Version:  1.1
* Comments: Fixed several bugs where it is stuck in a infinite while loop
*           Added support for 5xx
*
* Version:  1.00
* Comments: Initial Release Version
*******************************************************************************/

/*******************************************************************************
*  Routines for modifying registers settings during runtime - base freq etc.
*******************************************************************************/
void debug_cc_state(unsigned char RF_IDx);
char rf_set_freq(unsigned long freq,unsigned char RF_IDx);
int set_freq_dev(int freq_dev, unsigned char RF_IDx);
int set_rx_bw(int rx_bw, unsigned char RF_IDx);
int set_ch_spc(int ch_spc, unsigned char RF_IDx);
signed char set_tx_pwr(signed char tx_pwr, char cc_device_id, unsigned char RF_IDx);
char get_device_id(unsigned char RF_IDx);
unsigned char set_rf_packet_length(unsigned char length, unsigned char RF_IDx);
void set_tx_unmodulated_test_mode(unsigned char RF_IDx);
void set_tx_modulated_test_mode(unsigned char RF_IDx);
int get_rssi(unsigned char RF_IDx);

/*******************************************************************************
*  Nice to have routine for debugging runtime state
*******************************************************************************/
void debug_cc_state(unsigned char RF_IDx);