   /**************************************************************************************************
  Filename:       OAD_app.h
  Revised:        $Date: 2012-03-21 17:37:33 -0700 (Wed, 21 Mar 2012) $
  Revision:       $Revision: 246 $

  Description:    This file defines linux specific interface to Network Processor Interface
                  module.


  Copyright (C) {YEAR} Texas Instruments Incorporated - http://www.ti.com/


   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions
   are met:

     Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.

     Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the
     distribution.

     Neither the name of Texas Instruments Incorporated nor the names of
     its contributors may be used to endorse or promote products derived
     from this software without specific prior written permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
   A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
   OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
   SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
   LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
   DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
   THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
   (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
   OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

**************************************************************************************************/

#ifndef OAD_APP_H
#define OAD_APP_H

#ifdef __cplusplus
extern "C" {
#endif

#include "hal_types.h"
/////////////////////////////////////////////////////////////////////////////
  // Defines

// oad_app Events
#define OAD_APP_EVT_NONE                   			0x0000 // No event
#define OAD_APP_EVT_INIT                   			0x1000 // Initial Boot up Event
#define OAD_APP_EVT_OAD_KO          				0x0004 // OAD unsuccessful
#define OAD_APP_EVT_OAD_OK              			0x0008 // OAD successful
#define OAD_APP_EVT_OAD_REBOOT              		0x0010 // OAD rebooting
#define OAD_APP_EVT_OAD_TIMEOUT             		0x0020 // OAD timed out
#define OAD_APP_EVT_TOAD_SAFE_NORMAL_TOAD_WINDOW	0x0040 // TOAD Safe Normal Operation Window expired

#define OAD_APP_MAX_PAYLOAD_SIZE	116

#if (defined FEATURE_TOAD_TEST) && (FEATURE_TOAD_TEST == TRUE)
#define OAD_APP_EVT_TOAD_TEST             	0x4000 // TOAD timed out
#endif // FEATURE_TOAD_TEST

#define NAME_ELEMENT(element) [element] = #element

// Application States
enum {
	AP_STATE_INIT, // Initial state - prior to initialization completion
	AP_STATE_INIT_OAD,
	AP_STATE_OAD, // Waiting for RNP to wake up from sleep to send data
	AP_STATE_RESET, // Initial state - However, RNP is in Serial Boot mode.
	AP_STATE_READY, // Ready state - ready to pair, ready to send data
	AP_STATE_TOAD_KO, // Waiting for RNP to wake up from sleep to start the test mode
	AP_STATE_TOAD_KO_NO_PAIRING, // Waiting for client to receive temporary pairing information
};


  /////////////////////////////////////////////////////////////////////////////
  // Typedefs

// Configuration specific

#if !defined PACK_1
#define PACK_1
#endif


#if defined(_MSC_VER) || defined(unix) || (defined(__ICC430__) && (__ICC430__==1))
#pragma pack(1)
#endif

PACK_1 typedef struct ATTR_PACKED
{
	uint8  length;
	uint16 rate;
	uint32 nbPackets;
} appSendData_t;

#if defined _MSC_VER || defined(unix)
#pragma pack()
#endif

/////////////////////////////////////////////////////////////////////////////
// Global variable
extern appSendData_t  appSendData;
extern uint8 appState;
extern const char * const AppState_list[AP_STATE_READY + 1];//18 Application States

/////////////////////////////////////////////////////////////////////////////
// Function declarations

extern int appInit( int mode, char threadId );
extern void oad_appTestModeProcessKey (char* strIn);


#ifdef __cplusplus
}
#endif

#endif // OAD_APP_H
