/**************************************************************************************************
  Filename:       oad_client.h
  Revised:        $Date: 2011-11-07 14:20:32 -0800 (ma, 07 nov 2011) $
  Revision:       $Revision: 61 $

  Description:    This file contains inteface of the OAD downloadable image utilities
                  to make downloadable image function as OAD client


  Copyright 2008-2011 Texas Instruments Incorporated. All rights reserved.

  IMPORTANT: Your use of this Software is limited to those specific rights
  granted under the terms of a software license agreement between the user
  who downloaded the software, his/her employer (which must be your employer)
  and Texas Instruments Incorporated (the "License").  You may not use this
  Software unless you agree to abide by the terms of the License. The License
  limits your use, and you acknowledge, that the Software may not be modified,
  copied or distributed unless embedded on a Texas Instruments microcontroller
  or used solely and exclusively in conjunction with a Texas Instruments radio
  frequency transceiver, which is integrated into your product.  Other than for
  the foregoing purpose, you may not use, reproduce, copy, prepare derivative
  works of, modify, distribute, perform, display or sell this Software and/or
  its documentation for any purpose.

  YOU FURTHER ACKNOWLEDGE AND AGREE THAT THE SOFTWARE AND DOCUMENTATION ARE
  PROVIDED AS IS WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, 
  INCLUDING WITHOUT LIMITATION, ANY WARRANTY OF MERCHANTABILITY, TITLE, 
  NON-INFRINGEMENT AND FITNESS FOR A PARTICULAR PURPOSE. IN NO EVENT SHALL
  TEXAS INSTRUMENTS OR ITS LICENSORS BE LIABLE OR OBLIGATED UNDER CONTRACT,
  NEGLIGENCE, STRICT LIABILITY, CONTRIBUTION, BREACH OF WARRANTY, OR OTHER
  LEGAL EQUITABLE THEORY ANY DIRECT OR INDIRECT DAMAGES OR EXPENSES
  INCLUDING BUT NOT LIMITED TO ANY INCIDENTAL, SPECIAL, INDIRECT, PUNITIVE
  OR CONSEQUENTIAL DAMAGES, LOST PROFITS OR LOST DATA, COST OF PROCUREMENT
  OF SUBSTITUTE GOODS, TECHNOLOGY, SERVICES, OR ANY CLAIMS BY THIRD PARTIES
  (INCLUDING BUT NOT LIMITED TO ANY DEFENSE THEREOF), OR OTHER SIMILAR COSTS.

  Should you have any questions regarding your right to use this Software,
  contact Texas Instruments Incorporated at www.TI.com. 
**************************************************************************************************/

#ifndef _OAD_CLIENT_H
#define _OAD_CLIENT_H

#ifdef __cplusplus
extern "C"
{
#endif

/**************************************************************************************************
 * INCLUDES
 **************************************************************************************************/
#include "hal_types.h"

/**************************************************************************************************
 *                                        User's  Defines
 **************************************************************************************************/

/**************************************************************************************************
 * CONSTANTS
 **************************************************************************************************/

// OAD Client States
#define OAD_CLIENT_IDLE_STATE               0
#define OAD_CLIENT_DL_STATE                 1
#define OAD_CLIENT_VALIDATE_STATE           2
#define OAD_CLIENT_REBOOT                   3 // This is an internal state till next reboot.
#ifdef FEATURE_OAD_HOST
#define OAD_CLIENT_IMAGE_VERIFIED           OAD_CLIENT_REBOOT // This is an internal state before returning to Application.

// OAD inactivity timeout value  
#define OAD_INACTIVITY_TIMEOUT          10000  // 10 seconds timeout
#endif

/**************************************************************************************************
 * GLOBALS
 **************************************************************************************************/

// application has to initialize OAD_State to OAD_CLIENT_IDLE_STATE when boot up.
// application is also responsible to read OAD_State to reboot if OAD state indicates
// OAD_CLIENT_REBOOT (OAD_CLIENT_IMAGE_VERIFIED); after calling OAD_ReceiveDataInd() function.
extern uint8 OAD_State;
  
/*********************************************************************
 * FUNCTIONS
 */
extern void OAD_ReceiveDataInd( uint8 srcIndex, uint8 len, uint8 *pData );
#ifndef FEATURE_OAD_HOST
extern void OAD_Reboot(void);
#else
extern uint32 oadSBValidImage(void);
#endif

/*********************************************************************
*********************************************************************/

#ifdef __cplusplus
}
#endif

#endif /* _OAD_CLIENT_H */
