/**************************************************************************************************
  Filename:       oad_server.h
  Revised:        $Date: 2011-11-16 15:13:41 -0800 (on, 16 nov 2011) $
  Revision:       $Revision: 93 $

  Description:    This file contrains a sample OAD Server application


  Copyright 2008 Texas Instruments Incorporated. All rights reserved.

  IMPORTANT: Your use of this Software is limited to those specific rights
  granted under the terms of a software license agreement between the user
  who downloaded the software, his/her employer (which must be your employer)
  and Texas Instruments Incorporated (the "License").  You may not use this
  Software unless you agree to abide by the terms of the License. The License
  limits your use, and you acknowledge, that the Software may not be modified,
  copied or distributed unless embedded on a Texas Instruments microcontroller
  or used solely and exclusively in conjunction with a Texas Instruments radio
  frequency transceiver, which is integrated into your product.  Other than for
  the foregoing purpose, you may not use, reproduce, copy, prepare derivative
  works of, modify, distribute, perform, display or sell this Software and/or
  its documentation for any purpose.

  YOU FURTHER ACKNOWLEDGE AND AGREE THAT THE SOFTWARE AND DOCUMENTATION ARE
  PROVIDED �AS IS� WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED,
  INCLUDING WITHOUT LIMITATION, ANY WARRANTY OF MERCHANTABILITY, TITLE,
  NON-INFRINGEMENT AND FITNESS FOR A PARTICULAR PURPOSE. IN NO EVENT SHALL
  TEXAS INSTRUMENTS OR ITS LICENSORS BE LIABLE OR OBLIGATED UNDER CONTRACT,
  NEGLIGENCE, STRICT LIABILITY, CONTRIBUTION, BREACH OF WARRANTY, OR OTHER
  LEGAL EQUITABLE THEORY ANY DIRECT OR INDIRECT DAMAGES OR EXPENSES
  INCLUDING BUT NOT LIMITED TO ANY INCIDENTAL, SPECIAL, INDIRECT, PUNITIVE
  OR CONSEQUENTIAL DAMAGES, LOST PROFITS OR LOST DATA, COST OF PROCUREMENT
  OF SUBSTITUTE GOODS, TECHNOLOGY, SERVICES, OR ANY CLAIMS BY THIRD PARTIES
  (INCLUDING BUT NOT LIMITED TO ANY DEFENSE THEREOF), OR OTHER SIMILAR COSTS.

  Should you have any questions regarding your right to use this Software,
  contact Texas Instruments Incorporated at www.TI.com.
**************************************************************************************************/

#ifndef OAD_SERVER_H
#define OAD_SERVER_H

#define OAD_SERVER_CAPABILITIES             RCN_NODE_CAP_TARGET

#ifdef __cplusplus
extern "C" {
#endif

// Server States
#define OAD_SERVER_IDLE_STATE               0
#define OAD_SERVER_PREP_STATE               1
#define OAD_SERVER_START_STATE              2
#define OAD_SERVER_XFER_STATE               3
#define OAD_SERVER_ENABLE_STATE             4
#define OAD_SERVER_CANCEL_STATE             5

// Time (ms) to wait for resposne from target to an OAD commanjd
#define OAD_XFER_TIMEOUT                    1500
#define OAD_ENABLE_TIMEOUT                  30000

// Number of times to retry a command without response from terget
#define OAD_MAX_RETRIES                     5

// External Function Declarations
void OAD_ProcessDataInd(uint8 srcIndex, uint8 *pData, uint8 len);
void OAD_HandlePoll(uint8 destIdx);

#if defined unix
void OAD_ServerInit(uint8 threadId, uint8 *pBuf, int imageSize);
#else
void OAD_ServerInit(uint8 );
#endif // unix

uint8 OAD_CheckCode(uint32 imgCRC, uint32 imageLen, uint8 imageType);

#if defined unix
#define BinFile1 		oadBinFilePresent
#define BinFile2 		oadBinFilePresent
#else
extern bool BinFile1;
extern bool BinFile2;
#endif // defined unix

#ifdef __cplusplus
}
#endif

#endif // OAD_SERVER_H

