/*
 * main.c
 */
#include <msp430.h>

#define ARRAY_SZ      (10)

typedef struct _run_data
{
    unsigned long value;    // actual value
    unsigned int  time_ms;  // time in millisecond
} tRUN_DATA;

#define FLASH_UNLOCK    FCTL3 = FWKEY; FCTL1 = FWKEY + WRT;
#define FLASH_LOCK      FCTL1 = FWKEY; FCTL3 = FWKEY +  LOCK;

//#pragma DATA_SECTION(flash_run_data, ".infoB");   // compiles fine
#pragma DATA_SECTION(flash_run_data, ".mydata");  // warnings when compiling
const tRUN_DATA flash_run_data[ARRAY_SZ];

//#pragma DATA_SECTION(flash_reference, ".infoB");  // compiles fine
#pragma DATA_SECTION(flash_reference, ".mydata"); // warnings when compiling
const tRUN_DATA flash_reference[ARRAY_SZ];

void FLASH_Read(tRUN_DATA *data, unsigned int index)
{
  data->value = flash_run_data[index].value;
  data->time_ms = flash_run_data[index].time_ms;
}

void FLASH_Write(tRUN_DATA data)
{
  static unsigned int flash_index = 0;

  FLASH_UNLOCK;

  ((tRUN_DATA*)flash_run_data)[flash_index].value     = data.value;
  ((tRUN_DATA*)flash_run_data)[flash_index].time_ms   = data.time_ms;

  FLASH_LOCK;

  flash_index++;

}

void main(void)
{
  WDTCTL = WDTPW + WDTHOLD;
  tRUN_DATA test_data;
  unsigned int i;

  for (i = 1; i < 4; i++)
  {
    test_data.value = i * 10;
    test_data.time_ms = i * 100;
    FLASH_Write(test_data);
  }

  while(1)
  {
    for(i=0 ; i<10 ; i++)
    {
      FLASH_Read(&test_data, i);
    }
  }
}
