/*******************************************************************************
*  FILE PURPOSE: G3 standard PHY definitions
********************************************************************************
*
* FILE NAME: g3_phy.h
*
* DESCRIPTION:
*       This file includes G3 PHY standard definitions
*
*  Copyright (c) 2009 Texas Instruments Inc.
*  All Rights Reserved This program is the confidential and proprietary
*  product of Texas Instruments Inc.  Any Unauthorized use, reproduction or
*  transfer of this program is strictly prohibited.
*
* HISTORY:
*
* 02/22/2010 S.Yim             Written
*
* LIST OF FUNCTION PROTOTYPES:
*
******************************************************************************/
#ifndef _G3_PHY_H
#define _G3_PHY_H

#include <typedefs.h>

//#define PHY_ALLOW_COH_QPSK_8PSK

//----------------------------------------------------------------------------
//                      G3 Frame Structure
//----------------------------------------------------------------------------
/* Frame */
#define G3_PHY_NUM_PRMB_SYNCP_SYMBS           8
#define G3_PHY_NUM_FCH_SYMBS                 13
#define G3_PHY_NUM_FCH_SYMBS_TONEMASK        19
#define G3_PHY_MAX_NUM_DATA_SYMBS            252

#define G3_PHY_MAX_PSDU_LEN_BYTES           248
#define G3_PHY_MAX_PSDU_LEN_WORDS           ((G3_PHY_MAX_PSDU_LEN_BYTES + 1) >> 1)

#define G3_PHY_PRMB_LEN                     256
#define G3_PHY_HALF_SYNCM_LEN               (G3_PHY_PRMB_LEN >> 1)

/* Symbols */
#define G3_PHY_FFT_LEN                      256
#define G3_PHY_FFT_LEN_LOG2                   8
#define G3_PHY_CP_LEN                        30
#define G3_PHY_CP_FFT_LEN                   (G3_PHY_CP_LEN + G3_PHY_FFT_LEN)
#define G3_PHY_SYMB_OVLP                      8
#define G3_PHY_SYMB_LEN                     (G3_PHY_CP_FFT_LEN - G3_PHY_SYMB_OVLP)
#define G3_PHY_EFF_CP_LEN                   (G3_PHY_SYMB_LEN - G3_PHY_FFT_LEN)

#define G3_PHY_MAX_NUM_TONES_IN_SYMB         72     // FCC band requirement

#define G3_PHY_NUM_TONES_IN_SYMB_TONEMASK    25
#define G3_PHY_MAX_FCH_CBITS                 150   // FCC band requirement

#define G3_PHY_MAX_NUM_SUBBANDS              24  /* max number of subbands for tone map */
#define G3_PHY_TONEMASK_WORDS                 6

#ifdef CENELEC_ONLY
#define G3_PHY_MAX_NUM_ILV_SYMBS            252 /* Cenelec band */
#else
#define G3_PHY_MAX_NUM_ILV_SYMBS            511 /* FCC band */
#endif

/* PN Sequence length */
#define G3_PHY_PN_SEQ_LEN                   127

//----------------------------------------------------------------------------
//                      G3 Scrambler
//----------------------------------------------------------------------------


//----------------------------------------------------------------------------
//                      G3 RS Encoding
//----------------------------------------------------------------------------
#define G3_PHY_RS_N                     255
                                                 // normal mode
#define G3_PHY_RS_K                     239      // (N=255, N=239, T=8)
#define G3_PHY_RS_T                       8
                                                 // ROBO mode
#define G3_PHY_RS_K_ROBO                247      // (N=255, N=247, T=4)
#define G3_PHY_RS_T_ROBO                  4

//----------------------------------------------------------------------------
//                      G3 Convolutional Encoding
//----------------------------------------------------------------------------
#define G3_PHY_CNV_K                     7
#define G3_PHY_CNV_NUM_TAIL_BITS         (G3_PHY_CNV_K - 1)
#define G3_PHY_CNV_NUM_STATES            (1 << (G3_PHY_CNV_K - 1))

#define G3_PHY_CNV_UBLK_SIZE_LOG2        6
#define G3_PHY_CNV_UBLK_SIZE             (1 << G3_PHY_CNV_UBLK_SIZE_LOG2) //number of uncoded bits
//----------------------------------------------------------------------------
//                      G3 Interleaver
//----------------------------------------------------------------------------
#define G3_PHY_MAX_BLK_ILV_SYMBS         16  // maximum block interleaver size
#define G3_PHY_MIN_BLK_ILV_SYMBS          4  // minimum block interleaver size

//----------------------------------------------------------------------------
//                      G3 modulator
//----------------------------------------------------------------------------
#define G3_PHY_MOD_ROBO                  0
#define G3_PHY_MOD_DBPSK                 1
#define G3_PHY_MOD_DQPSK                 2
#define G3_PHY_MOD_D8PSK                 3

//----------------------------------------------------------------------------
//                      G3 Repetition
//----------------------------------------------------------------------------
#define G3_PHY_REPEAT_4                  4   // if ROBO mode data
#define G3_PHY_REPEAT_6                  6   // Super ROBO in FCH

//----------------------------------------------------------------------------
//                      G3 FCH
//----------------------------------------------------------------------------
// Cenelec band
#define G3_FCH_MOD_SHIFT                     6
#define G3_FCH_MOD_MASK                      3
#define G3_FCH_FL_SHIFT                      0
#define G3_FCH_FL_MASK                    0x3F
#define G3_FCH_TM_SHIFT                      0
#define G3_FCH_TM_MASK                    0x1FF
#define G3_FCH_DT_SHIFT                      4
#define G3_FCH_DT_MASK                       7
#define G3_FCH_DT_ACK                      0x2
#define G3_FCH_DT_NACK                     0x3

// FCC band
#define G3_FCC_FCH_MOD_SHIFT                6
#define G3_FCC_FCH_MOD_MASK                 0xF
#define G3_FCC_FCH_DT_SHIFT                  1
#define G3_FCC_FCH_DT_MASK                   7
#endif //_G3_PHY


//----------------------------------------------------------------------------
//                      G3 Coherent Modulation
//----------------------------------------------------------------------------
#define G3_COH_MOD_PILOT_TONE_SPACE            12   // tone spacing for the pilots
#define G3_COH_MOD_FCC_PILOT_OFFSET            36   // first pilot offset
#define G3_COH_MOD_CEN_PILOT_OFFSET            6   // first pilot offset
#define G3_COH_MAX_NUM_PILOTS_PER_SYMBOL       6   // max number of pilots per OFDM symbol


