/*****************************************************************************
* FILE PURPOSE: Header file for init flash
*******************************************************************************
*
* FILE NAME: flash_init.c
*
* DESCRIPTION:
*       Header file for flash
*
*  Copyright (c) 2004 Texas Instruments Inc.
*  All Rights Reserved This program is the confidential and proprietary
*  product of Texas Instruments Inc.  Any Unauthorized use, reproduction or
*  transfer of this program is strictly prohibited.
*
* HISTORY:
*
* 04/15/2009 R.Liang    initial version
* 06/10/2009 S.Yim      Added ram section for viterbi and fft
*
******************************************************************************/
#include "DSP28x_Project.h"
#ifdef F2806X
#include "F2806x_Device.h"
#elif defined (F28M35X)
#include "F28M35x_Device.h"
#else
#include "DSP2833x_Device.h"
#endif

#include <string.h>

// Used for running BackGround in flash, and ISR in RAM
extern Uint16 secureRamFuncs_loadstart;
extern Uint16 secureRamFuncs_loadend; 
extern Uint16 secureRamFuncs_runstart; 

extern Uint16 phyRamFuncs_loadstart;
extern Uint16 phyRamFuncs_loadend; 
extern Uint16 phyRamFuncs_runstart;  

extern Uint16 phyFirCoefs_loadstart;
extern Uint16 phyFirCoefs_loadend; 
extern Uint16 phyFirCoefs_runstart;  
#ifdef USE_SYSBIOS

#else
extern Uint16 hwi_vec_runstart;
extern Uint16 hwi_vec_loadstart;
extern Uint16 hwi_vec_loadend;

extern Uint16 trcdata_runstart;
extern Uint16 trcdata_loadstart;
extern Uint16 trcdata_loadend;
#endif
/**********************************************************************
* Function: config_flash()
*
* Description: Initializes and enables the PIE interrupts on the F280x.
**********************************************************************/
void config_flash(void)
{
  // Copy time critical code and Flash setup code to RAM
  // The  RamfuncsLoadStart, RamfuncsLoadEnd, and RamfuncsRunStart
  // symbols are created by the linker. Refer to the linker files. 
  memcpy(&secureRamFuncs_runstart,
         &secureRamFuncs_loadstart,
         &secureRamFuncs_loadend - &secureRamFuncs_loadstart);

#if 1
  memcpy(&phyRamFuncs_runstart,
         &phyRamFuncs_loadstart,
         &phyRamFuncs_loadend - &phyRamFuncs_loadstart);
  
  memcpy(&phyFirCoefs_runstart,
         &phyFirCoefs_loadstart,
         &phyFirCoefs_loadend - &phyFirCoefs_loadstart);
  
#endif
  
  // Call Flash Initialization to setup flash waitstates
  // This function must reside in RAM
  // InitFlash code in CSL.lib
  InitFlash();	// Call the flash wrapper init function
}

/**********************************************************************
* Function: InitPieVector()
*
* Description: Initializes and enables the PIE interrupts on the F280x.
**********************************************************************/
void InitPieVector(void)
{
//--- Disable interrupts
	asm(" SETC INTM, DBGM");			// Disable global interrupts

//--- Initialize the PIE_RAM
	PieCtrlRegs.PIECTRL.bit.ENPIE = 0;	// Disable the PIE
	asm(" EALLOW");						// Enable EALLOW protected register access
#ifdef USE_SYSBIOS
  // for SYSbios, this is not required
#else
  memcpy(&hwi_vec_runstart, &hwi_vec_loadstart,
  		 &hwi_vec_loadend - &hwi_vec_loadstart);
#endif         
	asm(" EDIS");						// Disable EALLOW protected register access

#if 1  
//--- Disable all PIE interrupts
	PieCtrlRegs.PIEIER1.all =  0x0000;
	PieCtrlRegs.PIEIER2.all =  0x0000;
	PieCtrlRegs.PIEIER3.all =  0x0000;
	PieCtrlRegs.PIEIER4.all =  0x0000;
	PieCtrlRegs.PIEIER5.all =  0x0000;
	PieCtrlRegs.PIEIER6.all =  0x0000;
	PieCtrlRegs.PIEIER7.all =  0x0000;
	PieCtrlRegs.PIEIER8.all =  0x0000;
	PieCtrlRegs.PIEIER9.all =  0x0000;
	PieCtrlRegs.PIEIER10.all = 0x0000;
	PieCtrlRegs.PIEIER11.all = 0x0000;
	PieCtrlRegs.PIEIER12.all = 0x0000;

//--- Clear any potentially pending PIEIFR flags
	PieCtrlRegs.PIEIFR1.all  = 0x0000;
	PieCtrlRegs.PIEIFR2.all  = 0x0000;
	PieCtrlRegs.PIEIFR3.all  = 0x0000;	
	PieCtrlRegs.PIEIFR4.all  = 0x0000;
	PieCtrlRegs.PIEIFR5.all  = 0x0000;
	PieCtrlRegs.PIEIFR6.all  = 0x0000;
	PieCtrlRegs.PIEIFR7.all  = 0x0000;
	PieCtrlRegs.PIEIFR8.all  = 0x0000;
	PieCtrlRegs.PIEIFR9.all  = 0x0000;
	PieCtrlRegs.PIEIFR10.all = 0x0000;
	PieCtrlRegs.PIEIFR11.all = 0x0000;
	PieCtrlRegs.PIEIFR12.all = 0x0000;

//--- Acknowlege all PIE interrupt groups
	PieCtrlRegs.PIEACK.all = 0xFFFF;

//--- Enable the PIE
	PieCtrlRegs.PIECTRL.bit.ENPIE = 1;		// Enable the PIE
#endif
} // end of InitPieCtrl()

	/**********************************************************************
* Function: UserInit()
*
* Description: This is the user initialization file to be specified in
* the DSP/BIOS configuration file, System - Global Settings.
**********************************************************************/
void UserInit(void)
{
	// Section .trcdata is generated by DSP/BIOS.
	// It must be copied from its load to its run address BEFORE main().
#ifdef USE_SYSBIOS

#else
	memcpy(&trcdata_runstart, &trcdata_loadstart, &trcdata_loadend - &trcdata_loadstart);
#endif
} // end of UserInit()

void flash_setup(void)
{
	//copy trcdata
  // R.Liang: 
  // UserInit is called by main. It is hook function by DSP/BIOS
  // don't call this function anymore, otherwise the GBL_Init_done
  // is reset to zero.

	//UserInit();
  
  // copy Pievector
  InitPieVector();
  
  //config flash
  config_flash();
}
//--- end of file -----------------------------------------------------

