/******************************************************************************
* FILE PURPOSE: This file implements the  PHY SWI
*******************************************************************************
*
* FILE NAME: test_rx_swi.c
*
* DESCRIPTION:
*
*  Copyright (c) 20098 Texas Instruments Inc.
*  All Rights Reserved This program is the confidential and proprietary
*  product of Texas Instruments Inc.  Any Unauthorized use, reproduction or
*  transfer of this program is strictly prohibited.
*
* HISTORY:
*
* 04/21/2008, Robert Liang, Initial version of prime phy
* 03/04/2010  S.Yim         Adapt for G3
*
* Functions:
*              sys_init_phy_rx     
*              PHY_RX_DMA_BIOS_ISR
*              PHY_RX_SWI
*              PHY_RX2_SWI
*
******************************************************************************/
#include <inttypes.h>
#include <std.h>
#include <swi.h>

/* configuration file */
#ifdef F2806X
  #include <test_tx_rx_f2806xcfg.h>
#elif defined (F28M35X)
  #include <test_tx_rx_f28m35xcfg.h>
#else
  #include <test_tx_rxcfg.h>
#endif
#include <hal_afe.h>
#include <phy_rx.h>

/******************************************************************************
 * FUNCTION NAME: sys_init_phy_rx
 *
 * DESCRIPTION: This function initializes the system for PHY RX
 *   
 * Return Value: 
 *
 * Input Parameters:  
 *
 * Output Parameters:
 *
 * Functions Called: 
 ******************************************************************************/
void sys_init_phy_rx(void)
{
  /* init PHY rx */
  PHY_rxInit();
}

/******************************************************************************
 * FUNCTION NAME: PHY_RX_DMA_BIOS_ISR
 *
 * DESCRIPTION: This function is called by BIOS for DMA ISR. It posts SWI for
 *              PHY Rx processing.
 *
 * Return Value: 
 *
 * Input Parameters:  
 *
 * Output Parameters:
 *
 * Functions Called: 
 ******************************************************************************/
void PHY_RX_DMA_BIOS_ISR(void)
{
  // call HAL library API
  HAL_afeRxDmaCh1IntFunc();

  // post SWI
  SWI_post(&SWI_PHY_RX);        
}

/******************************************************************************
 * FUNCTION NAME: PHY_RX_SWI
 *
 * DESCRIPTION: This function is executed in PHY RX SWI. It is triggered by
 *              SWI post in DMA ISR.
 *
 * Return Value: 
 *
 * Input Parameters:  
 *
 * Output Parameters:
 *
 * Functions Called: 
 ******************************************************************************/
int swicnt=0;
void PHY_RX_SWI(void)
{
  // call PHY library API
  PHY_rxSmRun(PHY_RX_PROC_SYMB);
  swicnt++;

}

/******************************************************************************
 * FUNCTION NAME: PHY_RX2_SWI
 *
 * DESCRIPTION: This function is executed in PHY RX2 SWI. It is triggered by
 *              SWI post for block processing
 *
 * Return Value: 
 *
 * Input Parameters:  
 *
 * Output Parameters:
 *
 * Functions Called: 
 ******************************************************************************/
int swicnt2=0;
void PHY_RX2_SWI(void)
{
  // call PHY library API
  /* debug #@@# */
  // if (swicnt2==1)
  //   { 
  //    swicnt ++;
  //   }
  PHY_rxSmRun(PHY_RX_PROC_BIT);
  swicnt2++;

}

/******************************************************************************
 * FUNCTION NAME: cb_bit
 *
 * DESCRIPTION: This function is post SWI for Rx Bit start
 *
 * Return Value: 
 *
 * Input Parameters:  
 *
 * Output Parameters:
 *
 * Functions Called: 
 ******************************************************************************/
void cb_bit(PHY_ev_t eventID, PHY_cbData_t *cbData_p)
{

  // post SWI
  // enable this when bit block ready
  SWI_post(&SWI_PHY_RX2);   

}
