//###########################################################################
//
// FILE:    F28M35x_DMA.c
//
// TITLE:   F28M35x Device DMA Initialization & Support Functions.
//
//###########################################################################
// $TI Release: F2806x/F2806x Header Files V1.20 $
// $Release Date: August 1, 2008 $
//###########################################################################

#include "F28M35x_Device.h"     // Headerfile Include File
#include "F28M35x_Examples.h"   // Examples Include File

// This function initializes the DMA to a known state.
//
void DMAInitialize(void)
{
	EALLOW;

	// Perform a hard reset on DMA
	DmaRegs.DMACTRL.bit.HARDRESET = 1;
    asm (" nop"); // one NOP required after HARDRESET

	// Allow DMA to run free on emulation suspend
	DmaRegs.DEBUGCTRL.bit.FREE = 0;

	EDIS;
}

