// TI File $Revision: /main/1 $
// Checkin $Date: April 5, 2011   18:35:45 $
//###########################################################################
//
// FILE:    F28M35x_DMA.c
//
// TITLE:   F28M35x Device DMA Initialization & Support Functions.
//
//###########################################################################
// $TI Release: F2806x/F2806x Header Files V1.20 $
// $Release Date: August 1, 2008 $
//###########################################################################

#include "F28M35x_Device.h"     // Headerfile Include File
#include "F28M35x_Examples.h"   // Examples Include File

void DMACHTransferConfig(Uint16 ch_num,Uint16 tsize, int16 srctstep, int16 deststep)
{
	volatile struct CH_REGS *pch;
  
	EALLOW;
  pch = &(DmaRegs.CH1);
  pch += (ch_num-1);

	// Set up TRANSFER registers:
	pch->TRANSFER_SIZE = tsize;                  // Number of bursts per transfer, DMA interrupt will occur after completed transfer
	pch->SRC_TRANSFER_STEP = srctstep;			// TRANSFER_STEP is ignored when WRAP occurs
	pch->DST_TRANSFER_STEP = deststep;			// TRANSFER_STEP is ignored when WRAP occurs

	EDIS;
}

