//###########################################################################
//
// FILE:   F28M35x_SysCtrl.c
//
// TITLE:  F28M35x Device System Control Initialization & Support Functions.
//
// DESCRIPTION:  Example initialization of system resources.
//###########################################################################
// $TI Release: $
// $Release Date: $
//###########################################################################

#include "F28M35x_Device.h" // Headerfile Include File
#include "F28M35x_Examples.h" // Examples Include File

// Functions that will be run from RAM need to be assigned to
// a different section.  This section will then be mapped to a load and
// run address using the linker cmd file.

//#pragma CODE_SECTION(InitFlash, "ramfuncs");

#pragma CODE_SECTION(InitFlash, "secureRamFuncs")



   //---------------------------------------------------------------------------
   // Example: InitFlash:
   //---------------------------------------------------------------------------
   // This function initializes the Flash Control registers

   //                   CAUTION
   // This function MUST be executed out of RAM. Executing it
   // out of OTP/Flash will yield unpredictable results

   void InitFlash(void)
   {
       EALLOW;
       
       //At reset bank and pump are in sleep
       //A Flash access will power up the bank and pump automatically
       //After a Flash access, bank and pump go to low power mode (configurable in FBFALLBACK/FPAC1 registers)-
       //if there is no further access to flash 
       //Power up Flash bank and pump and this also sets the fall back mode of flash and pump as active
       FlashCtrlRegs.FPAC1.bit.PMPPWR = 0x1;
       FlashCtrlRegs.FBFALLBACK.bit.BNKPWR0 = 0x3; 
       
//       //Disable Cache and prefetch mechanism before changing wait states
//       FlashCtrlRegs.FRD_INTF_CTRL.bit.DATA_CACHE_EN = 0;
//       FlashCtrlRegs.FRD_INTF_CTRL.bit.PREFETCH_EN = 0; 
//       
//       //Set waitstates according to frequency        
//       //                CAUTION
//       //Minimum waitstates required for the flash operating
//       //at a given CPU rate must be characterized by TI.
//       //Refer to the datasheet for the latest information.
       #if CPU_FRQ_150MHZ
       FlashCtrlRegs.FRDCNTL.bit.RWAIT =  0x3; 
       #endif
    
       #if CPU_FRQ_100MHZ
       FlashCtrlRegs.FRDCNTL.bit.RWAIT = 0x2;
       #endif
       
       #if CPU_FRQ_60MHZ
       FlashCtrlRegs.FRDCNTL.bit.RWAIT = 0x1;
       #endif              
//       
//       //Enable Cache and prefetch mechanism to improve performance
//       //of code executed from Flash.
//       FlashCtrlRegs.FRD_INTF_CTRL.bit.DATA_CACHE_EN = 1;
//       FlashCtrlRegs.FRD_INTF_CTRL.bit.PREFETCH_EN = 1; 
         
       //At reset, ECC is enabled
       //If it is disabled by application software and if application again wants to enable ECC

       // Robert, disabel ECC
       //FlashEccRegs.ECC_ENABLE.bit.ENABLE = 0xA;
       FlashEccRegs.ECC_ENABLE.bit.ENABLE = 0x0;
       
       EDIS;
    
       //Force a pipeline flush to ensure that the write to
       //the last register configured occurs before returning.
    
       asm(" RPT #7 || NOP");        
   }
