//###########################################################################
//
// FILE:   F28M35x_SysCtrl.c
//
// TITLE:  F28M35x Device System Control Initialization & Support Functions.
//
// DESCRIPTION:
//
//         Example initialization of system resources.
//
//###########################################################################
// $TI Release: $
// $Release Date: $
//###########################################################################

#include "F28M35x_Device.h" // Headerfile Include File
#include "F28M35x_Examples.h" // Examples Include File

//---------------------------------------------------------------------------
// InitSysCtrl:
//---------------------------------------------------------------------------
// This function initializes the System Control registers to a known state.
// - Disables the watchdog
// - Set the PLLCR for proper SYSCLKOUT frequency
// - Set the pre-scaler for the high and low frequency peripheral clocks
// - Enable the clocks to the peripherals

void InitSysCtrl(void)
{


    // *IMPORTANT*
    // The Device_cal function MUST be called
    // for the ADC and oscillators to function according
    // to specification. The clocks to the ADC MUST be enabled before calling
    // this function. See the device data manual and/or the ADC Reference
    // Manual for more information.

    (**InitAnalogSystemClock)(ACLKDIV4);

    EALLOW;
    // Initialize the Analog Sub-System and set the clock divider to divide by 4
    while((**AnalogClockEnable)(AnalogConfig1,ADC1_ENABLE));    // Enable ADC 1
    while((**AnalogClockEnable)(AnalogConfig2,ADC2_ENABLE));    // Enable ADC 2
    (**Device_Cal)();
    while((**AnalogClockDisable)(AnalogConfig1,ADC1_ENABLE));   // Disable ADC1
    while((**AnalogClockDisable)(AnalogConfig2,ADC2_ENABLE));   // Disable ADC2
    EDIS;

    // Initialize the peripheral clocks
    InitPeripheralClocks();
}
