//###########################################################################
//
// FILE:   F28M35x_SysCtrl.c
//
// TITLE:  F28M35x Device System Control Initialization & Support Functions.
//
// DESCRIPTION:
//
//         Example initialization of system resources.
//
//###########################################################################
// $TI Release: $
// $Release Date: $
//###########################################################################

#include "F28M35x_Device.h" // Headerfile Include File
#include "F28M35x_Examples.h" // Examples Include File


//--------------------------------------------------------------------------
// Example: InitPeripheralClocks:
//---------------------------------------------------------------------------
// This function initializes the clocks to the peripheral modules.
// First the high and low clock prescalers are set
// Second the clocks are enabled to each peripheral.
// To reduce power, leave clocks to unused peripherals disabled
//
// Note: If a peripherals clock is not enabled then you cannot
// read or write to the registers for that peripheral

void InitPeripheralClocks(void)
{
    // LOSPCP prescale register settings, normally it will be set to default
    // values
    EALLOW;
    SysCtrlRegs.LOSPCP.all = 0x0002;
    EDIS;

    // Initialize the Analog Sub-System and set the clock divider to divide by 4
    (**InitAnalogSystemClock)(ACLKDIV4);

    EALLOW;
    while((**AnalogClockEnable)(AnalogConfig1,ADC1_ENABLE)); // Enable ADC 1
    while((**AnalogClockEnable)(AnalogConfig2,ANALOGCONFIG2ALL)); // Enable 
                                                                  // ADC 2,
                                                                  // COMP1,2,3,
                                                                  // 4,5,6

    // Peripheral clock enables set for the selected peripherals.
    // If you are not using a peripheral leave the clock off
    // to save on power.
    // This function is not written to be an example of efficient code.

    SysCtrlRegs.PCLKCR1.bit.ECAP1ENCLK = 1; // eCAP1
    SysCtrlRegs.PCLKCR1.bit.ECAP2ENCLK = 1; // eCAP2
    SysCtrlRegs.PCLKCR1.bit.ECAP3ENCLK = 1; // eCAP3
    SysCtrlRegs.PCLKCR1.bit.ECAP4ENCLK = 1; // eCAP4
    SysCtrlRegs.PCLKCR1.bit.ECAP5ENCLK = 1; // eCAP5
    SysCtrlRegs.PCLKCR1.bit.ECAP6ENCLK = 1; // eCAP6

    SysCtrlRegs.PCLKCR1.bit.EQEP1ENCLK = 1; // eQEP1
    SysCtrlRegs.PCLKCR1.bit.EQEP2ENCLK = 1; // eQEP2
    SysCtrlRegs.PCLKCR2.bit.EQEP3ENCLK = 1; // eQEP3

    SysCtrlRegs.PCLKCR1.bit.EPWM1ENCLK = 1; // ePWM1
    SysCtrlRegs.PCLKCR1.bit.EPWM2ENCLK = 1; // ePWM2
    SysCtrlRegs.PCLKCR1.bit.EPWM3ENCLK = 1; // ePWM3
    SysCtrlRegs.PCLKCR1.bit.EPWM4ENCLK = 1; // ePWM4
    SysCtrlRegs.PCLKCR1.bit.EPWM5ENCLK = 1; // ePWM5
    SysCtrlRegs.PCLKCR1.bit.EPWM6ENCLK = 1; // ePWM6
    SysCtrlRegs.PCLKCR1.bit.EPWM7ENCLK = 1; // ePWM7
    SysCtrlRegs.PCLKCR1.bit.EPWM8ENCLK = 1; // ePWM8
    SysCtrlRegs.PCLKCR2.bit.EPWM9ENCLK = 1; // ePWM9

    SysCtrlRegs.PCLKCR3.bit.DMAENCLK = 1;   // DMA
    SysCtrlRegs.PCLKCR3.bit.CPUTIMER0ENCLK = 1; // Timer 0
    SysCtrlRegs.PCLKCR3.bit.CPUTIMER1ENCLK = 1; // Timer 1
    SysCtrlRegs.PCLKCR3.bit.CPUTIMER2ENCLK = 1; // Timer 2

    SysCtrlRegs.PCLKCR0.bit.SCIAENCLK = 1;   // SCI-A
    SysCtrlRegs.PCLKCR0.bit.SPIAENCLK = 1;   // SPI-A
    SysCtrlRegs.PCLKCR0.bit.I2CAENCLK = 1;   // I2C-A
    SysCtrlRegs.PCLKCR0.bit.MCBSPAENCLK = 1; // McBSP-A

    SysCtrlRegs.PCLKCR0.bit.HRPWMENCLK = 1; // HRPWM
    SysCtrlRegs.PCLKCR0.bit.TBCLKSYNC = 1;  // Enable TBCLK within the ePWM

    EDIS;
}
