;// TI File $Revision: /main/1 $ 
;// Checkin $Date: April 5, 2011   18:35:33 $
;//###########################################################################
;//
;// FILE:	F28M35x_CSMPasswords.asm
;//
;// TITLE:	F28M35x Code Security Module Passwords.
;// 
;// DESCRIPTION:
;//
;//         This file is used to specify password values to
;//         program into the CSM password locations in Flash
;//         at 0x13FFF8 - 0x13FFFF.
;//
;//###########################################################################
;// $TI Release: $ 
;// $Release Date: $ 
;//###########################################################################

; The "csmpasswords" section contains the actual CSM passwords that will be
; linked and programmed into to the CSM password locations (PWL) in flash.  
; These passwords must be known in order to unlock the CSM module. 
; All 0xFFFF's (erased) is the default value for the password locations (PWL).

; It is recommended that all passwords be left as 0xFFFF during code
; development.  Passwords of 0xFFFF do not activate code security and dummy 
; reads of the CSM PWL registers is all that is required to unlock the CSM.  
; When code development is complete, modify the passwords to activate the
; code security module.

      .sect "csmpasswds"

      .long	0xFFFFFFFF		;PWL0
      .long	0xFFFFFFFF		;PWL1
      .long	0xFFFFFFFF		;PWL2
      .long	0xFFFFFFFF		;PWL3 (MSW of 128-bit password)
      
      .sect "ecslpasswds"
      
      .long 0xFFFFFFFF		;ECSL0
      .long 0xFFFFFFFF		;ECSL1
      
      .sect "flashexeonly"
      
      .long	0xFFFFFFFF		;Flash Execute Only
	
;----------------------------------------------------------------------

; For code security operation, all addresses between 0x13FF80 and
; 0x13FFEF cannot be used as program code or data.  These locations
; must be programmed to 0x0000 when the code security password locations
; (PWL) are programmed.  If security is not a concern, then these addresses
; can be used for code or data.  

; The section "csm_rsvd" can be used to program these locations to 0x0000.

        .sect "csm_rsvd"
        .loop (13FFEFh - 13FF80h + 1)
              .int 0x0000
        .endloop

;//===========================================================================
;// End of file.
;//===========================================================================

      
