//###########################################################################
//
// FILE:   F28M35x_SysCtrl.c
//
// TITLE:  F28M35x Device System Control Initialization & Support Functions.
//
// DESCRIPTION:
//
//         Example initialization of system resources.
//
//###########################################################################
// $TI Release: $
// $Release Date: $
//###########################################################################

#include "F28M35x_Device.h" // Headerfile Include File
#include "F28M35x_Examples.h" // Examples Include File

// Functions that will be run from RAM need to be assigned to
// a different section.  This section will then be mapped to a load and
// run address using the linker cmd file.

//#pragma CODE_SECTION(InitFlash, "ramfuncs");

#pragma CODE_SECTION(InitFlash, "secureRamFuncs")

//---------------------------------------------------------------------------
// InitSysCtrl:
//---------------------------------------------------------------------------
// This function initializes the System Control registers to a known state.
// - Disables the watchdog
// - Set the PLLCR for proper SYSCLKOUT frequency
// - Set the pre-scaler for the high and low frequency peripheral clocks
// - Enable the clocks to the peripherals

void InitSysCtrl(void)
{

    // *IMPORTANT*
    // The Device_cal function, which copies the ADC & oscillator calibration
    // values from TI reserved OTP into the appropriate trim registers,
    // occurs automatically in the Boot ROM.If the boot ROM code is bypassed
    // during the debug process, the following function MUST be called
    // for the ADC and oscillators to function according
    // to specification. The clocks to the ADC MUST be enabled before calling
    // this function. See the device data manual and/or the ADC Reference
    // Manual for more information.

    EALLOW;
    //  SysCtrlRegs.PCLKCR0.bit.ADC1ENCLK = 1; // Enable ADC1 peripheral clock
    //  SysCtrlRegs.PCLKCR3.bit.ADC2ENCLK = 1; // Enable ADC2 peripheral clock
    // (*Device_cal)();
    //  SysCtrlRegs.PCLKCR0.bit.ADC1ENCLK = 0; // Return ADC1 clock to original
    // state
    //  SysCtrlRegs.PCLKCR3.bit.ADC2ENCLK = 0; // Return ADC2 clock to original
    // state
    EDIS;

    // Initialize the peripheral clocks
    InitPeripheralClocks();
}
/*
   //---------------------------------------------------------------------------
   // Example: InitFlash:
   //---------------------------------------------------------------------------
   // This function initializes the Flash Control registers

   //                   CAUTION
   // This function MUST be executed out of RAM. Executing it
   // out of OTP/Flash will yield unpredictable results

   void InitFlash(void)
   {
         // TODO: Update for Concerto
   }
 */
//--------------------------------------------------------------------------
// Example: InitPeripheralClocks:
//---------------------------------------------------------------------------
// This function initializes the clocks to the peripheral modules.
// First the high and low clock prescalers are set
// Second the clocks are enabled to each peripheral.
// To reduce power, leave clocks to unused peripherals disabled
//
// Note: If a peripherals clock is not enabled then you cannot
// read or write to the registers for that peripheral

void InitPeripheralClocks(void)
{
    EALLOW;

    // LOSPCP prescale register settings, normally it will be set to default
    // values
    SysCtrlRegs.LOSPCP.all = 0x0002;

    // Peripheral clock enables set for the selected peripherals.
    // If you are not using a peripheral leave the clock off
    // to save on power.
    //
    // This function is not written to be an example of efficient code.

    SysCtrlRegs.PCLKCR1.bit.ECAP1ENCLK = 1; // eCAP1
    SysCtrlRegs.PCLKCR1.bit.ECAP2ENCLK = 1; // eCAP2
    SysCtrlRegs.PCLKCR1.bit.ECAP3ENCLK = 1; // eCAP3
    SysCtrlRegs.PCLKCR1.bit.ECAP4ENCLK = 1; // eCAP4
    SysCtrlRegs.PCLKCR1.bit.ECAP5ENCLK = 1; // eCAP5
    SysCtrlRegs.PCLKCR1.bit.ECAP6ENCLK = 1; // eCAP6

    SysCtrlRegs.PCLKCR1.bit.EQEP1ENCLK = 1; // eQEP1
    SysCtrlRegs.PCLKCR1.bit.EQEP2ENCLK = 1; // eQEP2
    SysCtrlRegs.PCLKCR2.bit.EQEP3ENCLK = 1; // eQEP3

    SysCtrlRegs.PCLKCR1.bit.EPWM1ENCLK = 1; // ePWM1
    SysCtrlRegs.PCLKCR1.bit.EPWM2ENCLK = 1; // ePWM2
    SysCtrlRegs.PCLKCR1.bit.EPWM3ENCLK = 1; // ePWM3
    SysCtrlRegs.PCLKCR1.bit.EPWM4ENCLK = 1; // ePWM4
    SysCtrlRegs.PCLKCR1.bit.EPWM5ENCLK = 1; // ePWM5
    SysCtrlRegs.PCLKCR1.bit.EPWM6ENCLK = 1; // ePWM6
    SysCtrlRegs.PCLKCR1.bit.EPWM7ENCLK = 1; // ePWM7
    SysCtrlRegs.PCLKCR1.bit.EPWM8ENCLK = 1; // ePWM8
    SysCtrlRegs.PCLKCR2.bit.EPWM9ENCLK = 1; // ePWM9

    SysCtrlRegs.PCLKCR3.bit.DMAENCLK = 1; // DMA
    SysCtrlRegs.PCLKCR3.bit.CPUTIMER0ENCLK = 1; // Timer 0
    SysCtrlRegs.PCLKCR3.bit.CPUTIMER1ENCLK = 1; // Timer 1
    SysCtrlRegs.PCLKCR3.bit.CPUTIMER2ENCLK = 1; // Timer 2

    SysCtrlRegs.PCLKCR0.bit.SCIAENCLK = 1; // SCI-A
    SysCtrlRegs.PCLKCR0.bit.SPIAENCLK = 1; // SPI-A
    SysCtrlRegs.PCLKCR0.bit.I2CAENCLK = 1; // I2C-A
    SysCtrlRegs.PCLKCR0.bit.MCBSPAENCLK = 1; // McBSP-A

    SysCtrlRegs.PCLKCR0.bit.HRPWMENCLK = 1; // HRPWM
    SysCtrlRegs.PCLKCR0.bit.TBCLKSYNC = 1; // Enable TBCLK within the ePWM

    EDIS;
}

//===========================================================================
// End of file.
//===========================================================================
