/******************************************************************************
 *
 * F28M35H52C1_ccs.cmd - CCS linker configuration file for timers.
 *
 * Copyright (c) 2009-2011 Texas Instruments Incorporated.  All rights reserved.
 * Software License Agreement
 * 
 * Texas Instruments (TI) is supplying this software for use solely and
 * exclusively on TI's microcontroller products. The software is owned by
 * TI and/or its suppliers, and is protected under applicable copyright
 * laws. You may not combine this software with "viral" open-source
 * software in order to form a larger program.
 * 
 * THIS SOFTWARE IS PROVIDED "AS IS" AND WITH ALL FAULTS.
 * NO WARRANTIES, WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING, BUT
 * NOT LIMITED TO, IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE APPLY TO THIS SOFTWARE. TI SHALL NOT, UNDER ANY
 * CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL, OR CONSEQUENTIAL
 * DAMAGES, FOR ANY REASON WHATSOEVER.
 *
 *****************************************************************************/

--retain=g_pfnVectors

/* The following command line options are set as part of the CCS project.    */
/* If you are building using the command line, or for some reason want to    */
/* define them here, you can uncomment and modify these lines as needed.     */
/* If you are using CCS for building, it is probably better to make any such */
/* modifications in your CCS project and leave this file alone.              */
/*                                                                           */
/* --heap_size=0                                                             */
/* --stack_size=256                                                          */
/* --library=rtsv7M3_T_le_eabi.lib                                           */


/* System memory map */

MEMORY
{
    FLASH (RX) 		: origin = 0x00200000, length = 0x80000
    C0 (RWX) 		: origin = 0x20000000, length = 0x2000
    C1 (RWX) 		: origin = 0x20002000, length = 0x2000
    BOOT_RSVD (RX)	: origin = 0x20004000, length = 0x0FF8
    RESETISR (RWX)	: origin = 0x20004FF8, length = 0x0008
    INTVECS (RWX)	: origin = 0x20005000, length = 0x01B0
    C2 (RWX) 		: origin = 0x200051B0, length = 0x0E50
    C3 (RWX) 		: origin = 0x20006000, length = 0x2000
    S0 (RWX)		: origin = 0x20008000, length = 0x2000
    S1 (RWX)		: origin = 0x2000A000, length = 0x2000
    S2 (RWX)		: origin = 0x2000C000, length = 0x2000
    S3 (RWX)		: origin = 0x2000E000, length = 0x2000
    S4 (RWX)		: origin = 0x20010000, length = 0x2000
    S5 (RWX)		: origin = 0x20012000, length = 0x2000
    S6 (RWX)		: origin = 0x20014000, length = 0x2000
    S7 (RWX)		: origin = 0x20016000, length = 0x2000
    CTOMRAM (RX)	: origin = 0x2007F000, length = 0x0800
    MTOCRAM (RWX)   : origin = 0x2007F800, length = 0x0800
}

/* Section allocation in memory */

SECTIONS
{
    .intvecs:   > INTVECS
    .resetisr:  > RESETISR
    .text   :   > C0
    .const  :   > C2
    .cinit  :   > C2
    .pinit  :   > C2

    .vtable :   > C1
    .data   :   > C1
    .bss    :   > C1
    .sysmem :   > C1
    .stack  :   > C1
    
    GROUP : > MTOCRAM
    {
    	PUTBUFFER  
        PUTWRITEIDX
		GETREADIDX  
    }

 	GROUP : > CTOMRAM 
    {
       	GETBUFFER : TYPE = DSECT
		GETWRITEIDX : TYPE = DSECT
		PUTREADIDX : TYPE = DSECT
	}    
}

__STACK_TOP = __stack + 256;
