//###########################################################################
// FILE:   ram.c
// TITLE:  Driver for the IPC Module Utility Functions.
//###########################################################################
// $TI Release: F28M35x Driver Library vBeta1 $
// $Release Date: August 31, 2011 $
//###########################################################################

//*****************************************************************************
//! \addtogroup ram_api
//! @{
//*****************************************************************************
#include "inc/hw_memmap.h"
#include "inc/hw_types.h"
#include "inc/hw_ram.h"
#include "inc/hw_sysctl.h"
#include "driverlib/debug.h"
#include "driverlib/ram.h"

//*****************************************************************************
//! M3 master R/W/Exe Access to Shared SARAM.
//!
//! \param ulMask specifies the 32-bit mask for the SxMSEL RAM control register
//! to indicate which Sx SARAM blocks the C28 is requesting master access to.
//! \param usMaster specifies whether the C28 or M3 are given master access to
//! the Sx blocks. 
//!
//! This function will allow the M3 master system to configure master R/W/Exe
//! access to the Sx SARAM blocks specified by the /e ulMask parameter. 
//! The  \e usMaster parameter can be either: \b IPC_SX_C28MASTER
//! or \b IPC_SX_M3MASTER. 
//! The \e ulMask parameter can be any of the options:
//! \b S0_ACCESS - \b S7_ACCESS.
//
//*****************************************************************************
void
RamMReqSharedMemAccess (unsigned long ulMask, unsigned short usMaster)
{
    static unsigned long ulMWRAllow;
    ulMWRAllow = HWREG(SYSCTL_MWRALLOW);
    HWREG(SYSCTL_MWRALLOW) = 0xA5A5A5A5;
    if (usMaster == SX_M3MASTER)
    {
        HWREG(RAM_CONFIG_BASE + RAM_O_MSXMSEL) &= ~ulMask;
    }
    else if (usMaster == SX_C28MASTER)
    {
        HWREG(RAM_CONFIG_BASE + RAM_O_MSXMSEL) |= ulMask;
    }
    HWREG(SYSCTL_MWRALLOW) = ulMWRAllow;
}

//*****************************************************************************
// Close the Doxygen group.
//! @}
//*****************************************************************************


