/*-----------------------------------------------------------------------------------
*  DSP2834x_ExtFlashAPI.h
*
*  Abstract definition of functions for external flash memories
*
*  These functions serve as an abstract API for an external flash memory on 
*  the 2834x device.  Implement these functions in the device driver for your 
*  external flash memory. This allows the SDFlash application to program the
*  memory in place regardless of which actual external flash memory device is 
*  used. 
*
*----------------------------------------------------------------------------------*/

//Implement these functions in your external flash memory driver
extern Uint16 FL_SectorErase(Uint32 mask);
extern Uint16 FL_WriteWordArray(Uint16 **addr, Uint16 *data, Uint16 length);
extern Uint16 FL_VerifyWordArray(Uint16 **addr, Uint16 *data, Uint16 length);
extern void   FL_Init(void);

//Define bit addresses for sectors.
//Used in sector mask for flash erase.
#define FL_SBA0  0x00000001
#define FL_SBA1  0x00000002
#define FL_SBA2  0x00000004
#define FL_SBA3  0x00000008
#define FL_SBA4  0x00000010
#define FL_SBA5  0x00000020
#define FL_SBA6  0x00000040
#define FL_SBA7  0x00000080
#define FL_SBA8  0x00000100
#define FL_SBA9  0x00000200
#define FL_SBA10 0x00000400
#define FL_SBA11 0x00000800
#define FL_SBA12 0x00001000
#define FL_SBA13 0x00002000
#define FL_SBA14 0x00004000
#define FL_SBA15 0x00008000
#define FL_SBA16 0x00010000
#define FL_SBA17 0x00020000
#define FL_SBA18 0x00040000
#define FL_SBA19 0x00080000
#define FL_SBA20 0x00100000
#define FL_SBA21 0x00200000
#define FL_SBA22 0x00400000

#define FL_SBA23 0x00800000 
#define FL_SBA24 0x01000000
#define FL_SBA25 0x02000000
#define FL_SBA26 0x04000000
#define FL_SBA27 0x08000000
#define FL_SBA28 0x10000000
#define FL_SBA29 0x20000000
#define FL_SBA30 0x40000000
#define FL_SBA31 0x80000000//add more as needed

//API Status Messages
//The following status values are returned from the API to the calling
//program.  These can be used to determine if the API function passed
//or failed.  

// Operation passed, no errors were flagged
#define STATUS_SUCCESS                       0
// The CSM is preventing the function from performing its operation
#define STATUS_FAIL_CSM_LOCKED               10
// Device REVID does not match that required by the API
#define STATUS_FAIL_REVID_INVALID            11
// Invalid address passed to the API
#define STATUS_FAIL_ADDR_INVALID             12
// Incorrect PARTID
// For example the F2806 API was used on a F2808 device. 
#define STATUS_FAIL_INCORRECT_PARTID         13
// API/Silicon missmatch.  An old version of the
// API is being used on silicon it is not valid for
// Please update to the latest API. 
#define STATUS_FAIL_API_SILICON_MISMATCH     14
// ---- Erase Specific errors ---- 
#define STATUS_FAIL_NO_SECTOR_SPECIFIED      20
#define STATUS_FAIL_PRECONDITION             21
#define STATUS_FAIL_ERASE                    22
#define STATUS_FAIL_COMPACT                  23
#define STATUS_FAIL_PRECOMPACT               24
// ---- Program Specific errors ----  
#define STATUS_FAIL_PROGRAM                  30
#define STATUS_FAIL_ZERO_BIT_ERROR           31
// ---- Verify Specific errors ----
#define STATUS_FAIL_VERIFY                   40
// Busy is set by each API function before it determines
// a pass or fail condition for that operation.  
// The calling function will will not receive this 
// status condition back from the API
#define STATUS_BUSY                          999  
