/*-----------------------------------------------------------------------------------
*  DSP2834x_AT49BV802D.h
*
*  Heade files for AT49BV802D external flash memory drivers
*
*  This header file defines functions to be implemented in the AT49BV802D driver
*  file. It also defines sector addresses specific to the device and other 
*  and defines other constants neccessary for the driver. 
*
*----------------------------------------------------------------------------------*/

//Functions required for SDFlash
#include "DSP2834x_ExtFlashAPI.h"

//Other operatioins implemented for this flash memory
extern Uint16 FL_ChipErase(Uint16 *addr);
extern Uint16 FL_EraseSingleSector(Uint16 *addr);
extern Uint16 FL_WriteWord(Uint16 *addr, Uint16 data);
extern void   FL_LockSector(Uint16 *addr);
extern void   FL_InitXintfZone6(void);
extern void   FL_InitXintfZone7(void);

//Configurations and constant definitions...

//Select either zone 6 or zone 7
#define FL_ZONE 6
//#define FL_ZONE 7 

//Define start address of memory
#if FL_ZONE == 6
	#define FL_START_ADDR 0x00100000
#endif
#if FL_ZONE == 7
	#define FL_START_ADDR 0x00200000
#endif

//define locations to write command sequences
#define FL_CmdLoc1 (Uint16*)(FL_START_ADDR + 0x0555) 
#define FL_CmdLoc2 (Uint16*)(FL_START_ADDR + 0x02AA)
//#define FL_CmdLoc2 (Uint16*)(FL_START_ADDR + 0x0AAA)

//Define sector addresses
#define FL_SA0  (Uint16*)(FL_START_ADDR + 0x00000000)
#define FL_SA1  (Uint16*)(FL_START_ADDR + 0x00008000)
#define FL_SA2  (Uint16*)(FL_START_ADDR + 0x00010000)
#define FL_SA3  (Uint16*)(FL_START_ADDR + 0x00018000)
#define FL_SA4  (Uint16*)(FL_START_ADDR + 0x00020000)
#define FL_SA5  (Uint16*)(FL_START_ADDR + 0x00028000)
#define FL_SA6  (Uint16*)(FL_START_ADDR + 0x00030000)
#define FL_SA7  (Uint16*)(FL_START_ADDR + 0x00038000)
#define FL_SA8  (Uint16*)(FL_START_ADDR + 0x00040000)
#define FL_SA9  (Uint16*)(FL_START_ADDR + 0x00048000)
#define FL_SA10 (Uint16*)(FL_START_ADDR + 0x00050000)
#define FL_SA11 (Uint16*)(FL_START_ADDR + 0x00058000)
#define FL_SA12 (Uint16*)(FL_START_ADDR + 0x00060000)
#define FL_SA13 (Uint16*)(FL_START_ADDR + 0x00068000)
#define FL_SA14 (Uint16*)(FL_START_ADDR + 0x00070000)
#define FL_SA15 (Uint16*)(FL_START_ADDR + 0x00078000)
#define FL_SA16 (Uint16*)(FL_START_ADDR + 0x00080000)
#define FL_SA17 (Uint16*)(FL_START_ADDR + 0x00088000)
#define FL_SA18 (Uint16*)(FL_START_ADDR + 0x00090000)
#define FL_SA19 (Uint16*)(FL_START_ADDR + 0x00098000)
#define FL_SA20 (Uint16*)(FL_START_ADDR + 0x000A0000)
#define FL_SA21 (Uint16*)(FL_START_ADDR + 0x000A8000)
#define FL_SA22 (Uint16*)(FL_START_ADDR + 0x000B0000)

//add rest sector
#define FL_SA23 (Uint16*)(FL_START_ADDR + 0x000B8000)
#define FL_SA24 (Uint16*)(FL_START_ADDR + 0x000C0000)
#define FL_SA25 (Uint16*)(FL_START_ADDR + 0x000C8000)
#define FL_SA26 (Uint16*)(FL_START_ADDR + 0x000D0000)
#define FL_SA27 (Uint16*)(FL_START_ADDR + 0x000D8000)
#define FL_SA28 (Uint16*)(FL_START_ADDR + 0x000E0000)
#define FL_SA29 (Uint16*)(FL_START_ADDR + 0x000E8000)
#define FL_SA30 (Uint16*)(FL_START_ADDR + 0x000F0000)
#define FL_SA31 (Uint16*)(FL_START_ADDR + 0x000F8000)

