// TI File $Revision::1$
//###########################################################################
//  FILE: GpioFlash.c 
//
//  TITLE: 2834x Toggle GPIO0 example for XINTF external flash memory   
//
//  NOTE: This code toggles GPIO0. It runs from an external flash memory 
//  device.  Gpio will toggle a couple time per second, so if possible 
//  connect it to an LED.  
// 
//###########################################################################
//    Ver | dd mmm yyyy | Who  | Description of changes
//========|=============|======|=============================================
//   1.00 | 28 Jul 2009 |  TI  | Initial Release
//########################################################################### 

#include "DSP28x_Project.h"
#include "DSP2834x_MAX29GL640EL.h"

// Prototype statements for functions found within this file.
void delay_loop(void);
void Gpio_select(void);

#define DELAY 200000

//PLL settings for 200MHz clock
#define PLL_DIVSEL 2
#define PLL_DIV    19


#define OK   1
#define ERROR    0
#define FLASH_0 (volatile unsigned int *)0x100000   //16bit data selection
#define ERASEDATA  (unsigned int)0xFFFF    //Erase data checks
#define ANYADDRESS (unsigned long)0x7FFFF  //0x7FFFF maximun
void vReadReset(void);
unsigned char ucChipErase(void);
unsigned char ucBlockErase(unsigned long address);
unsigned char ucWriteFlash(unsigned long address,unsigned int data);
unsigned int uiReadFlash(unsigned long address);
unsigned int uiFlashBusy(unsigned long address,unsigned int data);
int vDelayTestUse(int delaytime);
unsigned int uiTestFlash();
unsigned long ulRomAddress = 0x78000;
int i=0,j=0,m=0,n=0;
unsigned char FL_EraseSingleSector1(unsigned long addr);
unsigned char FL_WriteWord1(unsigned long addr, Uint16 data);


void main(void)
{     
   DINT;
   EALLOW;

   //Setup clock
   SysCtrlRegs.WDCR = 0x0068;
   SysCtrlRegs.PLLSTS.bit.DIVSEL = 0; //set divider to /8
   SysCtrlRegs.PLLCR.bit.DIV = PLL_DIV; 
   SysCtrlRegs.PLLSTS.bit.DIVSEL = PLL_DIVSEL;

   //Wait for PLL to lock
   while(SysCtrlRegs.PLLSTS.bit.PLLLOCKS == 0);
   EDIS;
   //Initialize external flash
   FL_Init();

   //Setup gpio
   Gpio_select();   

   //Clear gpio0
   GpioDataRegs.GPBCLEAR.all = 0x00000004;
   
   	   delay_loop();

	   //toggle gpio 0
	   GpioDataRegs.GPBTOGGLE.all = 0x00000004;

	   GpioDataRegs.GPBCLEAR.all = 0x00000004;


#if 0
	   FL_EraseSingleSector1(ulRomAddress);
	   FL_WriteWord1(ulRomAddress, 0x55aa);
       n++;
	   ucChipErase();
	   n++;
	   FL_WriteWord1(ulRomAddress, 0x66bb);
	   n++;
	   asm("        ESTOP0");
#endif
	  for(;;)
   {   
	   delay_loop();

	   //toggle gpio 0
	   GpioDataRegs.GPBTOGGLE.all = 0x00000004;

   }
	   
} 	


unsigned char  ucChipErase()
{
    unsigned int newData1,newData2;


    *(FLASH_0 + 0x555)= 0xAA ;
    *(FLASH_0 + 0x2AA)= 0x55 ;
    *(FLASH_0 + 0x555)= 0x80 ;
    *(FLASH_0 + 0x555)= 0xAA ;
    *(FLASH_0 + 0x2AA)= 0x55 ;
	*(FLASH_0 + 0x555)= 0x10 ;

    do{
    	newData1 = *(FLASH_0 + ANYADDRESS);
    	newData2 = *(FLASH_0 + ANYADDRESS);
    	if( (newData1 & 0x0040) == (newData2 & 0x0040)  )
    	{
    		break;
    	}
    }while( (newData1 & 0x0020) == 0);

	newData1 = *(FLASH_0 + ANYADDRESS);
	newData2 = *(FLASH_0 + ANYADDRESS);
	if( (newData1 & 0x0040) == (newData2 & 0x0040)  )
	{
		return OK;
	}
	else
    {
    	return ERROR;
    }
}

unsigned char FL_EraseSingleSector1(unsigned long addr)
{
	//Uint16 testData;
    Uint16 data1,data2;

	//initiate sector erase
	*FL_CmdLoc1 = 0xAA;
	*FL_CmdLoc2 = 0x55;
	*FL_CmdLoc1 = 0x80;
	*FL_CmdLoc1 = 0xAA;
	*FL_CmdLoc2 = 0x55;
	*(FLASH_0+addr) = 0x30;

	//poll until erase is complete or erase operation fails
	do
	{
	    //read data and check if erase is complete

		data1 = *(FLASH_0+addr);
		data2 = *(FLASH_0+addr);
		if( ( data1 & 0x0040) == ( data2 & 0x0040) )
		{
			break;
		}
	}while((data1 & 0x0020) == 0x0000); //continue to check data if not timed out

	//verify that erase occured
	if(*(FLASH_0+addr) == 0xFFFF)
	{
		//erase operation success
		return STATUS_SUCCESS;
	}
	//erase operation failed
	return STATUS_FAIL_ERASE;
}

//This function writes a single word of data to the memory.  Pass in the
//address and the data, the function will return after the write is complete.
unsigned char FL_WriteWord1(unsigned long addr, Uint16 data)
{
	Uint16 oldData;
	Uint16 newData1,newData2;

	//read previous data
	oldData = *(FLASH_0+addr);

	//enter single program mode
	*FL_CmdLoc1 = 0xAA;
	*FL_CmdLoc2 = 0x55;
	*FL_CmdLoc1 = 0xA0;

	//write data to desired address
	*(FLASH_0+addr) = data;

	do
	{
		newData1 = *(FLASH_0+addr);
		newData2 = *(FLASH_0+addr);
		//Check if bit in data is toggling
		if((newData1 & 0x0040)  == (newData2 & 0x0040))
		{
			break; //bit did not toggle: write has completed
		}
	}while((newData1 & 0x0020) == 0); //continue to check data if not timed out

	//verify correct or incorrect data
	if(*(FLASH_0+addr) == (data & oldData))
	{
		//program operation success
		return STATUS_SUCCESS;
	}
	//program operation failed
	return STATUS_FAIL_PROGRAM;
}










//Delay between gpio0 toggles  
void delay_loop()
{
    Uint32 i;
    for(i = 0; i < DELAY; i++);
}

//Setup gpio0 for toggling 
void Gpio_select(void)
{
    //Gpio 0   
    EALLOW;
	GpioCtrlRegs.GPBMUX1.bit.GPIO34 = 0; // Gpio0 as Gpio
    GpioCtrlRegs.GPBDIR.bit.GPIO34 = 1; // Gpio0 as Output
    GpioDataRegs.GPBCLEAR.bit.GPIO34 = 1; // Clear Gpio0

    //set address 20 21 as gpio
    GpioCtrlRegs.GPBMUX1.bit.GPIO35 = 0; // Gpio as Gpio
   	GpioCtrlRegs.GPBMUX2.bit.GPIO63 = 0;
    GpioCtrlRegs.GPBDIR.bit.GPIO35 = 1; // Gpio as Output
	GpioCtrlRegs.GPBDIR.bit.GPIO63 = 1;
  //  GpioDataRegs.GPBCLEAR.bit.GPIO35 = 1; // Clear Gpio
  //  GpioDataRegs.GPBCLEAR.bit.GPIO63 = 1;
    GpioDataRegs.GPBSET.bit.GPIO35 = 1; // Clear Gpio
    GpioDataRegs.GPBSET.bit.GPIO63 = 1;

    EDIS;     
}     




void vReadReset()
{
    *(FLASH_0 + 0x555)= 0xF0;
//	*(FLASH_0 + 0x2AA)= 0x55 ;
//	*(FLASH_0 + ANYADDRESS)= 0xF0 ;
}


int vDelayTestUse(int delaytime)
{
    Uint32 i;
    for(i = 0; i < delaytime; i++);
    return 1;
}







//===========================================================================
// No more.
//===========================================================================

