//###########################################################################
//
// FILE:	F2806x_DMA.c
//
// TITLE:	F2806x Device DMA Initialization & Support Functions.
//
//###########################################################################
// $TI Release: F2806x/F2806x Header Files V1.20 $
// $Release Date: August 1, 2008 $
//###########################################################################

#include "F2806x_Device.h"     // Headerfile Include File
#include "F2806x_Examples.h"   // Examples Include File

// This function initializes the DMA to a known state.
//


void DMACHBurstConfig(Uint16 ch_num,Uint16 bsize, int16 srcbstep, int16 desbstep)
{
	volatile struct CH_REGS *pch;
  
	EALLOW;
  pch = &(DmaRegs.CH1);
  pch += (ch_num-1);

	// Set up BURST registers:
	pch->BURST_SIZE.all = bsize;	                // Number of words(X-1) x-ferred in a burst
	pch->SRC_BURST_STEP = srcbstep;			    // Increment source addr between each word x-ferred
	pch->DST_BURST_STEP = desbstep;              // Increment dest addr between each word x-ferred


	EDIS;
}

