//###########################################################################
//
// FILE:	F2806x_DMA.c
//
// TITLE:	F2806x Device DMA Initialization & Support Functions.
//
//###########################################################################
// $TI Release: F2806x/F2806x Header Files V1.20 $
// $Release Date: August 1, 2008 $
//###########################################################################

#include "F2806x_Device.h"     // Headerfile Include File
#include "F2806x_Examples.h"   // Examples Include File


void DMACHModeConfig(Uint16 ch_num,Uint16 persel, Uint16 perinte, Uint16 oneshot, Uint16 cont, Uint16 synce, Uint16 syncsel, Uint16 ovrinte, Uint16 datasize, Uint16 chintmode, Uint16 chinte)
{
	volatile struct CH_REGS *pch;
  Uint16 mask,data;
	EALLOW;
  pch = &(DmaRegs.CH1);
  pch += (ch_num-1);

	// Set up MODE Register:
	pch->MODE.bit.PERINTSEL = persel;	    // Passed DMA channel as peripheral interrupt source
	pch->MODE.bit.PERINTE = perinte;       	// Peripheral interrupt enable
	pch->MODE.bit.ONESHOT = oneshot;       	// Oneshot enable
	pch->MODE.bit.CONTINUOUS = cont;    		// Continous enable
	pch->MODE.bit.SYNCE = synce;         	// Peripheral sync enable/disable
	pch->MODE.bit.SYNCSEL = syncsel;       	// Sync effects source or destination
	pch->MODE.bit.OVRINTE = ovrinte;         // Enable/disable the overflow interrupt
	pch->MODE.bit.DATASIZE = datasize;      	// 16-bit/32-bit data size transfers
	pch->MODE.bit.CHINTMODE = chintmode;		// Generate interrupt to CPU at beginning/end of transfer
	pch->MODE.bit.CHINTE = chinte;        	// Channel Interrupt to CPU enable

	// Clear any spurious flags:
	pch->CONTROL.bit.PERINTCLR = 1;  		// Clear any spurious interrupt flags
	pch->CONTROL.bit.SYNCCLR = 1;    		// Clear any spurious sync flags
	pch->CONTROL.bit.ERRCLR = 1; 	     	// Clear any spurious sync error flags

	// Initialize PIE vector for CPU interrupt:
  
	// read/modify/write  
  mask = 1<<(ch_num-1);
  data = PieCtrlRegs.PIEIER7.all;
  data |=mask;
  PieCtrlRegs.PIEIER7.all = data;
	//PieCtrlRegs.PIEIER7.bit.INTx1 = 1;              // Enable DMA CH1 interrupt in PIE

	EDIS;
}

