// TI File $Revision: /main/7 $
// Checkin $Date: September 20, 2007   13:30:31 $
//###########################################################################
//
// FILE:   F2806x_SysCtrl.c
//
// TITLE:  F2806x Device System Control Initialization & Support Functions.
//
// DESCRIPTION:
//
//         Example initialization of system resources.
//
//###########################################################################
// $TI Release: F2806x/DSP2823x Header Files V1.20 $
// $Release Date: August 1, 2008 $
//###########################################################################


#include "F2806x_Device.h"     // Headerfile Include File
#include "F2806x_Examples.h"   // Examples Include File

void XTAL_OSC(void)
{
	SysCtrlRegs.CLKCTL.bit.XTALOSCOFF = 0;	// Make sure Crystal OSC is not turned off
	SysCtrlRegs.CLKCTL.bit.XCLKINOFF = 1;	// Ensure external XCLKIN i/p is disabled 
	SysCtrlRegs.CLKCTL.bit.OSCCLKSRC2SEL = 0;	// OSCCLK2 is routed to XCLKIN/XTAL
	SysCtrlRegs.CLKCTL.bit.OSCCLKSRCSEL = 1;	// OSCCLK is connected to OSCCLKSRC2
	if (SysCtrlRegs.PLLSTS.bit.DIVSEL != 0) { SysCtrlRegs.PLLSTS.bit.DIVSEL = 0; }   
	SysCtrlRegs.PLLCR.bit.DIV = DSP28_PLLCR;			// 	Write the PLL multiplier
		while(SysCtrlRegs.PLLSTS.bit.PLLLOCKS !=1){}	// Wait for the PLL to lock
	SysCtrlRegs.CLKCTL.bit.WDCLKSRCSEL = 1;	//
	SysCtrlRegs.CLKCTL.bit.INTOSC2OFF = 1;
	SysCtrlRegs.CLKCTL.bit.INTOSC1OFF = 1;

#if 0	
	// turn on XCLKOUT as monitor signal
	SysCtrlRegs.PLLSTS.bit.DIVSEL = 2; 		// O/P of PLL-->CPU, 0,1->/4, 2->/2, 3->/1
	SysCtrlRegs.XCLK.bit.XCLKOUTDIV = 0; 	// SYSCLKOUT-->XCLKOUT relationship. 0->/4, 1->/2, 2->/1, 3->OFF 
	GpioCtrlRegs.GPAMUX2.bit.GPIO18 = 3; 	// Turn-on XCLKOUT pin
#endif

}

void InitSysCtrl(void)
{

   // Disable the watchdog
   DisableDog();

   EALLOW;
   XTAL_OSC();
   EDIS;
   
   // Initialize the PLL control: PLLCR and DIVSEL
   // DSP28_PLLCR and DSP28_DIVSEL are defined in DSP2833x_Examples.h
   InitPll(DSP28_PLLCR,DSP28_DIVSEL);
    
   // Initialize the peripheral clocks
   InitPeripheralClocks();
}

