#ifndef _PHY_H
#define _PHY_H

/******************************************************************************
* FILE PURPOSE: Public header file module PRIME PHY
*******************************************************************************
*
* FILE NAME: phy.h
*
* DESCRIPTION:
*       This file contains public definitions, data structures and function
*       prototypes for PRIME PHY.
*
*  Copyright (c) 2009 Texas Instruments Inc.
*  All Rights Reserved This program is the confidential and proprietary
*  product of Texas Instruments Inc.  Any Unauthorized use, reproduction or
*  transfer of this program is strictly prohibited.
*
* HISTORY:
*
* 02/27/2009 S.Yim    Written
* 11/30/2009 S.Yim    Updated PHY API
*
*
* LIST OF FUNCTION PROTOTYPES:
*
******************************************************************************/

/*****************************************************************************/
/* Definitions                                                               */
/*****************************************************************************/
#define PHY_MAX_CB_PARMS     8

/* PHY status */
typedef enum
{
  PHY_STAT_SUCCESS                = 0,
  PHY_STAT_FAILURE                = 1,
  PHY_STAT_PREAMBLE_NOT_DETECTED  = 2,
  PHY_STAT_HEADER_CRC_FAILED      = 3,
  PHY_STAT_PAYLOAD_CRC_FAILED     = 4,
  PHY_STAT_ILLEGAL_PARAMETERS     = 5,
  PHY_STAT_ILLEGAL_OPERATIONS     = 6,
  PHY_STAT_UNKNOWN_ID             = 7,
  PHY_STAT_TX_LATE                = 8,
  PHY_STAT_INVALID_LEN            = 9,
  PHY_STAT_INVALID_SCH            = 10,
  PHY_STAT_INVALID_LEV            = 11,
  PHY_STAT_BUF_OVRUN              = 12,
  PHY_STAT_BUSY                   = 13,
  PHY_STAT_CMD_IN_PLACE           = 14,
  PHY_STAT_NOT_IN_SYNC            = 15,
  PHY_STAT_RX_BUF_OVERRUN         = 16
}PHY_status_t;

/* PHY callback events */
typedef enum
{
  PHY_EV_RX_START_DONE        = 0,
  PHY_EV_TX_PPDU_DONE         = 1,
  PHY_EV_RX_PPDU_DONE         = 2,
  PHY_EV_TX_SUSPEND_DONE      = 3,
  PHY_EV_RX_SUSPEND_DONE      = 4,
  PHY_EV_TX_RESUME_DONE       = 5,
  PHY_EV_RX_RESUME_DONE       = 6,
  PHY_EV_TX_TESTMODE_DONE     = 7

}PHY_ev_t;

/*****************************************************************************/
/* Data Structures                                                           */
/*****************************************************************************/
/* Tx PPDU done callback data structure */ 
typedef struct
{
  UINT32       ppduAddr;          // Tx PPDU address passed by caller

}PHY_cbTxPpdu_t;

/* Rx channel acquired callback data structure */ 
typedef struct
{
  SINT16       rssi;              // rssi in dBm
  UINT16       nSymbols;          // number of symbols for ppdu

}PHY_cbRxSync_t;

/* Rx PPDU callback data structure */ 
typedef struct
{
  UINT32       ppduInfoAddr;       // Rx PPDU info address (see PHY_rxPpdu_t in phy_rx.h)

}PHY_cbRxPpdu_t;

/* PHY callbacks data structure */
typedef struct
{
  PHY_status_t         status;     // callback status  
  union
  {
    PHY_cbTxPpdu_t     txPpdu;     // PHY Tx ppdu done callback
    PHY_cbRxSync_t     rxSync;     // PHY Rx channel acq callback
    PHY_cbRxPpdu_t     rxPpdu;     // PHY Rx ppdu callback

  }cbParms;

}PHY_cbData_t;

/* Callback functions */
typedef void (*PHY_cbFunc_t)(PHY_ev_t eventID, PHY_cbData_t *cbData_p);

/*****************************************************************************/
/* External variables                                                        */
/*****************************************************************************/


/*****************************************************************************/
/* Function Prototypes                                                       */
/*****************************************************************************/
const char *PHY_getLibVersion(void);

#endif // _PHY_H






