/*****************************************************************************
* FILE PURPOSE: Header file for PHY TX
*******************************************************************************
*
* FILE NAME: phy_tx.h
*
* DESCRIPTION:
*       Header file for PHY TX.
*
*  Copyright (c) 2009 Texas Instruments Inc.
*  All Rights Reserved This program is the confidential and proprietary
*  product of Texas Instruments Inc.  Any Unauthorized use, reproduction or
*  transfer of this program is strictly prohibited.
*
* HISTORY:
*
* 04/21/2009 fum    Written
* 11/30/2009 S.Yim  Updated Get/Set/CB API with data structure
*
******************************************************************************/
#ifndef _PHY_TX_H
#define _PHY_TX_H

#include <typedefs.h>
#include <phy.h>

/******************************************************************************
 * Definitions
 *****************************************************************************/
typedef enum
{
  PHY_TX_CLEAR_STAT         = 0,        // Clear PHY TX statistics
  PHY_TX_SETMODE            = 1,
  PHY_TX_SETTUNING          = 2,    

  NUM_PHY_TX_SETPARMS       = 3        

}PHY_tx_setType_t;

typedef enum
{
  PHY_TIMER                 = 0,        // Get current time from the 20-bit timer
  PHY_TXTIME                = 1,        // Get the next transmission time
  PHY_ZCT                   = 2,        // Get zero-crossing time (not supported yet)
  PHY_TX_GETMODE            = 3,
  PHY_TX_GETTUNING          = 4,
  
  NUM_PHY_TX_GETPARMS       = 5

}PHY_tx_getType_t;

typedef void (*PHY_cbTimerFunc_t) (UINT32);

/******************************************************************************
 * Data Structures
 *****************************************************************************/
/* TX PPDU parameter structure */
typedef struct
{
  UINT16              *ppduHdr_p;       // Pointer to MAC_H (PPDU header)
  UINT16              *ppduPld_p;       // Pointer to PPDU payload
  UINT16              length;           // Length of PPDU payload in bytes
  UINT16              level;            // TX level
  UINT16              mcs;              // TX modulation & coding scheme
  UINT32              txTime;           // TX time (in 10us)
}PHY_tx_ppdu_t;

typedef struct
{
  UINT16              phyStatsTxDropCount; // # of times TX PHY drops packets
  UINT16              phyTxQLen;           // TX queue length
  UINT32              phyTxProcDelay;      // time in 10us between txPpdu() called to it's put in the channel
  UINT32              phyTxPacketCount;    // # TX packets
}PHY_tx_stat_t;

/* Set data structure */
typedef union
{
  UINT16 roboMode;            // 0-PRIME; 1-ROBO
  SINT16 tuningLevel;         // -60(-6dB) to 30(3dB) in 0.1dB resolution
}PHY_txSetData_t;

typedef struct
{
  UINT32   lastZcaTime;    // last zero crossing time in 10us (20-bits)
  UINT32   lastZcbTime;    // last zero crossing time in 10us (20-bits)
}PHY_zcTime_t;

/* Get data structure */
typedef union
{
  UINT32   currTime;      // Current time in units of 10us (20-bits)
  UINT32   nextTxTime;    // Next transmission start time in 10us. (20-bits)
  //UINT32   lastZcTime;    // last zero crossing time in 10us (20-bits)
  PHY_zcTime_t zcTime;
  UINT16   roboMode;
  SINT16   tuningLevel;
}PHY_txGetData_t;

/******************************************************************************
 * Externals
 *****************************************************************************/


/******************************************************************************
 * Prototypes
 *****************************************************************************/
PHY_status_t PHY_txInit(void);
PHY_status_t PHY_txPpdu(PHY_tx_ppdu_t *ppdu, PHY_cbFunc_t cb_p);
PHY_status_t PHY_txSet(UINT16 setType, PHY_txSetData_t *setParms_p);
PHY_status_t PHY_txGet(UINT16 getType, PHY_txGetData_t *getParms_p);
PHY_status_t PHY_txGetStats(PHY_tx_stat_t *getParms_p);
PHY_status_t PHY_txSuspend(PHY_cbFunc_t cb_p);
PHY_status_t PHY_txResume(void);
PHY_status_t PHY_txTestmode(Uint16 mcs);
PHY_status_t PHY_txSmRun(void);
PHY_status_t PHY_txRegisterTimerCb(PHY_cbTimerFunc_t cb_p);
#endif

