/*******************************************************************************
*  FILE PURPOSE: Common header files for all modules
********************************************************************************
*
* FILE NAME: project.h
*
* DESCRIPTION:
*       This file includes PRIME PHY standard definitions
*
*  Copyright (c) 2009 Texas Instruments Inc. 
*  All Rights Reserved This program is the confidential and proprietary 
*  product of Texas Instruments Inc.  Any Unauthorized use, reproduction or 
*  transfer of this program is strictly prohibited.
*
* HISTORY:
*
* 02/16/2009 S.Yim             Written
*
* LIST OF FUNCTION PROTOTYPES: 
* 
******************************************************************************/
#ifndef _PRIME_PHY_H
#define _PRIME_PHY_H

//#include <project.h>
#include <typedefs.h>

//----------------------------------------------------------------------------
//                      Prime PHY Timer 
//----------------------------------------------------------------------------
/* Prime standard specifies a 20 bits counts in 10us, 0 to 2^20-1 */
#define PRIME_TIME_MAX_COUNT          0xFFFFF

#define PRIME_SYMBOL_TIME_IN_10US     224  

//----------------------------------------------------------------------------
//                      Prime Frame Structure
//----------------------------------------------------------------------------
/* Frame */
#define PRIME_MAX_SYMB_IN_FRM             276
#define PRIME_MAX_SYMB_IN_MSDU             63
#define PRIME_NUM_SYMB_IN_HDR               2
#define PRIME_ROBO_NUM_SYMB_IN_HDR         16  //For 1/8

/* Symbols */
#define PRIME_FFT_LEN                      512
#define PRIME_FFT_LEN_LOG2                   9
#define PRIME_CP_LEN                        48
#define PRIME_SYMB_LEN                     (PRIME_CP_LEN+PRIME_FFT_LEN)

#define PRIME_PRMB_LEN                      512

#define PRIME_NUM_TONES             97
#define PRIME_NUM_DATA_TONES        96
#define PRIME_NUM_HDR_TONES         84
#define PRIME_NUM_DATA_PILOTS        1
#define PRIME_NUM_HDR_PILOTS        13

#define PRIME_HDR_PILOTS_ITVL        8    // every 8th tone is pilot
#define PRIME_HDR_PILOTS_ITVL_SHIFT  3
//----------------------------------------------------------------------------
//                      Prime Bits Processing Structure
//----------------------------------------------------------------------------
#define PRIME_NCBPS_HDR              84   
#define PRIME_NCBPS_DBPSK            96
#define PRIME_NCBPS_DQPSK           192
#define PRIME_NCBPS_D8PSK           288

//----------------------------------------------------------------------------
//                      Prime Convolutional Encoding
//----------------------------------------------------------------------------
#define PRIME_CNV_K                   7
#define PRIME_CNV_NUM_TAIL_BITS       (PRIME_CNV_K - 1)
#define PRIME_CNV_NUM_STATES          (1 << (PRIME_CNV_K - 1))

#define PRIME_NUM_HDR_FLUSH_BITS            6
#define PRIME_NUM_DATA_FLUSH_BITS           8
#define PRIME_NUM_DATA_FLUSH_BYTES          (PRIME_NUM_DATA_FLUSH_BITS >> 3)

//----------------------------------------------------------------------------
//                      Prime Scrambler
//----------------------------------------------------------------------------


//----------------------------------------------------------------------------
//                      Prime Interleaver
//----------------------------------------------------------------------------
#define PRIME_INTLV_S_HDR             7
#define PRIME_INTLV_S_DBPSK           8
#define PRIME_INTLV_S_DQPSK          16
#define PRIME_INTLV_S_D8PSK          16

//----------------------------------------------------------------------------
//                      Prime Modulation
//----------------------------------------------------------------------------



//----------------------------------------------------------------------------
//                      Prime PPDU Header
//----------------------------------------------------------------------------

// Protocol
#define PRIME_PRCL_SHIFT       4
#define PRIME_PRCL_MASK        0xF

#define PRIME_HDR_PAD_MASK        0x3F

#define PRIME_HDR_LEN_SHIFT       6
#define PRIME_HDR_LEN_MASK        0x3F

#define PRIME_PRCL_DBPSK           0     // DBPSK w/o FEC
#define PRIME_PRCL_DQPSK           1     // DQPSK w/o FEC 
#define PRIME_PRCL_D8PSK           2     // D8PSK w/o FEC
#define PRIME_PRCL_RSVD            3     // Reserved

#define PRIME_PRCL_DBPSK_F         4     // DBPSK w/ FEC  
#define PRIME_PRCL_DQPSK_F         5     // DQPSK w/ FEC  
#define PRIME_PRCL_D8PSK_F         6     // D8PSK w/ FEC  

#define PRIME_PRCL_ROBO_4          8     // DBPSK w/ FEC + 1/4
#define PRIME_PRCL_ROBO_8         12     // DBPSK w/ FEC + 1/8

#define PRIME_PRCL_MOD_MASK      0x03
#define PRIME_PRCL_FEC_MASK      0x04
#define PRIME_PRCL_FEC_ROBO_MASK 0x0C    // DBPSK w/ FEC+Repetition

#define PRIME_PRCL_FEC_SHIFT     2

// MAC_H
#define PRIME_MAC_H_BYTES        7

// flush
#define PRIME_PRCL_PLD_FLUSHBITS   8     // Number of flushing bits in PPDU payload

#define PRIME_PHY_HDR_LEN        11
#define PHY_HDR_MAC_HDR_LEN      7

#endif //_PRIME_PHY



