/******************************************************************************
* FILE PURPOSE: F28335 Device initialization
*******************************************************************************
*
* FILE NAME: f28335_init.c
*
* DESCRIPTION: This file contains functions for block operations
*       
*
* HISTORY:
* 03/19/2009          S.Yim   From example file
* 04/15/2009          S.Yim   Added DMA initialize
*
* LIST OF FUNCTIONS:
*
*
* Copyright (c) 2009 Texas Instruments Inc.  All rights reserved.
******************************************************************************/
//#include <PeripheralHeaderIncludes.h>	// Include all Peripheral Headers
#include "DSP28x_Project.h"

/******************************************************************************
* FUNCTION NAME: F28335_init
*
* DESCRIPTION:   This function initializes the F28335 device
*
* Input Parameters:    
* Output Parameters:  
*
******************************************************************************/
void F28335_init(void)
{
  DINT;			// Global Disable all Interrupts
  IER = 0x0000;	        // Disable CPU interrupts
  IFR = 0x0000;	        // Clear all CPU interrupt flags

// Step 1. Initialize System Control:
// PLL, WatchDog, enable Peripheral Clocks
// This example function is found in the DSP2833x_SysCtrl.c file.
  InitSysCtrl();

#ifndef F2806X
  /* Map ePWM registers to PF3 */
  EALLOW;
  SysCtrlRegs.MAPCNF.bit.MAPEPWM = 1;
  EDIS;
#endif
 
// Step 1a. Reset peripherals
  DMAInitialize();

//  InitCpuTimers();
  CpuTimer0.RegsAddr = &CpuTimer0Regs;
  CpuTimer1.RegsAddr = &CpuTimer1Regs;


// Specific clock setting for this example:
   //EALLOW;
   //SysCtrlRegs.HISPCP.all = ADC_MODCLK;	// HSPCLK = SYSCLKOUT/ADC_MODCLK
   //EDIS;

// Step 2. Initialize GPIO:
// This example function is found in the DSP2833x_Gpio.c file and
// illustrates how to set the GPIO to it's default state.
// InitGpio();  // Skipped for this example

// Step 3. Clear all interrupts and initialize PIE vector table:
// Disable CPU interrupts
   DINT;

// Initialize the PIE control registers to their default state.
// The default state is all PIE interrupts disabled and flags
// are cleared.
// This function is found in the DSP2833x_PieCtrl.c file.
   InitPieCtrl();

// Disable CPU interrupts and clear all CPU interrupt flags:
   IER = 0x0000;
   IFR = 0x0000;

// Initialize the PIE vector table with pointers to the shell Interrupt
// Service Routines (ISR).
// This will populate the entire table, even if the interrupt
// is not used in this example.  This is useful for debug purposes.
// The shell ISR routines are found in DSP2833x_DefaultIsr.c.
// This function is found in DSP2833x_PieVect.c.
   InitPieVectTable();

}
