#include "led.h"
#include "timer.h"
#include "gpio.h"

  static GpioHandle wdt_handle;
  static GpioValue   wdt_value;

void main(void) {
  Timer_Initialize();

  wdt_handle = gpio_initialize(GPIO_BANK6, GPIO_PIN7, GPIO_OUTPUT);
  wdt_value = GPIO_OUTPUT_LOW;

  while(1)
  {
    if(Timer_IsRunning(TIMER_0))
    {
    }
    else
    { //Once per cycle actions
      //Make sure all flags are cleared to allow a restart
      Timer_Stop(TIMER_0);
      //Restart the timer (min timeout ~1s)
      Timer_Start(TIMER_0,WDT_MIN_TIMEOUT_CYCLES/2);

      //Cycle LEDs to show that the program is running
      Led_Cycle(LED2);
      Led_Cycle(LED1);

      //Toggle the GPIO output faster than the time out period
      if(wdt_value == GPIO_OUTPUT_HIGH)
      {
          wdt_value = GPIO_OUTPUT_LOW;
      }
      else
      {
          wdt_value = GPIO_OUTPUT_HIGH;
      }
      gpio_write(wdt_handle, wdt_value);
    }
  }
}
