//===========================================================================
//      ####     ###      ###    #####    ######   #######    ####   #     #
//     #        #   #    #   #   #    #   #     #     #      #    #  #     #
//    #        #     #  #     #  #     #  #     #     #     #        #     #
//    #  ###   #     #  #     #  #     #  ######      #     #        #######
//    #     #  #     #  #     #  #     #  #   #       #     #        #     #
//     #    #   #   #    #   #   #    #   #    #      #      #    #  #     #
//      ####     ###      ###    #####    #     #  #######    ####   #     #
//
//           Copyright 2012 Simmonds Precision Products, Inc.
//
//    =======================================================================
//                        DOMESTIC ITAR CONTROL STATEMENT
//    -----------------------------------------------------------------------
//    THESE ARTICLES OR TECHNICAL DATA ARE CONTROLLED BY THE INTERNATIONAL
//    TRAFFIC IN ARMS REGULATIONS (ITAR). THEY ARE SUBJECT TO THE EXPORT
//    CONTROL LAWS OF THE US GOVERNMENT.  THEY ARE NOT TO BE PLACED IN THE
//    PUBLIC DOMAIN, EXPORTED FROM THE US, OR GIVEN TO ANY FOREIGN PERSON IN
//    THE US, WITHOUT THE PRIOR, SPECIFIC WRITTEN AUTHORIZATION OF GOODRICH
//    AND THE US DEPARTMENT OF STATE. Export Classification: M, USML VIII(i).
//    =======================================================================
//
//    Project    : V-22 MAO
//    CSCI       : CPIO
//    CSC        : GPIO
//    Author     : Jason Corrigan
//===========================================================================
//    Purpose:
//         Public interface to GPIO.
//===========================================================================

#ifndef CPIO_GPIO
#define CPIO_GPIO

#include "my_types.h"

typedef enum 
{
    GPIO_BANK0 = 0,
    GPIO_BANK1 = 1,
    GPIO_BANK2 = 2,
    GPIO_BANK3 = 3,
    GPIO_BANK4 = 4,
    GPIO_BANK5 = 5,
    GPIO_BANK6 = 6,
    GPIO_BANK7 = 7,
    GPIO_BANK8 = 8
} GpioBank;

typedef enum
{
    GPIO_PIN0  =  0,
    GPIO_PIN1  =  1,
    GPIO_PIN2  =  2,
    GPIO_PIN3  =  3,
    GPIO_PIN4  =  4,
    GPIO_PIN5  =  5,
    GPIO_PIN6  =  6,
    GPIO_PIN7  =  7,
    GPIO_PIN8  =  8,
    GPIO_PIN9  =  9,
    GPIO_PIN10 = 10,
    GPIO_PIN11 = 11,
    GPIO_PIN12 = 12,
    GPIO_PIN13 = 13,
    GPIO_PIN14 = 14,
    GPIO_PIN15 = 15
} GpioPin;
            
typedef enum
{
    GPIO_INPUT               = 1,
    GPIO_OUTPUT              = 2
} GpioDirection;

typedef enum
{
    GPIO_OUTPUT_LOW  = 0,
    GPIO_OUTPUT_HIGH = 1
} GpioValue;    

typedef enum
{    
    GPIO_ERROR     = 0,
    GPIO_NO_ERROR  = 1
} GpioErrorCode;

typedef uint8 GpioHandle;

#define GPIO_ERROR_INITIALIZING (0)

//===========================================================================
//Public Function Declarations
//===========================================================================
GpioHandle      gpio_initialize   (GpioBank bank, GpioPin pin, GpioDirection direction);
GpioErrorCode   gpio_write        (const GpioHandle gpio_write_handle, GpioValue value);
GpioErrorCode   gpio_read         (const GpioHandle gpio_read_handle, GpioValue *value);
//===========================================================================

#endif
