//===========================================================================
//    Purpose:
//         Private interface to GPIO.
//===========================================================================

#ifndef GPIO_PRIVATE
#define GPIO_PRIVATE

#include "my_types.h"

typedef struct
{
    volatile uint32 DIR;
    volatile uint32 OUT_DATA;
    volatile uint32 SET_DATA;
    volatile uint32 CLR_DATA;
    volatile uint32 IN_DATA;
    volatile uint32 SET_RIS_TRIG;
    volatile uint32 CLR_RIS_TRIG;
    volatile uint32 SET_FAL_TRIG;
    volatile uint32 CLR_FAL_TRIG;
    volatile uint32 IRQ_STAT;
} GpioRegisters;

typedef struct 
{
    uint32 REVID;
    uint32 pad1;
    uint32 BINTEN;
    uint32 pad2;
    GpioRegisters block_0_1;
    GpioRegisters block_2_3;
    GpioRegisters block_4_5;
    GpioRegisters block_6_7;
    GpioRegisters block_8;
} GpioDevice;

typedef struct
{
    GpioRegisters    *gpio_registers;
    uint32           mask;
} GpioObject;

#endif
