//===========================================================================
//    Purpose: Public interface for the OMAP timer interface
//  Oscillator is running at ~16MHz
//===========================================================================
#ifndef HEADER_TIMER_
#define HEADER_TIMER_

#include "my_types.h"

/*16MHz * desired time*/
#define WDT_MIN_TIMEOUT_CYCLES        (0x00F42400u) /*~1.0s (before 1.05s)*/

typedef enum{
  TIMER_0,
  TIMER_1
} TimerEnum;

//============================
//Function Prototypes
//============================
void Timer_Initialize(void);
void Timer_Start(TimerEnum timer, unsigned long long period_cycles);
unsigned long long Timer_GetTime(TimerEnum timer);
void Timer_Stop(TimerEnum timer);
bool Timer_IsRunning(TimerEnum timer);

#endif //HEADER_TIMER_
