#include "drawlcd.h"
#include "string.h"
/*------------------------------------------------------------------*/
/*		video display EDMA reload parameter(linking) 				*/
/*------------------------------------------------------------------*/
void Set_DisEDMAparm(u32 DispBufAddr)
{	
	_XU32(EVENT0_PARAMS+4*0) = 0x25000002;				//opt
	_XU32(EVENT0_PARAMS+4*1) = DispBufAddr;// SDRAM_rgbA;				//src
	_XU32(EVENT0_PARAMS+4*2) = (VD_Y_EDMA_FRMCNT-1)<<16|(VD_Y_EDMA_ELECNT); //֡ݵԪ	
    _XU32(EVENT0_PARAMS+4*3) = VB1_YDSTA;              //Ydst
	_XU32(EVENT0_PARAMS+4*4) = (VD_Y_EDMA_ELECNT*4)<<16;//
	_XU32(EVENT0_PARAMS+4*5) = ((VD_Y_EDMA_ELECNT)<<16)|(EVENT0_PARAMS-EVENT0_PARAMS);
}


/**************************************************************
VP1ʾ
***************************************************************/
void Config_VP1_Display(void)
{
    _XU32(VP1_PCR) |= ((1<<PEREN)|(0<<SOFT)|(1<<FREE)); //Video port is enabled.

    _XU32(VP1_CTL) |= (1<<VPRST);// must in reset state for config

    while(_XU32(VP1_CTL) & (1<<VPRST));// poll to make sure every bit is cleared

    _XU32(VP1_CTL) |= ((1<<DISP)|(1<<VCT2P)|(1<<VCT1P)|(1<<VCT0P));// single channel display

    _XU32(VP1_CTL) |= (1<<VPHLT);

    _XU32(VD1_FRMSZ) = ((VD_FRM_HEIGHT<<FRMHEIGHT) + (VD_FRM_WIDTH<<FRMWIDTH));

    _XU32(VD1_HBLNK) = ((VD_HBLNK_START<<HBLNKSTART) + (VD_HBLNK_STOP<<HBLNKSTOP));

    _XU32(VD1_VBLKS1) = ((VD_VBLNK_YSTART1<<VBLNKYSTART) + (VD_VBLNK_XSTART1<<VBLNKXSTART));
    _XU32(VD1_VBLKE1) = ((VD_VBLNK_YSTOP1<<VBLNKYSTOP) + (VD_VBLNK_XSTOP1<<VBLNKXSTOP));

    _XU32(VD1_IMGSZ1) = ((VD_IMG_VSIZE1<<IMGVSIZE) + (VD_IMG_HSIZE1<<IMGHSIZE));
    _XU32(VD1_IMGOFF2) = (VD_IMG_VOFF2<<IMGVOFF) + (VD_IMG_HOFF2<<IMGHOFF);

    _XU32(VD1_IMGOFF1) = (VD_IMG_VOFF1<<IMGVOFF) + (VD_IMG_HOFF1<<IMGHOFF);
    _XU32(VD1_IMGSZ2) = ((VD_IMG_VSIZE2<<IMGVSIZE) + (VD_IMG_HSIZE2<<IMGHSIZE));

    _XU32(VD1_VBLKS2) = ((VD_VBLNK_YSTART2<<VBLNKYSTART) + (VD_VBLNK_XSTART2<<VBLNKXSTART));
    _XU32(VD1_VBLKE2) = ((VD_VBLNK_YSTOP2<<VBLNKYSTOP) + (VD_VBLNK_XSTOP2<<VBLNKXSTOP));

    _XU32(VD1_VSYNS1) = ((VD_VSYNC_XSTART1<<VSYNCXSTART) + (VD_VSYNC_YSTART1<<VSYNCYSTART));
    _XU32(VD1_VSYNE1) = ((VD_VSYNC_XSTOP1<<VSYNCXSTOP) + (VD_VSYNC_YSTOP1<<VSYNCYSTOP));

    _XU32(VD1_VSYNS2) = ((VD_VSYNC_XSTART2<<VSYNCXSTART) + (VD_VSYNC_YSTART2<<VSYNCYSTART));
    _XU32(VD1_VSYNE2) = ((VD_VSYNC_XSTOP2<<VSYNCXSTOP) + (VD_VSYNC_YSTOP2<<VSYNCYSTOP));

    _XU32(VD1_HSYNC) = ((VD_HSYNC_STOP<<HSYNCSTOP) + (VD_HSYNC_START<<HSYNCSTART));

    _XU32(VD1_FLDT2) = ((VD_yStartFld2<<FLDYSTART) + (VD_xStartFld2<<FLDXSTART));

    _XU32(VD1_DISPEVT) = ((VD_DISPEVT2<<DISPEVT2) + (VD_DISPEVT1<<DISPEVT1));

    _XU32(VP1_IE) = ((1<<VIE) + (1<<DUND) + (1<<DCMP)); // interrupt enable

    _XU32(VD1_THRLD) = ((VD_incPix<<INCPIX) + (VD_VDTHRLD1<<VDTHRLD1));

    _XU32(VD1_FLDT1) = ((VD_yStartFld1<<FLDYSTART) + (VD_xStartFld1<<FLDXSTART));

    //DMODE=111, 20-Bit Raw Display
    _XU32(VD1_CTL) = ((1<<BLKDIS)|(0<<PVPSYN)|(0<<VCTL2S)|(0<<VCTL1S)|(0<<VCTL0S)|(0<<RGBX)|
                     (0<<RSYNC)|(1<<CON)|(1<<FRAME)|
                     (0<<DF2)|(1<<DF1)|(6<<DMODE));

        memcpy( (u8 *)EVENT56_PARAMS, (u8 *)EVENT0_PARAMS, EVENT_PARAMS_LEN );
        _XU32(EERH) |= (1<<(56-32));

	//Enable video Display 
  	_XU32(VD1_CTL) |=  (1<<VDEN); 
	_XU32(VD1_CTL) &= (~(1<<BLKDIS));  	
}

void InitDisplayPort(){
    memset(DispBuf, 0x00, sizeof(DispBuf));
    Set_DisEDMAparm((u32)DispBuf);
    Config_VP1_Display();
}
