#include "global.h"
#include <c6x.h>
#include "REGS.h"


/*******************************************************************************
* FILENAME
*   dm642.h(derived from c64xx.h)
*
* DESCRIPTION
*   DSK Header File
*
*******************************************************************************/

/* Register definitions for dm642 dsp chip*/

/////////////////////////////////////////////////////  		  
/* Define EMIF Registers  */
#define EMIF_GCR 			0x1800000	/* Address of EMIF global control		*/

#define EMIF_CE0			0x1800008	/* Address of EMIF CE0 control: 4M * 64bit SDRAM			*/
#define EMIF_CE0SEC    		0x1800048   /* Address of EMIF CE0 space secondary control*/

#define EMIF_CE1			0x1800004	/* Address of EMIF CE1 control: 1M * 8 bit FLASH for boot */
#define EMIF_CE1SEC    		0x1800044

#define EMIF_CE2			0x1800010	/* Address of EMIF CE2 control: Unused			*/
#define EMIF_CE2SEC    		0x1800050  

#define EMIF_CE3			0x1800014	/* Address of EMIF CE3 control: FPGA/16bit SyncRAM */
#define EMIF_CE3SEC    		0x1800054 


#define EMIF_SDCTRL			0x1800018	/* Address of EMIF SDRAM control		*/
#define EMIF_SDTIM			0x180001c	/* Address of EMIF SDRM refresh control*/
#define EMIF_SDEXT			0x1800020	/* Address of EMIF SDRAM extension		*/

/////////////////////////////////////////////////
#define EMIF_CE0_ADDR	    0x80000000  
#define EMIF_CE1_ADDR	    0x90000000  
#define EMIF_CE2_ADDR	    0xA0000000
#define EMIF_CE3_ADDR	    0xB0000000
/////////////////////////////////////////////////

/* EMIF Global Control Register (GBLCTL) */
#define CLK6EN                   3
#define CLK4EN                   4
#define EK1EN                    5
#define EK1HZ                    6
#define NOHOLD                   7
#define HOLDA                    8 
#define HOLD                     9
#define ARDY                    10
#define BUSREQ                  11
#define BRMODE                  13
#define EK2EN                   16
#define EK2HZ                   17
#define EK2RATE                 18

/*EMIF CE Space Control Register (CExCTL)*/
//ĳɴĺֹ꣬ȡֵΧҽWRHLDֿúһ
#define WRSETUP(i)		((i & 0xF)<<28)				/* Setup width  */
#define WRSTRB(i)		((i &0x3F)<<22)				/* The width of write strobe (/AWE) in clock cycles*/
#define WRHLD(i)		((i & 0x3)<<20|(i & 0x4)<<1)/* Hold width   */
#define RDSETUP(i)		((i & 0xF)<<16)				/* Setup width  */
#define TA(i)			((i & 0x3)<<14)				/* Turn-around time */
#define RDSTRB(i)		((i &0x3F)<<8)				/* The width of read strobe (/ARE) in clock cycles */
#define MTYPE(i)		((i & 0xF)<<4)				/* Memory type of the corresponding CE spaces      */
#define RDHLD(i)		((i & 0x7)<<0)				/* Hold width   */

#define MTYPE_ASYNC8    0x0 //8-bit-wide asynchronous interface.
#define MTYPE_ASYNC16   0x1 //16-bit-wide asynchronous interface.
#define MTYPE_ASYNC32   0x2 //32-bit-wide asynchronous interface.
#define MTYPE_SDRAM32   0x3 //32-bit-wide SDRAM.
#define MTYPE_SYNC32    0x4 //32-bit-wide programmable synchronous memory.
#define MTYPE_SDRAM8    0x8 //8-bit-wide SDRAM.
#define MTYPE_SDRAM16   0x9 //16-bit-wide SDRAM.
#define MTYPE_SYNC8     0xA //8-bit-wide programmable synchronous memory.
#define MTYPE_SYNC16    0xB //16-bit-wide programmable synchronous memory.
#define MTYPE_ASYNC64   0xC //64-bit-wide asynchronous interface.
#define MTYPE_SDRAM64   0xD //64-bit-wide SDRAM.
#define MTYPE_SYNC64    0xE //64-bit-wide programmable synchronous memory.

/* CE Space Secondary Control Register (CExSEC) for TMS320C64x Only */
#define SYNCRL                   0       /* Synchronous interface data read latency  */
#define SYNCWL                   2       /* Synchronous interface data write latency */
#define CEEXT                    4       /* CE extension register                    */
#define RENEN                    5       /* Read Enable Enable                       */
#define SNCCLK                   6       /* Synchronization Clock                    */ 

/* SDRAM Control Register (SDCTL)        */
#define SLFRFR                   0       /* Self refresh mode */
#define TRC                      12      /* tRC*/
#define TRP                      16      /* tRP*/
#define TRCD                     20      /* tRCD*/
#define INIT                     24      /* Initialization bit*/
#define RFEN                     25      /* Refresh enable */
#define SDCSZ                    26      /* Column size */
#define SDRSZ                    28      /* Row size */
#define SDBSZ                    26      /* Bank size */

/* SDRAM Timing Register (SDTIM)         */
#define PERIOD                   0       /* Refresh peroid */
#define CNTR                     12      /* Current value */
#define XRFR                     24      /* Extra refresh */

/* SDRAM Extension Register (SDEXT)      */
#define TCL                      0       /* CAS */ 
#define TRAS                     1       /* RAS */ 
#define TRRD                     4       /* tRRD */ 
#define TWR                      5       /* tWR */
#define THZP                     7       /* tHZP or tROH */ 
#define RD2RD                    9       /* Read to Read */
#define RD2DEAC                  10      /*  */
#define RD2WR                    12      /*  */
#define RD2WDQM                  15      /*  */
#define WR2WR                    17      /*  */
#define WR2DEAC                  18      /*  */
#define WR2RD                    20      /*  */

/////////////////////////////////////////////////////  		  
/* Define HPI Registers */


/////////////////////////////////////////////////////  		  
/* Define McBSP0 Registers */
/* Serve as VideoPort0 */
#define McBSP0_DRR      0x18c0000   /* Address of data receive reg.         */
#define McBSP0_DXR      0x18c0004   /* Address of data transmit reg.        */
#define McBSP0_SPCR     0x18c0008   /* Address of serial port contl. reg.   */
#define McBSP0_RCR      0x18c000C   /* Address of receive control reg.      */
#define McBSP0_XCR      0x18c0010   /* Address of transmit control reg.     */
#define McBSP0_SRGR     0x18c0014   /* Address of sample rate generator     */
#define McBSP0_MCR      0x18c0018   /* Address of multichannel reg.         */
#define McBSP0_RCER     0x18c001C   /* Address of receive channel enable.   */
#define McBSP0_XCER     0x18c0020   /* Address of transmit channel enable.  */
#define McBSP0_PCR      0x18c0024   /* Address of pin control reg.          */

/* Define McBSP1 Registers */
#define McBSP1_DRR      0x1900000   /* Address of data receive reg.         */
#define McBSP1_DXR      0x1900004   /* Address of data transmit reg.        */
#define McBSP1_SPCR     0x1900008   /* Address of serial port contl. reg.   */
#define McBSP1_RCR      0x190000C   /* Address of receive control reg.      */
#define McBSP1_XCR      0x1900010   /* Address of transmit control reg.     */
#define McBSP1_SRGR     0x1900014   /* Address of sample rate generator     */
#define McBSP1_MCR      0x1900018   /* Address of multichannel reg.         */
#define McBSP1_RCER     0x190001C   /* Address of receive channel enable.   */
#define McBSP1_XCER     0x1900020   /* Address of transmit channel enable.  */
#define McBSP1_PCR      0x1900024   /* Address of pin control reg.          */

/////////////////////////////////////////////////////  		  
/* Define Timer0 Registers */
#define TIMER0_CTRL     0x1940000	/* Address of timer0 control reg.       */
#define TIMER0_PRD      0x1940004	/* Address of timer0 period reg.        */
#define TIMER0_COUNT    0x1940008	/* Address of timer0 counter reg.       */

/* Define Timer1 Registers */
#define TIMER1_CTRL     0x1980000	/* Address of timer1 control reg.       */
#define TIMER1_PRD      0x1980004	/* Address of timer1 period reg.        */
#define TIMER1_COUNT    0x1980008	/* Address of timer1 counter reg.       */

/* Define Timer2 Registers */
#define TIMER2_CTRL     0x1AC0000	/* Address of timer2 control reg.       */
#define TIMER2_PRD      0x1AC0004	/* Address of timer2 period reg.        */
#define TIMER2_COUNT    0x1AC0008	/* Address of timer2 counter reg.       */

/////////////////////////////////////////////////////  	
/*Interrupt Selector Registers*/
#define MUXH 			0x019C0000 	//Interrupt multiplexer high interrupts 10C15 (INT10CINT15)
#define MUXL 			0x019C0004 	//Interrupt multiplexer low
	  
/* Define Interrupt Registers */
#define IMH             0x19c0000   /* Address of Interrupt Multiplexer High*/
#define IML             0x19c0004   /* Address of Interrupt Multiplexer Low */
 
/////////////////////////////////////////////////////  		  
/* Define EDMA Registers */
#define PQSR			0x01A0FFE0	/* Address of priority queue status     */
#define CIPR			0x01A0FFE4	/* Address of channel interrupt pending */
#define CIER			0x01A0FFE8	/* Address of channel interrupt enable  */
#define CCER			0x01A0FFEC	/* Address of channel chain enable      */
#define ER				0x01A0FFF0	/* Address of event register            */
#define EER				0x01A0FFF4	/* Address of event enable register     */
#define ECR				0x01A0FFF8	/* Address of event clear register      */
#define ESR				0x01A0FFFC	/* Address of event set register        */
#define ERH				0x01A0FFB0
#define EERH			0x01A0FFB4	/*Event enable high register*/
#define ECRH			0x01A0FFB8	/*Event clear high register*/
#define ESRH			0x01A0FFBC  //Event set high register
#define CIPRH			0x01A0FFA4 	//Channel interrupt pending high register
#define EERL			0x01A0FFF4	/*Event enable high register*/
#define ECRL			0x01A0FFF8	/*Event clear high register*/
#define ESRL			0x01A0FFFC  //Event set high register

#define	rEPRH  	 	    _XU32(0x01A0FF9C) //	 Event polarity high register                  
#define	rCIPRH  	    _XU32(0x01A0FFA4) //	 Channel interrupt pending high register       
#define	rCIERH  	    _XU32(0x01A0FFA8) //	 Channel interrupt enable high register        
#define	rCCERH  	    _XU32(0x01A0FFAC) //	 Channel chain enable high register            
#define	rERH  	        _XU32(0x01A0FFB0) //	 Event high register                             
#define	rEERH  	        _XU32(0x01A0FFB4) //	 Event enable high register                      
#define	rECRH  	        _XU32(0x01A0FFB8) //	 Event clear high register                       
#define	rESRH  	        _XU32(0x01A0FFBC) //	 Event set high register                         
#define	rPQAR0  	    _XU32(0x01A0FFC0) //	 Priority queue allocation register 0          
#define	rPQAR1  	    _XU32(0x01A0FFC4) //	 Priority queue allocation register 1          
#define	rPQAR2  	    _XU32(0x01A0FFC8) //	 Priority queue allocation register 2          
#define	rPQAR3  	    _XU32(0x01A0FFCC) //	 Priority queue allocation register 3          
#define	rEPRL  	        _XU32(0x01A0FFDC) //	 Event polarity low register                     
#define	rPQSR  	        _XU32(0x01A0FFE0) //	 Priority queue status register                  
#define	rCIPRL  	    _XU32(0x01A0FFE4) //	 Channel interrupt pending low register        
#define	rCIERL  	    _XU32(0x01A0FFE8) //	 Channel interrupt enable low register         
#define	rCCERL  	    _XU32(0x01A0FFEC) //	 Channel chain enable low register             
#define	rERL  	        _XU32(0x01A0FFF0) //	 Event low register                              
#define	rEERL  	        _XU32(0x01A0FFF4) //	 Event enable low register                       
#define	rECRL  	        _XU32(0x01A0FFF8) //	 Event clear low register                        
#define	rESRL  	        _XU32(0x01A0FFFC) //	 Event set low register     

/* Define EDMA Transfer Parameter Entry Fields */
#define OPT				0*4			/* Options Parameter                    */
#define SRC				1*4			/* SRC Address Parameter                */
#define CNT				2*4			/* Count Parameter                      */
#define DST				3*4			/* DST Address Parameter                */
#define IDX				4*4			/* IDX Parameter                        */
#define LNK				5*4			/* LNK Parameter                        */
						
/* Define EDMA Parameter RAM Addresses(SPRS200G, p96) */ 
#define EVENT_PARAMS_LEN 	0x18

#define PARAM_ADDR(x) 		    (0x01A00000+(x)*EVENT_PARAMS_LEN)
#define rOPT(x)				_XU32(PARAM_ADDR(x)+0*4)			/* Options Parameter                    */
#define rSRC(x)				_XU32(PARAM_ADDR(x)+1*4)			/* SRC Address Parameter                */
#define rCNT(x)				_XU32(PARAM_ADDR(x)+2*4)			/* Count Parameter                      */
#define rDST(x)				_XU32(PARAM_ADDR(x)+3*4)			/* DST Address Parameter                */
#define rIDX(x)				_XU32(PARAM_ADDR(x)+4*4)			/* IDX Parameter                        */
#define rLNK(x)				_XU32(PARAM_ADDR(x)+5*4)			/* LNK Parameter                        */

#define EVENT0_PARAMS 		0x01A00000
#define EVENT1_PARAMS 		(EVENT0_PARAMS + 1*EVENT_PARAMS_LEN)
#define EVENT2_PARAMS 		(EVENT0_PARAMS + 2*EVENT_PARAMS_LEN)
#define EVENT3_PARAMS 		(EVENT0_PARAMS + 3*EVENT_PARAMS_LEN)
#define EVENT4_PARAMS 		(EVENT0_PARAMS + 4*EVENT_PARAMS_LEN)
#define EVENT5_PARAMS 		(EVENT0_PARAMS + 5*EVENT_PARAMS_LEN)
#define EVENT6_PARAMS 		(EVENT0_PARAMS + 6*EVENT_PARAMS_LEN)
#define EVENT7_PARAMS 		(EVENT0_PARAMS + 7*EVENT_PARAMS_LEN)
#define EVENT8_PARAMS 		(EVENT0_PARAMS + 8*EVENT_PARAMS_LEN)
#define EVENT9_PARAMS 		(EVENT0_PARAMS + 9*EVENT_PARAMS_LEN)
#define EVENT10_PARAMS 		(EVENT0_PARAMS + 10*EVENT_PARAMS_LEN)
#define EVENT11_PARAMS 		(EVENT0_PARAMS + 11*EVENT_PARAMS_LEN)
#define EVENT12_PARAMS 		(EVENT0_PARAMS + 12*EVENT_PARAMS_LEN)
#define EVENT13_PARAMS 		(EVENT0_PARAMS + 13*EVENT_PARAMS_LEN)
#define EVENT14_PARAMS 		(EVENT0_PARAMS + 14*EVENT_PARAMS_LEN)
#define EVENT15_PARAMS 		(EVENT0_PARAMS + 15*EVENT_PARAMS_LEN)
#define EVENT16_PARAMS 		(EVENT0_PARAMS + 16*EVENT_PARAMS_LEN)	//VP0 Channel A Y event DMA request
#define EVENT17_PARAMS 		(EVENT0_PARAMS + 17*EVENT_PARAMS_LEN)		//VP0 Channel A Cb event DMA request
#define EVENT18_PARAMS 		(EVENT0_PARAMS + 18*EVENT_PARAMS_LEN)		//VP0 Channel A Cr event DMA request
#define EVENT19_PARAMS 		(EVENT0_PARAMS + 19*EVENT_PARAMS_LEN)		//timer 2
#define EVENT24_PARAMS 		(EVENT0_PARAMS + 24*EVENT_PARAMS_LEN)		//VP0 Channel B Y event DMA request
#define EVENT25_PARAMS 		(EVENT0_PARAMS + 25*EVENT_PARAMS_LEN)		//VP0 Channel B Cb event DMA request
#define EVENT26_PARAMS 		(EVENT0_PARAMS + 26*EVENT_PARAMS_LEN)		//VP0 Channel B Cr event DMA request

#define EVENT38_PARAMS 		(EVENT0_PARAMS + 38*EVENT_PARAMS_LEN)		//VP1 Channel B Y event DMA request
#define EVENT39_PARAMS 		(EVENT0_PARAMS + 39*EVENT_PARAMS_LEN)		//VP1 Channel B Cb event DMA request
#define EVENT40_PARAMS 		(EVENT0_PARAMS + 40*EVENT_PARAMS_LEN)		//VP1 Channel B Cr event DMA request

#define EVENT56_PARAMS 		(EVENT0_PARAMS + 56*EVENT_PARAMS_LEN)		//VP1 Channel A Y event DMA request
#define EVENT57_PARAMS 		(EVENT0_PARAMS + 57*EVENT_PARAMS_LEN)		//VP1 Channel A Cb event DMA request
#define EVENT58_PARAMS 		(EVENT0_PARAMS + 58*EVENT_PARAMS_LEN)		//VP1 Channel A Cr event DMA request

#define EVENT59_PARAMS 		(EVENT0_PARAMS + 59*EVENT_PARAMS_LEN)		//VP2 Channel A Y event DMA request
#define EVENT60_PARAMS 		(EVENT0_PARAMS + 60*EVENT_PARAMS_LEN)		//VP2 Channel A Cb event DMA request
#define EVENT61_PARAMS 		(EVENT0_PARAMS + 61*EVENT_PARAMS_LEN)		//VP2 Channel A Cr event DMA request

//ParaRAM Bit reference
#define OPT_PRI(x)          ((x)<<29)
#define OPT_ESIZE(x)        ((x)<<27) 
#define OPT_2DS(x)          ((x)<<26) 
#define OPT_SUM(x)          ((x)<<24) 
#define OPT_2DD(x)          ((x)<<23) 
#define OPT_DUM(x)          ((x)<<21) 
#define OPT_TCINT(x)        ((x)<<20) 
#define OPT_TCC(x)          ((x)<<16) 
#define OPT_TCCM(x)         ((x)<<13) 
#define OPT_ATCINT(x)       ((x)<<12) 
#define OPT_ATCC(x)         ((x)<<5) 
#define OPT_PDTS(x)         ((x)<<3) 
#define OPT_PDTD(x)         ((x)<<2) 
#define OPT_LINK(x)         ((x)<<1) 
#define OPT_FS(x)           ((x)<<0) 

/////////////////////////////////////////////////////  		  
/* Define GPIO Registers */
#define GPEN			0x1B00000
#define GPDIR			0x1B00004
#define GPVAL			0x1B00008
#define GPDH			0x1B00010
#define GPHM			0x1B00014
#define GPDL			0x1B00018
#define GPLM			0x1B0001C
#define GPGC			0x1B00020
#define GPPOL			0x1B00024

/////////////////////////////////////////////////////  		  
/* Define Device Configuration Register */
#define PERCFG_CTRL		0x1B3F000	/* Select the peripheral functions */
#define PCFGLOCK        0x1B3F018   /* Unlock */

#define MCASP0EN        0
#define MCBSP0EN        1
#define MCBSP1EN        2
#define I2C0EN          3
#define VP0EN           4
#define VP1EN           5
#define VP2EN           6

/////////////////////////////////////////////////////  		  
/* I2C Register */
#define I2COAR0			0x1B40000	//own address
#define I2CIER0			0x1B40004	//int enable
#define I2CSTR0			0x1B40008	//status
#define I2CCLKL0		0x1B4000C	//clk divider
#define I2CCLKH0		0x1B40010	//clk divider
#define I2CCNT0			0x1B40014	//data cnt
#define I2CDRR0			0x1B40018	//data recv
#define I2CSAR0			0x1B4001C	//slave address
#define I2CDXR0			0x1B40020	//data trans
#define I2CMDR0			0x1B40024	//mode
#define I2CISRC			0x1B40028	//int source
#define I2CPSC0			0x1B40030	//prescaler

/////////////////////////////////////////////////////  
#define VP0BASEADDR		0x01C40000
#define VP0SBUFFADDR	0x74000000
#define VP1BASEADDR		0x01C44000
#define VP1SBUFFADDR	0x78000000
#define VP2BASEADDR		0x01C48000
#define VP2SBUFFADDR	0x7C000000

/* VP0 GPIO Register*/
#define VP0_VPPID		(VP0BASEADDR+0x00)
#define VP0_PCR         (VP0BASEADDR+0x04)
#define VP0_PFUNC		(VP0BASEADDR+0x20)
#define VP0_DIR			(VP0BASEADDR+0x24)
#define VP0_DIN			(VP0BASEADDR+0x28)
#define VP0_DOUT		(VP0BASEADDR+0x2C)
#define VP0_DSET		(VP0BASEADDR+0x30)
#define VP0_DCLR		(VP0BASEADDR+0x34)
#define VP0_PIEN		(VP0BASEADDR+0x38)
#define VP0_PIPOL		(VP0BASEADDR+0x3C)
#define VP0_PISTAT		(VP0BASEADDR+0x40)
#define VP0_PICLR		(VP0BASEADDR+0x44)

/* VP0 Control Register */
#define VP0_CTL			(VP0BASEADDR+0xC0)
#define VP0_STAT		(VP0BASEADDR+0xC4)
#define VP0_IE			(VP0BASEADDR+0xC8)
#define VP0_IS			(VP0BASEADDR+0xCC)

/* VP0 dispure Register */
#define VC0_ASTAT		(VP0BASEADDR+0x100)
#define VC0_ACTL		(VP0BASEADDR+0x104)
#define VC0_ASTRT1		(VP0BASEADDR+0x108)
#define VC0_ASTOP1		(VP0BASEADDR+0x10C)
#define VC0_ASTRT2		(VP0BASEADDR+0x110)
#define VC0_ASTOP2		(VP0BASEADDR+0x114)
#define VC0_AVINT		(VP0BASEADDR+0x118)
#define VC0_ATHRLD		(VP0BASEADDR+0x11C)
#define VC0_AEVTCT		(VP0BASEADDR+0x120)

#define VC0_BSTAT		(VP0BASEADDR+0x140)
#define VC0_BCTL		(VP0BASEADDR+0x144)
#define VC0_BSTRT1		(VP0BASEADDR+0x148)
#define VC0_BSTOP1		(VP0BASEADDR+0x14C)
#define VC0_BSTRT2		(VP0BASEADDR+0x150)
#define VC0_BSTOP2		(VP0BASEADDR+0x154)
#define VC0_BVINT		(VP0BASEADDR+0x158)
#define VC0_BTHRLD		(VP0BASEADDR+0x15C)
#define VC0_BEVTCT		(VP0BASEADDR+0x160)

/* VP0 Buffer  */

#define VB0_YSRCA		(VP0SBUFFADDR+0x0)
#define VB0_CbSRCA		(VP0SBUFFADDR+0x8)
#define VB0_CrSRCA		(VP0SBUFFADDR+0x10)
#define VB0_YDSTA		(VP0SBUFFADDR+0x20)
#define VB0_CbDSTA		(VP0SBUFFADDR+0x28)
#define VB0_CrDSTA		(VP0SBUFFADDR+0x30)

#define VP0DBUFFADDR	0x76000000
#define VB0_YSRCB		(VP0BUFFADDR+0x0)
#define VB0_CbSRCB		(VP0BUFFADDR+0x8)
#define VB0_CrSRCB		(VP0BUFFADDR+0x10)
#define VB0_YDSTB		(VP0BUFFADDR+0x20)
#define VB0_CbDSTB		(VP0BUFFADDR+0x28)
#define VB0_CrDSTB		(VP0BUFFADDR+0x30)

/////////////////////////////////////////////////////  		  
/* VP1 Control Register */
/* Serve as McBSP1 */

/* VP1 GPIO Register*/
#define VP1_PCR         (VP1BASEADDR+0x04)

/* VP1 Control Register */
#define VP1_CTL			(VP1BASEADDR+0xC0)
#define VP1_STAT		(VP1BASEADDR+0xC4)
#define VP1_IE			(VP1BASEADDR+0xC8)
#define VP1_IS			(VP1BASEADDR+0xCC)

/* VP1 Capture A Register */
#define VC1_ASTAT		(VP1BASEADDR+0x100)
#define VC1_ACTL		(VP1BASEADDR+0x104)
#define VC1_ASTRT1		(VP1BASEADDR+0x108)
#define VC1_ASTOP1		(VP1BASEADDR+0x10c)
#define VC1_ASTRT2		(VP1BASEADDR+0x110)
#define VC1_ASTOP2		(VP1BASEADDR+0x114)
#define VC1_AVINT		(VP1BASEADDR+0x118)
#define VC1_ATHRLD		(VP1BASEADDR+0x11c)
#define VC1_AEVTCT		(VP1BASEADDR+0x120)

/* VP1 Capture B Register */
#define VC1_BSTAT		(VP1BASEADDR+0x140)
#define VC1_BCTL		(VP1BASEADDR+0x144)
#define VC1_BSTRT1		(VP1BASEADDR+0x148)
#define VC1_BSTOP1		(VP1BASEADDR+0x14c)
#define VC1_BSTRT2		(VP1BASEADDR+0x150)
#define VC1_BSTOP2		(VP1BASEADDR+0x154)
#define VC1_BVINT		(VP1BASEADDR+0x158)
#define VC1_BTHRLD		(VP1BASEADDR+0x15c)
#define VC1_BEVTCT		(VP1BASEADDR+0x160)

/* VP1 Display Register */
#define VD1_STAT		(VP1BASEADDR+0x200)
#define VD1_CTL			(VP1BASEADDR+0x204)
#define VD1_FRMSZ		(VP1BASEADDR+0x208)
#define VD1_HBLNK		(VP1BASEADDR+0x20c)
#define VD1_VBLKS1		(VP1BASEADDR+0x210)
#define VD1_VBLKE1		(VP1BASEADDR+0x214)
#define VD1_VBLKS2		(VP1BASEADDR+0x218)
#define VD1_VBLKE2		(VP1BASEADDR+0x21c)
#define VD1_IMGOFF1		(VP1BASEADDR+0x220)
#define VD1_IMGSZ1		(VP1BASEADDR+0x224)
#define VD1_IMGOFF2		(VP1BASEADDR+0x228)
#define VD1_IMGSZ2		(VP1BASEADDR+0x22c)
#define VD1_FLDT1		(VP1BASEADDR+0x230)
#define VD1_FLDT2		(VP1BASEADDR+0x234)
#define VD1_THRLD		(VP1BASEADDR+0x238)
#define VD1_HSYNC		(VP1BASEADDR+0x23c)
#define VD1_VSYNS1		(VP1BASEADDR+0x240)
#define VD1_VSYNE1		(VP1BASEADDR+0x244)
#define VD1_VSYNS2		(VP1BASEADDR+0x248)
#define VD1_VSYNE2		(VP1BASEADDR+0x24c)
#define VD1_RELOAD		(VP1BASEADDR+0x250)
#define VD1_DISPEVT		(VP1BASEADDR+0x254)
#define VD1_CLIP		(VP1BASEADDR+0x258)
#define VD1_DEFVAL		(VP1BASEADDR+0x25c)
#define VD1_VINT		(VP1BASEADDR+0x260)
#define VD1_FBIT		(VP1BASEADDR+0x264)
#define VD1_VBIT1		(VP1BASEADDR+0x268)
#define VD1_VBIT2		(VP1BASEADDR+0x26c)

/* VP1 Buffer  */

#define VB1_YSRCA		(VP1SBUFFADDR+0x0)
#define VB1_CbSRCA		(VP1SBUFFADDR+0x8)
#define VB1_CrSRCA		(VP1SBUFFADDR+0x10)
#define VB1_YDSTA		(VP1SBUFFADDR+0x20)
#define VB1_CbDSTA		(VP1SBUFFADDR+0x28)
#define VB1_CrDSTA		(VP1SBUFFADDR+0x30)

#define VP1DBUFFADDR	0x7A000000
#define VB1_YSRCB		(VP1DBUFFADDR+0x0)
#define VB1_CbSRCB		(VP1DBUFFADDR+0x8)
#define VB1_CrSRCB		(VP1DBUFFADDR+0x10)
#define VB1_YDSTB		(VP1DBUFFADDR+0x20)
#define VB1_CbDSTB		(VP1DBUFFADDR+0x28)
#define VB1_CrDSTB		(VP1DBUFFADDR+0x30)

/////////////////////////////////////////////////////  		  
/* VP2 Control Register */

/* VP2 GPIO Register*/
#define VP2_PCR         (VP2BASEADDR+0x04)

/* VP2 Control Register */
#define VP2_CTL			(VP2BASEADDR+0xC0)
#define VP2_STAT		(VP2BASEADDR+0xC4)
#define VP2_IE			(VP2BASEADDR+0xC8)
#define VP2_IS			(VP2BASEADDR+0xCC)

/* VP2 Display Register */
#define VD2_STAT		(VP2BASEADDR+0x200)
#define VD2_CTL			(VP2BASEADDR+0x204)
#define VD2_FRMSZ		(VP2BASEADDR+0x208)
#define VD2_HBLNK		(VP2BASEADDR+0x20c)			//????????????
#define VD2_VBLKS1		(VP2BASEADDR+0x210)
#define VD2_VBLKE1		(VP2BASEADDR+0x214)
#define VD2_VBLKS2		(VP2BASEADDR+0x218)
#define VD2_VBLKE2		(VP2BASEADDR+0x21c)
#define VD2_IMGOFF1		(VP2BASEADDR+0x220)
#define VD2_IMGSZ1		(VP2BASEADDR+0x224)
#define VD2_IMGOFF2		(VP2BASEADDR+0x228)
#define VD2_IMGSZ2		(VP2BASEADDR+0x22c)
#define VD2_FLDT1		(VP2BASEADDR+0x230)
#define VD2_FLDT2		(VP2BASEADDR+0x234)
#define VD2_THRLD		(VP2BASEADDR+0x238)
#define VD2_HSYNC		(VP2BASEADDR+0x23c)
#define VD2_VSYNS1		(VP2BASEADDR+0x240)
#define VD2_VSYNE1		(VP2BASEADDR+0x244)
#define VD2_VSYNS2		(VP2BASEADDR+0x248)
#define VD2_VSYNE2		(VP2BASEADDR+0x24c)
#define VD2_RELOAD		(VP2BASEADDR+0x250)//nu
#define VD2_DISPEVT		(VP2BASEADDR+0x254)
#define VD2_CLIP		(VP2BASEADDR+0x258)//nu
#define VD2_DEFVAL		(VP2BASEADDR+0x25c)//nu
#define VD2_VINT		(VP2BASEADDR+0x260)//nu
#define VD2_FBIT		(VP2BASEADDR+0x264)
#define VD2_VBIT1		(VP2BASEADDR+0x268)
#define VD2_VBIT2		(VP2BASEADDR+0x26c)

/* VP2 Buffer  */

#define VB2_YSRCA		(VP2SBUFFADDR+0x0)
#define VB2_CbSRCA		(VP2SBUFFADDR+0x8)
#define VB2_CrSRCA		(VP2SBUFFADDR+0x10)
#define VB2_YDSTA		(VP2SBUFFADDR+0x20)
#define VB2_CbDSTA		(VP2SBUFFADDR+0x28)
#define VB2_CrDSTA		(VP2SBUFFADDR+0x30)

#define VP2DBUFFADDR	0x7E000000
#define VB2_YSRCB		(VP2DBUFFADDR+0x0)
#define VB2_CbSRCB		(VP2DBUFFADDR+0x8)
#define VB2_CrSRCB		(VP2DBUFFADDR+0x10)
#define VB2_YDSTB		(VP2DBUFFADDR+0x20)
#define VB2_CbDSTB		(VP2DBUFFADDR+0x28)
#define VB2_CrDSTB		(VP2DBUFFADDR+0x30)

/////////////////////////////////////////////////////
/* bit definition for VPx_PCR */
#define FREE            0
#define SOFT            1
#define PEREN           2

/* bit definition for VPx_CTL */
#define DCHNL           0		/* single/dual channel */
#define DISP            1		/* mode */
#define TSI             2       
#define VCT0P           4
#define VCT1P           5
#define VCT2P           6
#define VCLK1P          7
#define VPHLT          14		/* halt */
#define VPRST          15		/* reset */

/* bit definition for VPx_STAT */
#define DCDIS           3		/* Dual-channel disable bit. */
#define HIDATA			2

/* bit definition for VPx_IE & VPx_IS */ 
#define VIE             0       /* VP global int enable */
#define COVRA           1       /* cap fifo overrun */
#define CCMPA           2       /* cap complete of ChA */
#define SERRA           3       /* sync error, should reset */
#define VINTA1          4       /* ChA field 1 vertical int */
#define VINTA2          5       /* ChA field 2 vertical int */
#define SFDA            6       /* short field */
#define LFDA            7       /* long field */
#define STC            10       /* system time clock */
#define DUND           12       /* disp fifo underrun */
#define DCMP           13       /* disp complete */
#define DCNA           14       /* dcmp not cleared before new frame */

/////////////////////////////////////////////////////
/* bit definition for VCx_STAT */
#define VCXPOS         0       /* 11~0, pixel index of the last received pixel */
#define VCFLD          12       /* disping field indicater */
#define VCYPOS         16       /* 27~16, line that is currently being received */
#define F1C            28       /* disped field 1 */
#define F2C            29       /* caped field 2 */
#define FRMC           30       /* frame disped */
#define FSYNC          31       

/* bit definition for VCx_CTL */
#define CMODE           0       /* default:0, BT656, 8bit mode */
#define CF1             4       /* disp field 1 enable */
#define CF2             5       /* disp field 2 enable */
#define FRAME           6       /* disp frame enable */
#define CON             7       /* Continuous disp */
#define SCALE           8       /* half size scaling */
#define RESMPL         10       /* chroma resample */
#define SFDE           11       /* short field detect enable */
#define LFDE           12       /* long field detect enable */
#define VCEN           15       /* video dispure enable */
#define HRST           16       /* HCOUNT reset methord */
#define VRST           17       /* VCOUNT reset methord */
#define FLDD           18       /* field detect methord */
#define EXC            19       /* external control select bit */
#define FINV           20       /* field indicate bit polarity */
#define BLKCAP         30       /*   */
#define RSTCH          31       /*   */

/* bit definition for VCx_STRT1&2 */
#define VCYSTART       16       /* 27~16, start line number */
#define VCXSTART        0       /* 11~0, start pixel number */

/* bit definition for VCx_STOP1&2 */
#define VCYSTOP        16       /* 27~16, end line number */
#define VCXSTOP         0       /* 11~0, end pixel number */

/* bit definition for VCx_VINT */
#define VINT1           0       /* FSYNC */ 
#define VIF1           15       /*  */
#define VINT2          16       /*  */
#define FSCL2          30       /*  */
#define VIF2           31       /*  */

/* bit definition for VCx_THRLD */
#define VCTHRLD1        0
#define VCTHRLD2       16

/* bit definition for VCx_EVTCT */
#define CAPEVTCT1       0
#define CAPEVTCT2       16

/////////////////////////////////////////////////////
/* bit definition for VDx_STAT */
#define VDXPOS         0       /* 11~0, pixel index of the last received pixel */
#define VDFLD          12       /* disping field indicater */
#define VBLINK         13 
#define VDYPOS         16       /* 27~16, line that is currently being received */
#define F1D            28       /* disped field 1 */
#define F2D            29       /* caped field 2 */
#define FRMD           30       /* frame disped */

/* bit definition for VDx_CTL */
#define DMODE           0       /* default:0, BT656, 8bit mode */
#define DF1             4       /* disp field 1 enable */
#define DF2             5       /* disp field 2 enable */
//#define FRAME 			6
//#define CON				7
#define DVEN           11       /* default value enable bit */
#define RSYNC		   12
#define RGBX		   13
#define DPK 		   14
#define VDEN           15       /* video display enable */
#define VCTL0S         16       /* VCTL0 function */
#define VCTL1S         18       /* VCTL1 function */
#define VCTL2S         20       /* VCTL2 function */
#define PVPSYN         28
#define BLKDIS         30       /*   */

/////////////////////////////////////////////////////  		  
/* bit definition for VDx_FRMSZ */
#define FRMWIDTH        0		//
#define FRMHEIGHT      16		//

#define HBLNKSTART      0		/* HBLANK */
#define HBLNKSTOP      16

#define VBLNKXSTART    0		/* VBLANK start for fld1*/
#define VBLNKYSTART   16

#define VBLNKXSTOP     0		/* VBLANK start for fld1*/
#define VBLNKYSTOP    16

#define IMGHOFF        0
#define IMGVOFF       16

#define IMGHSIZE       0
#define IMGVSIZE      16

#define FLDXSTART     0
#define FLDYSTART    16

#define VDTHRLD1        0
#define INCPIX			12
#define VDTHRLD2       16

#define HSYNCSTART      0
#define HSYNCSTOP      16

#define VSYNCXSTART     0
#define VSYNCYSTART    16

#define VSYNCXSTOP     0
#define VSYNCYSTOP    16

#define DISPEVT1       0
#define DISPEVT2      16

#define FBITCLR        0	
#define FBITSET       16

#define VBITSET        0
#define VBITCLR       16

#define CLIPYLOW		0   
#define CLIPYHIGH		8
#define CLIPCLOW		16
#define CLIPCHIGH		24

//in raw mode
#define yDEFVAL			0 
#define cbDEFVAL		16
#define crDEFVAL		24

/////////////////////////////////////////////////////  
/* PLL Registers */
#define PLLCSR 				0x01B7C100		/* PLL control/status register       */
#define PLLM				0x01B7C110		/* PLL multiplier control register   */  
#define PLLDIV0 	        0x01B7C114		/* PLL controller divider 0 register */   
#define PLLDIV1		        0x01B7C118  	/* PLL controller divider 1 register */    
#define PLLDIV2		        0x01B7C11C  	/* PLL controller divider 2 register */    
#define PLLDIV3		        0x01B7C120  	/* PLL controller divider 3 register */    
#define OSCDIV1				0x01B7C124  	/* Oscillator divider 1 register     */
#define PLLCSR_REG			*(unsigned volatile int *)PLLCSR 	/* PLL control/status register       */
#define PLLM_REG			*(unsigned volatile int *)PLLM		/* PLL multiplier control register   */         
#define PLLDIV0_REG         *(unsigned volatile int *)PLLDIV0	/* PLL controller divider 0 register */         
#define PLLDIV1_REG         *(unsigned volatile int *)PLLDIV1  	/* PLL controller divider 1 register */         
#define PLLDIV2_REG         *(unsigned volatile int *)PLLDIV2  	/* PLL controller divider 2 register */         
#define PLLDIV3_REG         *(unsigned volatile int *)PLLDIV3  	/* PLL controller divider 3 register */         
#define OSCDIV1_REG			*(unsigned volatile int *)OSCDIV1  	/* Oscillator divider 1 register     */         

/////////////////////////////////////////////////////  		  
/* VIC Control Register */




/////////////////////////////////////////////////////  		  
/* EMAC Control Register */


/////////////////////////////////////////////////////  		  
/* EMAC Wrapper Register */


/////////////////////////////////////////////////////  		  
/* EWRAP Register */


/////////////////////////////////////////////////////  		  
/* MDIO Control Register */


/////////////////////////////////////////////////////  		  
/* Define QDMA Memory Mapped Registers */
#define QDMA_OPT		0x02000000	/* Address of QDMA options register     */
#define QDMA_SRC		0x02000004	/* Address of QDMA SRC address register */
#define QDMA_CNT		0x02000008	/* Address of QDMA counts register      */
#define QDMA_DST		0x0200000C	/* Address of QDMA DST address register */
#define QDMA_IDX		0x02000010	/* Address of QDMA index register       */

/* Define QDMA Pseudo Registers */
#define QDMA_S_OPT		0x02000020	/* Address of QDMA options register     */
#define QDMA_S_SRC		0x02000024	/* Address of QDMA SRC address register */
#define QDMA_S_CNT		0x02000028	/* Address of QDMA counts register      */
#define QDMA_S_DST		0x0200002C	/* Address of QDMA DST address register */
#define QDMA_S_IDX		0x02000030	/* Address of QDMA index register       */

/////////////////////////////////////////////////////  		  
/*                       Data                      */
/////////////////////////////////////////////////////  		  
#define McBSP1_ADDR         0x34000000 

//Ҫ趨λ: OPT_ESIZE(x), OPT_SUM(x), OPT_DUM(x)
#define QDMA_BLOCK_2D2D		PRI_LOW|OPT_2DS(1)|OPT_2DD(1)|OPT_TCINT(1)|OPT_TCC(0)|OPT_TCCM(0)|OPT_LINK(0)|OPT_FS(1)
#define QDMA_BLOCK_1D2D		PRI_LOW|OPT_2DS(0)|OPT_2DD(1)|OPT_TCINT(1)|OPT_TCC(0)|OPT_TCCM(0)|OPT_LINK(0)|OPT_FS(1)
#define QDMA_BLOCK_2D1D		PRI_LOW|OPT_2DS(1)|OPT_2DD(0)|OPT_TCINT(1)|OPT_TCC(0)|OPT_TCCM(0)|OPT_LINK(0)|OPT_FS(1)

#define QDMA_BLOCK_1D1D		PRI_LOW|OPT_2DS(0)|OPT_2DD(0)|OPT_TCINT(1)|OPT_TCC(0)|OPT_TCCM(0)|OPT_LINK(0)|OPT_FS(1)

#define PRI_URG				OPT_PRI(0)	//000--Level0; urgent priority,  L2 controller 
#define PRI_HIG				OPT_PRI(1)	//001--Level1; high priority, EDMA, QDMA and/or HPI 
#define PRI_MID				OPT_PRI(2)	//010--Level2; low priority , EDMA, QDMA 
#define PRI_LOW				OPT_PRI(3)	//011-111  Reserved 
		
#define ESIZE_32bit			OPT_ESIZE(0)
#define ESIZE_16bit			OPT_ESIZE(1)
#define ESIZE_8bit			OPT_ESIZE(2)

#define SUM_NONE			OPT_SUM(0)	//Fixed address mode. No source address modification.
#define SUM_INC				OPT_SUM(1)	//Source address increment depends on the 2DS and FS bits.
#define SUM_DEC				OPT_SUM(2)	//Source address decrement depends on the 2DS and FS bits.
#define SUM_IDX				OPT_SUM(3)	//Source address modified by the element index/frame index
								//depending on the 2DS and FS bits.
								
#define DUM_NONE			OPT_DUM(0)	//Fixed address mode. No source address modification.
#define DUM_INC				OPT_DUM(1)	//Destination address increment depends on the 2DS and FS bits.
#define DUM_DEC				OPT_DUM(2)	//Destination address decrement depends on the 2DS and FS bits.
#define DUM_IDX				OPT_DUM(3)	//Destination address modified by the element index/frame index
								//depending on the 2DS and FS bits.
/**************************************************************
Cache Register
***************************************************************/
#define	 CCFG  	 0x01840000  	//	 Cache configuration register  
				
#define	 EDMAWEIGHT  	 0x01841000  	//	 L2 EDMA access control register  
				
#define	 L2ALLOC0  	 0x01842000  	//	 L2 allocation register 0  
#define	 L2ALLOC1  	 0x01842004  	//	 L2 allocation register 1  
#define	 L2ALLOC2  	 0x01842008  	//	 L2 allocation register 2  
#define	 L2ALLOC3  	 0x0184200C  	//	 L2 allocation register 3  
				
#define	 L2WBAR  	 0x01844000  	//	 L2 writeback base address register  
#define	 L2WWC  	 0x01844004  	//	 L2 writeback word count register  
#define	 L2WIBAR  	 0x01844010  	//	 L2 writeback invalidate base address register  
#define	 L2WIWC  	 0x01844014  	//	 L2 writeback invalidate word count register  
#define	 L2IBAR  	 0x01844018  	//	 L2 invalidate base address register  
#define	 L2IWC  	 0x0184401C  	//	 L2 invalidate word count register  
#define	 L1PIBAR  	 0x01844020  	//	 L1P invalidate base address register  
#define	 L1PIWC  	 0x01844024  	//	 L1P invalidate word count register  
#define	 L1DWIBAR  	 0x01844030  	//	 L1D writeback invalidate base address register  
#define	 L1DWIWC  	 0x01844034  	//	 L1D writeback invalidate word count register  

#define	 L1DIBAR  	 0x01844048  	//	 L1D invalidate base address register  
#define	 L1DIWC  	 0x0184404C  	//	 L1D invalidate word count register  
				
#define	 L2WB  	 0x01845000  	//	 L2 writeback all register  
#define	 L2WBINV  	 0x01845004  	//	 L2 writeback invalidate all register  
				
#define	 MAR128  	 0x01848200  	//	 Controls EMIFA CE0 range 8000 0000 C 80FF FFFF  
#define	 MAR129  	 0x01848204  	//	 Controls EMIFA CE0 range 8100 0000 C 81FF FFFF  
#define	 MAR130  	 0x01848208  	//	 Controls EMIFA CE0 range 8200 0000 C 82FF FFFF  
#define	 MAR131  	 0x0184820C  	//	 Controls EMIFA CE0 range 8300 0000 C 83FF FFFF  
#define	 MAR132  	 0x01848210  	//	 Controls EMIFA CE0 range 8400 0000 C 84FF FFFF  
#define	 MAR133  	 0x01848214  	//	 Controls EMIFA CE0 range 8500 0000 C 85FF FFFF  
#define	 MAR134  	 0x01848218  	//	 Controls EMIFA CE0 range 8600 0000 C 86FF FFFF  
#define	 MAR135  	 0x0184821C  	//	 Controls EMIFA CE0 range 8700 0000 C 87FF FFFF  
#define	 MAR136  	 0x01848220  	//	 Controls EMIFA CE0 range 8800 0000 C 88FF FFFF  
#define	 MAR137  	 0x01848224  	//	 Controls EMIFA CE0 range 8900 0000 C 89FF FFFF  
#define	 MAR138  	 0x01848228  	//	 Controls EMIFA CE0 range 8A00 0000 C 8AFF FFFF  
#define	 MAR139  	 0x0184822C  	//	 Controls EMIFA CE0 range 8B00 0000 C 8BFF FFFF  
#define	 MAR140  	 0x01848230  	//	 Controls EMIFA CE0 range 8C00 0000 C 8CFF FFFF  
#define	 MAR141  	 0x01848234  	//	 Controls EMIFA CE0 range 8D00 0000 C 8DFF FFFF  
#define	 MAR142  	 0x01848238  	//	 Controls EMIFA CE0 range 8E00 0000 C 8EFF FFFF  
#define	 MAR143  	 0x0184823C  	//	 Controls EMIFA CE0 range 8F00 0000 C 8FFF FFFF  
#define	 MAR144  	 0x01848240  	//	 Controls EMIFA CE1 range 9000 0000 C 90FF FFFF  
#define	 MAR145  	 0x01848244  	//	 Controls EMIFA CE1 range 9100 0000 C 91FF FFFF  
#define	 MAR146  	 0x01848248  	//	 Controls EMIFA CE1 range 9200 0000 C 92FF FFFF  
#define	 MAR147  	 0x0184824C  	//	 Controls EMIFA CE1 range 9300 0000 C 93FF FFFF  
#define	 MAR148  	 0x01848250  	//	 Controls EMIFA CE1 range 9400 0000 C 94FF FFFF  
#define	 MAR149  	 0x01848254  	//	 Controls EMIFA CE1 range 9500 0000 C 95FF FFFF  
#define	 MAR150  	 0x01848258  	//	 Controls EMIFA CE1 range 9600 0000 C 96FF FFFF  
#define	 MAR151  	 0x0184825C  	//	 Controls EMIFA CE1 range 9700 0000 C 97FF FFFF  
#define	 MAR152  	 0x01848260  	//	 Controls EMIFA CE1 range 9800 0000 C 98FF FFFF  
#define	 MAR153  	 0x01848264  	//	 Controls EMIFA CE1 range 9900 0000 C 99FF FFFF  
#define	 MAR154  	 0x01848268  	//	 Controls EMIFA CE1 range 9A00 0000 C 9AFF FFFF  
#define	 MAR155  	 0x0184826C  	//	 Controls EMIFA CE1 range 9B00 0000 C 9BFF FFFF  
#define	 MAR156  	 0x01848270  	//	 Controls EMIFA CE1 range 9C00 0000 C 9CFF FFFF  
#define	 MAR157  	 0x01848274  	//	 Controls EMIFA CE1 range 9D00 0000 C 9DFF FFFF  
#define	 MAR158  	 0x01848278  	//	 Controls EMIFA CE1 range 9E00 0000 C 9EFF FFFF  
#define	 MAR159  	 0x0184827C  	//	 Controls EMIFA CE1 range 9F00 0000 C 9FFF FFFF  
#define	 MAR160  	 0x01848280  	//	 Controls EMIFA CE2 range A000 0000 C A0FF FFFF  
#define	 MAR161  	 0x01848284  	//	 Controls EMIFA CE2 range A100 0000 C A1FF FFFF  
#define	 MAR162  	 0x01848288  	//	 Controls EMIFA CE2 range A200 0000 C A2FF FFFF  
#define	 MAR163  	 0x0184828C  	//	 Controls EMIFA CE2 range A300 0000 C A3FF FFFF  
#define	 MAR164  	 0x01848290  	//	 Controls EMIFA CE2 range A400 0000 C A4FF FFFF  
#define	 MAR165  	 0x01848294  	//	 Controls EMIFA CE2 range A500 0000 C A5FF FFFF  
#define	 MAR166  	 0x01848298  	//	 Controls EMIFA CE2 range A600 0000 C A6FF FFFF  
#define	 MAR167  	 0x0184829C  	//	 Controls EMIFA CE2 range A700 0000 C A7FF FFFF  
#define	 MAR168  	 0x018482A0  	//	 Controls EMIFA CE2 range A800 0000 C A8FF FFFF  
#define	 MAR169  	 0x018482A4  	//	 Controls EMIFA CE2 range A900 0000 C A9FF FFFF  
#define	 MAR170  	 0x018482A8  	//	 Controls EMIFA CE2 range AA00 0000 C AAFF FFFF  
#define	 MAR171  	 0x018482AC  	//	 Controls EMIFA CE2 range AB00 0000 C ABFF FFFF  
#define	 MAR172  	 0x018482B0  	//	 Controls EMIFA CE2 range AC00 0000 C ACFF FFFF  
#define	 MAR173  	 0x018482B4  	//	 Controls EMIFA CE2 range AD00 0000 C ADFF FFFF  
#define	 MAR174  	 0x018482B8  	//	 Controls EMIFA CE2 range AE00 0000 C AEFF FFFF  
#define	 MAR175  	 0x018482BC  	//	 Controls EMIFA CE2 range AF00 0000 C AFFF FFFF  
#define	 MAR176  	 0x018482C0  	//	 Controls EMIFA CE3 range B000 0000 C B0FF FFFF  
#define	 MAR177  	 0x018482C4  	//	 Controls EMIFA CE3 range B100 0000 C B1FF FFFF  
#define	 MAR178  	 0x018482C8  	//	 Controls EMIFA CE3 range B200 0000 C B2FF FFFF  
#define	 MAR179  	 0x018482CC  	//	 Controls EMIFA CE3 range B300 0000 C B3FF FFFF  
#define	 MAR180  	 0x018482D0  	//	 Controls EMIFA CE3 range B400 0000 C B4FF FFFF  
#define	 MAR181  	 0x018482D4  	//	 Controls EMIFA CE3 range B500 0000 C B5FF FFFF  
#define	 MAR182  	 0x018482D8  	//	 Controls EMIFA CE3 range B600 0000 C B6FF FFFF  
#define	 MAR183  	 0x018482DC  	//	 Controls EMIFA CE3 range B700 0000 C B7FF FFFF  
#define	 MAR184  	 0x018482E0  	//	 Controls EMIFA CE3 range B800 0000 C B8FF FFFF  
#define	 MAR185  	 0x018482E4  	//	 Controls EMIFA CE3 range B900 0000 C B9FF FFFF  
#define	 MAR186  	 0x018482E8  	//	 Controls EMIFA CE3 range BA00 0000 C BAFF FFFF  
#define	 MAR187  	 0x018482EC  	//	 Controls EMIFA CE3 range BB00 0000 C BBFF FFFF  
#define	 MAR188  	 0x018482F0  	//	 Controls EMIFA CE3 range BC00 0000 C BCFF FFFF  
#define	 MAR189  	 0x018482F4  	//	 Controls EMIFA CE3 range BD00 0000 C BDFF FFFF  
#define	 MAR190  	 0x018482F8  	//	 Controls EMIFA CE3 range BE00 0000 C BEFF FFFF  
#define	 MAR191  	 0x018482FC  	//	 Controls EMIFA CE3 range BF00 0000 C BFFF FFFF  
				
/* End of file*/
