#include "drawLCD.h"
#include "emif.h"



#pragma DATA_SECTION (DispBuf , "DISP_BUF");
uPix DispBuf		[VD_IMG_SIZE1];	
//uPix DispBuf2		[VD_IMG_SIZE1];	

void fillRectangle(int x, int y, int width, int height, u32 color)
{
//	int i,j;
	uPix *sptr=DispBuf+y*LCD_Col+x;
	uPix *p=sptr;
	int i,j;
	for(i=0;i<height;i++){
		p=sptr + i*LCD_Col;
		for(j=0;j<width;j++){
			*p++ = color;
		}

	}	
}

/***************************************************************
//Configure SDRAM/SRAM registers
****************************************************************/
void EMIF_Configure()
{	
    _XU32(EMIF_GCR) = EMIF_GCR_V;
    _XU32(EMIF_CE0) = EMIF_CE0_V;
    _XU32(EMIF_CE1) = EMIF_CE1_V;
    _XU32(EMIF_SDCTRL) = EMIF_SDCTRL_V;
    _XU32(EMIF_SDTIM)  = EMIF_SDTIM_V;
    _XU32(EMIF_SDEXT)  = EMIF_SDEXT_V;

    /*---config peripherals' function---*/
    _XU32(PCFGLOCK) = 0x10C0010C;

    _XU32(PERCFG_CTRL) = ((1<<VP2EN) + (1<<VP1EN) + (1<<VP0EN) +
			 (1<<I2C0EN) +
			 (0<<MCBSP1EN) + (0<<MCBSP0EN) + 
			 (0<<MCASP0EN));  /* PERCFG_PARAMS; */
}


void drawCrossLine(int x, int y, int cenX, int cenY,int outR, int inR)
{
	fillRectangle(x+(cenX-outR), y+cenY, outR<<(1), 1, cRed);
 	fillRectangle(x+cenX, y+(cenY-outR), 1, outR<<(1), cRed);
 	
 	fillRectangle(x+(cenX-outR), y+(cenY-25), 1, 25<<(1), cRed);
 	fillRectangle(x+(cenX-inR),  y+(cenY-15), 1, 15<<(1), cRed);
 	fillRectangle(x+(cenX+outR), y+(cenY-25), 1, 25<<(1), cRed);
 	fillRectangle(x+(cenX+inR),  y+(cenY-15), 1, 15<<(1), cRed); 		
 	fillRectangle(x+(cenX-25),   y+(cenY-outR), 25<<(1), 1, cRed);
 	fillRectangle(x+(cenX-15),   y+(cenY-inR) , 15<<(1), 1, cRed);
 	fillRectangle(x+(cenX-25),   y+(cenY+outR), 25<<(1), 1, cRed);
 	fillRectangle(x+(cenX-15),   y+(cenY+inR) , 15<<(1), 1, cRed);	
}

volatile int x=8,y=10,cenX=200,cenY=250,outR=180,inR=150;

void Set_DisEDMAparm(u32 DispBufAddr);

void main(void)
{
#if 0 //run on DM642 board
    EMIF_Configure();
    InitDisplayPort();
#else //run on simulater,make sure DispBuf is used
	Set_DisEDMAparm((u32)DispBuf);
#endif
    while(1){ 		
		fillRectangle(0,0,800,600,cBlack);
		drawCrossLine(x,y,cenX,cenY,outR,inR);
    }
}


///////////////////////////////////////////////////////////////////////////////


