#ifndef _STDIO
#define _STDIO
#include <stdio.h>
#endif
#ifndef _STRING
#define _STRING
#include <string.h>
#endif
#ifndef _STDLIB
#define _STDLIB
#include <stdlib.h>
#endif
#ifndef __math__
#define __math__
#include <math.h>
#endif
#include "geo_dist_1p2centroids.h"
#include "src/globals.h"
#include "src/geodistance.h"
//#define QUARTERDEGREE_RES
//#include "geodistance.c"
//#include "get_pob_lat_lon.c"
// To store latitude and longitude of candidates where to compare distances
// nvalues stores the number of found candidates.
//typedef  struct Nzero_candidates{
//	int lat[361];
//	int lon[361];
//	int count;
//}nzero_candidates;
//
//typedef struct Coarse_point{
//	int lat;
//	int lon;
//}coarse_point;

/* 
 * ===  FUNCTION  ======================================================================
 *         Name:  geo_dist_1p2centroids
 *  Description:  Calculate closest point to point P from a list of populations in memory.,
 *  			this calculate the distance one by one and determine whats the nearest.
 *  Input:
 *  	P: Point under test.
 *    	points: file name with points(lat lon)which distance to P have  to be measured.
 *  Ouput:
 *  	return: tag of point, and distance choosen town or geofence to point P.
 * =====================================================================================
 */
//ClosestPop
//geo_dist_1p2centroids( double lat_p, double long_p )
//{
//	double lat_num,lon_num;		//Lat,long read from every line in file
//	char* tag[ MAX_LEN_STR ];
//	int i,j; //Counters
//	double dmin = 1000000000;
//	ClosestPop nearestPop;
//
//	for(i=0;i<max_pop;i++) {//	while(err != EOF) {
//		lat_num =  buf_lat[i];//atof(lat);
//		lon_num =  buf_lon[i];//atof(lon);
//		curr_dist = geodistance( lat_p, long_p, lat_num,lon_num);
//		if( curr_dist < dmin ) {
//			dmin = curr_dist;
//			nearestPop.pop = buf_pop[i];
//		}
//	}
//	nearestPop.distance =   (int) dmin; //distance in m
//	return nearestPop ;
//}		// -----  end of function geo_dist_1p2centroids  -----

/*
 * ===  FUNCTION  ======================================================================
 *         Name:  geo_dist_1p2centroids_alg
 *  Description:  Calculate closest point to point P from a list of populations in memory,
 *             this distance calculation is made point by point in the neighborhood regions until
 *             find a region with points in there.
 *  Input:
 *  	P: Point under test.
 *    	points: file name with points(lat lon)which distance to P have  to be measured.
 *  Ouput:
 *  	return: tag of point, and distance choosen town or geofence to point P.
 * =====================================================================================
 */
//ClosestPop
//geo_dist_1p2centroids_alg( double lat_p, double long_p, nzero_candidates* candidates )
//{
//	double lat_num,lon_num;		//Lat,long read from every line in file
//	char* tag[ MAX_LEN_STR ];
//	int i,j; //Counters
//	double dmin = 1000000000;
//	ClosestPop nearestPop;
//	int min_idx, max_idx;
//	int curr_dist=0;
//
////    nzero_candidates candidates;
//    int count_cand=0;
//
//	//Clear candidates structure
////	candidates.count = 0;
////	for(count_cand=0;count_cand<361;count_cand++) {
////		candidates.lat[count_cand] = 0;
////		candidates.lon[count_cand] = 0;
////	}
//
////	candidates = find_nearest_candidates(lat_p,long_p );
//
//	for(j=0; j<(*candidates).count; j++) {
//		min_idx = lon_lat_idxed_pos[90 + (*candidates).lat[j]][180 + (*candidates).lon[j]];
//		max_idx = min_idx + lon_lat_idxed_pos_count[90 + (*candidates).lat[j]][180 + (*candidates).lon[j]];
//		for(i=min_idx;i<max_idx;i++) {//	while(err != EOF) {
//			lat_num =  buf_lat[i]; //atof(lat);
//			lon_num =  buf_lon[i]; //atof(lon);
//			//Determine nearest non-empty neighbor in the map
//
//			curr_dist = geodistance( lat_p, long_p, lat_num,lon_num );
//			if( curr_dist < dmin ) {
//				dmin = curr_dist;
//				nearestPop.pop = buf_pop[i];
//			}
//		}
//	}
//	nearestPop.distance = (int) dmin; //distance in m
//	return nearestPop ;
//}		// -----  end of function geo_dist_1p2centroids  -----
/*
 * ===  FUNCTION  ======================================================================
 *         Name:  find_nearest_candidates
 *  Description:  Calculate closest point to point P from a list of populations in memory,
 *             this distance calculation is made point by point in the neighborhood regions until
 *             find a region with points in there.
 *  o--->---
 *  |x xx x |
 *     __
 *	|x|xX|x |
 *	|x|xx|x |
 *	|  --
 *	|x xx x |
 *	 ---<---
 * =====================================================================================
 */
//nzero_candidates
//void find_nearest_candidates(double central_lat, double central_lon, nzero_candidates* candidates )
//{
//	//nzero_candidates candidates;
//	int i,j;
//	int count_cand = 0;
//	int level=0;
//	int lat_coar,lon_coar;
//	int leftup_lat,leftup_lon;
//	int k;
//	int last_lat, last_lon;
////	coarse coordinates are getting from point under test
//	lat_coar = (int)central_lat;
//	lon_coar = (int)central_lon;
//
////	coarse_point coarpoint;
//	(*candidates).count = 0;
//	for( level=0; level<180 ;level++) //Level is swept
//	{
//	    //Get leftup quadrant coordinates
//		leftup_lat = lat_coar + level ;
//		leftup_lon = lon_coar - (level+1) ;
//
//		//Search for valid candidates
//		for( k=0; k<=(level*2+1); k++) //Forward to right
//		{
//			if(isvalid_coor(leftup_lat ,leftup_lon + k ) != 0) //If it is valid is stored in array and counter is incremented
//			{
//					if(lon_lat_idxed_pos_count[90 + leftup_lat][180 + leftup_lon + k] != 0)//Test if it is a non empty quadrant
//					{
//						(*candidates).lat[(*candidates).count] = leftup_lat;
//						(*candidates).lon[(*candidates).count++] = leftup_lon + k;
//					}
//			}
//		}
//		//Update coordinates with last value tested
//		last_lat = leftup_lat;
//		last_lon = leftup_lon + (level*2+1);
//		for( k=1; k<=(level*2+1); k++) //right to down
//		{
//			if(isvalid_coor(last_lat - k,last_lon) != 0) //If it is valid is stored in array and counter is incremented
//			{
//					if(lon_lat_idxed_pos_count[90 + last_lat - k][180 + last_lon] != 0)//Test if it is a non empty quadrant
//					{
//						(*candidates).lat[(*candidates).count] = last_lat - k;
//						(*candidates).lon[(*candidates).count++] = last_lon;
//					}
//			}
//		}
//		//Update coordinates with last value tested
//		last_lat = last_lat - (level*2+1);
//		last_lon = last_lon;
//		for( k=1; k<=(level*2+1); k++) //down to left
//		{
//			if(isvalid_coor(last_lat ,last_lon -k ) != 0) //If it is valid is stored in array and counter is incremented
//			{
//					if(lon_lat_idxed_pos_count[90 + last_lat][180 + last_lon - k] != 0) //Test if it is a non empty quadrant
//					{
//						(*candidates).lat[(*candidates).count] = last_lat;
//						(*candidates).lon[(*candidates).count++] = last_lon - k;
//					}
//			}
//		}
//		//Update coordinates with last value tested
//		last_lat = last_lat;
//		last_lon = last_lon - (level*2+1);
//		for( k=1; k<=(level*2); k++) //left to up:1 instead 2 because 2 consider first element
//		{
//			if(isvalid_coor(last_lat + k, last_lon) != 0) //If it is valid is stored in array and counter is incremented
//			{
//					if(lon_lat_idxed_pos_count[90 + last_lat + k][180 + last_lon] != 0)//Test if it is a non empty quadrant
//					{
//						(*candidates).lat[(*candidates).count] = last_lat + k;
//						(*candidates).lon[(*candidates).count++] = last_lon;
//					}
//			}
//		}
//		//Update coordinates with last value tested
//		last_lat = leftup_lat + (level*2);
//		last_lon = leftup_lon;
//		if( (*candidates).count != 0 ) //If in current level there is at least one candidate then break the for
//			break;
//	}
////	return candidates;
//}
int
isvalid_coor(int lu_lat,int lu_lon)
{
//	if( lu_lat > -90 && lu_lat <= 89 && lu_lon > -180 && lu_lon <= 179 )
//		return 1;
//	else
//		return 0; //No valid range
#ifdef ONEDEGREE_RES
	if( lu_lat > -90 && lu_lat <= 89 && lu_lon > -180 && lu_lon <= 179 )
#endif
#ifdef HALFDEGREE_RES
	if( lu_lat > -180 && lu_lat <= 179 && lu_lon > -360 && lu_lon <= 359 )
#endif
#ifdef QUARTERDEGREE_RES
	if( lu_lat > -360 && lu_lat <= 359 && lu_lon > -720 && lu_lon <= 719 )
#endif
#ifdef EIGHTHDEGREE_RES
	if( lu_lat > -720 && lu_lat <= 719 && lu_lon > -1440 && lu_lon <= 1439 )
#endif
		return 1;
	else
		return 0; //No valid range
}
/*
 * ===  FUNCTION  ======================================================================
 *         Name:  geo_dist_1p2centroids_alg
 *  Description:  Calculate closest point to point P from a list of populations in memory,
 *             this distance calculation is made point by point in the neighborhood regions until
 *             find a region with points in there.
 *  Input:
 *  	P: Point under test.
 *    	points: file name with points(lat lon)which distance to P have  to be measured.
 *  Ouput:
 *  	return: tag of point, and distance choosen town or geofence to point P.
 * =====================================================================================
 */
ClosestPop
geo_dist_1p2centroids_alg_halfdgres( double lat_p, double long_p, nzero_candidates* candidates )
{
	double lat_num,lon_num;		//Lat,long read from every line in file
	char* tag[ MAX_LEN_STR ];
	int i,j; //Counters
	double dmin = 1000000000;
	ClosestPop nearestPop;
	int min_idx, max_idx;
	int curr_dist=0;

//    nzero_candidates candidates;
    int count_cand=0;

	//Clear candidates structure
//	candidates.count = 0;
//	for(count_cand=0;count_cand<361;count_cand++) {
//		candidates.lat[count_cand] = 0;
//		candidates.lon[count_cand] = 0;
//	}

//	candidates = find_nearest_candidates(lat_p,long_p );

	for(j=0; j<(*candidates).count; j++) {
//		min_idx = lon_lat_idxed_pos[180 + (*candidates).lat[j]][360 + (*candidates).lon[j]];
//		max_idx = min_idx + lon_lat_idxed_pos_count[180 + (*candidates).lat[j]][360 + (*candidates).lon[j]];
		min_idx = lon_lat_idxed_pos[RES*90 + (*candidates).lat[j]][RES*180 + (*candidates).lon[j]];
		max_idx = min_idx + lon_lat_idxed_pos_count[RES*90 + (*candidates).lat[j]][RES*180 + (*candidates).lon[j]];
		for(i=min_idx;i<max_idx;i++) {//	while(err != EOF) {
//			lat_num =  buf_lat[i]; //atof(lat);
//			lon_num =  buf_lon[i]; //atof(lon);
			//Determine nearest non-empty neighbor in the map
//			curr_dist = geodistance( lat_p, long_p, lat_num,lon_num );
			curr_dist =  geodistance( lat_p, long_p, buf_lat[i],buf_lon[i] );
			if( curr_dist < dmin ) {
				dmin = curr_dist; //Used without multicore approach
				nearestPop.pop = buf_pop[i]; //Used without multicore approach
			}
		}
	}
	nearestPop.distance = (int) dmin; //distance in m
	return nearestPop ;
}		// -----  end of function geo_dist_1p2centroids  -----
/*
 * ===  FUNCTION  ======================================================================
 *         Name:  find_nearest_candidates_halfdegrees
 *  Description:  Calculate closest point to point P from a list of populations in memory,
 *             this distance calculation is made point by point in the neighborhood regions until
 *             find a region with points in there.
 *  o--->---
 *  |x xx x |
 *     __
 *	|x|xX|x |
 *	|x|xx|x |
 *	|  --
 *	|x xx x |
 *	 ---<---
 * =====================================================================================
 */
//nzero_candidates
//void find_nearest_candidates_halfdgres(double central_lat, double central_lon, nzero_candidates* candidates )
//{
//	//nzero_candidates candidates;
//	int i,j;
//	int count_cand = 0;
//	int level=0;
//	int lat_coar,lon_coar;
//	int leftup_lat,leftup_lon;
//	int k;
//	int last_lat, last_lon;
//	int count_levels=0;
////	coarse coordinates are getting from point under test
//#ifdef ONEDEGREE_RES
//	lat_coar = (int)(central_lat);
//	lon_coar = (int)(central_lon);
//#endif
//#ifdef HALFDEGREE_RES
//	lat_coar = (int)(central_lat * 2);
//	lon_coar = (int)(central_lon * 2);
//#endif
//#ifdef QUARTERDEGREE_RES
//	lat_coar = (int)(central_lat * 4);
//	lon_coar = (int)(central_lon * 4);
//#endif
////	lat_coar = (int)central_lat;
////	lon_coar = (int)central_lon;
////	lat_coar = lat_coar * 2; //Change to half degree resolution
////	lon_coar = lon_coar * 2; //Change to half degree resolution
//
////	coarse_point coarpoint;
//	(*candidates).count = 0;
//	for( level=0; level<360 ;level++) //Level is swept
//	{
//	    //Get leftup quadrant coordinates
//		leftup_lat = lat_coar + level ;
//		leftup_lon = lon_coar - (level+1) ;
//
//		//Search for valid candidates
//		for( k=0; k<=(level*2+1); k++) //Forward to right
//		{
//			if(isvalid_coor_halfdgres(leftup_lat ,leftup_lon + k ) != 0) //If it is valid is stored in array and counter is incremented
//			{
//					if(lon_lat_idxed_pos_count[180 + leftup_lat][360 + leftup_lon + k] != 0)//Test if it is a non empty quadrant
//					{
//						(*candidates).lat[(*candidates).count] = leftup_lat;
//						(*candidates).lon[(*candidates).count++] = leftup_lon + k;
//					}
//			}
//		}
//		//Update coordinates with last value tested
//		last_lat = leftup_lat;
//		last_lon = leftup_lon + (level*2+1);
//		for( k=1; k<=(level*2+1); k++) //right to down
//		{
//			if(isvalid_coor_halfdgres(last_lat - k,last_lon) != 0) //If it is valid is stored in array and counter is incremented
//			{
//					if(lon_lat_idxed_pos_count[180 + last_lat - k][360 + last_lon] != 0)//Test if it is a non empty quadrant
//					{
//						(*candidates).lat[(*candidates).count] = last_lat - k;
//						(*candidates).lon[(*candidates).count++] = last_lon;
//					}
//			}
//		}
//		//Update coordinates with last value tested
//		last_lat = last_lat - (level*2+1);
//		last_lon = last_lon;
//		for( k=1; k<=(level*2+1); k++) //down to left
//		{
//			if(isvalid_coor_halfdgres(last_lat ,last_lon -k ) != 0) //If it is valid is stored in array and counter is incremented
//			{
//					if(lon_lat_idxed_pos_count[180 + last_lat][360 + last_lon - k] != 0) //Test if it is a non empty quadrant
//					{
//						(*candidates).lat[(*candidates).count] = last_lat;
//						(*candidates).lon[(*candidates).count++] = last_lon - k;
//					}
//			}
//		}
//		//Update coordinates with last value tested
//		last_lat = last_lat;
//		last_lon = last_lon - (level*2+1);
//		for( k=1; k<=(level*2); k++) //left to up:1 instead 2 because 2 consider first element
//		{
//			if(isvalid_coor_halfdgres(last_lat + k, last_lon) != 0) //If it is valid is stored in array and counter is incremented
//			{
//					if(lon_lat_idxed_pos_count[180 + last_lat + k][360 + last_lon] != 0)//Test if it is a non empty quadrant
//					{
//						(*candidates).lat[(*candidates).count] = last_lat + k;
//						(*candidates).lon[(*candidates).count++] = last_lon;
//					}
//			}
//		}
//		//Update coordinates with last value tested
//		last_lat = leftup_lat + (level*2);
//		last_lon = leftup_lon;
//		if( (*candidates).count != 0 ) //If in current level there is at least one candidate then break the for
//		{
//			count_levels++;
//			//S:Added code
//			if(count_levels == 2 || level ==359)
//			{
//				break;
//			}
//			//E:Added code
//			//break;
//		}
//	}
////	return candidates;
//}
/*
 * ===  FUNCTION  ======================================================================
 *         Name:  find_nearest_candidates_halfdegrees
 *  Description:  Calculate closest point to point P from a list of populations in memory,
 *             this distance calculation is made point by point in the neighborhood regions until
 *             find a region with points in there.
 *  o--->---
 *  |x xx x |
 *     __
 *	|x|xX|x |
 *	|x|xx|x |
 *	|  --
 *	|x xx x |
 *	 ---<---
 * =====================================================================================
 */
//nzero_candidates
void find_nearest_candidates_halfdgres(double central_lat, double central_lon, nzero_candidates* candidates )
{
	//nzero_candidates candidates;
	int i,j;
	int count_cand = 0;
	int level=0;
	int lat_coar,lon_coar;
	int leftup_lat,leftup_lon;
	int k;
	int last_lat, last_lon;
	int count_levels=0;
//	int RES = 2;//RES=4 1/4degree resolution, RES=2 1/2 degree resolution,RES=1 one degree resolution
//	coarse coordinates are getting from point under test
//#ifdef ONEDEGREE_RES
//	lat_coar = (int)(central_lat);
//	lon_coar = (int)(central_lon);
//#endif
//#ifdef HALFDEGREE_RES
//	lat_coar = (int)(central_lat * 2);
//	lon_coar = (int)(central_lon * 2);
//#endif
//#ifdef QUARTERDEGREE_RES
//	lat_coar = (int)(central_lat * 4);
//	lon_coar = (int)(central_lon * 4);
//#endif
	lat_coar = (int)(central_lat * RES);
	lon_coar = (int)(central_lon * RES);
//	lat_coar = (int)central_lat;
//	lon_coar = (int)central_lon;
//	lat_coar = lat_coar * 2; //Change to half degree resolution
//	lon_coar = lon_coar * 2; //Change to half degree resolution

//	coarse_point coarpoint;
	(*candidates).count = 0;
	for( level=0; level<RES*180 ;level++) //Level is swept
	{
	    //Get leftup quadrant coordinates
		leftup_lat = lat_coar + level ;
		leftup_lon = lon_coar - (level+1) ;

		//Search for valid candidates
		for( k=0; k<=(level*2+1); k++) //Forward to right
		{
			if(isvalid_coor(leftup_lat ,leftup_lon + k ) != 0) //If it is valid is stored in array and counter is incremented
			{
					if(lon_lat_idxed_pos_count[RES*90 + leftup_lat][RES*180 + leftup_lon + k] != 0)//Test if it is a non empty quadrant
					{
						(*candidates).lat[(*candidates).count] = leftup_lat;
						(*candidates).lon[(*candidates).count++] = leftup_lon + k;
					}
			}
		}
		//Update coordinates with last value tested
		last_lat = leftup_lat;
		last_lon = leftup_lon + (level*2+1);
		for( k=1; k<=(level*2+1); k++) //right to down
		{
			if(isvalid_coor(last_lat - k,last_lon) != 0) //If it is valid is stored in array and counter is incremented
			{
					if(lon_lat_idxed_pos_count[RES*90 + last_lat - k][RES*180 + last_lon] != 0)//Test if it is a non empty quadrant
					{
						(*candidates).lat[(*candidates).count] = last_lat - k;
						(*candidates).lon[(*candidates).count++] = last_lon;
					}
			}
		}
		//Update coordinates with last value tested
		last_lat = last_lat - (level*2+1);
		last_lon = last_lon;
		for( k=1; k<=(level*2+1); k++) //down to left
		{
			if(isvalid_coor(last_lat ,last_lon -k ) != 0) //If it is valid is stored in array and counter is incremented
			{
					if(lon_lat_idxed_pos_count[RES*90 + last_lat][RES*180 + last_lon - k] != 0) //Test if it is a non empty quadrant
					{
						(*candidates).lat[(*candidates).count] = last_lat;
						(*candidates).lon[(*candidates).count++] = last_lon - k;
					}
			}
		}
		//Update coordinates with last value tested
		last_lat = last_lat;
		last_lon = last_lon - (level*2+1);
		for( k=1; k<=(level*2); k++) //left to up:1 instead 2 because 2 consider first element
		{
			if(isvalid_coor(last_lat + k, last_lon) != 0) //If it is valid is stored in array and counter is incremented
			{
					if(lon_lat_idxed_pos_count[RES*90 + last_lat + k][RES*180 + last_lon] != 0)//Test if it is a non empty quadrant
					{
						(*candidates).lat[(*candidates).count] = last_lat + k;
						(*candidates).lon[(*candidates).count++] = last_lon;
					}
			}
		}
		//Update coordinates with last value tested
		last_lat = leftup_lat + (level*2);
		last_lon = leftup_lon;
		if( (*candidates).count != 0 ) //If in current level there is at least one candidate then break the for
		{
			count_levels++;
			//S:Added code
			if(count_levels == 2 || level ==(RES*180 -1))
			{
				break;
			}
			//E:Added code
			//break;
		}
	}
//	return candidates;
}
void
ini_idxed_arrays()
{
#ifdef ONEDEGREE_RES
    //                  0 - 181     0 - 361
    lon_lat_idxed_pos[ 90  + 21 ][ 180 - 98 ] =    0 ;
    lon_lat_idxed_pos[ 90  + 20 ][ 180 - 98 ] =  851 ;
    lon_lat_idxed_pos[ 90  + 19 ][ 180 - 98 ] = 2947 ;
    lon_lat_idxed_pos[ 90  + 18 ][ 180 - 98 ] = 4622 ;
    lon_lat_idxed_pos[ 90  + 21 ][ 180 - 99 ] = 4670 ;
    lon_lat_idxed_pos[ 90  + 20 ][ 180 - 99 ] = 4836 ;
    lon_lat_idxed_pos[ 90  + 19 ][ 180 - 99 ] = 6336 ;
    lon_lat_idxed_pos[ 90  + 18 ][ 180 - 99 ] = 8536 ;
    lon_lat_idxed_pos[ 90  + 20 ][ 180 - 100 ] = 9029 ;
    lon_lat_idxed_pos[ 90  + 19 ][ 180 - 100 ] = 9045 ;
    lon_lat_idxed_pos[ 90  + 18 ][ 180 - 100 ] = 9747 ;
    //All other values of longitude and latitude are zero

    lon_lat_idxed_pos_count[ 90  + 21 ][ 180 - 98 ] =  851 ;
    lon_lat_idxed_pos_count[ 90  + 20 ][ 180 - 98 ] = 2096 ;
    lon_lat_idxed_pos_count[ 90  + 19 ][ 180 - 98 ] = 1675 ;
    lon_lat_idxed_pos_count[ 90  + 18 ][ 180 - 98 ] =   48 ;
    lon_lat_idxed_pos_count[ 90  + 21 ][ 180 - 99 ] =  166 ;
    lon_lat_idxed_pos_count[ 90  + 20 ][ 180 - 99 ] = 1500 ;
    lon_lat_idxed_pos_count[ 90  + 19 ][ 180 - 99 ] = 2200 ;
    lon_lat_idxed_pos_count[ 90  + 18 ][ 180 - 99 ] =  493 ;
    lon_lat_idxed_pos_count[ 90  + 20 ][ 180 - 100] =   16 ;
    lon_lat_idxed_pos_count[ 90  + 19 ][ 180 - 100] =  702 ;
    lon_lat_idxed_pos_count[ 90  + 18 ][ 180 - 100] =  793 ;
#endif
#ifdef HALFDEGREE_RES
	//For a half degree resolution
    lon_lat_idxed_pos[ 180  + 42 ][ 360 - 196] = 0    ;
    lon_lat_idxed_pos[ 180  + 41 ][ 360 - 196] = 233  ;
    lon_lat_idxed_pos[ 180  + 40 ][ 360 - 196] = 453  ;
    lon_lat_idxed_pos[ 180  + 39 ][ 360 - 196] = 1002 ;
    lon_lat_idxed_pos[ 180  + 42 ][ 360 - 197] = 1338 ;
    lon_lat_idxed_pos[ 180  + 41 ][ 360 - 197] = 1956 ;
    lon_lat_idxed_pos[ 180  + 40 ][ 360 - 197] = 2594 ;
    lon_lat_idxed_pos[ 180  + 39 ][ 360 - 197] = 3283 ;
    lon_lat_idxed_pos[ 180  + 38 ][ 360 - 197 ] =4086  ;
    lon_lat_idxed_pos[ 180  + 37 ][ 360 - 197 ] =4622  ;
    lon_lat_idxed_pos[ 180  + 42 ][ 360 - 198 ] =4670 ;
    lon_lat_idxed_pos[ 180  + 41 ][ 360 - 198 ] =4836 ;
    lon_lat_idxed_pos[ 180  + 40 ][ 360 - 198 ] =5337 ;
    lon_lat_idxed_pos[ 180  + 39 ][ 360 - 198 ] =5872 ;
    lon_lat_idxed_pos[ 180  + 38 ][ 360 - 198 ] =6486 ;
    lon_lat_idxed_pos[ 180  + 37 ][ 360 - 198 ] =6822 ;
    lon_lat_idxed_pos[ 180  + 41 ][ 360 - 199 ] =6893 ;
    lon_lat_idxed_pos[ 180  + 40 ][ 360 - 199 ] =6957 ;
    lon_lat_idxed_pos[ 180  + 39 ][ 360 - 199 ] =7357 ;
    lon_lat_idxed_pos[ 180  + 38 ][ 360 - 199 ] =7958 ;
    lon_lat_idxed_pos[ 180  + 37 ][ 360 - 199 ] =8607 ;
    lon_lat_idxed_pos[ 180  + 40 ][ 360 - 200 ] =9029 ;
    lon_lat_idxed_pos[ 180  + 39 ][ 360 - 200 ] =9045 ;
    lon_lat_idxed_pos[ 180  + 38 ][ 360 - 200 ] =9326 ;
    lon_lat_idxed_pos[ 180  + 37 ][ 360 - 200 ] =9747 ;
    lon_lat_idxed_pos[ 180  + 36 ][ 360 - 200 ] =10449;
    lon_lat_idxed_pos[ 180  + 37 ][ 360 - 201 ] =10484;
    //All other values of longitude and latitude are zero

    lon_lat_idxed_pos_count[ 180  + 42 ][ 360 - 196] =	233  ;
    lon_lat_idxed_pos_count[ 180  + 41 ][ 360 - 196] =	220  ;
    lon_lat_idxed_pos_count[ 180  + 40 ][ 360 - 196] =	549  ;
    lon_lat_idxed_pos_count[ 180  + 39 ][ 360 - 196] =	336  ;
    lon_lat_idxed_pos_count[ 180  + 42 ][ 360 - 197] =	618  ;
    lon_lat_idxed_pos_count[ 180  + 41 ][ 360 - 197] =	638  ;
    lon_lat_idxed_pos_count[ 180  + 40 ][ 360 - 197] =	689  ;
    lon_lat_idxed_pos_count[ 180  + 39 ][ 360 - 197] =	803  ;
    lon_lat_idxed_pos_count[ 180  + 38 ][ 360 - 197 ] =	536  ;
    lon_lat_idxed_pos_count[ 180  + 37 ][ 360 - 197 ] =	48   ;
    lon_lat_idxed_pos_count[ 180  + 42 ][ 360 - 198 ] =	166 ;
    lon_lat_idxed_pos_count[ 180  + 41 ][ 360 - 198 ] =	501 ;
    lon_lat_idxed_pos_count[ 180  + 40 ][ 360 - 198 ] =	535 ;
    lon_lat_idxed_pos_count[ 180  + 39 ][ 360 - 198 ] =	614 ;
    lon_lat_idxed_pos_count[ 180  + 38 ][ 360 - 198 ] =	336 ;
    lon_lat_idxed_pos_count[ 180  + 37 ][ 360 - 198 ] =	71  ;
    lon_lat_idxed_pos_count[ 180  + 41 ][ 360 - 199 ] =	64  ;
    lon_lat_idxed_pos_count[ 180  + 40 ][ 360 - 199 ] =	400 ;
    lon_lat_idxed_pos_count[ 180  + 39 ][ 360 - 199 ] =	601 ;
    lon_lat_idxed_pos_count[ 180  + 38 ][ 360 - 199 ] =	649 ;
    lon_lat_idxed_pos_count[ 180  + 37 ][ 360 - 199 ] =	422 ;
    lon_lat_idxed_pos_count[ 180  + 40 ][ 360 - 200 ] =	16  ;
    lon_lat_idxed_pos_count[ 180  + 39 ][ 360 - 200 ] =	281 ;
    lon_lat_idxed_pos_count[ 180  + 38 ][ 360 - 200 ] =	421 ;
    lon_lat_idxed_pos_count[ 180  + 37 ][ 360 - 200 ] =	702 ;
    lon_lat_idxed_pos_count[ 180  + 36 ][ 360 - 200 ] =	35  ;
    lon_lat_idxed_pos_count[ 180  + 37 ][ 360 - 201 ] =	56  ;
#endif
#ifdef QUARTERDEGREE_RES
// For a quarter of grade resolution
    lon_lat_idxed_pos[360 + 84][720-392] = 		0;
    lon_lat_idxed_pos[360 + 83][720-392] = 		30;
    lon_lat_idxed_pos[360 + 82][720-392] = 		40;
    lon_lat_idxed_pos[360 + 81][720-392] = 		113;
    lon_lat_idxed_pos[360 + 80][720-392] = 		285;
    lon_lat_idxed_pos[360 + 79][720-392] = 		350;
    lon_lat_idxed_pos[360 + 85][720-393] = 		365;
    lon_lat_idxed_pos[360 + 84][720-393] = 		367;
    lon_lat_idxed_pos[360 + 83][720-393] = 		568;
    lon_lat_idxed_pos[360 + 82][720-393] = 		697;
    lon_lat_idxed_pos[360 + 81][720-393] = 		705;
    lon_lat_idxed_pos[360 + 80][720-393] = 		819;
    lon_lat_idxed_pos[360 + 79][720-393] = 		1017;
    lon_lat_idxed_pos[360 + 78][720-393] = 		1221;
    lon_lat_idxed_pos[360 + 85][720-394] = 		1338;
    lon_lat_idxed_pos[360 + 84][720-394] = 		1395;
    lon_lat_idxed_pos[360 + 83][720-394] = 		1700;
    lon_lat_idxed_pos[360 + 82][720-394] = 		1937;
    lon_lat_idxed_pos[360 + 81][720-394] = 		2058;
    lon_lat_idxed_pos[360 + 80][720-394] = 		2166;
    lon_lat_idxed_pos[360 + 79][720-394] = 		2470;
    lon_lat_idxed_pos[360 + 78][720-394] = 		2706;
    lon_lat_idxed_pos[360 + 77][720-394] = 		2792;
    lon_lat_idxed_pos[360 + 76][720-394] = 		2799;
    lon_lat_idxed_pos[360 + 75][720-394] = 		2833;
    lon_lat_idxed_pos[360 + 85][720-395] = 		2835;
    lon_lat_idxed_pos[360 + 84][720-395] = 		2851;
    lon_lat_idxed_pos[360 + 83][720-395] = 		3091;
    lon_lat_idxed_pos[360 + 82][720-395] = 		3255;
    lon_lat_idxed_pos[360 + 81][720-395] = 		3371;
    lon_lat_idxed_pos[360 + 80][720-395] = 		3457;
    lon_lat_idxed_pos[360 + 79][720-395] = 		3648;
    lon_lat_idxed_pos[360 + 78][720-395] = 		3842;
    lon_lat_idxed_pos[360 + 77][720-395] = 		4129;
    lon_lat_idxed_pos[360 + 76][720-395] = 		4314;
    lon_lat_idxed_pos[360 + 75][720-395] = 		4624;
    lon_lat_idxed_pos[360 + 85][720-396] = 		4670;
    lon_lat_idxed_pos[360 + 84][720-396] = 		4677;
    lon_lat_idxed_pos[360 + 83][720-396] = 		4826;
    lon_lat_idxed_pos[360 + 82][720-396] = 		4946;
    lon_lat_idxed_pos[360 + 81][720-396] = 		5099;
    lon_lat_idxed_pos[360 + 80][720-396] = 		5225;
    lon_lat_idxed_pos[360 + 79][720-396] = 		5389;
    lon_lat_idxed_pos[360 + 78][720-396] = 		5580;
    lon_lat_idxed_pos[360 + 77][720-396] = 		5715;
    lon_lat_idxed_pos[360 + 84][720-397] = 		5720;
    lon_lat_idxed_pos[360 + 83][720-397] = 		5730;
    lon_lat_idxed_pos[360 + 82][720-397] = 		5823;
    lon_lat_idxed_pos[360 + 81][720-397] = 		5958;
    lon_lat_idxed_pos[360 + 80][720-397] = 		6067;
    lon_lat_idxed_pos[360 + 79][720-397] = 		6203;
    lon_lat_idxed_pos[360 + 78][720-397] = 		6337;
    lon_lat_idxed_pos[360 + 77][720-397] = 		6491;
    lon_lat_idxed_pos[360 + 76][720-397] = 		6722;
    lon_lat_idxed_pos[360 + 75][720-397] = 		6822;
    lon_lat_idxed_pos[360 + 74][720-397] = 		6891;
    lon_lat_idxed_pos[360 + 82][720-398] = 		6893;
    lon_lat_idxed_pos[360 + 81][720-398] = 		6951;
    lon_lat_idxed_pos[360 + 80][720-398] = 		7083;
    lon_lat_idxed_pos[360 + 79][720-398] = 		7201;
    lon_lat_idxed_pos[360 + 78][720-398] = 		7310;
    lon_lat_idxed_pos[360 + 77][720-398] = 		7462;
    lon_lat_idxed_pos[360 + 76][720-398] = 		7687;
    lon_lat_idxed_pos[360 + 75][720-398] = 		7873;
    lon_lat_idxed_pos[360 + 74][720-398] = 		8048;
    lon_lat_idxed_pos[360 + 82][720-399] = 		8055;
    lon_lat_idxed_pos[360 + 81][720-399] = 		8061;
    lon_lat_idxed_pos[360 + 80][720-399] = 		8108;
    lon_lat_idxed_pos[360 + 79][720-399] = 		8211;
    lon_lat_idxed_pos[360 + 78][720-399] = 		8381;
    lon_lat_idxed_pos[360 + 77][720-399] = 		8551;
    lon_lat_idxed_pos[360 + 76][720-399] = 		8714;
    lon_lat_idxed_pos[360 + 75][720-399] = 		8789;
    lon_lat_idxed_pos[360 + 74][720-399] = 		8948;
    lon_lat_idxed_pos[360 + 80][720-400] = 		9029;
    lon_lat_idxed_pos[360 + 79][720-400] = 		9045;
    lon_lat_idxed_pos[360 + 78][720-400] = 		9128;
    lon_lat_idxed_pos[360 + 77][720-400] = 		9324;
    lon_lat_idxed_pos[360 + 76][720-400] = 		9463;
    lon_lat_idxed_pos[360 + 75][720-400] = 		9587;
    lon_lat_idxed_pos[360 + 74][720-400] = 		9760;
    lon_lat_idxed_pos[360 + 73][720-400] = 		9903;
    lon_lat_idxed_pos[360 + 78][720-401] = 		9913;
    lon_lat_idxed_pos[360 + 77][720-401] = 		9915;
    lon_lat_idxed_pos[360 + 76][720-401] = 		9938;
    lon_lat_idxed_pos[360 + 75][720-401] = 		10073;
    lon_lat_idxed_pos[360 + 74][720-401] = 		10271;
    lon_lat_idxed_pos[360 + 73][720-401] = 		10459;
    lon_lat_idxed_pos[360 + 75][720-402] = 		10484;
        //Other values of longitude and latitude are zero;

    lon_lat_idxed_pos_count[360 + 84][720-392] = 		30;
    lon_lat_idxed_pos_count[360 + 83][720-392] = 		10;
    lon_lat_idxed_pos_count[360 + 82][720-392] = 		73;
    lon_lat_idxed_pos_count[360 + 81][720-392] = 		172;
    lon_lat_idxed_pos_count[360 + 80][720-392] = 		65;
    lon_lat_idxed_pos_count[360 + 79][720-392] = 		15;
    lon_lat_idxed_pos_count[360 + 85][720-393] = 		2;
    lon_lat_idxed_pos_count[360 + 84][720-393] = 		201;
    lon_lat_idxed_pos_count[360 + 83][720-393] = 		129;
    lon_lat_idxed_pos_count[360 + 82][720-393] = 		8;
    lon_lat_idxed_pos_count[360 + 81][720-393] = 		114;
    lon_lat_idxed_pos_count[360 + 80][720-393] = 		198;
    lon_lat_idxed_pos_count[360 + 79][720-393] = 		204;
    lon_lat_idxed_pos_count[360 + 78][720-393] = 		117;
    lon_lat_idxed_pos_count[360 + 85][720-394] = 		57;
    lon_lat_idxed_pos_count[360 + 84][720-394] = 		305;
    lon_lat_idxed_pos_count[360 + 83][720-394] = 		237;
    lon_lat_idxed_pos_count[360 + 82][720-394] = 		121;
    lon_lat_idxed_pos_count[360 + 81][720-394] = 		108;
    lon_lat_idxed_pos_count[360 + 80][720-394] = 		304;
    lon_lat_idxed_pos_count[360 + 79][720-394] = 		236;
    lon_lat_idxed_pos_count[360 + 78][720-394] = 		86;
    lon_lat_idxed_pos_count[360 + 77][720-394] = 		7;
    lon_lat_idxed_pos_count[360 + 76][720-394] = 		34;
    lon_lat_idxed_pos_count[360 + 75][720-394] = 		2;
    lon_lat_idxed_pos_count[360 + 85][720-395] = 		16;
    lon_lat_idxed_pos_count[360 + 84][720-395] = 		240;
    lon_lat_idxed_pos_count[360 + 83][720-395] = 		164;
    lon_lat_idxed_pos_count[360 + 82][720-395] = 		116;
    lon_lat_idxed_pos_count[360 + 81][720-395] = 		86;
    lon_lat_idxed_pos_count[360 + 80][720-395] = 		191;
    lon_lat_idxed_pos_count[360 + 79][720-395] = 		194;
    lon_lat_idxed_pos_count[360 + 78][720-395] = 		287;
    lon_lat_idxed_pos_count[360 + 77][720-395] = 		185;
    lon_lat_idxed_pos_count[360 + 76][720-395] = 		310;
    lon_lat_idxed_pos_count[360 + 75][720-395] = 		46;
    lon_lat_idxed_pos_count[360 + 85][720-396] = 		7;
    lon_lat_idxed_pos_count[360 + 84][720-396] = 		149;
    lon_lat_idxed_pos_count[360 + 83][720-396] = 		120;
    lon_lat_idxed_pos_count[360 + 82][720-396] = 		153;
    lon_lat_idxed_pos_count[360 + 81][720-396] = 		126;
    lon_lat_idxed_pos_count[360 + 80][720-396] = 		164;
    lon_lat_idxed_pos_count[360 + 79][720-396] = 		191;
    lon_lat_idxed_pos_count[360 + 78][720-396] = 		135;
    lon_lat_idxed_pos_count[360 + 77][720-396] = 		5;
    lon_lat_idxed_pos_count[360 + 84][720-397] = 		10;
    lon_lat_idxed_pos_count[360 + 83][720-397] = 		93;
    lon_lat_idxed_pos_count[360 + 82][720-397] = 		135;
    lon_lat_idxed_pos_count[360 + 81][720-397] = 		109;
    lon_lat_idxed_pos_count[360 + 80][720-397] = 		136;
    lon_lat_idxed_pos_count[360 + 79][720-397] = 		134;
    lon_lat_idxed_pos_count[360 + 78][720-397] = 		154;
    lon_lat_idxed_pos_count[360 + 77][720-397] = 		231;
    lon_lat_idxed_pos_count[360 + 76][720-397] = 		100;
    lon_lat_idxed_pos_count[360 + 75][720-397] = 		69;
    lon_lat_idxed_pos_count[360 + 74][720-397] = 		2;
    lon_lat_idxed_pos_count[360 + 82][720-398] = 		58;
    lon_lat_idxed_pos_count[360 + 81][720-398] = 		132;
    lon_lat_idxed_pos_count[360 + 80][720-398] = 		118;
    lon_lat_idxed_pos_count[360 + 79][720-398] = 		109;
    lon_lat_idxed_pos_count[360 + 78][720-398] = 		152;
    lon_lat_idxed_pos_count[360 + 77][720-398] = 		225;
    lon_lat_idxed_pos_count[360 + 76][720-398] = 		186;
    lon_lat_idxed_pos_count[360 + 75][720-398] = 		175;
    lon_lat_idxed_pos_count[360 + 74][720-398] = 		7;
    lon_lat_idxed_pos_count[360 + 82][720-399] = 		6;
    lon_lat_idxed_pos_count[360 + 81][720-399] = 		47;
    lon_lat_idxed_pos_count[360 + 80][720-399] = 		103;
    lon_lat_idxed_pos_count[360 + 79][720-399] = 		170;
    lon_lat_idxed_pos_count[360 + 78][720-399] = 		170;
    lon_lat_idxed_pos_count[360 + 77][720-399] = 		163;
    lon_lat_idxed_pos_count[360 + 76][720-399] = 		75;
    lon_lat_idxed_pos_count[360 + 75][720-399] = 		159;
    lon_lat_idxed_pos_count[360 + 74][720-399] = 		81;
    lon_lat_idxed_pos_count[360 + 80][720-400] = 		16;
    lon_lat_idxed_pos_count[360 + 79][720-400] = 		83;
    lon_lat_idxed_pos_count[360 + 78][720-400] = 		196;
    lon_lat_idxed_pos_count[360 + 77][720-400] = 		139;
    lon_lat_idxed_pos_count[360 + 76][720-400] = 		124;
    lon_lat_idxed_pos_count[360 + 75][720-400] = 		173;
    lon_lat_idxed_pos_count[360 + 74][720-400] = 		143;
    lon_lat_idxed_pos_count[360 + 73][720-400] = 		10;
    lon_lat_idxed_pos_count[360 + 78][720-401] = 		2;
    lon_lat_idxed_pos_count[360 + 77][720-401] = 		23;
    lon_lat_idxed_pos_count[360 + 76][720-401] = 		135;
    lon_lat_idxed_pos_count[360 + 75][720-401] = 		198;
    lon_lat_idxed_pos_count[360 + 74][720-401] = 		188;
    lon_lat_idxed_pos_count[360 + 73][720-401] = 		25;
    lon_lat_idxed_pos_count[360 + 75][720-402] = 		56;
#endif
        //Other values of longitude and latitude are zero
#ifdef EIGHTHDEGREE_RES
    lon_lat_idxed_pos[720+165][1440-785] =  	0;
    lon_lat_idxed_pos[720+164][1440-785] =  	6;
    lon_lat_idxed_pos[720+163][1440-785] =  	59;
    lon_lat_idxed_pos[720+162][1440-785] =  	105;
    lon_lat_idxed_pos[720+161][1440-785] =  	107;
    lon_lat_idxed_pos[720+169][1440-786] =  	110;
    lon_lat_idxed_pos[720+168][1440-786] =  	113;
    lon_lat_idxed_pos[720+167][1440-786] =  	141;
    lon_lat_idxed_pos[720+166][1440-786] =  	150;
    lon_lat_idxed_pos[720+164][1440-786] =  	151;
    lon_lat_idxed_pos[720+163][1440-786] =  	165;
    lon_lat_idxed_pos[720+162][1440-786] =  	259;
    lon_lat_idxed_pos[720+161][1440-786] =  	289;
    lon_lat_idxed_pos[720+160][1440-786] =  	333;
    lon_lat_idxed_pos[720+159][1440-786] =  	351;
    lon_lat_idxed_pos[720+158][1440-786] =  	365;
    lon_lat_idxed_pos[720+169][1440-787] =  	366;
    lon_lat_idxed_pos[720+168][1440-787] =  	382;
    lon_lat_idxed_pos[720+167][1440-787] =  	443;
    lon_lat_idxed_pos[720+166][1440-787] =  	487;
    lon_lat_idxed_pos[720+163][1440-787] =  	513;
    lon_lat_idxed_pos[720+162][1440-787] =  	549;
    lon_lat_idxed_pos[720+161][1440-787] =  	589;
    lon_lat_idxed_pos[720+160][1440-787] =  	635;
    lon_lat_idxed_pos[720+159][1440-787] =  	689;
    lon_lat_idxed_pos[720+158][1440-787] =  	732;
    lon_lat_idxed_pos[720+157][1440-787] =  	800;
    lon_lat_idxed_pos[720+171][1440-788] =  	833;
    lon_lat_idxed_pos[720+170][1440-788] =  	834;
    lon_lat_idxed_pos[720+169][1440-788] =  	835;
    lon_lat_idxed_pos[720+168][1440-788] =  	877;
    lon_lat_idxed_pos[720+167][1440-788] =  	958;
    lon_lat_idxed_pos[720+166][1440-788] =  	997;
    lon_lat_idxed_pos[720+165][1440-788] =  	1017;
    lon_lat_idxed_pos[720+163][1440-788] =  	1025;
    lon_lat_idxed_pos[720+162][1440-788] =  	1026;
    lon_lat_idxed_pos[720+161][1440-788] =  	1063;
    lon_lat_idxed_pos[720+160][1440-788] =  	1103;
    lon_lat_idxed_pos[720+159][1440-788] =  	1161;
    lon_lat_idxed_pos[720+158][1440-788] =  	1195;
    lon_lat_idxed_pos[720+157][1440-788] =  	1254;
    lon_lat_idxed_pos[720+171][1440-789] =  	1339;
    lon_lat_idxed_pos[720+170][1440-789] =  	1341;
    lon_lat_idxed_pos[720+169][1440-789] =  	1389;
    lon_lat_idxed_pos[720+168][1440-789] =  	1500;
    lon_lat_idxed_pos[720+167][1440-789] =  	1610;
    lon_lat_idxed_pos[720+166][1440-789] =  	1692;
    lon_lat_idxed_pos[720+165][1440-789] =  	1742;
    lon_lat_idxed_pos[720+164][1440-789] =  	1770;
    lon_lat_idxed_pos[720+163][1440-789] =  	1784;
    lon_lat_idxed_pos[720+162][1440-789] =  	1802;
    lon_lat_idxed_pos[720+161][1440-789] =  	1830;
    lon_lat_idxed_pos[720+160][1440-789] =  	1876;
    lon_lat_idxed_pos[720+159][1440-789] =  	1938;
    lon_lat_idxed_pos[720+158][1440-789] =  	2030;
    lon_lat_idxed_pos[720+157][1440-789] =  	2093;
    lon_lat_idxed_pos[720+156][1440-789] =  	2125;
    lon_lat_idxed_pos[720+170][1440-790] =  	2128;
    lon_lat_idxed_pos[720+169][1440-790] =  	2135;
    lon_lat_idxed_pos[720+168][1440-790] =  	2163;
    lon_lat_idxed_pos[720+167][1440-790] =  	2219;
    lon_lat_idxed_pos[720+166][1440-790] =  	2272;
    lon_lat_idxed_pos[720+165][1440-790] =  	2324;
    lon_lat_idxed_pos[720+164][1440-790] =  	2363;
    lon_lat_idxed_pos[720+163][1440-790] =  	2403;
    lon_lat_idxed_pos[720+162][1440-790] =  	2439;
    lon_lat_idxed_pos[720+161][1440-790] =  	2465;
    lon_lat_idxed_pos[720+160][1440-790] =  	2538;
    lon_lat_idxed_pos[720+159][1440-790] =  	2661;
    lon_lat_idxed_pos[720+158][1440-790] =  	2712;
    lon_lat_idxed_pos[720+157][1440-790] =  	2742;
    lon_lat_idxed_pos[720+156][1440-790] =  	2777;
    lon_lat_idxed_pos[720+155][1440-790] =  	2792;
    lon_lat_idxed_pos[720+154][1440-790] =  	2793;
    lon_lat_idxed_pos[720+153][1440-790] =  	2799;
    lon_lat_idxed_pos[720+152][1440-790] =  	2806;
    lon_lat_idxed_pos[720+151][1440-790] =  	2833;
    lon_lat_idxed_pos[720+169][1440-791] =  	2835;
    lon_lat_idxed_pos[720+168][1440-791] =  	2867;
    lon_lat_idxed_pos[720+167][1440-791] =  	2918;
    lon_lat_idxed_pos[720+166][1440-791] =  	2951;
    lon_lat_idxed_pos[720+165][1440-791] =  	2982;
    lon_lat_idxed_pos[720+164][1440-791] =  	3010;
    lon_lat_idxed_pos[720+163][1440-791] =  	3050;
    lon_lat_idxed_pos[720+162][1440-791] =  	3064;
    lon_lat_idxed_pos[720+161][1440-791] =  	3082;
    lon_lat_idxed_pos[720+160][1440-791] =  	3122;
    lon_lat_idxed_pos[720+159][1440-791] =  	3192;
    lon_lat_idxed_pos[720+158][1440-791] =  	3242;
    lon_lat_idxed_pos[720+157][1440-791] =  	3275;
    lon_lat_idxed_pos[720+156][1440-791] =  	3354;
    lon_lat_idxed_pos[720+155][1440-791] =  	3423;
    lon_lat_idxed_pos[720+154][1440-791] =  	3462;
    lon_lat_idxed_pos[720+153][1440-791] =  	3518;
    lon_lat_idxed_pos[720+152][1440-791] =  	3678;
    lon_lat_idxed_pos[720+151][1440-791] =  	3768;
    lon_lat_idxed_pos[720+170][1440-792] =  	3814;
    lon_lat_idxed_pos[720+169][1440-792] =  	3830;
    lon_lat_idxed_pos[720+168][1440-792] =  	3922;
    lon_lat_idxed_pos[720+167][1440-792] =  	3988;
    lon_lat_idxed_pos[720+166][1440-792] =  	4057;
    lon_lat_idxed_pos[720+165][1440-792] =  	4088;
    lon_lat_idxed_pos[720+164][1440-792] =  	4108;
    lon_lat_idxed_pos[720+163][1440-792] =  	4136;
    lon_lat_idxed_pos[720+162][1440-792] =  	4155;
    lon_lat_idxed_pos[720+161][1440-792] =  	4190;
    lon_lat_idxed_pos[720+160][1440-792] =  	4241;
    lon_lat_idxed_pos[720+159][1440-792] =  	4271;
    lon_lat_idxed_pos[720+158][1440-792] =  	4321;
    lon_lat_idxed_pos[720+157][1440-792] =  	4382;
    lon_lat_idxed_pos[720+156][1440-792] =  	4465;
    lon_lat_idxed_pos[720+155][1440-792] =  	4521;
    lon_lat_idxed_pos[720+154][1440-792] =  	4581;
    lon_lat_idxed_pos[720+153][1440-792] =  	4611;
    lon_lat_idxed_pos[720+152][1440-792] =  	4657;
    lon_lat_idxed_pos[720+170][1440-793] =  	4671;
    lon_lat_idxed_pos[720+169][1440-793] =  	4678;
    lon_lat_idxed_pos[720+168][1440-793] =  	4723;
    lon_lat_idxed_pos[720+167][1440-793] =  	4799;
    lon_lat_idxed_pos[720+166][1440-793] =  	4826;
    lon_lat_idxed_pos[720+165][1440-793] =  	4846;
    lon_lat_idxed_pos[720+164][1440-793] =  	4882;
    lon_lat_idxed_pos[720+163][1440-793] =  	4904;
    lon_lat_idxed_pos[720+162][1440-793] =  	4913;
    lon_lat_idxed_pos[720+161][1440-793] =  	4953;
    lon_lat_idxed_pos[720+160][1440-793] =  	4999;
    lon_lat_idxed_pos[720+159][1440-793] =  	5007;
    lon_lat_idxed_pos[720+158][1440-793] =  	5025;
    lon_lat_idxed_pos[720+157][1440-793] =  	5117;
    lon_lat_idxed_pos[720+156][1440-793] =  	5169;
    lon_lat_idxed_pos[720+155][1440-793] =  	5182;
    lon_lat_idxed_pos[720+169][1440-794] =  	5186;
    lon_lat_idxed_pos[720+168][1440-794] =  	5189;
    lon_lat_idxed_pos[720+167][1440-794] =  	5213;
    lon_lat_idxed_pos[720+166][1440-794] =  	5240;
    lon_lat_idxed_pos[720+165][1440-794] =  	5287;
    lon_lat_idxed_pos[720+164][1440-794] =  	5320;
    lon_lat_idxed_pos[720+163][1440-794] =  	5382;
    lon_lat_idxed_pos[720+162][1440-794] =  	5422;
    lon_lat_idxed_pos[720+161][1440-794] =  	5459;
    lon_lat_idxed_pos[720+160][1440-794] =  	5519;
    lon_lat_idxed_pos[720+159][1440-794] =  	5569;
    lon_lat_idxed_pos[720+158][1440-794] =  	5605;
    lon_lat_idxed_pos[720+157][1440-794] =  	5650;
    lon_lat_idxed_pos[720+156][1440-794] =  	5712;
    lon_lat_idxed_pos[720+155][1440-794] =  	5720;
    lon_lat_idxed_pos[720+168][1440-795] =  	5721;
    lon_lat_idxed_pos[720+167][1440-795] =  	5731;
    lon_lat_idxed_pos[720+166][1440-795] =  	5755;
    lon_lat_idxed_pos[720+165][1440-795] =  	5789;
    lon_lat_idxed_pos[720+164][1440-795] =  	5834;
    lon_lat_idxed_pos[720+163][1440-795] =  	5871;
    lon_lat_idxed_pos[720+162][1440-795] =  	5912;
    lon_lat_idxed_pos[720+161][1440-795] =  	5927;
    lon_lat_idxed_pos[720+160][1440-795] =  	5964;
    lon_lat_idxed_pos[720+159][1440-795] =  	6013;
    lon_lat_idxed_pos[720+158][1440-795] =  	6066;
    lon_lat_idxed_pos[720+157][1440-795] =  	6094;
    lon_lat_idxed_pos[720+156][1440-795] =  	6140;
    lon_lat_idxed_pos[720+155][1440-795] =  	6163;
    lon_lat_idxed_pos[720+154][1440-795] =  	6249;
    lon_lat_idxed_pos[720+153][1440-795] =  	6274;
    lon_lat_idxed_pos[720+151][1440-795] =  	6277;
    lon_lat_idxed_pos[720+167][1440-796] =  	6285;
    lon_lat_idxed_pos[720+166][1440-796] =  	6291;
    lon_lat_idxed_pos[720+165][1440-796] =  	6319;
    lon_lat_idxed_pos[720+164][1440-796] =  	6357;
    lon_lat_idxed_pos[720+163][1440-796] =  	6372;
    lon_lat_idxed_pos[720+162][1440-796] =  	6393;
    lon_lat_idxed_pos[720+161][1440-796] =  	6425;
    lon_lat_idxed_pos[720+160][1440-796] =  	6450;
    lon_lat_idxed_pos[720+159][1440-796] =  	6475;
    lon_lat_idxed_pos[720+158][1440-796] =  	6499;
    lon_lat_idxed_pos[720+157][1440-796] =  	6528;
    lon_lat_idxed_pos[720+156][1440-796] =  	6577;
    lon_lat_idxed_pos[720+155][1440-796] =  	6613;
    lon_lat_idxed_pos[720+154][1440-796] =  	6667;
    lon_lat_idxed_pos[720+153][1440-796] =  	6733;
    lon_lat_idxed_pos[720+152][1440-796] =  	6810;
    lon_lat_idxed_pos[720+151][1440-796] =  	6830;
    lon_lat_idxed_pos[720+150][1440-796] =  	6875;
    lon_lat_idxed_pos[720+149][1440-796] =  	6891;
    lon_lat_idxed_pos[720+165][1440-797] =  	6893;
    lon_lat_idxed_pos[720+164][1440-797] =  	6896;
    lon_lat_idxed_pos[720+163][1440-797] =  	6919;
    lon_lat_idxed_pos[720+162][1440-797] =  	6960;
    lon_lat_idxed_pos[720+161][1440-797] =  	6974;
    lon_lat_idxed_pos[720+160][1440-797] =  	7013;
    lon_lat_idxed_pos[720+159][1440-797] =  	7027;
    lon_lat_idxed_pos[720+158][1440-797] =  	7059;
    lon_lat_idxed_pos[720+157][1440-797] =  	7084;
    lon_lat_idxed_pos[720+156][1440-797] =  	7107;
    lon_lat_idxed_pos[720+155][1440-797] =  	7141;
    lon_lat_idxed_pos[720+154][1440-797] =  	7231;
    lon_lat_idxed_pos[720+153][1440-797] =  	7263;
    lon_lat_idxed_pos[720+152][1440-797] =  	7337;
    lon_lat_idxed_pos[720+151][1440-797] =  	7382;
    lon_lat_idxed_pos[720+150][1440-797] =  	7450;
    lon_lat_idxed_pos[720+149][1440-797] =  	7474;
    lon_lat_idxed_pos[720+164][1440-798] =  	7476;
    lon_lat_idxed_pos[720+163][1440-798] =  	7508;
    lon_lat_idxed_pos[720+162][1440-798] =  	7544;
    lon_lat_idxed_pos[720+161][1440-798] =  	7585;
    lon_lat_idxed_pos[720+160][1440-798] =  	7627;
    lon_lat_idxed_pos[720+159][1440-798] =  	7650;
    lon_lat_idxed_pos[720+158][1440-798] =  	7673;
    lon_lat_idxed_pos[720+157][1440-798] =  	7702;
    lon_lat_idxed_pos[720+156][1440-798] =  	7747;
    lon_lat_idxed_pos[720+155][1440-798] =  	7798;
    lon_lat_idxed_pos[720+154][1440-798] =  	7844;
    lon_lat_idxed_pos[720+153][1440-798] =  	7901;
    lon_lat_idxed_pos[720+152][1440-798] =  	7944;
    lon_lat_idxed_pos[720+151][1440-798] =  	7968;
    lon_lat_idxed_pos[720+150][1440-798] =  	8012;
    lon_lat_idxed_pos[720+149][1440-798] =  	8052;
    lon_lat_idxed_pos[720+164][1440-799] =  	8057;
    lon_lat_idxed_pos[720+163][1440-799] =  	8063;
    lon_lat_idxed_pos[720+162][1440-799] =  	8070;
    lon_lat_idxed_pos[720+161][1440-799] =  	8106;
    lon_lat_idxed_pos[720+160][1440-799] =  	8144;
    lon_lat_idxed_pos[720+159][1440-799] =  	8175;
    lon_lat_idxed_pos[720+158][1440-799] =  	8219;
    lon_lat_idxed_pos[720+157][1440-799] =  	8266;
    lon_lat_idxed_pos[720+156][1440-799] =  	8310;
    lon_lat_idxed_pos[720+155][1440-799] =  	8345;
    lon_lat_idxed_pos[720+154][1440-799] =  	8387;
    lon_lat_idxed_pos[720+153][1440-799] =  	8443;
    lon_lat_idxed_pos[720+152][1440-799] =  	8454;
    lon_lat_idxed_pos[720+151][1440-799] =  	8467;
    lon_lat_idxed_pos[720+150][1440-799] =  	8514;
    lon_lat_idxed_pos[720+149][1440-799] =  	8555;
    lon_lat_idxed_pos[720+148][1440-799] =  	8598;
    lon_lat_idxed_pos[720+162][1440-800] =  	8599;
    lon_lat_idxed_pos[720+161][1440-800] =  	8603;
    lon_lat_idxed_pos[720+160][1440-800] =  	8614;
    lon_lat_idxed_pos[720+159][1440-800] =  	8637;
    lon_lat_idxed_pos[720+158][1440-800] =  	8674;
    lon_lat_idxed_pos[720+157][1440-800] =  	8716;
    lon_lat_idxed_pos[720+156][1440-800] =  	8761;
    lon_lat_idxed_pos[720+155][1440-800] =  	8807;
    lon_lat_idxed_pos[720+154][1440-800] =  	8844;
    lon_lat_idxed_pos[720+153][1440-800] =  	8872;
    lon_lat_idxed_pos[720+152][1440-800] =  	8886;
    lon_lat_idxed_pos[720+151][1440-800] =  	8923;
    lon_lat_idxed_pos[720+150][1440-800] =  	8961;
    lon_lat_idxed_pos[720+149][1440-800] =  	8993;
    lon_lat_idxed_pos[720+148][1440-800] =  	9024;
    lon_lat_idxed_pos[720+160][1440-801] =  	9030;
    lon_lat_idxed_pos[720+159][1440-801] =  	9044;
    lon_lat_idxed_pos[720+158][1440-801] =  	9071;
    lon_lat_idxed_pos[720+157][1440-801] =  	9119;
    lon_lat_idxed_pos[720+156][1440-801] =  	9183;
    lon_lat_idxed_pos[720+155][1440-801] =  	9241;
    lon_lat_idxed_pos[720+154][1440-801] =  	9289;
    lon_lat_idxed_pos[720+153][1440-801] =  	9324;
    lon_lat_idxed_pos[720+152][1440-801] =  	9369;
    lon_lat_idxed_pos[720+151][1440-801] =  	9398;
    lon_lat_idxed_pos[720+150][1440-801] =  	9432;
    lon_lat_idxed_pos[720+149][1440-801] =  	9473;
    lon_lat_idxed_pos[720+148][1440-801] =  	9491;
    lon_lat_idxed_pos[720+160][1440-802] =  	9505;
    lon_lat_idxed_pos[720+158][1440-802] =  	9507;
    lon_lat_idxed_pos[720+157][1440-802] =  	9515;
    lon_lat_idxed_pos[720+156][1440-802] =  	9555;
    lon_lat_idxed_pos[720+155][1440-802] =  	9588;
    lon_lat_idxed_pos[720+154][1440-802] =  	9615;
    lon_lat_idxed_pos[720+153][1440-802] =  	9644;
    lon_lat_idxed_pos[720+152][1440-802] =  	9680;
    lon_lat_idxed_pos[720+151][1440-802] =  	9694;
    lon_lat_idxed_pos[720+150][1440-802] =  	9742;
    lon_lat_idxed_pos[720+149][1440-802] =  	9792;
    lon_lat_idxed_pos[720+148][1440-802] =  	9867;
    lon_lat_idxed_pos[720+147][1440-802] =  	9903;
    lon_lat_idxed_pos[720+157][1440-803] =  	9913;
    lon_lat_idxed_pos[720+154][1440-803] =  	9915;
    lon_lat_idxed_pos[720+153][1440-803] =  	9938;
    lon_lat_idxed_pos[720+152][1440-803] =  	9986;
    lon_lat_idxed_pos[720+151][1440-803] =  	10044;
    lon_lat_idxed_pos[720+150][1440-803] =  	10085;
    lon_lat_idxed_pos[720+149][1440-803] =  	10135;
    lon_lat_idxed_pos[720+148][1440-803] =  	10214;
    lon_lat_idxed_pos[720+147][1440-803] =  	10271;
    lon_lat_idxed_pos[720+146][1440-803] =  	10295;
    lon_lat_idxed_pos[720+153][1440-804] =  	10296;
    lon_lat_idxed_pos[720+152][1440-804] =  	10297;
    lon_lat_idxed_pos[720+151][1440-804] =  	10325;
    lon_lat_idxed_pos[720+150][1440-804] =  	10387;
    lon_lat_idxed_pos[720+149][1440-804] =  	10432;
    lon_lat_idxed_pos[720+148][1440-804] =  	10469;
    lon_lat_idxed_pos[720+151][1440-805] =  	10484;
    lon_lat_idxed_pos[720+150][1440-805] =  	10525;


    lon_lat_idxed_pos_count[720+165][1440-785] =  	6;
    lon_lat_idxed_pos_count[720+164][1440-785] =  	53;
    lon_lat_idxed_pos_count[720+163][1440-785] =  	46;
    lon_lat_idxed_pos_count[720+162][1440-785] =  	2;
    lon_lat_idxed_pos_count[720+161][1440-785] =  	3;
    lon_lat_idxed_pos_count[720+169][1440-786] =  	3;
    lon_lat_idxed_pos_count[720+168][1440-786] =  	28;
    lon_lat_idxed_pos_count[720+167][1440-786] =  	9;
    lon_lat_idxed_pos_count[720+166][1440-786] =  	1;
    lon_lat_idxed_pos_count[720+164][1440-786] =  	14;
    lon_lat_idxed_pos_count[720+163][1440-786] =  	94;
    lon_lat_idxed_pos_count[720+162][1440-786] =  	30;
    lon_lat_idxed_pos_count[720+161][1440-786] =  	44;
    lon_lat_idxed_pos_count[720+160][1440-786] =  	18;
    lon_lat_idxed_pos_count[720+159][1440-786] =  	14;
    lon_lat_idxed_pos_count[720+158][1440-786] =  	1;
    lon_lat_idxed_pos_count[720+169][1440-787] =  	16;
    lon_lat_idxed_pos_count[720+168][1440-787] =  	61;
    lon_lat_idxed_pos_count[720+167][1440-787] =  	44;
    lon_lat_idxed_pos_count[720+166][1440-787] =  	26;
    lon_lat_idxed_pos_count[720+163][1440-787] =  	36;
    lon_lat_idxed_pos_count[720+162][1440-787] =  	40;
    lon_lat_idxed_pos_count[720+161][1440-787] =  	46;
    lon_lat_idxed_pos_count[720+160][1440-787] =  	54;
    lon_lat_idxed_pos_count[720+159][1440-787] =  	43;
    lon_lat_idxed_pos_count[720+158][1440-787] =  	68;
    lon_lat_idxed_pos_count[720+157][1440-787] =  	33;
    lon_lat_idxed_pos_count[720+171][1440-788] =  	1;
    lon_lat_idxed_pos_count[720+170][1440-788] =  	1;
    lon_lat_idxed_pos_count[720+169][1440-788] =  	42;
    lon_lat_idxed_pos_count[720+168][1440-788] =  	81;
    lon_lat_idxed_pos_count[720+167][1440-788] =  	39;
    lon_lat_idxed_pos_count[720+166][1440-788] =  	20;
    lon_lat_idxed_pos_count[720+165][1440-788] =  	8;
    lon_lat_idxed_pos_count[720+163][1440-788] =  	1;
    lon_lat_idxed_pos_count[720+162][1440-788] =  	37;
    lon_lat_idxed_pos_count[720+161][1440-788] =  	40;
    lon_lat_idxed_pos_count[720+160][1440-788] =  	58;
    lon_lat_idxed_pos_count[720+159][1440-788] =  	34;
    lon_lat_idxed_pos_count[720+158][1440-788] =  	59;
    lon_lat_idxed_pos_count[720+157][1440-788] =  	85;
    lon_lat_idxed_pos_count[720+171][1440-789] =  	2;
    lon_lat_idxed_pos_count[720+170][1440-789] =  	48;
    lon_lat_idxed_pos_count[720+169][1440-789] =  	111;
    lon_lat_idxed_pos_count[720+168][1440-789] =  	110;
    lon_lat_idxed_pos_count[720+167][1440-789] =  	82;
    lon_lat_idxed_pos_count[720+166][1440-789] =  	50;
    lon_lat_idxed_pos_count[720+165][1440-789] =  	28;
    lon_lat_idxed_pos_count[720+164][1440-789] =  	14;
    lon_lat_idxed_pos_count[720+163][1440-789] =  	18;
    lon_lat_idxed_pos_count[720+162][1440-789] =  	28;
    lon_lat_idxed_pos_count[720+161][1440-789] =  	46;
    lon_lat_idxed_pos_count[720+160][1440-789] =  	62;
    lon_lat_idxed_pos_count[720+159][1440-789] =  	92;
    lon_lat_idxed_pos_count[720+158][1440-789] =  	63;
    lon_lat_idxed_pos_count[720+157][1440-789] =  	32;
    lon_lat_idxed_pos_count[720+156][1440-789] =  	3;
    lon_lat_idxed_pos_count[720+170][1440-790] =  	7;
    lon_lat_idxed_pos_count[720+169][1440-790] =  	28;
    lon_lat_idxed_pos_count[720+168][1440-790] =  	56;
    lon_lat_idxed_pos_count[720+167][1440-790] =  	53;
    lon_lat_idxed_pos_count[720+166][1440-790] =  	52;
    lon_lat_idxed_pos_count[720+165][1440-790] =  	39;
    lon_lat_idxed_pos_count[720+164][1440-790] =  	40;
    lon_lat_idxed_pos_count[720+163][1440-790] =  	36;
    lon_lat_idxed_pos_count[720+162][1440-790] =  	26;
    lon_lat_idxed_pos_count[720+161][1440-790] =  	73;
    lon_lat_idxed_pos_count[720+160][1440-790] =  	123;
    lon_lat_idxed_pos_count[720+159][1440-790] =  	51;
    lon_lat_idxed_pos_count[720+158][1440-790] =  	30;
    lon_lat_idxed_pos_count[720+157][1440-790] =  	35;
    lon_lat_idxed_pos_count[720+156][1440-790] =  	15;
    lon_lat_idxed_pos_count[720+155][1440-790] =  	1;
    lon_lat_idxed_pos_count[720+154][1440-790] =  	6;
    lon_lat_idxed_pos_count[720+153][1440-790] =  	7;
    lon_lat_idxed_pos_count[720+152][1440-790] =  	27;
    lon_lat_idxed_pos_count[720+151][1440-790] =  	2;
    lon_lat_idxed_pos_count[720+169][1440-791] =  	32;
    lon_lat_idxed_pos_count[720+168][1440-791] =  	51;
    lon_lat_idxed_pos_count[720+167][1440-791] =  	33;
    lon_lat_idxed_pos_count[720+166][1440-791] =  	31;
    lon_lat_idxed_pos_count[720+165][1440-791] =  	28;
    lon_lat_idxed_pos_count[720+164][1440-791] =  	40;
    lon_lat_idxed_pos_count[720+163][1440-791] =  	14;
    lon_lat_idxed_pos_count[720+162][1440-791] =  	18;
    lon_lat_idxed_pos_count[720+161][1440-791] =  	40;
    lon_lat_idxed_pos_count[720+160][1440-791] =  	70;
    lon_lat_idxed_pos_count[720+159][1440-791] =  	50;
    lon_lat_idxed_pos_count[720+158][1440-791] =  	33;
    lon_lat_idxed_pos_count[720+157][1440-791] =  	79;
    lon_lat_idxed_pos_count[720+156][1440-791] =  	69;
    lon_lat_idxed_pos_count[720+155][1440-791] =  	39;
    lon_lat_idxed_pos_count[720+154][1440-791] =  	56;
    lon_lat_idxed_pos_count[720+153][1440-791] =  	160;
    lon_lat_idxed_pos_count[720+152][1440-791] =  	90;
    lon_lat_idxed_pos_count[720+151][1440-791] =  	46;
    lon_lat_idxed_pos_count[720+170][1440-792] =  	16;
    lon_lat_idxed_pos_count[720+169][1440-792] =  	92;
    lon_lat_idxed_pos_count[720+168][1440-792] =  	66;
    lon_lat_idxed_pos_count[720+167][1440-792] =  	69;
    lon_lat_idxed_pos_count[720+166][1440-792] =  	31;
    lon_lat_idxed_pos_count[720+165][1440-792] =  	20;
    lon_lat_idxed_pos_count[720+164][1440-792] =  	28;
    lon_lat_idxed_pos_count[720+163][1440-792] =  	19;
    lon_lat_idxed_pos_count[720+162][1440-792] =  	35;
    lon_lat_idxed_pos_count[720+161][1440-792] =  	51;
    lon_lat_idxed_pos_count[720+160][1440-792] =  	30;
    lon_lat_idxed_pos_count[720+159][1440-792] =  	50;
    lon_lat_idxed_pos_count[720+158][1440-792] =  	61;
    lon_lat_idxed_pos_count[720+157][1440-792] =  	83;
    lon_lat_idxed_pos_count[720+156][1440-792] =  	56;
    lon_lat_idxed_pos_count[720+155][1440-792] =  	60;
    lon_lat_idxed_pos_count[720+154][1440-792] =  	30;
    lon_lat_idxed_pos_count[720+153][1440-792] =  	46;
    lon_lat_idxed_pos_count[720+152][1440-792] =  	14;
    lon_lat_idxed_pos_count[720+170][1440-793] =  	7;
    lon_lat_idxed_pos_count[720+169][1440-793] =  	45;
    lon_lat_idxed_pos_count[720+168][1440-793] =  	76;
    lon_lat_idxed_pos_count[720+167][1440-793] =  	27;
    lon_lat_idxed_pos_count[720+166][1440-793] =  	20;
    lon_lat_idxed_pos_count[720+165][1440-793] =  	36;
    lon_lat_idxed_pos_count[720+164][1440-793] =  	22;
    lon_lat_idxed_pos_count[720+163][1440-793] =  	9;
    lon_lat_idxed_pos_count[720+162][1440-793] =  	40;
    lon_lat_idxed_pos_count[720+161][1440-793] =  	46;
    lon_lat_idxed_pos_count[720+160][1440-793] =  	8;
    lon_lat_idxed_pos_count[720+159][1440-793] =  	18;
    lon_lat_idxed_pos_count[720+158][1440-793] =  	92;
    lon_lat_idxed_pos_count[720+157][1440-793] =  	52;
    lon_lat_idxed_pos_count[720+156][1440-793] =  	13;
    lon_lat_idxed_pos_count[720+155][1440-793] =  	4;
    lon_lat_idxed_pos_count[720+169][1440-794] =  	3;
    lon_lat_idxed_pos_count[720+168][1440-794] =  	24;
    lon_lat_idxed_pos_count[720+167][1440-794] =  	27;
    lon_lat_idxed_pos_count[720+166][1440-794] =  	47;
    lon_lat_idxed_pos_count[720+165][1440-794] =  	33;
    lon_lat_idxed_pos_count[720+164][1440-794] =  	62;
    lon_lat_idxed_pos_count[720+163][1440-794] =  	40;
    lon_lat_idxed_pos_count[720+162][1440-794] =  	37;
    lon_lat_idxed_pos_count[720+161][1440-794] =  	60;
    lon_lat_idxed_pos_count[720+160][1440-794] =  	50;
    lon_lat_idxed_pos_count[720+159][1440-794] =  	36;
    lon_lat_idxed_pos_count[720+158][1440-794] =  	45;
    lon_lat_idxed_pos_count[720+157][1440-794] =  	62;
    lon_lat_idxed_pos_count[720+156][1440-794] =  	8;
    lon_lat_idxed_pos_count[720+155][1440-794] =  	1;
    lon_lat_idxed_pos_count[720+168][1440-795] =  	10;
    lon_lat_idxed_pos_count[720+167][1440-795] =  	24;
    lon_lat_idxed_pos_count[720+166][1440-795] =  	34;
    lon_lat_idxed_pos_count[720+165][1440-795] =  	45;
    lon_lat_idxed_pos_count[720+164][1440-795] =  	37;
    lon_lat_idxed_pos_count[720+163][1440-795] =  	41;
    lon_lat_idxed_pos_count[720+162][1440-795] =  	15;
    lon_lat_idxed_pos_count[720+161][1440-795] =  	37;
    lon_lat_idxed_pos_count[720+160][1440-795] =  	49;
    lon_lat_idxed_pos_count[720+159][1440-795] =  	53;
    lon_lat_idxed_pos_count[720+158][1440-795] =  	28;
    lon_lat_idxed_pos_count[720+157][1440-795] =  	46;
    lon_lat_idxed_pos_count[720+156][1440-795] =  	23;
    lon_lat_idxed_pos_count[720+155][1440-795] =  	86;
    lon_lat_idxed_pos_count[720+154][1440-795] =  	25;
    lon_lat_idxed_pos_count[720+153][1440-795] =  	3;
    lon_lat_idxed_pos_count[720+151][1440-795] =  	8;
    lon_lat_idxed_pos_count[720+167][1440-796] =  	6;
    lon_lat_idxed_pos_count[720+166][1440-796] =  	28;
    lon_lat_idxed_pos_count[720+165][1440-796] =  	38;
    lon_lat_idxed_pos_count[720+164][1440-796] =  	15;
    lon_lat_idxed_pos_count[720+163][1440-796] =  	21;
    lon_lat_idxed_pos_count[720+162][1440-796] =  	32;
    lon_lat_idxed_pos_count[720+161][1440-796] =  	25;
    lon_lat_idxed_pos_count[720+160][1440-796] =  	25;
    lon_lat_idxed_pos_count[720+159][1440-796] =  	24;
    lon_lat_idxed_pos_count[720+158][1440-796] =  	29;
    lon_lat_idxed_pos_count[720+157][1440-796] =  	49;
    lon_lat_idxed_pos_count[720+156][1440-796] =  	36;
    lon_lat_idxed_pos_count[720+155][1440-796] =  	54;
    lon_lat_idxed_pos_count[720+154][1440-796] =  	66;
    lon_lat_idxed_pos_count[720+153][1440-796] =  	77;
    lon_lat_idxed_pos_count[720+152][1440-796] =  	20;
    lon_lat_idxed_pos_count[720+151][1440-796] =  	45;
    lon_lat_idxed_pos_count[720+150][1440-796] =  	16;
    lon_lat_idxed_pos_count[720+149][1440-796] =  	2;
    lon_lat_idxed_pos_count[720+165][1440-797] =  	3;
    lon_lat_idxed_pos_count[720+164][1440-797] =  	23;
    lon_lat_idxed_pos_count[720+163][1440-797] =  	41;
    lon_lat_idxed_pos_count[720+162][1440-797] =  	14;
    lon_lat_idxed_pos_count[720+161][1440-797] =  	39;
    lon_lat_idxed_pos_count[720+160][1440-797] =  	14;
    lon_lat_idxed_pos_count[720+159][1440-797] =  	32;
    lon_lat_idxed_pos_count[720+158][1440-797] =  	25;
    lon_lat_idxed_pos_count[720+157][1440-797] =  	23;
    lon_lat_idxed_pos_count[720+156][1440-797] =  	34;
    lon_lat_idxed_pos_count[720+155][1440-797] =  	90;
    lon_lat_idxed_pos_count[720+154][1440-797] =  	32;
    lon_lat_idxed_pos_count[720+153][1440-797] =  	74;
    lon_lat_idxed_pos_count[720+152][1440-797] =  	45;
    lon_lat_idxed_pos_count[720+151][1440-797] =  	68;
    lon_lat_idxed_pos_count[720+150][1440-797] =  	24;
    lon_lat_idxed_pos_count[720+149][1440-797] =  	2;
    lon_lat_idxed_pos_count[720+164][1440-798] =  	32;
    lon_lat_idxed_pos_count[720+163][1440-798] =  	36;
    lon_lat_idxed_pos_count[720+162][1440-798] =  	41;
    lon_lat_idxed_pos_count[720+161][1440-798] =  	42;
    lon_lat_idxed_pos_count[720+160][1440-798] =  	23;
    lon_lat_idxed_pos_count[720+159][1440-798] =  	23;
    lon_lat_idxed_pos_count[720+158][1440-798] =  	29;
    lon_lat_idxed_pos_count[720+157][1440-798] =  	45;
    lon_lat_idxed_pos_count[720+156][1440-798] =  	51;
    lon_lat_idxed_pos_count[720+155][1440-798] =  	46;
    lon_lat_idxed_pos_count[720+154][1440-798] =  	57;
    lon_lat_idxed_pos_count[720+153][1440-798] =  	43;
    lon_lat_idxed_pos_count[720+152][1440-798] =  	24;
    lon_lat_idxed_pos_count[720+151][1440-798] =  	44;
    lon_lat_idxed_pos_count[720+150][1440-798] =  	40;
    lon_lat_idxed_pos_count[720+149][1440-798] =  	5;
    lon_lat_idxed_pos_count[720+164][1440-799] =  	6;
    lon_lat_idxed_pos_count[720+163][1440-799] =  	7;
    lon_lat_idxed_pos_count[720+162][1440-799] =  	36;
    lon_lat_idxed_pos_count[720+161][1440-799] =  	38;
    lon_lat_idxed_pos_count[720+160][1440-799] =  	31;
    lon_lat_idxed_pos_count[720+159][1440-799] =  	44;
    lon_lat_idxed_pos_count[720+158][1440-799] =  	47;
    lon_lat_idxed_pos_count[720+157][1440-799] =  	44;
    lon_lat_idxed_pos_count[720+156][1440-799] =  	35;
    lon_lat_idxed_pos_count[720+155][1440-799] =  	42;
    lon_lat_idxed_pos_count[720+154][1440-799] =  	56;
    lon_lat_idxed_pos_count[720+153][1440-799] =  	11;
    lon_lat_idxed_pos_count[720+152][1440-799] =  	13;
    lon_lat_idxed_pos_count[720+151][1440-799] =  	47;
    lon_lat_idxed_pos_count[720+150][1440-799] =  	41;
    lon_lat_idxed_pos_count[720+149][1440-799] =  	43;
    lon_lat_idxed_pos_count[720+148][1440-799] =  	1;
    lon_lat_idxed_pos_count[720+162][1440-800] =  	4;
    lon_lat_idxed_pos_count[720+161][1440-800] =  	11;
    lon_lat_idxed_pos_count[720+160][1440-800] =  	23;
    lon_lat_idxed_pos_count[720+159][1440-800] =  	37;
    lon_lat_idxed_pos_count[720+158][1440-800] =  	42;
    lon_lat_idxed_pos_count[720+157][1440-800] =  	45;
    lon_lat_idxed_pos_count[720+156][1440-800] =  	46;
    lon_lat_idxed_pos_count[720+155][1440-800] =  	37;
    lon_lat_idxed_pos_count[720+154][1440-800] =  	28;
    lon_lat_idxed_pos_count[720+153][1440-800] =  	14;
    lon_lat_idxed_pos_count[720+152][1440-800] =  	37;
    lon_lat_idxed_pos_count[720+151][1440-800] =  	38;
    lon_lat_idxed_pos_count[720+150][1440-800] =  	32;
    lon_lat_idxed_pos_count[720+149][1440-800] =  	31;
    lon_lat_idxed_pos_count[720+148][1440-800] =  	6;
    lon_lat_idxed_pos_count[720+160][1440-801] =  	14;
    lon_lat_idxed_pos_count[720+159][1440-801] =  	27;
    lon_lat_idxed_pos_count[720+158][1440-801] =  	48;
    lon_lat_idxed_pos_count[720+157][1440-801] =  	64;
    lon_lat_idxed_pos_count[720+156][1440-801] =  	58;
    lon_lat_idxed_pos_count[720+155][1440-801] =  	48;
    lon_lat_idxed_pos_count[720+154][1440-801] =  	35;
    lon_lat_idxed_pos_count[720+153][1440-801] =  	45;
    lon_lat_idxed_pos_count[720+152][1440-801] =  	29;
    lon_lat_idxed_pos_count[720+151][1440-801] =  	34;
    lon_lat_idxed_pos_count[720+150][1440-801] =  	41;
    lon_lat_idxed_pos_count[720+149][1440-801] =  	18;
    lon_lat_idxed_pos_count[720+148][1440-801] =  	14;
    lon_lat_idxed_pos_count[720+160][1440-802] =  	2;
    lon_lat_idxed_pos_count[720+158][1440-802] =  	8;
    lon_lat_idxed_pos_count[720+157][1440-802] =  	40;
    lon_lat_idxed_pos_count[720+156][1440-802] =  	33;
    lon_lat_idxed_pos_count[720+155][1440-802] =  	27;
    lon_lat_idxed_pos_count[720+154][1440-802] =  	29;
    lon_lat_idxed_pos_count[720+153][1440-802] =  	36;
    lon_lat_idxed_pos_count[720+152][1440-802] =  	14;
    lon_lat_idxed_pos_count[720+151][1440-802] =  	48;
    lon_lat_idxed_pos_count[720+150][1440-802] =  	50;
    lon_lat_idxed_pos_count[720+149][1440-802] =  	75;
    lon_lat_idxed_pos_count[720+148][1440-802] =  	36;
    lon_lat_idxed_pos_count[720+147][1440-802] =  	10;
    lon_lat_idxed_pos_count[720+157][1440-803] =  	2;
    lon_lat_idxed_pos_count[720+154][1440-803] =  	23;
    lon_lat_idxed_pos_count[720+153][1440-803] =  	48;
    lon_lat_idxed_pos_count[720+152][1440-803] =  	58;
    lon_lat_idxed_pos_count[720+151][1440-803] =  	41;
    lon_lat_idxed_pos_count[720+150][1440-803] =  	50;
    lon_lat_idxed_pos_count[720+149][1440-803] =  	79;
    lon_lat_idxed_pos_count[720+148][1440-803] =  	57;
    lon_lat_idxed_pos_count[720+147][1440-803] =  	24;
    lon_lat_idxed_pos_count[720+146][1440-803] =  	1;
    lon_lat_idxed_pos_count[720+153][1440-804] =  	1;
    lon_lat_idxed_pos_count[720+152][1440-804] =  	28;
    lon_lat_idxed_pos_count[720+151][1440-804] =  	62;
    lon_lat_idxed_pos_count[720+150][1440-804] =  	45;
    lon_lat_idxed_pos_count[720+149][1440-804] =  	37;
    lon_lat_idxed_pos_count[720+148][1440-804] =  	15;
    lon_lat_idxed_pos_count[720+151][1440-805] =  	41;
    lon_lat_idxed_pos_count[720+150][1440-805] =  	15;
#endif

}
int
isvalid_coor_halfdgres(int lu_lat,int lu_lon)
{
	if( lu_lat > -180 && lu_lat <= 179 && lu_lon > -360 && lu_lon <= 359 )
		return 1;
	else
		return 0; //No valid range
}
int suma_2_numbers(int a, int b)
{
	return a+b;
}
