//#include <mathlib.h>
#include <math.h>
#define GLOBAL_Q 20  //default is IQ 24
//#include <IQmath.h>
#include <stdio.h>
#include "src/geodistance.h"
#include "src/radius_of_curvature.h"

double
toradians(double angle)
{
	return angle*PI/180;
}
/* 
 * ===  FUNCTION  ======================================================================
 *         Name:  geodistance
 *  Description:  calculate distance between positions 
 * =====================================================================================
 */
double
geodistance ( double lat1, double lon1, double lat2, double lon2 )
{
	double dlon,dlat;
	double a;//Square of half of distance between the two points
	double c;//Great circle distance[rad]
	double d;//Great circle distance[km] or [mi] depending in R units
	double r=0;
	double temp1,temp2;
//	lat1 = 19.5541667;
//	lon1 = -99.205002;
//	lat2 = 19.536667;
//	lon2 = -99.194722;

//	printf ( "lat1: %f lon1: %f lat2: %f lon2: %f\n",lat1,lon1,lat2,lon2 );
	r= radius_of_curvature(  (lat1+lat2)/2 );
	lat1 = toradians(lat1);
	lon1 = toradians(lon1);
	lat2 = toradians(lat2);
	lon2 = toradians(lon2);
	dlon = lon2 - lon1;
	dlat = lat2 - lat1;
//	temp1 = sin( dlon/2 );
//	temp1 = pow( temp1, 2 );
//	temp2 = cos( lat2 );
//	temp1 =	temp2 * temp1;
//	temp2 = cos( lat1 );
//	temp1 = temp2 * temp1;
//	temp2 = sin( dlat/2 );
//	temp2 = pow(temp2,2);
//	a = temp2 + temp1 ; //Intrinsic +,*, mathlib pow,atan, cos, sin
//	temp1 = sqrt(a);
//	temp2 = sqrt( 1-a );
//	temp1 = atan2( temp1 , temp2  );
//	c = 2 * temp1;
	//math.h Tested with O3 best perfomance than mathlib
	a = pow(sin( dlat/2 ),2) + cos( lat1 ) * cos( lat2 ) * pow( sin( dlon/2 ), 2); //Intrinsic +,*, mathlib pow,atan, cos, sin
	c = 2 * atan2(  sqrt(a), sqrt( 1-a )  );
	//mathlib.h
//	a = powdp(sindp( dlat/2 ),2) + cosdp( lat1 ) * cosdp( lat2 ) * powdp( sindp( dlon/2 ), 2); //Intrinsic +,*, mathlib pow,atan, cos, sin
//	c = 2 * atan2dp(  sqrtdp(a), sqrtdp( 1-a )  );

	d = r * c;
//	printf ( "DISTANCE IS %f:\n",d );

	return d;
}		// -----  end of function geodistance  -----

/*
 * ===  FUNCTION  ======================================================================
 *         Name:  geodistance_fxp
 *  Description:  calculate distance between positions
 * =====================================================================================
 */
//double
//geodistance_fxp ( double lat1, double lon1, double lat2, double lon2 )
//{
//	double dlon,dlat;
//	double a;//Square of half of distance between the two points
//	double c;//Great circle distance[rad]
//	double d;//Great circle distance[km] or [mi] depending in R units
//	double r=0;
//	double temp;
//	//Variables for Fixed point
//	_iq20 dlat_fp;
//	double temp_iq_to_F;
//
//
////	_iq29 r_fxp_iq29;
//	_iq29 a_fxp;
//	_iq29 dlat_fxp;
//	_iq29 lat1_fxp;
//	_iq29 lat2_fxp;
//	_iq29 dlon_fxp;
//	_iq29 c_fxp;
//	_iq20 r_fxp_iq20;
//	_iq29 d_fxp;
//	_iq29 tmp_iq29_1;
//	_iq29 tmp_iq29_2;
//	_iq29 tmp_iq29_3;
//	_iq29 tmp_iq29_4;
//	_iq31 tmp_iq31;
//
////	printf ( "lat1: %f lon1: %f lat2: %f lon2: %f\n",lat1,lon1,lat2,lon2 );
//	r_fxp_iq20 = radius_of_curvature_fxp(  _IQ20( (lat1+lat2)/2 )  );
////	r_fxp_iq20 = _IQXtoIQY(r_fxp_iq20,20,29);
//	lat1 = toradians(lat1);
//	lon1 = toradians(lon1);
//	lat2 = toradians(lat2);
//	lon2 = toradians(lon2);
//	dlon = lon2 - lon1;
//	dlat = lat2 - lat1;
//	dlon_fxp = _FtoIQ29(dlon);
//	dlat_fxp = _FtoIQ29(dlat);
//	lat1_fxp = _FtoIQ29(lat1);
//	lat2_fxp = _FtoIQ29(lat2);
////	r_fxp = _FtoIQ(r);
//
//	//math.h
////	a = pow(sin( dlat/2 ),2) + cos( lat1 ) * cos( lat2 ) * pow( sin( dlon/2 ), 2); //Intrinsic +,*, mathlib pow,atan, cos, sin
////	c = 2 * atan2(  sqrt(a), sqrt( 1-a )  );
//	//IQmath.h
//	//changing to FixedPoint
//
//	 tmp_iq29_1 = _IQ29div( dlon_fxp,_IQ29(2) );
//	tmp_iq29_1 = _IQ29sin( tmp_iq29_1 );
////	tmp_iq29_1 = _IQ29mpy( tmp_iq29_1,tmp_iq29_1 );
////		tmp_iq29_1 = _IQmpy( tmp_iq29_1, _IQ29(1000) ); //1000 fits in qi20 not in qi29
//	 //changing to qi30 @CORRECTION
//	 tmp_iq31 = _IQXtoIQY(tmp_iq29_1,29,31);
//	tmp_iq31 = _IQ31mpy( tmp_iq31,tmp_iq31 ); //@TODO: Solucionar pow INCORRECTO
//	 tmp_iq29_1 = _IQXtoIQY(tmp_iq31,31,29);
//	 //changing to qi20
//	tmp_iq29_2 = _IQ29cos( lat2_fxp );
//	tmp_iq29_1 = _IQ29mpy( tmp_iq29_2 , tmp_iq29_1  ); //Intrinsic +,*, mathlib pow,atan, cos, sin
//	tmp_iq29_2 = _IQ29cos( lat1_fxp );
//	tmp_iq29_1 = _IQ29mpy(  tmp_iq29_2, tmp_iq29_1 );
//	 tmp_iq29_2 = _IQ29div( dlat_fxp, _IQ29(2) );
//	tmp_iq29_2 = _IQ29sin( tmp_iq29_2 );
////		tmp_iq29_2 = _IQmpy( tmp_iq29_2, _IQ29(1000) );
//		//changing to qi30 @CORRECTION
//	 tmp_iq31 = _IQXtoIQY(tmp_iq29_2,29,31);
//	tmp_iq31 = _IQ31mpy( tmp_iq31,tmp_iq31 ); //@TODO: Solucionar pow INCORRECTO
//	 tmp_iq29_2 = _IQXtoIQY(tmp_iq31,31,29);
//		//changing to qi20
//	//tmp_iq20_2 = _IQpow( tmp_iq20_2, _IQ(2) );
//	a_fxp = tmp_iq29_2 + tmp_iq29_1;  //<<<<
//	tmp_iq29_1 = _IQ29sqrt(a_fxp);
//	 tmp_iq29_2 = _IQ29(1) - a_fxp;
//	tmp_iq29_2 = _IQ29sqrt( tmp_iq29_2 );
//	tmp_iq29_1 = _IQ29atan2( tmp_iq29_1 , tmp_iq29_2 );
//	c_fxp = _IQ29mpy(_IQ29(2) , tmp_iq29_1 );
//
//	d_fxp = _IQmpy( r_fxp_iq20, c_fxp );
////	a_fxp = _IQpow(_IQsin( dlat_fxp/2 ),2) + _IQcos( lat1_fxp ) * _IQcos( lat2_fxp ) * _IQpow( _IQsin( dlon_fxp/2 ), 2); //Intrinsic +,*, mathlib pow,atan, cos, sin
////	c_fxp = 2 * _IQatan2(  _IQsqrt(a_fxp), _IQsqrt( 1-a_fxp )  );
//	//changing to Floating point
//	d = _IQtoF( d_fxp );
//	//d = r * c;
//	return d;
//}		// -----  end of function geodistance  -----

