#define	GLOBE_RADIUS_EQUATOR	6378000		/*  */
#define	GLOBE_RADIUS_POLES 	6357000		/*  */

#include <math.h>
#define GLOBAL_Q 20
#include <IQmath.h>
#include "radius_of_curvature.h"

/* 
 * ===  FUNCTION  ======================================================================
 *         Name:  radius_of_curvature
 *  Description:  
 * =====================================================================================
 */
double
radius_of_curvature ( double lat )
{
	double temp1, temp2,temp3;

	double a = GLOBE_RADIUS_EQUATOR; // major axis
	double b = GLOBE_RADIUS_POLES; // minor axis
	double e = sqrt( 1 - pow( (b/a), 2 ) ); //eccentricity
	return a * sqrt( 1- pow( e, 2) ) / ( 1 - pow(  e * sin( lat ), 2 ) );
//	Up code is reduced to next line calculating all operations with constant values

//	temp1 = sin(lat);
//	temp1 = 0.081082028 * temp1;//0.996707 * temp1;
//	temp1 = pow( temp1, 2 );
//	temp1 = 1 - temp1;
//	temp1 = 5394034.66 / temp1;//517141.179950/ temp1;
//	return temp1;

//	return 517141.179950/( 1 - pow(  0.996707 * sin(lat), 2) )  ;
}		// -----  end of function radius_of_curvature  ----- 
/*
 * ===  FUNCTION  ======================================================================
 *         Name:  radius_of_curvature_fxp
 *  Description:
 * =====================================================================================
 */
_iq20
radius_of_curvature_fxp ( _iq20 lat )
	{
//	_iq24 tmp_iq20;
//	_iq24 cte_iq20;
//
//	tmp_iq20 = _IQsin( lat );
//	tmp_iq20 = _IQmpy( _IQ( 0.996707 ),  tmp_iq20);
//	tmp_iq20 = _IQpow(  tmp_iq20, _IQ(2) ) ;
//	tmp_iq20 = _IQ( 1 ) - tmp_iq20;
//	//changing qi to qi 12
//	cte_iq20 = _IQ( 517.14117995 );
//	tmp_iq20 = _IQdiv( cte_iq20, tmp_iq20 );
	_iq20 tmp_iq20;
	_iq20 cte_iq20;

	tmp_iq20 = _IQ20sin( lat );
	tmp_iq20 = _IQ20mpy( _IQ20( 0.081082028 ),  tmp_iq20);; //  _IQ20mpy( _IQ20( 0.996707 ),  tmp_iq20);
	tmp_iq20 = _IQ20pow(  tmp_iq20, _IQ20(2) ) ;
	tmp_iq20 = _IQ20( 1 ) - tmp_iq20;
	//changing qi to qi 12
	cte_iq20 = _IQ20( 539.403466 );; //_IQ20( 517.14117995 );
	tmp_iq20 = _IQ20div( cte_iq20, tmp_iq20 );
	return tmp_iq20; // Value returned has to be multiplied by 1000, so the final value will be in [m]
}		// -----  end of function radius_of_curvature  -----
