#include "Android_P2P.h"
#include "nfc.h"

char message[50];
uint8_t response[50];
uint8_t messageStatus = 0;

uint8_t* Android_SYMM_received(uint8_t* buffer)
{
    if(messageDirection == SENDING)
      return Android_send_CONNECT(buffer[3]);
   else
    	return Android_send_SYMM(buffer[3]);
}

//NPP version
uint8_t* Android_send_CONNECT(uint8_t PFB)
{
	response[0] = 0x17; //length
	response[1] = 0xD5; //DEP_RES
	response[2] = 0x07; //DEP_RES
	response[3] = PFB; //PFB (info PDU, PNI)
	response[4] = 0x05; //DSAP = 1 (SDP), PTYPE = CONNECT
	response[5] = 0x21; //PTYPE = CONNECT, SSAP = 0x21
	response[6] = 0x06; //Type = Service Name
	response[7] = 0x0F; //Length = 0x0F
	response[8] = 'c';  //Service Name
	response[9] = 'o';
	response[10] = 'm';
	response[11] = '.';
	response[12] = 'a';
	response[13] = 'n';
	response[14] = 'd';
	response[15] = 'r';
	response[16] = 'o';
	response[17] = 'i';
	response[18] = 'd';
	response[19] = '.';
	response[20] = 'n';
	response[21] = 'p';
	response[22] = 'p';

	return response;
}

uint8_t* Android_SNEP_received(uint8_t* buffer)
{
	return Android_send_DM(buffer[3]);
}

uint8_t* Android_send_DM(uint8_t PFB)
{
	response[0] = 0x07; //length
	response[1] = 0xD5; //DEP_RES
	response[2] = 0x07; //DEP_RES
	response[3] = PFB;  //PFB (info PDU, PNI)
	response[4] = 0x81; //DSAP = 0x20, PTYPE = DM
	response[5] = 0xC4; //PTYPE = DM, SSAP = SNEP
	response[6] = 0x03; //Reason = 0x03 = the remote LLC has processed a CONNECT PDU
						//and the request to connect was rejected by the service layer.
						//(since we don't support SNEP)
	return response;
}

uint8_t* Android_RR_received(uint8_t* buffer)
{
	return Android_send_DISC(buffer[3]);
}

uint8_t* Android_send_DISC(uint8_t PFB)
{
	response[0] = 0x07; //length
	response[1] = 0xD5; //DEP_RES
	response[2] = 0x07; //DEP_RES
	response[3] = PFB;  //PFB (info PDU, PNI)
	response[4] = 0x41; //DSAP = 0x10, PTYPE = DISC
	response[5] = 0x60; //SSAP = 0x20
	response[6] = 0x01; //# of I PDUs received
	return response;
}

uint8_t* Android_CONNECT_received(uint8_t* buffer, uint8_t DSAP, uint8_t SSAP)
{
	return Android_send_CC(buffer[3], DSAP, SSAP);
}

uint8_t* Android_send_CC(uint8_t PFB, uint8_t DSAP, uint8_t SSAP)
{
	response[0] = 0x0A; //length
	response[1] = 0xD5; //DEP_RES
	response[2] = 0x07; //DEP_RES
	response[3] = PFB; //PFB (info PDU, PNI)

	//response[4] = 0x85; //DSAP = 0x21, PTYPE = CC
	//response[5] = 0x90; //PTYPE = CC, SSAP = 0x10
	response[4] = (SSAP << 2 | CC >> 2);
	response[5] = (CC << 6 | 0x10);

	response[6] = 0x02; //Type = MIUX
	response[7] = 0x02; //Length = 2
	response[8] = 0x00; // MIUX
	response[9] = 0x78; // MIUX

	return response;
}

uint8_t* Android_CC_received(uint8_t* buffer)
{
	return Android_send_I(buffer[3]);
}

uint8_t* Android_send_I(uint8_t PFB)
{
	uint8_t i;

	response[0] = message[0] + 24; //length
	response[1] = 0xD5; //DEP_RES
	response[2] = 0x07; //DEP_RES
	response[3] = PFB; //PFB (info PDU, PNI)
	response[4] = 0x43; //DSAP = 0x10, PTYPE = I
	response[5] = 0x21; //PTYPE = I, SSAP = 0x21
	response[6] = 0x00; //Sequence N(S) = 0 N(R) = 0
	response[7] = 0x01; //NPP Protocol version
	response[8] = 0x00; //# NDEF Entries
	response[9] = 0x00; //# NDEF Entries
	response[10] = 0x00; //# NDEF Entries
	response[11] = 0x01; //# NDEF Entries
	response[12] = 0x01; //Action code 1
	response[13] = 0x00; //NDEF length
	response[14] = 0x00; //NDEF length
	response[15] = 0x00; //NDEF length
	response[16] = message[0] + 7; //NDEF length
	response[17] = 0xD1; //Short record, NFC RTD
	response[18] = 0x01; //Type length = 1
	response[19] = message[0] + 3; //Payload length
	response[20] = 'T';  //Payload type = text
	response[21] = 0x02; //UTF-8, 2 byte language code
	response[22] = 'e';  //language = english
	response[23] = 'n';  //language = english
	for(i = 0; i < 15; i++ )
	{
		response[i + 24] = message[i+1]; //copy the message into the payload
	}

	messageStatus = MESSAGE_SENT;

	return response;
}

uint8_t* Android_I_received(uint8_t* buffer)
{
	uint8_t i;
	//store NDEF message data
	message[0] = buffer[19] - 3; //get payload length;
	for(i = 0; i < message[0]; i++)
	{
		message[i + 1] = buffer[i + 24]; //get the message data
	}

	messageStatus = MESSAGE_RECEIVED;

	return Android_send_SYMM(buffer[3]);
}

uint8_t* Android_send_SYMM(uint8_t PFB)
{
	response[0] = 0x06; //length
	response[1] = 0xD5; //DEP_RES
	response[2] = 0x07; //DEP_RES
	response[3] = PFB;    //PFB (info PDU, PNI)
	response[4] = 0;    //SYMM
	response[5] = 0;    //SYMM
	return response;
}
