/** @file   RFID_hardware.h
 *  @brief  header file for hardware initialization of RFID Host
 *  @author LR
 *  @date   Feb 2011
 *  @note   History:
 *          Date        Author      Comment
 *          02/2011     LR          File created and added to GIT
 *  Built with IAR Embedded Workbench Version: 5.20
 *
 */
/* --COPYRIGHT--,BSD
 * Copyright (c) 2011, Texas Instruments Incorporated
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * *  Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * *  Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * *  Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * --/COPYRIGHT--*/


//
// Header files
//
#include <MSP430.h>
#include <stdint.h>

#include "SPI.h"

#ifndef __HARDWARE_H
#define __HARDWARE_H


//
// Macro definitions
//
/*! Use a  TRF7970 with the corresponding SPI polarity */
#define USE_TRF7970
/*! Default NFC ID for this device */
//#define TARGET_CID   {0x64, 0xC2, 0x80, 0x2E, 0xF4, 0x51, 0x7D, 0x0C, 0x54, 0xF3}
 #define TARGET_CID {0x01, 0xFE, 0x88, 0x77, 0x66, 0x55, 0x44, 0x33, 0x22, 0x11}

// Define Clocks
/*! Mhz   */
#define MHZ         1000000
/*! khz   */
#define KHZ         1000

/*! SMCLK/MCLK frequency   */
#define SYS_CLK         (16*MHZ)
/*! XT1/ACLK frequency   */
#define XTAL_CLK        (32768)

/*! Software delay in Miliseconds */
#define DELAY_MS(x)     {__delay_cycles((SYS_CLK/1000)*x);}

//EN pin on the TRF796x - P2.2 (P1.7 in 5438, P2.3 in 5529, P2.2 in G2553)
#define TRF_ENABLEBIT           BIT2
#define TRF_ENABLESET()         {P2DIR |= TRF_ENABLEBIT;}
#define TRF_ENABLE()            {P2OUT |= TRF_ENABLEBIT;}
#define TRF_DISABLE()           {P2OUT &= ~TRF_ENABLEBIT;}

// SPI pins in MSP430 (P3.1-P3.3 in 5438, P3.0-P3.2 in 5529, P1.5-7 in G2553)
#define SPI_PSEL                P1SEL
#define SPI_DIR                 P1DIR
#define SPI_OUT                 P1OUT
#define SPI_IN                  P1IN
#define SPI_MOSI_PIN            BIT7
#define SPI_MISO_PIN            BIT6
#define SPI_CLK_PIN             BIT5
// SPI_SS pin in MSP430 (P3.0 in 5438, P2.6 in 5529, P2.1 in G2553)
#define SPI_SS_PSEL             P2SEL
#define SPI_SS_DIR              P2DIR
#define SPI_SS_OUT              P2OUT
#define SPI_SS_IN               P2IN
#define SPI_SS_PIN              BIT1
#define SLAVESELECT_OUTPUT()    {SPI_SS_DIR |= SPI_SS_PIN;}
#define SLAVESELECT_HIGH()      {SPI_SS_OUT |= SPI_SS_PIN;}
#define SLAVESELECT_LOW()       {SPI_SS_OUT &= ~SPI_SS_PIN;}

//USCI Register for SPI communication with TRF - uses USCI_B0
#define  UCSPICTL0              UCB0CTL0
#define  UCSPICTL1              UCB0CTL1
#define  UCSPIRXBUF             UCB0RXBUF
#define  UCSPITXBUF             UCB0TXBUF
#define  UCSPIIFG               IFG2
#define  UCSPISTAT              UCB0STAT

// IRQ pin definition (P1.5 in 5438, P4.0 in 5529, P2.0 in G2553)
#define IRQ_PIN                 (BIT0)
#define IRQ_PIN_SET()           {P2DIR &= ~IRQ_PIN;}
#define IRQ_PORT                (P2IN)
//#define IRQ_IS_SET()            (P1IFG & IRQ_PIN)
#define IRQ_IS_SET()            (P2IN & IRQ_PIN)

// OOK pin control (P8.1 in 5428, P4.7 in 5529, not found on G2553)
#define OOK_DIR_IN()            {P2DIR &= ~BIT7;}


/*! \def ResetDecoders()
  Reset the decoders
 */
//#define ResetDecoders()	    RADIO_DIRECTCOMMAND(StopDecoders, buf); RADIO_DIRECTCOMMAND(RunDecoders, buf);

//
// Function prototypes
//
void RFID_Hardware_Init(void);

#endif //__HARDWARE_H
